/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Vector;
import util.JarFile;
import util.Log;

public class JarDir
implements FilenameFilter {
    String prefix;
    String dir;
    JarFile[] jars;

    public JarDir(String string, String string2) {
        try {
            this.dir = string;
            this.prefix = string2;
            Log.log("JAR", Log.DB2, "jar dir = " + string);
            File file = new File(string);
            String[] stringArray = file.list(this);
            if (stringArray == null) {
                return;
            }
            this.jars = new JarFile[stringArray.length];
            int n = 0;
            while (n < this.jars.length) {
                this.jars[n] = new JarFile(String.valueOf(string) + File.separatorChar + stringArray[n]);
                this.jars[n].loadEntireJar();
                ++n;
            }
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public Vector findClasses(Class clazz) {
        if (this.jars == null) {
            return null;
        }
        Vector<Class> vector = new Vector<Class>();
        int n = 0;
        while (n < this.jars.length) {
            JarFile jarFile = this.jars[n];
            int n2 = 0;
            while (n2 < jarFile.classList.size()) {
                try {
                    Class clazz2 = jarFile.loadClass((String)jarFile.classList.elementAt(n2));
                    if (!clazz2.isInterface() && clazz.isAssignableFrom(clazz2)) {
                        Log.log("JAR", Log.DB3, "Found a matching class " + clazz2);
                        vector.addElement(clazz2);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                ++n2;
            }
            ++n;
        }
        return vector;
    }

    public boolean accept(File file, String string) {
        return string.endsWith(".jar") && string.startsWith(this.prefix);
    }
}

