/*
 * Decompiled with CFR 0.152.
 */
package module.rendezvous.fileTransfer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.Window;
import main.Oscar;
import module.rendezvous.fileTransfer.ErrorPanel;
import module.rendezvous.fileTransfer.FileTransfer;
import module.rendezvous.fileTransfer.ReceivePanel;
import module.rendezvous.fileTransfer.SendPanel;
import tool.icbm.RendezvousEvent;
import uiutil.BoundedPanel;
import uiutil.OFrame;

public class FxferUI
extends OFrame {
    public static String MODULE = "RendezvousFxferUI";
    String frameTitle;
    Panel mainPanel = new Panel(new BorderLayout());
    BoundedPanel boundedPanel;
    private FileTransfer fileTransfer;
    private SendPanel sendPanel;
    private ReceivePanel receivePanel;
    private ErrorPanel errorPanel;
    private byte[] cookie;

    public FxferUI(FileTransfer fileTransfer, RendezvousEvent rendezvousEvent) {
        this.fileTransfer = fileTransfer;
        rendezvousEvent.getId();
        this.frameTitle = rendezvousEvent.getNickname().nickname == null ? "File Transfer " : String.valueOf(rendezvousEvent.getNickname().nickname) + ":";
        this.cookie = rendezvousEvent.getRendezvousCookie();
        ((Component)((Object)this)).setBackground(Oscar.backgroundColor);
        ((Container)((Object)this)).setLayout(new BorderLayout());
        this.update(rendezvousEvent);
    }

    private void update(RendezvousEvent rendezvousEvent) {
        if (this.boundedPanel != null) {
            this.boundedPanel.removeAll();
        }
        if (this.mainPanel != null) {
            this.mainPanel.removeAll();
        }
        ((Container)((Object)this)).removeAll();
        int n = rendezvousEvent.getId();
        if (n == 1100) {
            this.mainPanel.add("Center", new SendPanel(this.fileTransfer, this, rendezvousEvent));
        } else if (n == 1102) {
            this.mainPanel.add("Center", new ReceivePanel(this.fileTransfer, this, rendezvousEvent));
        } else if (n == 1105) {
            System.out.println("**** FxferUI.. CHANNEL_ERROR_IN *** ");
            this.frameTitle = String.valueOf(this.frameTitle) + " Error";
            this.mainPanel.add("Center", new ErrorPanel(this.fileTransfer, this, rendezvousEvent));
        } else {
            this.frameTitle = "Unknown Event Type";
            this.mainPanel.add("Center", new ErrorPanel(this.fileTransfer, this, rendezvousEvent));
        }
        ((Frame)((Object)this)).setTitle(this.frameTitle);
        this.boundedPanel = new BoundedPanel((Component)this.mainPanel);
        ((Container)((Object)this)).add("Center", (Component)this.boundedPanel);
        ((Window)((Object)this)).pack();
        ((Component)((Object)this)).setVisible(true);
    }

    public void setEnabled(boolean bl) {
        this.boundedPanel.setEnabled(bl);
        if (bl) {
            ((Component)((Object)this)).setCursor(Cursor.getDefaultCursor());
            return;
        }
        ((Component)((Object)this)).setCursor(Cursor.getPredefinedCursor(3));
    }

    public byte[] getCookie() {
        return this.cookie;
    }

    public void dispose() {
        ((Component)((Object)this)).setVisible(false);
        this.fileTransfer.removeFxferUI(this);
        this.mainPanel = null;
        this.boundedPanel = null;
        super.dispose();
    }

    public void removeNotify() {
        this.boundedPanel = null;
        this.mainPanel = null;
        this.fileTransfer = null;
        this.sendPanel = null;
        this.receivePanel = null;
        this.errorPanel = null;
    }
}

