/*
 * Decompiled with CFR 0.152.
 */
package module.rendezvous.buddyChat;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import main.ChatRoomID;
import module.rendezvous.buddyChat.BuddyChat;
import module.rendezvous.buddyChat.ChatUI;
import snac.TLV;
import tool.icbm.RendezvousEvent;
import uiutil.ChoiceUI;
import uiutil.IUtil;
import uiutil.MultiLineLabel;
import util.JUtil;

class ReceivePanel
extends Panel
implements ActionListener {
    BuddyChat buddyChat;
    ChatUI chatUI;
    String nickname;
    ChatRoomID crid;
    Button goButton;
    Button sendIMButton;
    Button cancelButton;
    Button helpButton;
    Button okButton;
    String message;
    String ipAddress;
    int port;
    byte[] ccookie;
    byte[] cookie;
    TLV params;
    String roomName = "chat";

    public ReceivePanel() {
    }

    public ReceivePanel(BuddyChat buddyChat, ChatUI chatUI, RendezvousEvent rendezvousEvent) {
        this.buddyChat = buddyChat;
        this.chatUI = chatUI;
        int n = rendezvousEvent.getRendezvousType();
        this.cookie = rendezvousEvent.getCookie();
        this.setLayout(new BorderLayout());
        Panel panel = new Panel();
        if (n == 0) {
            this.message = "Press 'Go' to join my chatroom";
            this.extractInfo(rendezvousEvent);
            this.goButton = new Button("Go");
            panel.add(this.goButton);
            this.sendIMButton = new Button("Send IM");
            panel.add(this.sendIMButton);
            this.cancelButton = new Button("Cancel");
            panel.add(this.cancelButton);
            this.helpButton = new Button("Help");
            panel.add(this.helpButton);
            this.goButton.addActionListener(this);
            this.sendIMButton.addActionListener(this);
            this.cancelButton.addActionListener(this);
            this.helpButton.addActionListener(this);
            this.add("North", (Component)new MultiLineLabel(IUtil.format((String)this.message, (int)60), 0, 10));
            this.add("Center", new Label("Chat Room: " + this.roomName));
            chatUI.frameTitle = "Invitation from: " + this.nickname;
        } else if (n == 2) {
            String string = "User " + rendezvousEvent.getNickname().nickname + "\nhas accepted your invitation to join a chat room.";
            this.add("Center", (Component)new MultiLineLabel(IUtil.format((String)string, (int)60), 0, 10));
            this.okButton = new Button("OK");
            panel.add(this.okButton);
            this.okButton.addActionListener(this);
            chatUI.frameTitle = String.valueOf(chatUI.frameTitle) + "Invitation accepted";
        } else if (n == 1) {
            String string = "User " + rendezvousEvent.getNickname().nickname + "\nhas declined your invitation to join a chat room.";
            this.add("Center", (Component)new MultiLineLabel(IUtil.format((String)string, (int)10), 0, 10));
            this.okButton = new Button("OK");
            panel.add(this.okButton);
            this.okButton.addActionListener(this);
            chatUI.frameTitle = String.valueOf(chatUI.frameTitle) + "Invitation declined";
        }
        this.add("South", panel);
    }

    private final void extractInfo(RendezvousEvent rendezvousEvent) {
        Object object;
        this.nickname = rendezvousEvent.getNickname().nickname;
        this.params = rendezvousEvent.getRendezvousParams();
        int n = 6;
        this.message = this.params.tlvTypePresent(n) ? new String(this.params.getTlvData(n)) : "No invitation message sent";
        n = 2;
        if (this.params.tlvTypePresent(n)) {
            this.ipAddress = new String(this.params.getTlvData(n));
        } else {
            System.out.println("No IP Address found in rendezvous event");
            this.ipAddress = "127.0.0.1";
        }
        n = 5;
        if (this.params.tlvTypePresent(n)) {
            this.port = this.params.getTlvDataAsU16(n);
        } else {
            System.out.println("No port info. found in rendezvous event");
            this.port = 1024;
        }
        n = 10001;
        this.crid = null;
        if (this.params.tlvTypePresent(n)) {
            byte[] byArray = this.params.getTlvData(n);
            System.out.println("ChatUI: data = " + JUtil.bytesToHexString((byte[])byArray));
            object = new ByteArrayInputStream(byArray);
            DataInputStream dataInputStream = new DataInputStream((InputStream)object);
            try {
                this.crid = new ChatRoomID(dataInputStream);
            }
            catch (IOException iOException) {
                System.out.println("BUSTED_PARAMETERS error!");
                iOException.printStackTrace();
                this.buddyChat.sendError(rendezvousEvent.getCookie(), rendezvousEvent.getRendezvousCookie(), rendezvousEvent.getNickname().nickname, 3);
            }
        }
        if (this.params.tlvTypePresent(n = 10011)) {
            this.roomName = this.params.getTlvDataAsString(n);
        }
        if (this.crid != null) {
            object = JUtil.bytesToHexString((byte[])this.crid.getCookie());
            System.out.println("exchange = " + this.crid.getExchange());
            System.out.println("instance = " + this.crid.getInstance());
            System.out.println("room cookie = " + (String)object);
        }
        System.out.println("nickname = " + this.nickname);
        System.out.println("ipAddress = " + this.ipAddress);
        System.out.println("port = " + this.port);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof Button) {
            Button button = (Button)actionEvent.getSource();
            if (button == this.goButton) {
                ((Component)((Object)this.chatUI)).setVisible(false);
                this.buddyChat.sendAccept(this.cookie, this.chatUI.getCookie(), this.nickname, this.params, this.crid);
                this.chatUI.dispose();
                return;
            }
            if (button == this.cancelButton) {
                ((Component)((Object)this.chatUI)).setVisible(false);
                this.buddyChat.sendExplicitIgnore(this.chatUI.getCookie(), this.nickname);
                this.chatUI.dispose();
                return;
            }
            if (button == this.sendIMButton) {
                this.buddyChat.sendIM(this.nickname);
                return;
            }
            if (button == this.helpButton) {
                ChoiceUI.newChoiceUI((String)"Help", (String)"Press 'Go' to join the chatroom\nor press 'Cancel' to decline the invitation.");
                return;
            }
            if (button == this.okButton) {
                this.chatUI.dispose();
            }
        }
    }
}

