/*
 * Decompiled with CFR 0.152.
 */
package com.sun.sql.rowset;

import com.sun.sql.rowset.BaseRowSetX;
import com.sun.sql.rowset.JdbcRowSetX;
import java.beans.Beans;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringBufferInputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.sql.rowset.Joinable;
import javax.sql.rowset.RowSetWarning;
import javax.sql.rowset.serial.SQLInputImpl;
import javax.sql.rowset.serial.SerialArray;
import javax.sql.rowset.serial.SerialBlob;
import javax.sql.rowset.serial.SerialClob;
import javax.sql.rowset.serial.SerialRef;

public class JdbcRowSetXImpl
extends BaseRowSetX
implements JdbcRowSetX,
Joinable {
    private static ResourceBundle rb = ResourceBundle.getBundle("com.sun.sql.rowset.Bundle", Locale.getDefault());
    boolean onInsertRow;
    HashMap insertedRowObjects;
    boolean wasNullObject;
    private boolean autoCommit;
    private Connection conn;
    private int holdability;
    private PreparedStatement ps;
    private PropertyChangeSupport propertyChangeSupport;
    private ResultSet rs;
    private ResultSetMetaData rsmd;
    private Vector iMatchColumns;
    private Vector strMatchColumns;

    public JdbcRowSetXImpl() {
        try {
            this.initProps(false);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public JdbcRowSetXImpl(Connection con) throws SQLException {
        try {
            this.initProps(true);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.conn = con;
    }

    public JdbcRowSetXImpl(String url, String user, String password) throws SQLException {
        try {
            this.initProps(true);
        }
        catch (SQLException e) {
            // empty catch block
        }
        this.setUsername(user);
        this.setPassword(password);
        this.setUrl(url);
    }

    public JdbcRowSetXImpl(ResultSet res) throws SQLException {
        try {
            this.initProps(true);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.rs = res;
    }

    private void initProps(boolean okToThrowException) throws SQLException {
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.conn = null;
        this.ps = null;
        this.rs = null;
        this.rsmd = null;
        this.resetOnInsertRow();
        this.initParams();
        try {
            this.setAutoCommit(false);
        }
        catch (SQLException sqle) {
            if (okToThrowException) {
                throw sqle;
            }
            System.err.println(rb.getString("SET_AUTO_COMMIT") + sqle.getLocalizedMessage());
        }
        try {
            this.setHoldability(1);
        }
        catch (SQLException sqle) {
            if (okToThrowException) {
                throw sqle;
            }
            System.err.println(rb.getString("SET_HOLDABILITY") + sqle.getLocalizedMessage());
        }
        try {
            this.setShowDeleted(false);
        }
        catch (SQLException sqle) {
            if (okToThrowException) {
                throw sqle;
            }
            System.err.println(rb.getString("SET_SHOW_DELETED") + sqle.getLocalizedMessage());
        }
        try {
            this.setQueryTimeout(0);
        }
        catch (SQLException sqle) {
            if (okToThrowException) {
                throw sqle;
            }
            System.err.println(rb.getString("SET_QUERY_TIMEOUT") + sqle.getLocalizedMessage());
        }
        try {
            this.setMaxRows(0);
        }
        catch (SQLException sqle) {
            if (okToThrowException) {
                throw sqle;
            }
            System.err.println(rb.getString("SET_MAX_ROWS") + sqle.getLocalizedMessage());
        }
        try {
            this.setMaxFieldSize(0);
        }
        catch (SQLException sqle) {
            if (okToThrowException) {
                throw sqle;
            }
            System.err.println(rb.getString("SET_MAX_FIELD_SIZE") + sqle.getLocalizedMessage());
        }
        try {
            this.setEscapeProcessing(true);
        }
        catch (SQLException sqle) {
            if (okToThrowException) {
                throw sqle;
            }
            System.err.println(rb.getString("SET_ESCAPE_PROCESSING") + sqle.getLocalizedMessage());
        }
        this.setTypeMap(null);
        try {
            this.setType(1004);
        }
        catch (SQLException sqle) {
            if (okToThrowException) {
                throw sqle;
            }
            System.err.println(rb.getString("SET_TYPE") + sqle.getLocalizedMessage());
        }
        try {
            this.setConcurrency(1007);
        }
        catch (SQLException sqle) {
            if (okToThrowException) {
                throw sqle;
            }
            System.err.println(rb.getString("SET_CONCURRENCY") + sqle.getLocalizedMessage());
        }
        this.setReadOnly(true);
        try {
            this.setTransactionIsolation(2);
        }
        catch (SQLException sqle) {
            if (okToThrowException) {
                throw sqle;
            }
            System.err.println(rb.getString("SET_TRANSACTION_ISOLATION") + sqle.getLocalizedMessage());
        }
        this.iMatchColumns = new Vector(10);
        for (int i = 0; i < 10; ++i) {
            this.iMatchColumns.add(i, new Integer(-1));
        }
        this.strMatchColumns = new Vector(10);
        for (int j = 0; j < 10; ++j) {
            this.strMatchColumns.add(j, null);
        }
    }

    void checkState() throws SQLException {
        if (this.conn == null && this.ps == null && this.rs == null) {
            throw new SQLException(rb.getString("INVALID_STATE"));
        }
    }

    void checkExecuted() throws SQLException {
        if (this.rs == null) {
            throw new SQLException(rb.getString("EXECUTE_NEVER_CALLED"));
        }
    }

    public boolean isExecuted() throws SQLException {
        return this.rs != null;
    }

    public void execute() throws SQLException {
        this.prepare();
        this.setProperties(this.ps);
        this.decodeParams(this.getParams(), this.ps);
        this.rs = this.ps.executeQuery();
        this.resetOnInsertRow();
        this.notifyRowSetChanged();
    }

    private void setProperties(PreparedStatement ps) throws SQLException {
        try {
            ps.setEscapeProcessing(this.getEscapeProcessing());
        }
        catch (SQLException ex) {
            System.err.println(rb.getString("SET_ESCAPE_PROCESSING") + ex.getLocalizedMessage());
        }
        try {
            ps.setMaxFieldSize(this.getMaxFieldSize());
        }
        catch (SQLException ex) {
            System.err.println(rb.getString("SET_MAX_FIELD_SIZE") + ex.getLocalizedMessage());
        }
        try {
            ps.setMaxRows(this.getMaxRows());
        }
        catch (SQLException ex) {
            System.err.println(rb.getString("SET_MAX_ROWS") + ex.getLocalizedMessage());
        }
        try {
            ps.setQueryTimeout(this.getQueryTimeout());
        }
        catch (SQLException ex) {
            System.err.println(rb.getString("SET_QUERY_TIMEOUT") + ex.getLocalizedMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    protected Connection connect() throws SQLException {
        void var1_6;
        Connection c;
        if (this.conn != null) {
            return this.conn;
        }
        if (this.getDataSourceName() != null) {
            try {
                InitialContext ctx = new InitialContext();
                DataSource ds = (DataSource)ctx.lookup(this.getDataSourceName());
                if (this.getUsername() == null || this.getUsername().equals("")) {
                    c = ds.getConnection();
                }
                c = ds.getConnection(this.getUsername(), this.getPassword());
            }
            catch (NamingException ex) {
                throw new SQLException(rb.getString("UNABLE_TO_CONNECT") + ex.getLocalizedMessage());
            }
        } else if (this.getUrl() != null) {
            c = DriverManager.getConnection(this.getUrl(), this.getUsername(), this.getPassword());
        } else {
            return null;
        }
        try {
            var1_6.setTransactionIsolation(this.getTransactionIsolation());
        }
        catch (SQLException ex) {
            try {
                var1_6.rollback();
                var1_6.setTransactionIsolation(this.getTransactionIsolation());
                System.err.println(rb.getString("INFORMATIONAL") + " " + rb.getString("SET_TRANSACTION_ISOLATION_WORKAROUND"));
            }
            catch (SQLException e2) {
                System.err.println(rb.getString("SET_TRANSACTION_ISOLATION") + ex.getLocalizedMessage());
            }
        }
        var1_6.setAutoCommit(this.autoCommit);
        return var1_6;
    }

    public void setCommand(String command) throws SQLException {
        String oldValue = this.getCommand();
        super.setCommand(command);
        this.close();
        this.propertyChangeSupport.firePropertyChange("command", oldValue, command);
    }

    public void setDataSourceName(String dataSourceName) throws SQLException {
        String oldValue = this.getDataSourceName();
        super.setDataSourceName(dataSourceName);
        this.close();
        this.propertyChangeSupport.firePropertyChange("dataSourceName", oldValue, dataSourceName);
    }

    public void setUrl(String url) throws SQLException {
        String oldValue = this.getUrl();
        super.setUrl(url);
        this.close();
        this.propertyChangeSupport.firePropertyChange("url", oldValue, url);
    }

    public void setUsername(String username) {
        String oldValue = this.getUsername();
        super.setUsername(username);
        this.close();
        this.propertyChangeSupport.firePropertyChange("username", oldValue, username);
    }

    public void setPassword(String password) {
        String oldValue = this.getPassword();
        super.setPassword(password);
        this.close();
        this.propertyChangeSupport.firePropertyChange("password", oldValue, password);
    }

    public void setType(int type) throws SQLException {
        int oldValue = 0;
        try {
            oldValue = this.getType();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        super.setType(type);
        this.closePreparedStatement();
        this.propertyChangeSupport.firePropertyChange("type", oldValue, type);
    }

    public void setConcurrency(int concurrency) throws SQLException {
        int oldValue = 0;
        try {
            oldValue = this.getConcurrency();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        super.setConcurrency(concurrency);
        this.closePreparedStatement();
        this.propertyChangeSupport.firePropertyChange("concurrency", oldValue, concurrency);
    }

    public void setTransactionIsolation(int transactionIsolation) throws SQLException {
        int oldValue = this.getTransactionIsolation();
        super.setTransactionIsolation(transactionIsolation);
        this.close();
        this.propertyChangeSupport.firePropertyChange("transactionIsolation", oldValue, transactionIsolation);
    }

    public void setMaxRows(int maxRows) throws SQLException {
        int oldValue = 0;
        try {
            oldValue = this.getMaxRows();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        super.setMaxRows(maxRows);
        this.closePreparedStatement();
        this.propertyChangeSupport.firePropertyChange("maxRows", oldValue, maxRows);
    }

    private Connection getConnection() throws SQLException {
        return this.connect();
    }

    protected PreparedStatement getPreparedStatement() throws SQLException {
        this.prepare();
        return this.ps;
    }

    private void prepare() throws SQLException {
        this.conn = this.connect();
        try {
            this.conn.setTypeMap(this.getTypeMap());
        }
        catch (Throwable ex) {
            // empty catch block
        }
        try {
            try {
                this.ps = Beans.isDesignTime() ? this.conn.prepareStatement(this.getCommand(), this.getType(), 1007, this.holdability) : this.conn.prepareStatement(this.getCommand(), this.getType(), this.getConcurrency(), this.holdability);
            }
            catch (SQLException e) {
                this.ps = Beans.isDesignTime() ? this.conn.prepareStatement(this.getCommand(), this.getType(), 1007) : this.conn.prepareStatement(this.getCommand(), this.getType(), this.getConcurrency());
            }
            this.ps.setFetchSize(this.getFetchSize());
        }
        catch (SQLException ex) {
            System.err.println(rb.getString("PREPARE") + ex.getLocalizedMessage());
            this.closePreparedStatement();
            throw ex;
        }
    }

    private void decodeParams(Object[] params, PreparedStatement ps) throws SQLException {
        Object[] param = null;
        for (int i = 0; i < params.length; ++i) {
            if (params[i] instanceof Object[]) {
                param = (Object[])params[i];
                if (param.length == 2) {
                    if (param[0] == null) {
                        ps.setNull(i + 1, (Integer)param[1]);
                        continue;
                    }
                    if (param[0] instanceof Date || param[0] instanceof Time || param[0] instanceof Timestamp) {
                        System.err.println(rb.getString("DETECTED_A_DATE"));
                        if (param[1] instanceof Calendar) {
                            System.err.println(rb.getString("DETECTED_A_CALENDAR"));
                            ps.setDate(i + 1, (Date)param[0], (Calendar)param[1]);
                            continue;
                        }
                        throw new SQLException(rb.getString("UNABLE_TO_DEDUCE_PARAM_TYPE"));
                    }
                    if (param[0] instanceof Reader) {
                        ps.setCharacterStream(i + 1, (Reader)param[0], (Integer)param[1]);
                        continue;
                    }
                    if (!(param[1] instanceof Integer)) continue;
                    ps.setObject(i + 1, param[0], (Integer)param[1]);
                    continue;
                }
                if (param.length == 3) {
                    if (param[0] == null) {
                        ps.setNull(i + 1, (Integer)param[1], (String)param[2]);
                        continue;
                    }
                    if (param[0] instanceof InputStream) {
                        switch ((Integer)param[2]) {
                            case 0: {
                                ps.setUnicodeStream(i + 1, (InputStream)param[0], (Integer)param[1]);
                            }
                            case 1: {
                                ps.setBinaryStream(i + 1, (InputStream)param[0], (Integer)param[1]);
                            }
                            case 2: {
                                ps.setAsciiStream(i + 1, (InputStream)param[0], (Integer)param[1]);
                            }
                        }
                        throw new SQLException(rb.getString("UNABLE_TO_DEDUCE_PARAM_TYPE"));
                    }
                    if (param[1] instanceof Integer && param[2] instanceof Integer) {
                        ps.setObject(i + 1, param[0], (Integer)param[1], (int)((Integer)param[2]));
                        continue;
                    }
                    throw new SQLException(rb.getString("UNABLE_TO_DEDUCE_PARAM_TYPE"));
                }
                ps.setObject(i + 1, params[i]);
                continue;
            }
            ps.setObject(i + 1, params[i]);
        }
    }

    public boolean next() throws SQLException {
        this.checkExecuted();
        boolean b = this.rs.next();
        this.notifyCursorMoved();
        return b;
    }

    public void close() {
        this.closeResultSet();
        this.closePreparedStatement();
        if (this.conn != null) {
            try {
                this.conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.conn = null;
        }
    }

    public void closePreparedStatement() {
        this.closeResultSet();
        if (this.ps != null) {
            try {
                this.ps.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.ps = null;
            this.rsmd = null;
        }
    }

    public void closeResultSet() {
        if (this.rs != null) {
            try {
                this.rs.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.rs = null;
        }
    }

    public boolean wasNull() throws SQLException {
        this.checkExecuted();
        if (this.onInsertRow) {
            return this.wasNullObject;
        }
        return this.rs.wasNull();
    }

    public String getString(int columnIndex) throws SQLException {
        return (String)this.handleOnInsertRowGet(this.rs, String.class, columnIndex);
    }

    public boolean getBoolean(int columnIndex) throws SQLException {
        if (!this.onInsertRow) {
            this.checkExecuted();
            return this.rs.getBoolean(columnIndex);
        }
        Object o = this.handleOnInsertRowGet(this.rs, Boolean.class, columnIndex);
        if (o == null) {
            return false;
        }
        return (Boolean)o;
    }

    public byte getByte(int columnIndex) throws SQLException {
        if (!this.onInsertRow) {
            this.checkExecuted();
            return this.rs.getByte(columnIndex);
        }
        Object o = this.handleOnInsertRowGet(this.rs, Byte.class, columnIndex);
        if (o == null) {
            return 0;
        }
        return (Byte)o;
    }

    public short getShort(int columnIndex) throws SQLException {
        if (!this.onInsertRow) {
            this.checkExecuted();
            return this.rs.getShort(columnIndex);
        }
        Object o = this.handleOnInsertRowGet(this.rs, Short.class, columnIndex);
        if (o == null) {
            return 0;
        }
        return (Short)o;
    }

    public int getInt(int columnIndex) throws SQLException {
        if (!this.onInsertRow) {
            this.checkExecuted();
            return this.rs.getInt(columnIndex);
        }
        Object o = this.handleOnInsertRowGet(this.rs, Integer.class, columnIndex);
        if (o == null) {
            return 0;
        }
        return (Integer)o;
    }

    public long getLong(int columnIndex) throws SQLException {
        if (!this.onInsertRow) {
            this.checkExecuted();
            return this.rs.getLong(columnIndex);
        }
        Object o = this.handleOnInsertRowGet(this.rs, Long.class, columnIndex);
        if (o == null) {
            return 0L;
        }
        return (Long)o;
    }

    public float getFloat(int columnIndex) throws SQLException {
        if (!this.onInsertRow) {
            this.checkExecuted();
            return this.rs.getFloat(columnIndex);
        }
        Object o = this.handleOnInsertRowGet(this.rs, Float.class, columnIndex);
        if (o == null) {
            return 0.0f;
        }
        return ((Float)o).floatValue();
    }

    public double getDouble(int columnIndex) throws SQLException {
        if (!this.onInsertRow) {
            this.checkExecuted();
            return this.rs.getDouble(columnIndex);
        }
        Object o = this.handleOnInsertRowGet(this.rs, Double.class, columnIndex);
        if (o == null) {
            return 0.0;
        }
        return (Double)o;
    }

    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        return (BigDecimal)this.handleOnInsertRowGet(this.rs, BigDecimal.class, columnIndex, new Integer(scale));
    }

    public byte[] getBytes(int columnIndex) throws SQLException {
        return (byte[])this.handleOnInsertRowGet(this.rs, [B.class, columnIndex);
    }

    public Date getDate(int columnIndex) throws SQLException {
        return (Date)this.handleOnInsertRowGet(this.rs, Date.class, columnIndex);
    }

    public Time getTime(int columnIndex) throws SQLException {
        return (Time)this.handleOnInsertRowGet(this.rs, Time.class, columnIndex);
    }

    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return (Timestamp)this.handleOnInsertRowGet(this.rs, Timestamp.class, columnIndex);
    }

    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        return (InputStream)this.handleOnInsertRowGet(this.rs, AsciiStream.class, columnIndex);
    }

    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        return (InputStream)this.handleOnInsertRowGet(this.rs, UnicodeStream.class, columnIndex);
    }

    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        return (InputStream)this.handleOnInsertRowGet(this.rs, BinaryStream.class, columnIndex);
    }

    public String getString(String columnName) throws SQLException {
        return this.getString(this.findColumn(columnName));
    }

    public boolean getBoolean(String columnName) throws SQLException {
        return this.getBoolean(this.findColumn(columnName));
    }

    public byte getByte(String columnName) throws SQLException {
        return this.getByte(this.findColumn(columnName));
    }

    public short getShort(String columnName) throws SQLException {
        return this.getShort(this.findColumn(columnName));
    }

    public int getInt(String columnName) throws SQLException {
        return this.getInt(this.findColumn(columnName));
    }

    public long getLong(String columnName) throws SQLException {
        return this.getLong(this.findColumn(columnName));
    }

    public float getFloat(String columnName) throws SQLException {
        return this.getFloat(this.findColumn(columnName));
    }

    public double getDouble(String columnName) throws SQLException {
        return this.getDouble(this.findColumn(columnName));
    }

    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName), scale);
    }

    public byte[] getBytes(String columnName) throws SQLException {
        return this.getBytes(this.findColumn(columnName));
    }

    public Date getDate(String columnName) throws SQLException {
        return this.getDate(this.findColumn(columnName));
    }

    public Time getTime(String columnName) throws SQLException {
        return this.getTime(this.findColumn(columnName));
    }

    public Timestamp getTimestamp(String columnName) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName));
    }

    public InputStream getAsciiStream(String columnName) throws SQLException {
        return this.getAsciiStream(this.findColumn(columnName));
    }

    public InputStream getUnicodeStream(String columnName) throws SQLException {
        return this.getUnicodeStream(this.findColumn(columnName));
    }

    public InputStream getBinaryStream(String columnName) throws SQLException {
        return this.getBinaryStream(this.findColumn(columnName));
    }

    public SQLWarning getWarnings() throws SQLException {
        SQLWarning sqlWarning = null;
        if (this.conn != null) {
            sqlWarning = this.conn.getWarnings();
            if (this.ps != null) {
                SQLWarning cursor;
                SQLWarning temp;
                if (sqlWarning == null) {
                    sqlWarning = this.ps.getWarnings();
                } else {
                    temp = this.ps.getWarnings();
                    if (temp != null) {
                        cursor = sqlWarning;
                        while (cursor.getNextWarning() != null) {
                            cursor = cursor.getNextWarning();
                        }
                        cursor.setNextWarning(temp);
                    }
                }
                if (this.rs != null) {
                    if (sqlWarning == null) {
                        sqlWarning = this.rs.getWarnings();
                    } else {
                        temp = this.rs.getWarnings();
                        if (temp != null) {
                            cursor = sqlWarning;
                            while (cursor.getNextWarning() != null) {
                                cursor = cursor.getNextWarning();
                            }
                            cursor.setNextWarning(temp);
                        }
                    }
                }
            }
        }
        return sqlWarning;
    }

    public void clearWarnings() {
        try {
            if (this.rs != null) {
                this.rs.clearWarnings();
            }
        }
        catch (SQLException e) {
            // empty catch block
        }
        try {
            if (this.ps != null) {
                this.ps.clearWarnings();
            }
        }
        catch (SQLException e) {
            // empty catch block
        }
        try {
            if (this.conn != null) {
                this.conn.clearWarnings();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public String getCursorName() throws SQLException {
        this.checkExecuted();
        return this.rs.getCursorName();
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.rsmd == null) {
            this.conn = this.connect();
            this.checkState();
            if (this.rs == null) {
                if (this.ps == null) {
                    this.prepare();
                }
                this.rsmd = this.ps.getMetaData();
                if (this.rsmd == null) {
                    throw new SQLException(rb.getString("GETMD_NOT_SUPP"));
                }
            } else {
                this.rsmd = this.rs.getMetaData();
            }
        }
        return this.rsmd;
    }

    public Object getObject(int columnIndex) throws SQLException {
        return this.handleOnInsertRowGet(this.rs, Object.class, columnIndex);
    }

    public Object getObject(String columnName) throws SQLException {
        return this.getObject(this.findColumn(columnName));
    }

    public int findColumn(String columnName) throws SQLException {
        if (this.rs != null) {
            return this.rs.findColumn(columnName);
        }
        ResultSetMetaData rsmd = this.getMetaData();
        for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
            if (!rsmd.getColumnName(i).toLowerCase().equals(columnName.toLowerCase())) continue;
            return i;
        }
        throw new SQLException(MessageFormat.format(rb.getString("COLUMN_NOT_FOUND"), columnName));
    }

    public Reader getCharacterStream(int columnIndex) throws SQLException {
        return (Reader)this.handleOnInsertRowGet(this.rs, CharacterStream.class, columnIndex);
    }

    public Reader getCharacterStream(String columnName) throws SQLException {
        return this.getCharacterStream(this.findColumn(columnName));
    }

    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return (BigDecimal)this.handleOnInsertRowGet(this.rs, BigDecimal.class, columnIndex);
    }

    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName));
    }

    public boolean isBeforeFirst() throws SQLException {
        this.checkExecuted();
        if (this.onInsertRow) {
            return false;
        }
        return this.rs.isBeforeFirst();
    }

    public boolean isAfterLast() throws SQLException {
        this.checkExecuted();
        return this.rs.isAfterLast();
    }

    public boolean isFirst() throws SQLException {
        this.checkExecuted();
        return this.rs.isFirst();
    }

    public boolean isLast() throws SQLException {
        this.checkExecuted();
        return this.rs.isLast();
    }

    public void beforeFirst() throws SQLException {
        this.checkExecuted();
        this.rs.beforeFirst();
        this.notifyCursorMoved();
    }

    public void afterLast() throws SQLException {
        this.checkExecuted();
        this.rs.afterLast();
        this.notifyCursorMoved();
    }

    public boolean first() throws SQLException {
        this.checkExecuted();
        boolean b = this.rs.first();
        this.notifyCursorMoved();
        return b;
    }

    public boolean last() throws SQLException {
        this.checkExecuted();
        boolean b = this.rs.last();
        this.notifyCursorMoved();
        return b;
    }

    public int getRow() throws SQLException {
        this.checkExecuted();
        return this.rs.getRow();
    }

    public boolean absolute(int row) throws SQLException {
        this.checkExecuted();
        boolean b = this.rs.absolute(row);
        this.notifyCursorMoved();
        return b;
    }

    public boolean relative(int rows) throws SQLException {
        this.checkExecuted();
        boolean b = this.rs.relative(rows);
        this.notifyCursorMoved();
        return b;
    }

    public boolean previous() throws SQLException {
        this.checkExecuted();
        boolean b = this.rs.previous();
        this.notifyCursorMoved();
        return b;
    }

    public void setFetchDirection(int direction) throws SQLException {
        this.checkExecuted();
        this.rs.setFetchDirection(direction);
    }

    public int getFetchDirection() throws SQLException {
        try {
            this.checkExecuted();
        }
        catch (SQLException sqle) {
            super.getFetchDirection();
        }
        return this.rs.getFetchDirection();
    }

    public void setFetchSize(int rows) throws SQLException {
        super.setFetchSize(rows);
        if (this.ps != null) {
            this.ps.setFetchSize(rows);
        }
        if (this.rs != null) {
            this.rs.setFetchSize(rows);
        }
    }

    public int getFetchSize() throws SQLException {
        if (this.rs != null) {
            return this.rs.getFetchSize();
        }
        if (this.ps != null) {
            return this.ps.getFetchSize();
        }
        return super.getFetchSize();
    }

    public int getType() throws SQLException {
        try {
            this.checkState();
        }
        catch (SQLException sqle) {
            return super.getType();
        }
        if (this.rs != null) {
            return this.rs.getType();
        }
        return super.getType();
    }

    public int getConcurrency() throws SQLException {
        if (Beans.isDesignTime()) {
            return super.getConcurrency();
        }
        try {
            this.checkState();
        }
        catch (SQLException sqle) {
            super.getConcurrency();
        }
        if (this.rs != null) {
            return this.rs.getConcurrency();
        }
        return super.getConcurrency();
    }

    public boolean rowUpdated() throws SQLException {
        this.checkExecuted();
        return this.rs.rowUpdated();
    }

    public boolean rowInserted() throws SQLException {
        this.checkExecuted();
        return this.rs.rowInserted();
    }

    public boolean rowDeleted() throws SQLException {
        this.checkExecuted();
        return this.rs.rowDeleted();
    }

    public void updateNull(int columnIndex) throws SQLException {
        this.checkExecuted();
        this.rs.updateNull(columnIndex);
        this.handleOnInsertRowUpdate(columnIndex, new NullClass());
    }

    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        this.checkExecuted();
        this.rs.updateBoolean(columnIndex, x);
        this.handleOnInsertRowUpdate(columnIndex, new Boolean(x));
    }

    public void updateByte(int columnIndex, byte x) throws SQLException {
        this.checkExecuted();
        this.rs.updateByte(columnIndex, x);
        this.handleOnInsertRowUpdate(columnIndex, new Byte(x));
    }

    public void updateShort(int columnIndex, short x) throws SQLException {
        this.checkExecuted();
        this.rs.updateShort(columnIndex, x);
        this.handleOnInsertRowUpdate(columnIndex, new Short(x));
    }

    public void updateInt(int columnIndex, int x) throws SQLException {
        this.checkExecuted();
        this.rs.updateInt(columnIndex, x);
        this.handleOnInsertRowUpdate(columnIndex, new Integer(x));
    }

    public void updateLong(int columnIndex, long x) throws SQLException {
        this.checkExecuted();
        this.rs.updateLong(columnIndex, x);
        this.handleOnInsertRowUpdate(columnIndex, new Long(x));
    }

    public void updateFloat(int columnIndex, float x) throws SQLException {
        this.checkExecuted();
        this.rs.updateFloat(columnIndex, x);
        this.handleOnInsertRowUpdate(columnIndex, new Float(x));
    }

    public void updateDouble(int columnIndex, double x) throws SQLException {
        this.checkExecuted();
        this.rs.updateDouble(columnIndex, x);
        this.handleOnInsertRowUpdate(columnIndex, new Double(x));
    }

    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        this.checkExecuted();
        this.rs.updateBigDecimal(columnIndex, x);
        if (this.onInsertRow) {
            Object o = this.convertNumeric(x, 2, this.getMetaData().getColumnType(columnIndex));
            this.handleOnInsertRowUpdate(columnIndex, o);
        }
    }

    public void updateString(int columnIndex, String x) throws SQLException {
        this.checkExecuted();
        this.rs.updateString(columnIndex, x);
        this.handleOnInsertRowUpdate(columnIndex, x);
    }

    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        this.checkExecuted();
        this.rs.updateBytes(columnIndex, x);
        this.handleOnInsertRowUpdate(columnIndex, x);
    }

    public void updateDate(int columnIndex, Date x) throws SQLException {
        this.checkExecuted();
        this.rs.updateDate(columnIndex, x);
        if (this.onInsertRow) {
            Object o = this.convertTemporal(x, 91, this.getMetaData().getColumnType(columnIndex));
            this.handleOnInsertRowUpdate(columnIndex, o);
        }
    }

    public void updateTime(int columnIndex, Time x) throws SQLException {
        this.checkExecuted();
        this.rs.updateTime(columnIndex, x);
        if (this.onInsertRow) {
            Object o = this.convertTemporal(x, 92, this.getMetaData().getColumnType(columnIndex));
            this.handleOnInsertRowUpdate(columnIndex, o);
        }
    }

    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        this.checkExecuted();
        this.rs.updateTimestamp(columnIndex, x);
        if (this.onInsertRow) {
            Object o = this.convertTemporal(x, 93, this.getMetaData().getColumnType(columnIndex));
            this.handleOnInsertRowUpdate(columnIndex, o);
        }
    }

    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.checkExecuted();
        this.rs.updateAsciiStream(columnIndex, x, length);
        if (this.onInsertRow) {
            byte[] buf = new byte[length];
            try {
                int charsRead = 0;
                while ((charsRead += x.read(buf, charsRead, length - charsRead)) != length) {
                }
            }
            catch (IOException ex) {
                throw new SQLException(ex.getLocalizedMessage());
            }
            String o = new String(buf);
            this.handleOnInsertRowUpdate(columnIndex, o);
        }
    }

    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.checkExecuted();
        this.rs.updateBinaryStream(columnIndex, x, length);
        if (this.onInsertRow) {
            byte[] buf = new byte[length];
            try {
                int charsRead = 0;
                while ((charsRead += x.read(buf, charsRead, length - charsRead)) != length) {
                }
            }
            catch (IOException ex) {
                throw new SQLException(ex.getLocalizedMessage());
            }
            this.handleOnInsertRowUpdate(columnIndex, buf);
        }
    }

    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        this.checkExecuted();
        this.rs.updateCharacterStream(columnIndex, x, length);
        if (this.onInsertRow) {
            char[] buf = new char[length];
            try {
                int charsRead = 0;
                while ((charsRead += x.read(buf, charsRead, length - charsRead)) != length) {
                }
            }
            catch (IOException ex) {
                throw new SQLException(ex.getLocalizedMessage());
            }
            String o = new String(buf);
            this.handleOnInsertRowUpdate(columnIndex, o);
        }
    }

    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        int type;
        this.checkExecuted();
        this.rs.updateObject(columnIndex, x, scale);
        if (this.onInsertRow && ((type = this.getMetaData().getColumnType(columnIndex)) == 3 || type == 2)) {
            if (x instanceof BigDecimal) {
                ((BigDecimal)x).setScale(scale);
            }
            this.handleOnInsertRowUpdate(columnIndex, x);
        }
    }

    public void updateObject(int columnIndex, Object x) throws SQLException {
        this.checkExecuted();
        this.rs.updateObject(columnIndex, x);
        this.handleOnInsertRowUpdate(columnIndex, x);
    }

    public void updateNull(String columnName) throws SQLException {
        this.updateNull(this.findColumn(columnName));
    }

    public void updateBoolean(String columnName, boolean x) throws SQLException {
        this.updateBoolean(this.findColumn(columnName), x);
    }

    public void updateByte(String columnName, byte x) throws SQLException {
        this.updateByte(this.findColumn(columnName), x);
    }

    public void updateShort(String columnName, short x) throws SQLException {
        this.updateShort(this.findColumn(columnName), x);
    }

    public void updateInt(String columnName, int x) throws SQLException {
        this.updateInt(this.findColumn(columnName), x);
    }

    public void updateLong(String columnName, long x) throws SQLException {
        this.updateLong(this.findColumn(columnName), x);
    }

    public void updateFloat(String columnName, float x) throws SQLException {
        this.updateFloat(this.findColumn(columnName), x);
    }

    public void updateDouble(String columnName, double x) throws SQLException {
        this.updateDouble(this.findColumn(columnName), x);
    }

    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        this.updateBigDecimal(this.findColumn(columnName), x);
    }

    public void updateString(String columnName, String x) throws SQLException {
        this.updateString(this.findColumn(columnName), x);
    }

    public void updateBytes(String columnName, byte[] x) throws SQLException {
        this.updateBytes(this.findColumn(columnName), x);
    }

    public void updateDate(String columnName, Date x) throws SQLException {
        this.updateDate(this.findColumn(columnName), x);
    }

    public void updateTime(String columnName, Time x) throws SQLException {
        this.updateTime(this.findColumn(columnName), x);
    }

    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        this.updateTimestamp(this.findColumn(columnName), x);
    }

    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        this.updateAsciiStream(this.findColumn(columnName), x, length);
    }

    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        this.updateBinaryStream(this.findColumn(columnName), x, length);
    }

    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        this.updateCharacterStream(this.findColumn(columnName), reader, length);
    }

    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        this.updateObject(this.findColumn(columnName), x, scale);
    }

    public void updateObject(String columnName, Object x) throws SQLException {
        this.updateObject(this.findColumn(columnName), x);
    }

    public void insertRow() throws SQLException {
        this.checkExecuted();
        this.rs.insertRow();
        this.resetOnInsertRow();
        this.notifyRowChanged();
    }

    public void updateRow() throws SQLException {
        this.checkExecuted();
        this.rs.updateRow();
        this.notifyRowChanged();
    }

    public void deleteRow() throws SQLException {
        this.checkExecuted();
        this.rs.deleteRow();
        this.notifyRowChanged();
    }

    public void refreshRow() throws SQLException {
        this.checkExecuted();
        this.rs.refreshRow();
    }

    public void cancelRowUpdates() throws SQLException {
        this.checkExecuted();
        this.rs.cancelRowUpdates();
        this.notifyRowChanged();
    }

    public void moveToInsertRow() throws SQLException {
        this.checkExecuted();
        this.rs.moveToInsertRow();
        this.onInsertRow = true;
    }

    public void moveToCurrentRow() throws SQLException {
        this.checkExecuted();
        this.rs.moveToCurrentRow();
    }

    public Statement getStatement() throws SQLException {
        return this.getPreparedStatement();
    }

    public Object getObject(int columnIndex, Map map) throws SQLException {
        Struct s;
        Class c;
        this.checkExecuted();
        if (!this.onInsertRow) {
            return this.rs.getObject(columnIndex, map);
        }
        Object o = this.handleOnInsertRowGet(this.rs, Object.class, columnIndex);
        if (this.wasNull()) {
            return null;
        }
        if (o instanceof Struct && (c = (Class)map.get((s = (Struct)o).getSQLTypeName())) != null) {
            SQLData obj = null;
            try {
                obj = (SQLData)c.newInstance();
            }
            catch (InstantiationException ex) {
                throw new SQLException(ex.getLocalizedMessage());
            }
            catch (IllegalAccessException ex) {
                throw new SQLException(ex.getLocalizedMessage());
            }
            Object[] attribs = s.getAttributes(map);
            SQLInputImpl sqlInput = new SQLInputImpl(attribs, map);
            obj.readSQL(sqlInput, s.getSQLTypeName());
            return obj;
        }
        return o;
    }

    public Ref getRef(int columnIndex) throws SQLException {
        return (Ref)this.handleOnInsertRowGet(this.rs, Ref.class, columnIndex);
    }

    public Blob getBlob(int columnIndex) throws SQLException {
        return (Blob)this.handleOnInsertRowGet(this.rs, Blob.class, columnIndex);
    }

    public Clob getClob(int columnIndex) throws SQLException {
        return (Clob)this.handleOnInsertRowGet(this.rs, Clob.class, columnIndex);
    }

    public Array getArray(int columnIndex) throws SQLException {
        return (Array)this.handleOnInsertRowGet(this.rs, Array.class, columnIndex);
    }

    public Object getObject(String colName, Map map) throws SQLException {
        return this.getObject(this.findColumn(colName), map);
    }

    public Ref getRef(String colName) throws SQLException {
        return this.getRef(this.findColumn(colName));
    }

    public Blob getBlob(String colName) throws SQLException {
        return this.getBlob(this.findColumn(colName));
    }

    public Clob getClob(String colName) throws SQLException {
        return this.getClob(this.findColumn(colName));
    }

    public Array getArray(String colName) throws SQLException {
        return this.getArray(this.findColumn(colName));
    }

    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        return (Date)this.handleOnInsertRowGet(this.rs, Date.class, columnIndex, cal);
    }

    public Date getDate(String columnName, Calendar cal) throws SQLException {
        return this.getDate(this.findColumn(columnName), cal);
    }

    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        return (Time)this.handleOnInsertRowGet(this.rs, Time.class, columnIndex, cal);
    }

    public Time getTime(String columnName, Calendar cal) throws SQLException {
        return this.getTime(this.findColumn(columnName), cal);
    }

    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        return (Timestamp)this.handleOnInsertRowGet(this.rs, Timestamp.class, columnIndex, cal);
    }

    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName), cal);
    }

    public void updateRef(int columnIndex, Ref ref) throws SQLException {
        this.checkExecuted();
        this.rs.updateRef(columnIndex, ref);
        this.handleOnInsertRowUpdate(columnIndex, new SerialRef(ref));
    }

    public void updateRef(String columnName, Ref ref) throws SQLException {
        this.updateRef(this.findColumn(columnName), ref);
    }

    public void updateClob(int columnIndex, Clob c) throws SQLException {
        this.checkExecuted();
        this.rs.updateClob(columnIndex, c);
        this.handleOnInsertRowUpdate(columnIndex, new SerialClob(c));
    }

    public void updateClob(String columnName, Clob c) throws SQLException {
        this.updateClob(this.findColumn(columnName), c);
    }

    public void updateBlob(int columnIndex, Blob b) throws SQLException {
        this.checkExecuted();
        this.rs.updateBlob(columnIndex, b);
        this.handleOnInsertRowUpdate(columnIndex, new SerialBlob(b));
    }

    public void updateBlob(String columnName, Blob b) throws SQLException {
        this.updateBlob(this.findColumn(columnName), b);
    }

    public void updateArray(int columnIndex, Array a) throws SQLException {
        this.checkExecuted();
        this.rs.updateArray(columnIndex, a);
        this.handleOnInsertRowUpdate(columnIndex, new SerialArray(a));
    }

    public void updateArray(String columnName, Array a) throws SQLException {
        this.updateArray(this.findColumn(columnName), a);
    }

    public URL getURL(int columnIndex) throws SQLException {
        return (URL)this.handleOnInsertRowGet(this.rs, URL.class, columnIndex);
    }

    public URL getURL(String columnName) throws SQLException {
        return this.getURL(this.findColumn(columnName));
    }

    public RowSetWarning getRowSetWarnings() throws SQLException {
        return null;
    }

    public void unsetMatchColumn(int[] columnIdxes) throws SQLException {
        for (int j = 0; j < columnIdxes.length; ++j) {
            int i_val = Integer.parseInt(this.iMatchColumns.get(j).toString());
            if (columnIdxes[j] == i_val) continue;
            throw new SQLException(rb.getString("MATCH_COLUMNS_NOT_THE_SAME"));
        }
        for (int i = 0; i < columnIdxes.length; ++i) {
            this.iMatchColumns.set(i, new Integer(-1));
        }
    }

    public void unsetMatchColumn(String[] columnIdxes) throws SQLException {
        for (int j = 0; j < columnIdxes.length; ++j) {
            if (columnIdxes[j].equals(this.strMatchColumns.get(j))) continue;
            throw new SQLException(rb.getString("MATCH_COLUMNS_NOT_THE_SAME"));
        }
        for (int i = 0; i < columnIdxes.length; ++i) {
            this.strMatchColumns.set(i, null);
        }
    }

    public String[] getMatchColumnNames() throws SQLException {
        Object[] str_temp = new String[this.strMatchColumns.size()];
        if (this.strMatchColumns.get(0) == null) {
            throw new SQLException(rb.getString("SET_MATCH_COLUMNS_BEFORE_GETTING"));
        }
        this.strMatchColumns.copyInto(str_temp);
        return str_temp;
    }

    public int[] getMatchColumnIndexes() throws SQLException {
        Object[] int_temp = new Integer[this.iMatchColumns.size()];
        int[] i_temp = new int[this.iMatchColumns.size()];
        int i_val = (Integer)this.iMatchColumns.get(0);
        if (i_val == -1) {
            throw new SQLException(rb.getString("SET_MATCH_COLUMNS_BEFORE_GETTING"));
        }
        this.iMatchColumns.copyInto(int_temp);
        for (int i = 0; i < int_temp.length; ++i) {
            i_temp[i] = (Integer)int_temp[i];
        }
        return i_temp;
    }

    public void setMatchColumn(int[] columnIdxes) throws SQLException {
        for (int j = 0; j < columnIdxes.length; ++j) {
            if (columnIdxes[j] >= 0) continue;
            throw new SQLException(rb.getString("MATCH_COL_SHOULD_BE_GT_0"));
        }
        for (int i = 0; i < columnIdxes.length; ++i) {
            this.iMatchColumns.add(i, new Integer(columnIdxes[i]));
        }
    }

    public void setMatchColumn(String[] columnNames) throws SQLException {
        for (int j = 0; j < columnNames.length; ++j) {
            if (columnNames[j] != null && !columnNames[j].equals("")) continue;
            throw new SQLException(rb.getString("MATCH_COL_CANNOT_BE_NULL_OR_EMPTY"));
        }
        for (int i = 0; i < columnNames.length; ++i) {
            this.strMatchColumns.add(i, columnNames[i]);
        }
    }

    public void setMatchColumn(int columnIdx) throws SQLException {
        if (columnIdx < 0) {
            throw new SQLException(rb.getString("COL_ID_HAS_TO_BE_GT_0"));
        }
        this.iMatchColumns.set(0, new Integer(columnIdx));
    }

    public void setMatchColumn(String columnName) throws SQLException {
        if ((columnName = columnName.trim()) == "" || columnName.equals(null)) {
            throw new SQLException(rb.getString("COL_ID_HAS_TO_BE_NON_NULL"));
        }
        this.strMatchColumns.set(0, columnName);
    }

    public void unsetMatchColumn(int columnIdx) throws SQLException {
        if (!this.iMatchColumns.get(0).equals(new Integer(columnIdx))) {
            throw new SQLException(rb.getString("COL_UNSET_NOT_SAME_AS_SET"));
        }
        if (this.strMatchColumns.get(0) != null) {
            throw new SQLException(rb.getString("USE_COL_NAME_AS_ARG_TO_UNSETMATCHCOL"));
        }
        this.iMatchColumns.set(0, new Integer(-1));
    }

    public void unsetMatchColumn(String columnName) throws SQLException {
        columnName = columnName.trim();
        if (!this.strMatchColumns.get(0).equals(columnName)) {
            throw new SQLException(rb.getString("COL_UNSET_NOT_SAME_AS_SET"));
        }
        if ((Integer)this.iMatchColumns.get(0) > 0) {
            throw new SQLException(rb.getString("USE_COL_ID_AS_ARG_TO_UNSETMATCHCOL"));
        }
        this.strMatchColumns.set(0, null);
    }

    public DatabaseMetaData getDatabaseMetaData() throws SQLException {
        return this.getConnection().getMetaData();
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.getConnection().releaseSavepoint(savepoint);
    }

    public Savepoint setSavepoint() throws SQLException {
        return this.getConnection().setSavepoint();
    }

    public Savepoint setSavepoint(String name) throws SQLException {
        return this.getConnection().setSavepoint(name);
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        return this.getPreparedStatement().getParameterMetaData();
    }

    public void commit() throws SQLException {
        this.getConnection().commit();
        if (this.getHoldability() != 1) {
            this.closeResultSet();
        }
    }

    public void rollback() throws SQLException {
        this.getConnection().rollback();
    }

    public void rollback(Savepoint s) throws SQLException {
        this.getConnection().rollback(s);
        this.closeResultSet();
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.autoCommit = autoCommit;
        if (this.conn != null) {
            this.conn.setAutoCommit(autoCommit);
        }
    }

    public boolean getAutoCommit() throws SQLException {
        if (this.conn != null) {
            return this.conn.getAutoCommit();
        }
        return this.autoCommit;
    }

    public void setHoldability(int holdability) throws SQLException {
        try {
            if (this.ps != null && this.ps.getResultSetHoldability() != holdability) {
                this.closePreparedStatement();
            }
        }
        catch (SQLException e) {
            // empty catch block
        }
        if (this.holdability != holdability) {
            int oldValue = this.getHoldability();
            this.holdability = holdability;
            this.propertyChangeSupport.firePropertyChange("holdability", oldValue, holdability);
        }
    }

    public int getHoldability() throws SQLException {
        if (this.ps != null) {
            try {
                return this.ps.getResultSetHoldability();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return this.holdability;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    private void handleOnInsertRowUpdate(int columnIndex, Object o) {
        if (this.onInsertRow) {
            this.insertedRowObjects.put(new Integer(columnIndex), o);
        }
    }

    private void resetOnInsertRow() {
        this.onInsertRow = false;
        this.wasNullObject = false;
        if (this.insertedRowObjects == null) {
            this.insertedRowObjects = new HashMap();
        } else {
            this.insertedRowObjects.clear();
        }
    }

    private Object handleOnInsertRowGet(ResultSet rs, Class clazz, int columnIndex) throws SQLException {
        return this.handleOnInsertRowGet(rs, clazz, columnIndex, null, null);
    }

    private Object handleOnInsertRowGet(ResultSet rs, Class clazz, int columnIndex, Calendar cal) throws SQLException {
        return this.handleOnInsertRowGet(rs, clazz, columnIndex, null, cal);
    }

    private Object handleOnInsertRowGet(ResultSet rs, Class clazz, int columnIndex, Integer scale) throws SQLException {
        return this.handleOnInsertRowGet(rs, clazz, columnIndex, scale, null);
    }

    private Object handleOnInsertRowGet(ResultSet rs, Class clazz, int columnIndex, Integer scale, Calendar cal) throws SQLException {
        this.checkExecuted();
        if (this.onInsertRow) {
            Object o = this.insertedRowObjects.get(new Integer(columnIndex));
            if (o == null || o instanceof NullClass) {
                this.wasNullObject = true;
                return null;
            }
            this.wasNullObject = false;
            if (clazz == BigDecimal.class) {
                try {
                    if (scale == null) {
                        return new BigDecimal(o.toString().trim());
                    }
                    return new BigDecimal(new BigInteger(o.toString().trim()), scale);
                }
                catch (NumberFormatException e) {
                    throw new SQLException(e.getLocalizedMessage());
                }
            }
            if (clazz == AsciiStream.class) {
                this.asciiStream = null;
                try {
                    if (this.isString(this.getMetaData().getColumnType(columnIndex))) {
                        this.asciiStream = new ByteArrayInputStream(((String)o).getBytes("ASCII"));
                        return this.asciiStream;
                    }
                    throw new SQLException(rb.getString("DATATYPE_MISMATCH"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new SQLException(e.getLocalizedMessage());
                }
            }
            if (clazz == UnicodeStream.class) {
                this.unicodeStream = null;
                if (this.isBinary(this.getMetaData().getColumnType(columnIndex)) || this.isString(this.getMetaData().getColumnType(columnIndex))) {
                    this.unicodeStream = new StringBufferInputStream(o.toString());
                    return this.unicodeStream;
                }
                throw new SQLException(rb.getString("DATATYPE_MISMATCH"));
            }
            if (clazz == BinaryStream.class) {
                this.binaryStream = null;
                if (this.isBinary(this.getMetaData().getColumnType(columnIndex))) {
                    this.binaryStream = new ByteArrayInputStream((byte[])o);
                    return this.binaryStream;
                }
                throw new SQLException(rb.getString("DATATYPE_MISMATCH"));
            }
            if (clazz == CharacterStream.class) {
                if (this.isBinary(this.getMetaData().getColumnType(columnIndex))) {
                    return new InputStreamReader(new ByteArrayInputStream((byte[])o));
                }
                if (this.isString(this.getMetaData().getColumnType(columnIndex))) {
                    return new StringReader(o.toString());
                }
                throw new SQLException(rb.getString("DATATYPE_MISMATCH"));
            }
            if (clazz == Ref.class) {
                if (this.getMetaData().getColumnType(columnIndex) != 2006) {
                    throw new SQLException(rb.getString("DATATYPE_MISMATCH"));
                }
            } else if (clazz == Blob.class) {
                if (this.getMetaData().getColumnType(columnIndex) != 2004) {
                    throw new SQLException(rb.getString("DATATYPE_MISMATCH"));
                }
            } else if (clazz == Clob.class) {
                if (this.getMetaData().getColumnType(columnIndex) != 2005) {
                    throw new SQLException(rb.getString("DATATYPE_MISMATCH"));
                }
            } else if (clazz == Array.class) {
                if (this.getMetaData().getColumnType(columnIndex) != 2003) {
                    throw new SQLException(rb.getString("DATATYPE_MISMATCH"));
                }
            } else {
                if (clazz == Date.class) {
                    Object date = this.convertTemporal(o, this.getMetaData().getColumnType(columnIndex), 91);
                    if (cal == null) {
                        return date;
                    }
                    Calendar defaultCal = Calendar.getInstance();
                    defaultCal.setTime((java.util.Date)date);
                    cal.set(1, defaultCal.get(1));
                    cal.set(2, defaultCal.get(2));
                    cal.set(5, defaultCal.get(5));
                    return new Date(cal.getTime().getTime());
                }
                if (clazz == Time.class) {
                    Object time = this.convertTemporal(o, this.getMetaData().getColumnType(columnIndex), 92);
                    if (cal == null) {
                        return time;
                    }
                    Calendar defaultCal = Calendar.getInstance();
                    defaultCal.setTime((java.util.Date)time);
                    cal.set(11, defaultCal.get(11));
                    cal.set(12, defaultCal.get(12));
                    cal.set(13, defaultCal.get(13));
                    return new Time(cal.getTime().getTime());
                }
                if (clazz == Timestamp.class) {
                    Object timestamp = this.convertTemporal(o, this.getMetaData().getColumnType(columnIndex), 93);
                    if (cal == null) {
                        return timestamp;
                    }
                    Calendar defaultCal = Calendar.getInstance();
                    defaultCal.setTime((java.util.Date)timestamp);
                    cal.set(1, defaultCal.get(1));
                    cal.set(2, defaultCal.get(2));
                    cal.set(5, defaultCal.get(5));
                    cal.set(11, defaultCal.get(11));
                    cal.set(12, defaultCal.get(12));
                    cal.set(13, defaultCal.get(13));
                    return new Timestamp(cal.getTime().getTime());
                }
                if (clazz == URL.class) {
                    if (this.getMetaData().getColumnType(columnIndex) != 70) {
                        throw new SQLException(rb.getString("DATATYPE_MISMATCH"));
                    }
                } else {
                    if (clazz == Boolean.class) {
                        try {
                            return o instanceof Boolean ? o : new Boolean(o.toString().trim());
                        }
                        catch (NumberFormatException e) {
                            throw new SQLException(e.getLocalizedMessage());
                        }
                    }
                    if (clazz == Byte.class) {
                        try {
                            return o instanceof Byte ? o : new Byte(o.toString().trim());
                        }
                        catch (NumberFormatException e) {
                            throw new SQLException(e.getLocalizedMessage());
                        }
                    }
                    if (clazz == Short.class) {
                        try {
                            return o instanceof Short ? o : new Short(o.toString().trim());
                        }
                        catch (NumberFormatException e) {
                            throw new SQLException(e.getLocalizedMessage());
                        }
                    }
                    if (clazz == Integer.class) {
                        try {
                            return o instanceof Integer ? o : new Integer(o.toString().trim());
                        }
                        catch (NumberFormatException e) {
                            throw new SQLException(e.getLocalizedMessage());
                        }
                    }
                    if (clazz == Long.class) {
                        try {
                            return o instanceof Long ? o : new Long(o.toString().trim());
                        }
                        catch (NumberFormatException e) {
                            throw new SQLException(e.getLocalizedMessage());
                        }
                    }
                    if (clazz == Float.class) {
                        try {
                            return o instanceof Float ? o : new Float(o.toString().trim());
                        }
                        catch (NumberFormatException e) {
                            throw new SQLException(e.getLocalizedMessage());
                        }
                    }
                    if (clazz == Double.class) {
                        try {
                            return o instanceof Double ? o : new Double(o.toString().trim());
                        }
                        catch (NumberFormatException e) {
                            throw new SQLException(e.getLocalizedMessage());
                        }
                    }
                }
            }
            return o;
        }
        if (clazz == String.class) {
            return rs.getString(columnIndex);
        }
        if (clazz == BigDecimal.class) {
            if (scale == null) {
                return rs.getBigDecimal(columnIndex);
            }
            return rs.getBigDecimal(columnIndex, (int)scale);
        }
        if (clazz == [B.class) {
            return rs.getBytes(columnIndex);
        }
        if (clazz == Date.class) {
            if (cal == null) {
                return rs.getDate(columnIndex);
            }
            return rs.getDate(columnIndex, cal);
        }
        if (clazz == Time.class) {
            if (cal == null) {
                return rs.getTime(columnIndex);
            }
            return rs.getTime(columnIndex, cal);
        }
        if (clazz == Timestamp.class) {
            if (cal == null) {
                return rs.getTimestamp(columnIndex);
            }
            return rs.getTimestamp(columnIndex, cal);
        }
        if (clazz == AsciiStream.class) {
            return rs.getAsciiStream(columnIndex);
        }
        if (clazz == UnicodeStream.class) {
            return rs.getUnicodeStream(columnIndex);
        }
        if (clazz == BinaryStream.class) {
            return rs.getBinaryStream(columnIndex);
        }
        if (clazz == CharacterStream.class) {
            return rs.getCharacterStream(columnIndex);
        }
        if (clazz == Ref.class) {
            return rs.getRef(columnIndex);
        }
        if (clazz == Blob.class) {
            return rs.getBlob(columnIndex);
        }
        if (clazz == Clob.class) {
            return rs.getClob(columnIndex);
        }
        if (clazz == Array.class) {
            return rs.getArray(columnIndex);
        }
        if (clazz == URL.class) {
            return rs.getURL(columnIndex);
        }
        return rs.getObject(columnIndex);
    }

    private boolean isNumeric(int type) {
        switch (type) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    private boolean isBinary(int type) {
        switch (type) {
            case -4: 
            case -3: 
            case -2: {
                return true;
            }
        }
        return false;
    }

    private boolean isString(int type) {
        switch (type) {
            case -1: 
            case 1: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    private boolean isTemporal(int type) {
        switch (type) {
            case 91: 
            case 92: 
            case 93: {
                return true;
            }
        }
        return false;
    }

    private Object convertNumeric(Object srcObj, int srcType, int trgType) throws SQLException {
        if (srcType == trgType) {
            return srcObj;
        }
        if (!this.isNumeric(trgType) && !this.isString(trgType)) {
            throw new SQLException(rb.getString("DATATYPE_MISMATCH"));
        }
        try {
            switch (trgType) {
                case -7: {
                    Integer i = new Integer(srcObj.toString().trim());
                    return i.equals(new Integer(0)) ? new Boolean(false) : new Boolean(true);
                }
                case -6: {
                    return new Byte(srcObj.toString().trim());
                }
                case 5: {
                    return new Short(srcObj.toString().trim());
                }
                case 4: {
                    return new Integer(srcObj.toString().trim());
                }
                case -5: {
                    return new Long(srcObj.toString().trim());
                }
                case 2: 
                case 3: {
                    return new BigDecimal(srcObj.toString().trim());
                }
                case 6: 
                case 7: {
                    return new Float(srcObj.toString().trim());
                }
                case 8: {
                    return new Double(srcObj.toString().trim());
                }
                case -1: 
                case 1: 
                case 12: {
                    return new String(srcObj.toString());
                }
            }
            throw new SQLException(rb.getString("DATATYPE_MISMATCH"));
        }
        catch (NumberFormatException ex) {
            throw new SQLException(rb.getString("DATATYPE_MISMATCH"));
        }
    }

    private Object convertTemporal(Object srcObj, int srcType, int trgType) throws SQLException {
        if (srcType == trgType) {
            return srcObj;
        }
        if (this.isNumeric(trgType) || !this.isString(trgType) && !this.isTemporal(trgType)) {
            throw new SQLException(rb.getString("DATATYPE_MISMATCH"));
        }
        try {
            switch (trgType) {
                case 91: {
                    if (srcType == 93) {
                        return new Date(((Timestamp)srcObj).getTime());
                    }
                    throw new SQLException(rb.getString("DATATYPE_MISMATCH"));
                }
                case 93: {
                    if (srcType == 92) {
                        return new Timestamp(((Time)srcObj).getTime());
                    }
                    return new Timestamp(((Date)srcObj).getTime());
                }
                case 92: {
                    if (srcType == 93) {
                        return new Time(((Timestamp)srcObj).getTime());
                    }
                    throw new SQLException(rb.getString("DATATYPE_MISMATCH"));
                }
                case -1: 
                case 1: 
                case 12: {
                    return new String(srcObj.toString());
                }
            }
            throw new SQLException(rb.getString("DATATYPE_MISMATCH"));
        }
        catch (NumberFormatException ex) {
            throw new SQLException(rb.getString("DATATYPE_MISMATCH"));
        }
    }

    private class CharacterStream {
        private CharacterStream() {
        }
    }

    private class BinaryStream {
        private BinaryStream() {
        }
    }

    private class UnicodeStream {
        private UnicodeStream() {
        }
    }

    private class AsciiStream {
        private AsciiStream() {
        }
    }

    private class NullClass {
        private NullClass() {
        }
    }
}

