/*
 * Decompiled with CFR 0.152.
 */
package com.sun.sql.rowset;

import com.sun.sql.rowset.RowSetMetaDataX;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.sql.rowset.RowSetMetaDataImpl;

public class RowSetMetaDataXImpl
extends RowSetMetaDataImpl
implements RowSetMetaDataX {
    private static ResourceBundle rb = ResourceBundle.getBundle("com.sun.sql.rowset.Bundle", Locale.getDefault());
    String[] columnClassName;
    boolean[] definitelyWritable;
    boolean[] readOnly;
    boolean[] writable;

    public void setColumnCount(int columnCount) throws SQLException {
        super.setColumnCount(columnCount);
        if (columnCount != Integer.MAX_VALUE) {
            this.columnClassName = new String[columnCount + 1];
            this.definitelyWritable = new boolean[columnCount + 1];
            this.readOnly = new boolean[columnCount + 1];
            this.writable = new boolean[columnCount + 1];
        }
    }

    public void setColumnClassName(int columnIndex, String className) throws SQLException {
        this.checkColumnIndex(columnIndex);
        this.columnClassName[columnIndex] = className;
    }

    public void setDefinitelyWritable(int columnIndex, boolean value) throws SQLException {
        this.checkColumnIndex(columnIndex);
        this.definitelyWritable[columnIndex] = value;
    }

    public void setReadOnly(int columnIndex, boolean value) throws SQLException {
        this.checkColumnIndex(columnIndex);
        this.readOnly[columnIndex] = value;
    }

    public void setWritable(int columnIndex, boolean value) throws SQLException {
        this.checkColumnIndex(columnIndex);
        this.writable[columnIndex] = value;
    }

    public String getColumnClassName(int columnIndex) throws SQLException {
        this.checkColumnIndex(columnIndex);
        String className = this.columnClassName[columnIndex];
        if (className.equals("byte[]")) {
            className = new byte[0].getClass().getName();
        } else if (className.equals("char[]")) {
            className = new char[0].getClass().getName();
        } else if (className.equals("short[]")) {
            className = new short[0].getClass().getName();
        } else if (className.equals("int[]")) {
            className = new int[0].getClass().getName();
        } else if (className.equals("long[]")) {
            className = new long[0].getClass().getName();
        } else if (className.equals("float[]")) {
            className = new float[0].getClass().getName();
        } else if (className.equals("double[]")) {
            className = new double[0].getClass().getName();
        } else if (className.equals("boolean[]")) {
            className = new boolean[0].getClass().getName();
        }
        return className;
    }

    public boolean isDefinitelyWritable(int columnIndex) throws SQLException {
        this.checkColumnIndex(columnIndex);
        return this.definitelyWritable[columnIndex];
    }

    public boolean isReadOnly(int columnIndex) throws SQLException {
        this.checkColumnIndex(columnIndex);
        return this.readOnly[columnIndex];
    }

    public boolean isWritable(int columnIndex) throws SQLException {
        this.checkColumnIndex(columnIndex);
        return this.writable[columnIndex];
    }

    private void checkColumnIndex(int columnIndex) throws SQLException {
        if (columnIndex <= 0 || columnIndex > this.getColumnCount()) {
            throw new SQLException(MessageFormat.format(rb.getString("INVALID_COLUMN_INDEX"), new Integer(columnIndex)));
        }
    }
}

