/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.console.config;

import com.sun.web.console.config.ConsoleConfigException;
import com.sun.web.console.config.ConsoleConfigLog;
import com.sun.web.console.config.ConsoleConfigUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

public class ConsoleConfigStatus {
    private String configStatusDir = null;
    private String configStatusFilepath = null;
    private Properties statusProps = new Properties();
    File configStatusFile = null;
    public static final String INIT = "init";
    public static final String COMPLETE = "complete";
    public static final String UNDEFINED = "undefined";
    private static final String DOMAIN = "domain";
    private static final String SUBDIRS = "subdirs";
    private static final String CONTAINER = "container";
    private static final String KEYENTRY = "keyentry";
    private static final String UPGRADE = "upgrade";
    private static final String USERNAME = "username";
    private static final String INITCONF = "initial-config";

    public ConsoleConfigStatus(Properties properties) throws ConsoleConfigException {
        String string;
        String string2;
        String string3 = System.getProperty("com.sun.web.console.conf");
        if (properties != null) {
            string2 = properties.getProperty("console_conf");
            string = properties.getProperty("console_instance");
            if (string2 == null || string == null) {
                ConsoleConfigException consoleConfigException = new ConsoleConfigException("driver_err_06");
                throw consoleConfigException;
            }
        } else {
            ConsoleConfigException consoleConfigException = new ConsoleConfigException("driver_err_22");
            throw consoleConfigException;
        }
        this.configStatusDir = string2 + File.separator + string;
        this.configStatusFilepath = this.configStatusDir + File.separator + "status.properties";
        this.createConfigStatusFile();
    }

    private void createConfigStatusFile() throws ConsoleConfigException {
        this.configStatusFile = new File(this.configStatusFilepath);
        try {
            if (!this.exists()) {
                boolean bl = this.configStatusFile.createNewFile();
                if (!bl) {
                    ConsoleConfigException consoleConfigException = new ConsoleConfigException("driver_err_23", this.configStatusFilepath);
                    throw consoleConfigException;
                }
            } else {
                this.loadProperties();
            }
        }
        catch (Exception exception) {
            ConsoleConfigLog.log(1, exception);
            ConsoleConfigException consoleConfigException = new ConsoleConfigException("driver_err_23", this.configStatusFilepath);
            throw consoleConfigException;
        }
    }

    private void loadProperties() throws IOException {
        this.statusProps.load(new FileInputStream(this.configStatusFilepath));
    }

    private void writeProperties() throws ConsoleConfigException {
        ConsoleConfigUtil.storeProperties(this.configStatusFilepath, this.statusProps, null);
    }

    private boolean updateProperty(String string, String string2) {
        boolean bl;
        block2: {
            bl = false;
            Object object = this.statusProps.setProperty(string, string2);
            try {
                this.writeProperties();
                bl = true;
            }
            catch (Exception exception) {
                if (object == null) break block2;
                this.statusProps.setProperty(string, (String)object);
            }
        }
        return bl;
    }

    private String getProperty(String string) {
        String string2 = null;
        if (this.statusProps != null) {
            string2 = this.statusProps.getProperty(string);
        }
        return string2 == null ? UNDEFINED : string2;
    }

    public String getconfigStatusFilepath() {
        return this.configStatusFilepath;
    }

    public void setconfigStatusFilepath(String string) throws ConsoleConfigException {
        this.configStatusFilepath = string;
        if (string != null) {
            this.createConfigStatusFile();
        }
    }

    public boolean exists() {
        boolean bl = false;
        if (this.configStatusFile != null) {
            bl = this.configStatusFile.exists();
        }
        return bl;
    }

    public boolean setDomainInit() {
        return this.updateProperty(DOMAIN, INIT);
    }

    public boolean setDomainComplete() {
        return this.updateProperty(DOMAIN, COMPLETE);
    }

    public boolean setSubdirsInit() {
        return this.updateProperty(SUBDIRS, INIT);
    }

    public boolean setSubdirsComplete() {
        return this.updateProperty(SUBDIRS, COMPLETE);
    }

    public boolean setContainerInit() {
        return this.updateProperty(CONTAINER, INIT);
    }

    public boolean setContainerComplete() {
        return this.updateProperty(CONTAINER, COMPLETE);
    }

    public boolean setKeyEntryInit() {
        return this.updateProperty(KEYENTRY, INIT);
    }

    public boolean setKeyEntryComplete() {
        return this.updateProperty(KEYENTRY, COMPLETE);
    }

    public boolean setUpgradeInit() {
        return this.updateProperty(UPGRADE, INIT);
    }

    public boolean setUpgradeComplete() {
        return this.updateProperty(UPGRADE, COMPLETE);
    }

    public boolean setInitialConfigInit() {
        return this.updateProperty(INITCONF, INIT);
    }

    public boolean setInitialConfigComplete() {
        return this.updateProperty(INITCONF, COMPLETE);
    }

    public boolean setUserName(String string) {
        return this.updateProperty(USERNAME, string);
    }

    public String getDomainStatus() {
        return this.getProperty(DOMAIN);
    }

    public String getSubdirsStatus() {
        return this.getProperty(SUBDIRS);
    }

    public String getContainerStatus() {
        return this.getProperty(CONTAINER);
    }

    public String getKeyEntryStatus() {
        return this.getProperty(KEYENTRY);
    }

    public String getUpgradeStatus() {
        return this.getProperty(UPGRADE);
    }

    public String getInitialConfigStatus() {
        return this.getProperty(INITCONF);
    }

    public String getUserName() {
        return this.getProperty(USERNAME);
    }

    public boolean isDomainComplete() {
        boolean bl = false;
        if (this.getDomainStatus().equals(COMPLETE)) {
            bl = true;
        }
        return bl;
    }

    public boolean isSubdirsComplete() {
        boolean bl = false;
        if (this.getSubdirsStatus().equals(COMPLETE)) {
            bl = true;
        }
        return bl;
    }

    public boolean isContainerComplete() {
        boolean bl = false;
        if (this.getContainerStatus().equals(COMPLETE)) {
            bl = true;
        }
        return bl;
    }

    public boolean isKeyEntryComplete() {
        boolean bl = false;
        if (this.getKeyEntryStatus().equals(COMPLETE)) {
            bl = true;
        }
        return bl;
    }

    public boolean isUpgradeComplete() {
        boolean bl = false;
        if (this.getUpgradeStatus().equals(COMPLETE)) {
            bl = true;
        }
        return bl;
    }

    public boolean isInitialConfigComplete() {
        boolean bl = false;
        if (this.getInitialConfigStatus().equals(COMPLETE)) {
            bl = true;
        }
        return bl;
    }
}

