/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.console.config;

import com.sun.web.console.config.ConsoleConfigException;
import com.sun.web.console.config.ConsoleConfigLog;
import com.sun.web.console.config.ConsoleConfigRegnot;
import com.sun.web.console.config.ConsoleConfigUtil;
import com.sun.web.console.config.SectionedProperties;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;

public class ConsoleConfigUpgrade {
    private String prefix = this.getInstallDir();
    private final String FS = File.separator;
    public String PLUS21_REG_DB_PATH = this.prefix + this.FS + "var" + this.FS + "opt" + this.FS + "webconsole";
    public String PLUS21_WEBAPPS_DIR = this.PLUS21_REG_DB_PATH + this.FS + "webapps";
    public static final String DEFAULT_APPNAME = "legacy";
    public static String LEGACY_PLUGIN_DB = "registered_plugins";
    public static String LEGACY_JAR_DB = "registered_jars";
    public static String LEGACY_MODULE_DB = "registered_modules";
    public static String COMMENT_CHAR = "#";
    public static String DB_FIELD_SEPARATOR = "|";
    public String UPGRADE_CACHE_PATH = this.prefix + this.FS + "var" + this.FS + "opt" + this.FS + "webconsole" + this.FS + ".upgrade";
    public String UPGRADE_MODULE_FILE = this.prefix + this.FS + "var" + this.FS + "opt" + this.FS + "webconsole" + this.FS + ".upgradeLoginModules";
    public String UPGRADE_FILE = this.prefix + this.FS + "usr" + this.FS + "lib" + this.FS + "webconsole" + this.FS + ".upgrade";
    public String DEFER_FILE_PATH = "private" + this.FS + "deferredRegistrations" + this.FS + ".reg";
    public String DEFER_CACHE_PATH = this.prefix + this.FS + "var" + this.FS + "opt" + this.FS + "webconsole" + this.FS + ".reg";
    public String PROP_FILE_21_PLUS = this.prefix + this.FS + "etc" + this.FS + "opt" + this.FS + "webconsole" + this.FS + "webconsole";
    public String SMREG_CMD = "bin" + this.FS + "smreg";
    public String BAT_EXT = ".bat";
    public String ADD_CMD = "add";
    public String DASH_A = "-a";
    public String DASH_X = "-x";
    public String DASH_Q = "-q";
    public String DASH = "-";
    public final String JAR_SUFFIX = ".jar";
    public final String EXCLUDE_DELIM = " ";
    public String EXCLUDE_PLUGINS = " com.sun.web.console com.sun.web.ui com.sun.web.admin.example";
    public String EXCLUDE_MODULES = " com.sun.management.services.authentication.PamLoginModule com.sun.management.services.authentication.RbacRoleLoginModule";
    public String EXCLUDE_JARS = " com_sun_management_services_api.jar com_sun_management_services_impl.jar com_sun_management_console_impl.jar com_sun_management_webcommon.jar com_iplanet_jato_jato.jar com_sun_management_solaris_impl.jar com_sun_management_solaris_implx.jar com_sun_management_cc.jar com_sun_management_linux_impl.jar com_sun_management_linux_implx.jar com_sun_management_hpux_impl.jar com_sun_management_hpux_implx.jar";
    public final int NO_UPGRADE = 0;
    public final int UPGRADE_10 = 10;
    public final int UPGRADE_20 = 20;
    public final int UPGRADE_21 = 21;
    public final int ERR_UPGRADE = -1;
    public final int MAX_PLUGIN_DBS = 3;
    private final String UNIX_FS = "/";
    private final String WIN_FS = "\\";
    private final String WEBINF_LIB = "WEB-INF" + this.FS + "lib";
    Properties configProperties = null;

    private String getInstallDir() {
        String string = System.getProperty("os.name", "");
        if (string != null && string.toLowerCase().indexOf("windows") == -1) {
            return "";
        }
        String string2 = System.getProperty("com.sun.web.console.conf");
        this.configProperties = null;
        try {
            this.configProperties = ConsoleConfigUtil.getEnvProperties(string2, "console");
        }
        catch (Exception exception) {
            return "";
        }
        String string3 = this.configProperties.getProperty("console_home", "");
        return string3;
    }

    private void checkProp(String string, String string2, String string3) throws ConsoleConfigException {
        if (string == null || string.length() == 0) {
            ConsoleConfigException consoleConfigException = new ConsoleConfigException(string3, string2);
            ConsoleConfigLog.log(1, (Throwable)((Object)consoleConfigException));
            throw consoleConfigException;
        }
    }

    private File[] getRegDBs(String string, Properties properties) throws ConsoleConfigException {
        File[] fileArray = new File[3];
        int n = 0;
        String string2 = properties.getProperty("console_upgrade_home", "");
        File file = new File(string2 + string);
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equals(LEGACY_MODULE_DB) && !stringArray[i].equals(LEGACY_PLUGIN_DB) && !stringArray[i].equals(LEGACY_JAR_DB)) continue;
                fileArray[n] = new File(string2 + this.FS + string + this.FS + stringArray[i]);
                ++n;
            }
        }
        if (n > 0) {
            return fileArray;
        }
        return null;
    }

    private File[] getLegacyDBs(Properties properties) throws ConsoleConfigException {
        File[] fileArray = this.getRegDBs(this.PLUS21_REG_DB_PATH, properties);
        if (fileArray != null && fileArray.length > 0) {
            return fileArray;
        }
        return null;
    }

    private String getInstancePath(Properties properties) throws ConsoleConfigException {
        String string = properties.getProperty("console_instance", "");
        String string2 = properties.getProperty("console_conf", "");
        if (string2.equals("")) {
            throw new ConsoleConfigException("driver_err_35");
        }
        string2 = string2 + this.FS + string;
        return string2;
    }

    private void createModuleRegnot(String[] stringArray, String string) throws ConsoleConfigException {
        Object object;
        String string2;
        if (stringArray.length < 3 || stringArray.length > 4) {
            return;
        }
        String string3 = stringArray[0];
        String string4 = stringArray[1];
        String string5 = stringArray[2];
        String string6 = string2 = stringArray.length == 4 ? stringArray[3] : null;
        if (this.EXCLUDE_MODULES.indexOf(" " + string4) != -1) {
            return;
        }
        Properties properties = new Properties();
        properties.setProperty("appname", DEFAULT_APPNAME);
        String string7 = string4.replaceAll("\\.", "_");
        properties.setProperty("id", string7);
        properties.setProperty("type", "loginmodule");
        properties.setProperty("class", string4);
        properties.setProperty("service", string3);
        properties.setProperty("behavior", string5);
        if (string2 != null && (object = string2.split("\" ")) != null) {
            for (int i = 0; i < ((Object)object).length; ++i) {
                String[] stringArray2 = null;
                String string8 = null;
                String string9 = null;
                stringArray2 = ((String)object[i]).split("=");
                if (stringArray2 == null || stringArray2.length != 2) continue;
                string8 = "option_" + stringArray2[0].trim();
                string9 = stringArray2[1];
                string9 = string9.replaceAll("\"", " ");
                string9 = string9.trim();
                properties.setProperty(string8, string9);
            }
        }
        object = new ConsoleConfigRegnot(string);
        ((ConsoleConfigRegnot)object).write(properties);
    }

    private Properties createJarRegnot(String[] stringArray, String string) throws ConsoleConfigException, IOException {
        if (stringArray.length != 3) {
            return null;
        }
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        String string4 = stringArray[2].replaceAll("\"", "");
        if (this.EXCLUDE_JARS.indexOf(" " + string3) != -1) {
            return null;
        }
        Properties properties = new Properties();
        properties.setProperty("appname", DEFAULT_APPNAME);
        String string5 = string4.endsWith(".jar") ? string4.substring(0, string4.indexOf(".jar")) : string4;
        string5 = string5.replace("/".charAt(0), '_');
        string5 = string5.replace("\\".charAt(0), '_');
        string5 = string5.replaceAll("[a-zA-Z]:", "");
        properties.setProperty("id", string5);
        properties.setProperty("type", "jar");
        properties.setProperty("location", string4);
        ConsoleConfigRegnot consoleConfigRegnot = new ConsoleConfigRegnot(string);
        if (string2.equals("ALL")) {
            consoleConfigRegnot.write(properties);
        }
        properties.setProperty("scope", string2);
        properties.setProperty("name", string3);
        return properties;
    }

    private void deleteLegacyPluginDir(String[] stringArray) throws ConsoleConfigException {
        try {
            String string = stringArray[0];
            String string2 = this.PLUS21_WEBAPPS_DIR + this.FS + string;
            if (string != null && string.length() > 0) {
                File file = new File(string2);
                if (file.exists() && file.isDirectory() && file.canWrite()) {
                    ConsoleConfigUtil.deleteFile(file);
                } else {
                    ConsoleConfigLog.log(1, "driver_err_51", string2);
                }
            } else {
                ConsoleConfigLog.log(1, "driver_err_51", string2);
            }
        }
        catch (ConsoleConfigException consoleConfigException) {
            ConsoleConfigLog.log(1, (Throwable)((Object)consoleConfigException));
        }
    }

    private void smreg(String[] stringArray, Properties properties) throws ConsoleConfigException {
        String string;
        if (stringArray.length != 5) {
            return;
        }
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        String string4 = stringArray[2];
        String string5 = stringArray[3];
        int n = string3.indexOf("_");
        String string6 = string = n == -1 ? string3 : string3.substring(0, n);
        if (this.EXCLUDE_PLUGINS.indexOf(" " + string) != -1) {
            return;
        }
        String string7 = properties.getProperty("console_home") + this.FS + this.SMREG_CMD;
        String string8 = System.getProperty("os.name", "");
        if (string8 != null && string8.toLowerCase().indexOf("windows") != -1) {
            string7 = string7 + this.BAT_EXT;
        }
        String string9 = new String(string7 + " " + this.DASH_Q + " " + this.ADD_CMD + " " + this.DASH_A + " " + this.DASH_X + " " + string2 + " " + string4);
        int n2 = -1;
        n2 = ConsoleConfigUtil.execCommand(string9);
        if (n2 != 0) {
            ConsoleConfigLog.trace(n2 + "returned executing the command :\n\t" + string9);
        }
    }

    private void upgrade21PlusProps(Properties properties) throws ConsoleConfigException {
        String string = this.getInstancePath(properties);
        String string2 = string + this.FS + "service.properties";
        File file = new File(string2);
        File file2 = new File(this.PROP_FILE_21_PLUS);
        try {
            if (file2.exists()) {
                Properties properties2 = ConsoleConfigUtil.loadProperties(this.PROP_FILE_21_PLUS);
                Properties properties3 = ConsoleConfigUtil.loadProperties(string2);
                if (!properties3.isEmpty()) {
                    ConsoleConfigUtil.mergeProperties(properties3, properties2);
                }
                if (!properties2.isEmpty()) {
                    ConsoleConfigUtil.storeProperties(string2, properties2, null);
                }
            }
        }
        catch (Exception exception) {
            ConsoleConfigLog.trace("Error merging properties ", exception);
            ConsoleConfigLog.log(1, "driver_err_55", string2);
        }
    }

    private void upgrade21Plus(File[] fileArray, Properties properties) throws ConsoleConfigException {
        ArrayList<Properties> arrayList = new ArrayList<Properties>();
        String string = this.getInstancePath(properties);
        String string2 = string + this.FS + "prereg";
        if (fileArray == null || fileArray.length <= 0) {
            return;
        }
        try {
            int n;
            BufferedReader bufferedReader = null;
            String string3 = new String();
            String string4 = null;
            for (n = 0; n < fileArray.length; ++n) {
                if (fileArray[n] == null) continue;
                bufferedReader = new BufferedReader(new FileReader(fileArray[n].getPath()));
                string4 = fileArray[n].getName();
                while ((string3 = bufferedReader.readLine()) != null) {
                    String[] stringArray;
                    if (string3.startsWith(COMMENT_CHAR) || (stringArray = string3.split("\\" + DB_FIELD_SEPARATOR)) == null || stringArray.length <= 0) continue;
                    if (string4.equals(LEGACY_MODULE_DB)) {
                        this.createModuleRegnot(stringArray, string2);
                        continue;
                    }
                    if (string4.equals(LEGACY_JAR_DB)) {
                        Properties properties2 = this.createJarRegnot(stringArray, string2);
                        if (!this.isAppScopedJar(properties2)) continue;
                        properties2 = this.getContextForAppScopedJar(fileArray[n].getPath(), properties2);
                        arrayList.add(properties2);
                        continue;
                    }
                    if (!string4.equals(LEGACY_PLUGIN_DB)) continue;
                    this.deleteLegacyPluginDir(stringArray);
                    this.smreg(stringArray, properties);
                }
                bufferedReader.close();
            }
            for (n = 0; n < arrayList.size(); ++n) {
                this.copyAppScopedJar((Properties)arrayList.get(n), properties);
            }
        }
        catch (Exception exception) {
            ConsoleConfigLog.trace("Error running smreg ", exception);
            ConsoleConfigLog.log(1, "driver_err_42");
        }
    }

    private boolean checkTimestamp(File file, File file2) throws ConsoleConfigException {
        boolean bl = false;
        if (file.isFile()) {
            long l = file.lastModified();
            if (file2.isFile()) {
                long l2 = file2.lastModified();
                if (l2 < l) {
                    file2.setLastModified(l);
                    bl = true;
                }
            } else {
                try {
                    if (!file2.createNewFile()) {
                        throw new ConsoleConfigException("driver_err_36");
                    }
                    file2.setLastModified(l);
                }
                catch (Exception exception) {
                    throw new ConsoleConfigException("driver_err_36");
                }
                bl = true;
            }
        }
        return bl;
    }

    private void processSectionedProperties(File file, Properties properties) {
        try {
            Object object;
            ArrayList arrayList = new ArrayList();
            String string = this.getInstancePath(properties);
            String string2 = string + this.FS + "prereg";
            SectionedProperties sectionedProperties = new SectionedProperties();
            Properties properties2 = null;
            sectionedProperties.load(new FileInputStream(file));
            Iterator iterator = sectionedProperties.blockNames();
            while (iterator.hasNext()) {
                Object object2;
                String string3;
                String string4 = (String)iterator.next();
                object = null;
                if (string4 != null) {
                    object = string4.substring(0, string4.indexOf(this.DASH));
                    if (object == null) {
                        ConsoleConfigLog.log(1, "driver_err_39");
                        continue;
                    }
                } else {
                    ConsoleConfigLog.log(1, "driver_err_39");
                    continue;
                }
                object = ((String)object).trim();
                Properties properties3 = sectionedProperties.getBlock(string4);
                if (properties3 == null) {
                    ConsoleConfigLog.log(1, "driver_err_39");
                    continue;
                }
                if (((String)object).equals("webapp")) {
                    string3 = properties3.getProperty("location");
                    object2 = properties3.getProperty("context");
                    if (string3 != null && object2 != null) {
                        String[] stringArray = new String[]{object2, object2, string3, "", ""};
                        this.smreg(stringArray, properties);
                        continue;
                    }
                    ConsoleConfigLog.log(1, "driver_err_39");
                    continue;
                }
                if (((String)object).equals("jar")) {
                    string3 = properties3.getProperty("location");
                    if (string3 != null) {
                        string3 = string3.endsWith(".jar") ? string3.substring(0, string3.indexOf(".jar")) : string3;
                        string3 = string3.replace(File.separatorChar, '_');
                        properties3.setProperty("id", string3);
                        properties3.setProperty("type", (String)object);
                        properties3.setProperty("appname", DEFAULT_APPNAME);
                        object2 = new ConsoleConfigRegnot(string2);
                        ((ConsoleConfigRegnot)object2).write(properties3);
                        continue;
                    }
                    ConsoleConfigLog.log(1, "driver_err_39");
                    continue;
                }
                if (((String)object).equals("loginmodule")) {
                    string3 = properties3.getProperty("class");
                    if (string3 != null) {
                        string3 = string3.replace('.', '_');
                        properties3.setProperty("id", string3);
                        properties3.setProperty("type", (String)object);
                        properties3.setProperty("appname", DEFAULT_APPNAME);
                        object2 = new ConsoleConfigRegnot(string2);
                        ((ConsoleConfigRegnot)object2).write(properties3);
                        continue;
                    }
                    ConsoleConfigLog.log(1, "driver_err_39");
                    continue;
                }
                if (!((String)object).equals("property")) continue;
                if (properties2 == null) {
                    properties2 = new Properties(properties3);
                    continue;
                }
                ConsoleConfigUtil.mergeProperties(properties3, properties2);
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                this.copyAppScopedJar((Properties)arrayList.get(i), properties);
            }
            String string5 = string + this.FS + "service.properties";
            object = ConsoleConfigUtil.loadProperties(string5);
            ConsoleConfigUtil.mergeProperties(properties2, (Properties)object);
            ConsoleConfigUtil.storeProperties(string5, (Properties)object, null);
        }
        catch (IOException iOException) {
            ConsoleConfigLog.log(1, "driver_err_39");
        }
        catch (ConsoleConfigException consoleConfigException) {
            ConsoleConfigLog.log(1, "driver_err_39");
        }
    }

    private int determineUpgradeSource(File[] fileArray, File file, File file2) throws ConsoleConfigException {
        if (fileArray != null) {
            return 21;
        }
        if (fileArray == null && file.isFile() && !file2.isFile()) {
            return 20;
        }
        if (fileArray == null && file2.isFile()) {
            return 10;
        }
        return 0;
    }

    private boolean isAppScopedJar(Properties properties) {
        boolean bl = false;
        if (properties == null) {
            return bl;
        }
        String string = properties.getProperty("scope");
        if (string == null) {
            ConsoleConfigLog.log(1, "driver_err_52");
        } else if (!string.equals("ALL")) {
            bl = true;
        }
        return bl;
    }

    private void copyAppScopedJar(Properties properties, Properties properties2) {
        try {
            File file;
            File file2;
            String string = properties.getProperty("scope", "");
            String string2 = properties.getProperty("context", "");
            if (string2.equals("")) {
                string2 = string;
            }
            String string3 = properties.getProperty("name");
            String string4 = properties2.getProperty("console_appbase", null);
            if (string4 != null) {
                String string5 = properties.getProperty("location");
                if (string5 == null) {
                    ConsoleConfigLog.log(1, "driver_err_53");
                    return;
                }
                file2 = new File(string5);
                if (!file2.isFile()) {
                    ConsoleConfigLog.log(1, "driver_err_54", string5);
                    return;
                }
                file = new File(string4 + this.FS + string2 + this.FS + this.WEBINF_LIB);
                if (!file.isDirectory()) {
                    ConsoleConfigLog.log(1, "driver_err_57", file.getPath());
                    return;
                }
            } else {
                ConsoleConfigLog.log(1, "driver_err_01", "console_appbase");
                return;
            }
            String string6 = file.getPath() + this.FS + (string3 == null ? file2.getName() : string3);
            ConsoleConfigUtil.copyBinaryFile(file2.getPath(), string6);
        }
        catch (Exception exception) {
            ConsoleConfigLog.log(1, "driver_err_59");
            ConsoleConfigLog.log(1, exception);
        }
    }

    private Properties getContextForAppScopedJar(String string, Properties properties) {
        File file = null;
        File file2 = new File(string);
        if (string != null && !string.equals("")) {
            file = new File(file2.getParent() + this.FS + LEGACY_PLUGIN_DB);
            if (file == null || !file.isFile()) {
                return properties;
            }
        } else {
            return properties;
        }
        String string2 = properties.getProperty("scope", "");
        BufferedReader bufferedReader = null;
        String string3 = new String();
        try {
            bufferedReader = new BufferedReader(new FileReader(file.getPath()));
            while ((string3 = bufferedReader.readLine()) != null) {
                String[] stringArray;
                if (string3.startsWith(COMMENT_CHAR) || (stringArray = string3.split("\\" + DB_FIELD_SEPARATOR)) == null || stringArray.length <= 0) continue;
                String string4 = stringArray[0];
                String string5 = stringArray[1];
                if (!string5.equals(string2)) continue;
                properties.setProperty("context", string4);
                break;
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return properties;
    }

    public void performUpgrade(Properties properties) throws ConsoleConfigException {
        File file;
        File file2;
        String string = properties.getProperty("console_instance", "");
        if (string.equals("") || !string.equals("console")) {
            return;
        }
        File[] fileArray = this.getLegacyDBs(properties);
        int n = this.determineUpgradeSource(fileArray, file2 = new File(this.UPGRADE_FILE), file = new File(this.UPGRADE_MODULE_FILE));
        if (21 == n) {
            this.upgrade21Plus(fileArray, properties);
            this.upgrade21PlusProps(properties);
        }
        if (20 == n || 10 == n) {
            File file3 = new File(this.UPGRADE_CACHE_PATH);
            if (this.checkTimestamp(file2, file3)) {
                this.processSectionedProperties(file2, properties);
            }
            if (10 == n) {
                this.processSectionedProperties(file, properties);
            }
        }
    }

    public void registerDeferredObjects(Properties properties) throws ConsoleConfigException {
        String string = properties.getProperty("console_instance", "");
        if (string.equals("") || !string.equals("console")) {
            return;
        }
        String string2 = properties.getProperty("console_home", "");
        if (string2.equals("")) {
            ConsoleConfigLog.log(1, "driver_err_46", "console_home");
            ConsoleConfigLog.log(1, "driver_err_39");
        } else {
            File file;
            File file2 = new File(string2 + this.FS + this.DEFER_FILE_PATH);
            if (this.checkTimestamp(file2, file = new File(this.DEFER_CACHE_PATH))) {
                this.processSectionedProperties(file2, properties);
            }
        }
    }
}

