/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.console.config;

import com.sun.management.services.common.CCServiceLibrary;
import com.sun.web.console.config.ConsoleConfigConstants;
import com.sun.web.console.config.ConsoleConfigException;
import com.sun.web.console.config.ConsoleConfigExecProcess;
import com.sun.web.console.config.ConsoleConfigLog;
import com.sun.web.console.config.ConsoleConfigLoginModule;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class ConsoleConfigUtil {
    private static final String ADMIN_USER_NAME = "ADMIN_USERNAME";
    private static final String ADMIN_USER_PSWD = "ADMIN_USERPSWD";
    private static final String ADMIN_TRUSTSTORE_FILE = "ADMIN_TRUSTSTORE_FILE";
    private static final String ADMIN_TRUSTSTORE_PSWD = "ADMIN_TRUSTSTORE_PSWD";
    private static final String JAR_MANIFEST_VERSION_KEY = "Implementation-Version";
    private static final String FS = File.separator;
    private static final String LS = System.getProperty("line.separator");

    public static int execCommand(Object object) throws ConsoleConfigException {
        if (object == null) {
            throw new ConsoleConfigException("util_err_07");
        }
        String string = new String();
        try {
            String[] stringArray;
            Object object2;
            Object object3;
            Runtime runtime = Runtime.getRuntime();
            Process process = null;
            String string2 = "";
            if (object instanceof String) {
                object3 = (String[])object;
                string = object3;
                object2 = ((String)object3).split(" ");
                string2 = object2[0];
                ConsoleConfigLog.trace("Exec command: " + string);
                process = runtime.exec((String)object3);
            } else if (object instanceof String[]) {
                object3 = (String[])object;
                for (int i = 0; i < ((String[])object3).length; ++i) {
                    string = string.concat(object3[i] + " ");
                }
                string2 = object3[0];
                ConsoleConfigLog.trace("Exec command: " + string);
                process = runtime.exec((String[])object3);
            } else {
                throw new ConsoleConfigException("util_err_08");
            }
            object3 = process.getInputStream();
            object2 = process.getErrorStream();
            OutputStream outputStream = process.getOutputStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)object3));
            BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader((InputStream)object2));
            outputStream.close();
            String string3 = null;
            String string4 = null;
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            int n = 0;
            boolean bl = true;
            while (bl) {
                String string5;
                try {
                    if (bufferedReader.ready() && (string3 = bufferedReader.readLine()) != null && (string5 = string3.trim()).length() > 0) {
                        arrayList2.add(string5);
                    }
                }
                catch (IOException iOException) {
                    throw new ConsoleConfigException("util_err_09", iOException.getLocalizedMessage());
                }
                try {
                    if (bufferedReader2.ready() && (string4 = bufferedReader2.readLine()) != null) {
                        string5 = string4.trim();
                        if (string5.length() > 0) {
                            arrayList.add(string5);
                        }
                        if (string5.length() > 6 && string5.startsWith("WCERR:")) {
                            string5 = string5.substring(6).trim();
                            ConsoleConfigLog.log(1, "util_err_23", string2, string5);
                        }
                    }
                }
                catch (IOException iOException) {
                    throw new ConsoleConfigException("util_err_10", iOException.getLocalizedMessage());
                }
                try {
                    n = process.exitValue();
                    bl = false;
                }
                catch (IllegalThreadStateException illegalThreadStateException) {
                    Thread.currentThread();
                    Thread.sleep(100L);
                }
                catch (Exception exception) {
                    throw new ConsoleConfigException("execCommand: unexpected ecception from exitValue: " + exception.getMessage());
                }
            }
            bufferedReader.close();
            bufferedReader2.close();
            ((InputStream)object3).close();
            ((InputStream)object2).close();
            int n2 = 4;
            if (n > 0) {
                stringArray = new ConsoleConfigException("util_err_24", Integer.toString(n), string);
                ConsoleConfigLog.log(3, (Throwable)stringArray);
                n2 = 3;
            }
            if (arrayList.size() > 0) {
                arrayList.add(0, "Exec command error output:");
                stringArray = new String[arrayList.size()];
                stringArray = arrayList.toArray(stringArray);
                ConsoleConfigLog.log(n2, stringArray);
            }
            n2 = ConsoleConfigLog.getLevel();
            if (n > 0 && arrayList2.size() > 0 && n2 == 4) {
                arrayList2.add(0, "Exec command standard output:");
                stringArray = new String[arrayList2.size()];
                stringArray = arrayList2.toArray(stringArray);
                ConsoleConfigLog.trace(stringArray);
            }
            return n;
        }
        catch (Exception exception) {
            throw new ConsoleConfigException("util_err_11", string, exception.getLocalizedMessage());
        }
    }

    public static int createJKSCertificate(String string, String string2, String string3, String string4, String string5) throws ConsoleConfigException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CN=").append(ConsoleConfigUtil.getHostName()).append(", OU=Solaris Management Products and Tools, ").append("O=Sun Microsystems, L=Burlington, ST=Mass, C=US");
        Vector<String> vector = new Vector<String>();
        vector.addElement(string);
        vector.addElement("-genkey");
        vector.addElement("-alias");
        vector.addElement(string2);
        vector.addElement("-keyalg");
        vector.addElement(string4);
        vector.addElement("-keypass");
        vector.addElement(string5);
        vector.addElement("-storepass");
        vector.addElement(string5);
        vector.addElement("-keystore");
        vector.addElement(string3);
        vector.addElement("-dname");
        vector.addElement(stringBuffer.toString());
        vector.addElement("-validity");
        vector.addElement("2000");
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return ConsoleConfigUtil.execCommand(stringArray);
    }

    public static int exportJKSCertificate(String string, String string2, String string3, String string4, String string5) throws ConsoleConfigException {
        Vector<String> vector = new Vector<String>();
        vector.addElement(string);
        vector.addElement("-export");
        vector.addElement("-alias");
        vector.addElement(string2);
        vector.addElement("-file");
        vector.addElement(string3);
        vector.addElement("-storepass");
        vector.addElement(string5);
        vector.addElement("-keystore");
        vector.addElement(string4);
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return ConsoleConfigUtil.execCommand(stringArray);
    }

    public static int exportNSSCertificate(String string, String string2, String string3, String string4) throws ConsoleConfigException {
        Vector<String> vector = new Vector<String>();
        vector.addElement(string);
        vector.addElement("-L");
        vector.addElement("-d");
        vector.addElement(string4);
        vector.addElement("-n");
        vector.addElement(string2);
        vector.addElement("-a");
        vector.addElement("-o");
        vector.addElement(string3);
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return ConsoleConfigUtil.execCommand(stringArray);
    }

    public static int importJKSCertificate(String string, String string2, String string3, String string4, String string5) throws ConsoleConfigException {
        Vector<String> vector = new Vector<String>();
        vector.addElement(string);
        vector.addElement("-import");
        vector.addElement("-noprompt");
        vector.addElement("-alias");
        vector.addElement(string2);
        vector.addElement("-file");
        vector.addElement(string3);
        vector.addElement("-storepass");
        vector.addElement(string5);
        vector.addElement("-keystore");
        vector.addElement(string4);
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return ConsoleConfigUtil.execCommand(stringArray);
    }

    public static ConsoleConfigLoginModule[] listLoginModules(String string) throws ConsoleConfigException {
        throw new ConsoleConfigException("Not yet implemented!");
    }

    public static void addLoginServiceDefinition(String string, ConsoleConfigLoginModule[] consoleConfigLoginModuleArray, String string2, String string3) throws ConsoleConfigException {
        if (consoleConfigLoginModuleArray == null || consoleConfigLoginModuleArray.length == 0) {
            throw new ConsoleConfigException("util_err_12");
        }
        String string4 = string2 + File.separator + string3;
        String string5 = string2 + File.separator + "login.temp";
        String string6 = string2 + File.separator + "login.save";
        try {
            int n;
            String string7;
            String[] stringArray;
            Object object;
            File file = new File(string4);
            File file2 = new File(string5);
            File file3 = new File(string6);
            if (file2.exists()) {
                file2.delete();
            }
            file2 = File.createTempFile("login", "temp", new File(string2));
            if (file.exists()) {
                if (file3.exists()) {
                    file3.delete();
                }
                file.renameTo(file3);
            }
            FileWriter fileWriter = new FileWriter(file2);
            PrintWriter printWriter = new PrintWriter(fileWriter);
            if (file3.exists()) {
                FileReader fileReader = new FileReader(file3);
                object = new BufferedReader(fileReader);
                stringArray = null;
                string7 = null;
                n = 0;
                boolean bl = false;
                int n2 = -1;
                while ((stringArray = ((BufferedReader)object).readLine()) != null) {
                    if (n != 0) {
                        string7 = stringArray.trim();
                        if (!string7.equals("};")) continue;
                        n = 0;
                        bl = false;
                        continue;
                    }
                    n2 = stringArray.indexOf("{");
                    if (n2 == -1) {
                        printWriter.println((String)stringArray);
                        continue;
                    }
                    string7 = stringArray.substring(0, n2);
                    StringTokenizer stringTokenizer = new StringTokenizer(string7);
                    int n3 = stringTokenizer.countTokens();
                    String string8 = null;
                    if (n3 > 0) {
                        string8 = stringTokenizer.nextToken();
                    }
                    if (string8 != null && string8.equalsIgnoreCase(string)) {
                        n = 1;
                        bl = true;
                        continue;
                    }
                    printWriter.println((String)stringArray);
                }
                ((BufferedReader)object).close();
                fileReader.close();
            }
            printWriter.println("");
            printWriter.println(string + " {");
            for (int i = 0; i < consoleConfigLoginModuleArray.length; ++i) {
                object = consoleConfigLoginModuleArray[i];
                stringArray = object.getOptionNames();
                string7 = "";
                if (stringArray == null || stringArray.length == 0) {
                    string7 = ";" + LS;
                }
                printWriter.println("    " + object.getClassName() + " " + object.getControlFlag() + string7);
                if (stringArray == null || stringArray.length <= 0) continue;
                printWriter.print("\t");
                for (n = 0; n < stringArray.length; ++n) {
                    printWriter.print(" " + stringArray[n] + "=\"" + object.getOption(stringArray[n]) + "\"");
                }
                printWriter.print(";" + LS);
            }
            printWriter.println("    };");
            printWriter.close();
            fileWriter.close();
            file2.renameTo(file);
        }
        catch (Exception exception) {
            ConsoleConfigLog.trace("Error creating service definition", exception);
            throw new ConsoleConfigException("util_err_13", exception.getLocalizedMessage());
        }
    }

    public static void copySystemRegnots(Properties properties, String string) throws ConsoleConfigException {
        String string2 = properties.getProperty("console_conf") + FS + properties.getProperty("console_instance") + FS + "prereg" + FS + "console";
        String string3 = "Console system resource registration notification";
        String[] stringArray = null;
        try {
            File file = new File(string);
            stringArray = file.list();
        }
        catch (Exception exception) {
            throw new ConsoleConfigException("util_err_22", exception.getLocalizedMessage());
        }
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].endsWith(".reg")) continue;
                String string4 = string + FS + stringArray[i];
                String string5 = string2 + FS + stringArray[i];
                ConsoleConfigUtil.copyProperties(string4, string5, null, string3, properties);
            }
        }
    }

    public static Properties loadProperties(String string) throws ConsoleConfigException {
        Properties properties = new Properties();
        FileInputStream fileInputStream = null;
        ConsoleConfigException consoleConfigException = null;
        try {
            File file = new File(string);
            if (file.exists()) {
                fileInputStream = new FileInputStream(file);
                properties.load(fileInputStream);
            }
        }
        catch (Exception exception) {
            consoleConfigException = new ConsoleConfigException("Error loading properties: {0}", exception.getLocalizedMessage());
        }
        if (fileInputStream != null) {
            try {
                fileInputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (consoleConfigException != null) {
            throw consoleConfigException;
        }
        return properties;
    }

    public static void storeProperties(String string, Properties properties, String string2) throws ConsoleConfigException {
        String string3 = "";
        int n = string.lastIndexOf(FS);
        if (n > 0) {
            string3 = string.substring(0, n + 1);
        }
        File file = new File(string);
        File file2 = new File(string3 + "temp.properties");
        File file3 = new File(string3 + "backup.properties");
        FileOutputStream fileOutputStream = null;
        ConsoleConfigException consoleConfigException = null;
        boolean bl = false;
        try {
            if (file2.exists()) {
                file2.delete();
            }
            fileOutputStream = new FileOutputStream(file2);
            properties.store(fileOutputStream, string2);
            fileOutputStream.close();
            fileOutputStream = null;
            if (file.exists()) {
                file3.delete();
                bl = file.renameTo(file3);
                if (!bl) {
                    ConsoleConfigUtil.renamePropFile(file, file3, string2);
                    bl = false;
                }
            }
            if (!(bl = file2.renameTo(file))) {
                ConsoleConfigUtil.renamePropFile(file2, file, string2);
                bl = false;
            }
        }
        catch (Exception exception) {
            consoleConfigException = new ConsoleConfigException("Error storing properties: {0}", exception.getLocalizedMessage());
        }
        if (file3.exists()) {
            try {
                file3.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (fileOutputStream != null) {
            try {
                fileOutputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (consoleConfigException != null) {
            throw consoleConfigException;
        }
    }

    private static void renamePropFile(File file, File file2, String string) throws Exception {
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        Properties properties = ConsoleConfigUtil.loadProperties(file.getPath());
        properties.store(fileOutputStream, string);
        if (fileOutputStream != null) {
            try {
                fileOutputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        file.delete();
    }

    public static Properties mergeProperties(Properties properties, Properties properties2) {
        if (properties == null) {
            properties = new Properties();
        }
        if (properties2 == null) {
            properties2 = new Properties();
        }
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            if (string2 == null) continue;
            properties2.setProperty(string, string2);
        }
        return properties2;
    }

    public static String[] getAdminUserAndPswd(String string) throws ConsoleConfigException {
        String[] stringArray = new String[]{null, null};
        try {
            Properties properties = new Properties();
            properties.load(new FileInputStream(string));
            stringArray[0] = properties.getProperty(ADMIN_USER_NAME).trim();
            stringArray[1] = properties.getProperty(ADMIN_USER_PSWD).trim();
        }
        catch (Exception exception) {
            throw new ConsoleConfigException("util_err_14", exception.getMessage());
        }
        return stringArray;
    }

    public static String[] getTrustStoreAndPswd(String string) throws ConsoleConfigException {
        String[] stringArray = new String[]{null, null};
        try {
            Properties properties = new Properties();
            properties.load(new FileInputStream(string));
            stringArray[0] = properties.getProperty(ADMIN_TRUSTSTORE_FILE).trim();
            stringArray[1] = properties.getProperty(ADMIN_TRUSTSTORE_PSWD).trim();
        }
        catch (Exception exception) {
            throw new ConsoleConfigException("util_err_15", exception.getLocalizedMessage());
        }
        return stringArray;
    }

    private static String getHostName() {
        String string = null;
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            string = "localhost";
        }
        return string;
    }

    public static int versionStringToInt(String string) {
        int n = -1;
        try {
            StringBuffer stringBuffer = new StringBuffer(string);
            int n2 = stringBuffer.indexOf("_");
            if (n2 != -1) {
                stringBuffer = stringBuffer.delete(n2, stringBuffer.length());
            }
            String string2 = new String();
            for (int i = 0; i < stringBuffer.length(); ++i) {
                if (!Character.isDigit(stringBuffer.charAt(i))) continue;
                string2 = string2.concat(stringBuffer.substring(i, i + 1));
            }
            n = Integer.parseInt(string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    public static int checkJavaVersion(String string) throws ConsoleConfigException {
        int n;
        if (string == null || string.length() == 0) {
            ConsoleConfigLog.log(1, "util_err_25");
            return 1;
        }
        String string2 = ConsoleConfigConstants.JAVA_CMD_PATH;
        String string3 = string;
        if (!string.endsWith(string2)) {
            if (!string.endsWith(FS)) {
                string3 = string3.concat(FS);
            }
            string3 = string3.concat(string2);
        }
        ConsoleConfigExecProcess consoleConfigExecProcess = new ConsoleConfigExecProcess();
        String[] stringArray = new String[]{string3, "-version"};
        ArrayList arrayList = new ArrayList(1);
        ArrayList arrayList2 = new ArrayList(1);
        int n2 = -1;
        try {
            n2 = consoleConfigExecProcess.exec(stringArray, null, arrayList, arrayList2);
        }
        catch (Exception exception) {
            String string4 = "Error running command: " + string3 + ": " + exception.getMessage();
            throw new ConsoleConfigException(string4);
        }
        if (n2 != 0) {
            int n3;
            String string5 = "";
            for (n3 = 0; n3 < arrayList.size(); ++n3) {
                string5 = string5 + (String)arrayList.get(n3) + LS;
            }
            for (n3 = 0; n3 < arrayList2.size(); ++n3) {
                string5 = string5 + (String)arrayList2.get(n3) + LS;
            }
            ConsoleConfigLog.log(1, "util_err_23", string3, string5);
            return 1;
        }
        String string6 = "";
        for (n = 0; n < arrayList.size(); ++n) {
            String[] stringArray2;
            String string7 = (String)arrayList.get(n);
            if (string7 == null || string7.length() == 0 || !string7.startsWith("java version") || (stringArray2 = string7.split("\"")) == null || stringArray2.length <= 1) continue;
            string6 = stringArray2[1];
            break;
        }
        if ((n = ConsoleConfigUtil.versionStringToInt(string6)) < 150) {
            ConsoleConfigLog.trace("Check Java at: " + string + " found " + n + ", expected " + 150);
            return 1;
        }
        return 0;
    }

    public static int checkJavahelpVersion(Properties properties) throws ConsoleConfigException {
        int n = 0;
        try {
            String string = properties.getProperty("javahelp_home");
            if (string == null) {
                ConsoleConfigException consoleConfigException = new ConsoleConfigException("driver_err_21", "javahelp_home");
                throw consoleConfigException;
            }
            String string2 = string + File.separator + "lib" + File.separator + "jhall.jar";
            JarFile jarFile = new JarFile(string2);
            Manifest manifest = jarFile.getManifest();
            Attributes attributes = manifest.getMainAttributes();
            Set<Map.Entry<Object, Object>> set = attributes.entrySet();
            Iterator<Map.Entry<Object, Object>> iterator = set.iterator();
            while (iterator.hasNext()) {
                String string3;
                int n2;
                String string4 = iterator.next().toString();
                if (!string4.startsWith(JAR_MANIFEST_VERSION_KEY) || (n2 = ConsoleConfigUtil.versionStringToInt(string3 = string4.substring(string4.indexOf("=")))) >= 20) continue;
                n = 1;
            }
        }
        catch (Exception exception) {
            ConsoleConfigLog.trace("Unexpected error checking javahelp version: " + exception.getMessage());
            n = 1;
        }
        return n;
    }

    public static int checkJato(Properties properties) throws ConsoleConfigException {
        int n = 0;
        try {
            String string = properties.getProperty("jato_home");
            if (string == null) {
                ConsoleConfigException consoleConfigException = new ConsoleConfigException("driver_err_21", "jato_home");
                throw consoleConfigException;
            }
            String string2 = string + File.separator + "jato.jar";
            File file = new File(string2);
            if (!file.exists()) {
                n = 1;
            }
        }
        catch (Exception exception) {
            ConsoleConfigLog.trace("Unexpected error checking for jato.jar: " + exception.getMessage());
            n = 1;
        }
        return n;
    }

    public static int checkASVersion() {
        return 0;
    }

    public static int checkSupportingProducts(Properties properties) throws ConsoleConfigException {
        boolean bl = false;
        String string = properties.getProperty("java_home");
        if (ConsoleConfigUtil.checkJavaVersion(string) != 0) {
            ConsoleConfigException consoleConfigException = new ConsoleConfigException("driver_err_19", "1.5.0");
            throw consoleConfigException;
        }
        if (0 != ConsoleConfigUtil.checkJavahelpVersion(properties)) {
            ConsoleConfigException consoleConfigException = new ConsoleConfigException("driver_err_20", "2.0");
            throw consoleConfigException;
        }
        if (0 != ConsoleConfigUtil.checkJato(properties)) {
            ConsoleConfigException consoleConfigException = new ConsoleConfigException("driver_err_60");
            throw consoleConfigException;
        }
        return 0;
    }

    public static String buildPath(String string, String string2) {
        if (string.endsWith(File.separator + string2)) {
            return string;
        }
        String string3 = string;
        if (!string.endsWith(File.separator)) {
            string3 = string3.concat(File.separator);
        }
        String string4 = string2;
        if (string2.startsWith(File.separator)) {
            string4 = string2.substring(string2.indexOf(File.separator));
        }
        if (string4.endsWith(File.separator)) {
            string4 = string4.substring(0, string4.length());
        }
        return string3 + string4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getEnvProperties(String string, String string2) throws ConsoleConfigException {
        Properties properties;
        block7: {
            String string3 = ConsoleConfigUtil.buildPath(string, string2) + File.separator + "config.properties";
            properties = new Properties();
            try {
                if (string3 != null) {
                    File file = new File(string3);
                    if (file.exists()) {
                        FileInputStream fileInputStream = new FileInputStream(file);
                        try {
                            properties.load(fileInputStream);
                            break block7;
                        }
                        finally {
                            fileInputStream.close();
                        }
                    }
                    ConsoleConfigException consoleConfigException = new ConsoleConfigException("util_err_02");
                    throw consoleConfigException;
                }
                ConsoleConfigException consoleConfigException = new ConsoleConfigException("util_err_01");
                throw consoleConfigException;
            }
            catch (Exception exception) {
                ConsoleConfigException consoleConfigException = new ConsoleConfigException("util_err_03");
                throw consoleConfigException;
            }
        }
        return properties;
    }

    public static void copyFile(String string, String string2) throws ConsoleConfigException {
        try {
            int n;
            File file = new File(string);
            File file2 = new File(string2);
            FileReader fileReader = new FileReader(file);
            FileWriter fileWriter = new FileWriter(file2);
            while ((n = fileReader.read()) != -1) {
                fileWriter.write(n);
            }
            fileReader.close();
            fileWriter.close();
        }
        catch (Exception exception) {
            throw new ConsoleConfigException("util_err_16", string, string2, exception.getLocalizedMessage());
        }
    }

    public static void copyBinaryFile(String string, String string2) throws ConsoleConfigException {
        try {
            int n;
            File file = new File(string);
            File file2 = new File(string2);
            FileInputStream fileInputStream = new FileInputStream(file);
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            while ((n = fileInputStream.read()) != -1) {
                fileOutputStream.write(n);
            }
            fileInputStream.close();
            fileOutputStream.close();
        }
        catch (Exception exception) {
            throw new ConsoleConfigException("util_err_16", string, string2, exception.getLocalizedMessage());
        }
    }

    public static void copyProperties(String string, String string2, HashMap hashMap, String string3, Properties properties) throws ConsoleConfigException {
        Properties properties2 = ConsoleConfigUtil.loadProperties(string);
        Enumeration<?> enumeration = properties2.propertyNames();
        while (enumeration.hasMoreElements()) {
            int n;
            int n2;
            String string4 = (String)enumeration.nextElement();
            String string5 = properties2.getProperty(string4);
            String string6 = "";
            boolean bl = false;
            while ((n2 = string5.indexOf("%%")) != -1 && n2 + 2 < string5.length() && (n = string5.indexOf("%%", n2 + 2)) != -1) {
                String string7 = string5.substring(0, n2);
                String string8 = string5.substring(n2 + 2, n);
                string5 = n + 2 < string5.length() ? string5.substring(n + 2) : "";
                String string9 = null;
                if (string8.length() > 0) {
                    if (hashMap != null) {
                        string9 = (String)hashMap.get(string8);
                    }
                    if (string9 == null) {
                        string9 = properties.getProperty(string8);
                    }
                }
                if (string9 == null) {
                    string9 = "%%" + string8 + "%%";
                } else {
                    bl = true;
                }
                string6 = string6 + string7 + string9;
            }
            if (!bl) continue;
            string6 = string6 + string5;
            properties2.setProperty(string4, string6);
        }
        ConsoleConfigUtil.storeProperties(string2, properties2, string3);
    }

    public static String[] readFile(String string) throws ConsoleConfigException {
        String[] stringArray;
        FileInputStream fileInputStream = null;
        BufferedReader bufferedReader = null;
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        try {
            fileInputStream = new FileInputStream(string);
            bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
            stringArray = null;
            while ((stringArray = bufferedReader.readLine()) != null) {
                if ((stringArray = stringArray.trim()).length() == 0 || stringArray.startsWith("#")) continue;
                arrayList.add(stringArray);
            }
        }
        catch (Exception exception) {
            throw new ConsoleConfigException("util_err_21", string, exception.getLocalizedMessage());
        }
        try {
            bufferedReader.close();
            fileInputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    public static void writeFile(String string, String[] stringArray) throws ConsoleConfigException {
        String string2 = "";
        int n = string.lastIndexOf(FS);
        if (n > 0) {
            string2 = string.substring(0, n);
        }
        File file = new File(string2 + FS + ".temp");
        File file2 = new File(string2 + FS + ".backup");
        File file3 = new File(string);
        FileWriter fileWriter = null;
        PrintWriter printWriter = null;
        ConsoleConfigException consoleConfigException = null;
        try {
            if (file.exists()) {
                file.delete();
            }
            fileWriter = new FileWriter(file);
            printWriter = new PrintWriter(fileWriter);
            for (int i = 0; i < stringArray.length; ++i) {
                printWriter.println(stringArray[i]);
            }
            printWriter.close();
            printWriter = null;
            fileWriter.close();
            fileWriter = null;
            if (file3.exists()) {
                if (file2.exists()) {
                    file2.delete();
                }
                file3.renameTo(file2);
            }
            file.renameTo(file3);
        }
        catch (Exception exception) {
            consoleConfigException = new ConsoleConfigException("Error writing file: ", exception.getMessage());
        }
        if (file.exists()) {
            try {
                file.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (file2.exists() && file3.exists()) {
            try {
                file2.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (printWriter != null) {
            try {
                printWriter.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (fileWriter != null) {
            try {
                fileWriter.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (consoleConfigException != null) {
            throw consoleConfigException;
        }
    }

    public static boolean createDir(String string) throws ConsoleConfigException {
        File file = new File(string);
        if (!file.exists()) {
            try {
                return file.mkdirs();
            }
            catch (Exception exception) {
                throw new ConsoleConfigException("util_err_17", string, exception.getLocalizedMessage());
            }
        }
        throw new ConsoleConfigException("util_err_18", string);
    }

    public static void deleteFile(File file) throws ConsoleConfigException {
        try {
            if (file.isDirectory()) {
                File[] fileArray = file.listFiles();
                if (fileArray != null || fileArray.length > 0) {
                    for (int i = 0; i < fileArray.length; ++i) {
                        ConsoleConfigUtil.deleteFile(fileArray[i]);
                    }
                }
                file.delete();
            } else {
                file.delete();
            }
        }
        catch (Exception exception) {
            throw new ConsoleConfigException("util_error_19", exception.getLocalizedMessage());
        }
    }

    public static int pingConsole(Properties properties) {
        int n = 3;
        String string = properties.getProperty("console_unsecurehost");
        String string2 = properties.getProperty("console_httpsport");
        int n2 = 0;
        if (string2 != null) {
            try {
                n2 = Integer.parseInt(string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (string == null || n2 == 0) {
            ConsoleConfigLog.log(1, "Ping: Invalid unsecure host or port");
            return n;
        }
        Socket socket = null;
        try {
            socket = new Socket(string, n2);
            socket.close();
            n = 0;
        }
        catch (ConnectException connectException) {
            n = 2;
        }
        catch (Exception exception) {
            ConsoleConfigLog.trace("Ping: Unexpected error pinging console: " + exception.getMessage());
            n = 3;
        }
        return n;
    }

    public static boolean isWindows() {
        int n;
        boolean bl = false;
        String string = System.getProperty("os.name");
        if (string != null && (n = (string = string.toLowerCase()).indexOf("windows")) >= 0) {
            bl = true;
        }
        return bl;
    }

    public static boolean isValidUser(String string, Properties properties) {
        boolean bl = false;
        try {
            if (ConsoleConfigUtil.isWindows()) {
                if (ConsoleConfigUtil.execCommand("net user " + string) == 0) {
                    bl = true;
                }
            } else if (CCServiceLibrary.getUserId((String)string) != -1) {
                bl = true;
            }
        }
        catch (Exception exception) {
            ConsoleConfigLog.log(1, exception);
        }
        if (bl) {
            ConsoleConfigLog.trace(string + " is a valid user.");
        } else {
            ConsoleConfigLog.trace(string + " not a valid user.");
        }
        return bl;
    }

    public static ArrayList parseOptions(String string) {
        StringTokenizer stringTokenizer = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string != null && string.trim().length() > 0) {
            stringTokenizer = new StringTokenizer(string);
            int n = stringTokenizer.countTokens();
            for (int i = 0; i < n; ++i) {
                arrayList.add(stringTokenizer.nextToken());
            }
        }
        return arrayList;
    }

    public static ArrayList getJvmOptions(Properties properties) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (properties != null) {
            int n = 1;
            boolean bl = true;
            while (bl) {
                String string = "value_" + n;
                String string2 = properties.getProperty(string);
                if (string2 == null) {
                    bl = false;
                    continue;
                }
                if (string2.length() > 0) {
                    arrayList.add(string2);
                }
                ++n;
            }
        }
        return arrayList;
    }

    public static ArrayList mergeJvmOptions(ArrayList arrayList, ArrayList arrayList2) {
        String string;
        ArrayList<String> arrayList3 = new ArrayList<String>();
        if (arrayList == null && arrayList2 == null) {
            return arrayList3;
        }
        if (arrayList2 == null || arrayList2.size() == 0) {
            return arrayList;
        }
        if (arrayList == null || arrayList.size() == 0) {
            return arrayList2;
        }
        HashMap hashMap = ConsoleConfigUtil.getJvmOptionsMap(arrayList);
        HashMap hashMap2 = ConsoleConfigUtil.getJvmOptionsMap(arrayList2);
        Set set = hashMap2.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            hashMap.put(string, hashMap2.get(string));
        }
        set = hashMap.keySet();
        iterator = set.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            String string3 = (String)hashMap.get(string2);
            string = string2.equals("type") ? string3 : (string2.equals("-Xmx") || string2.equals("-Xms") || string2.equals("-Xss") ? string2 + string3 : (string3 != null ? string2 + "=" + string3 : string2));
            arrayList3.add(string);
        }
        return arrayList3;
    }

    private static HashMap getJvmOptionsMap(ArrayList arrayList) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < arrayList.size(); ++i) {
            String string;
            String string2 = (String)arrayList.get(i);
            String string3 = "";
            if (string2.startsWith("-Xmx")) {
                string = "-Xmx";
                if (string2.length() > 4) {
                    string3 = string2.substring(4);
                }
            } else if (string2.startsWith("-Xms")) {
                string = "-Xms";
                if (string2.length() > 4) {
                    string3 = string2.substring(4);
                }
            } else if (string2.startsWith("-Xss")) {
                string = "-Xss";
                if (string2.length() > 4) {
                    string3 = string2.substring(4);
                }
            } else if (string2.equals("-client") || string2.equals("-server")) {
                string = "type";
                string3 = string2;
            } else {
                int n = string2.indexOf(61);
                if (n > 0) {
                    string = string2.substring(0, n);
                    if (string2.length() > n + 1) {
                        string3 = string2.substring(n + 1);
                    }
                } else {
                    string = string2;
                    string3 = null;
                }
            }
            hashMap.put(string, string3);
        }
        return hashMap;
    }
}

