/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.console.config.tomcat;

import com.sun.web.console.config.ConsoleConfigException;
import com.sun.web.console.config.ConsoleConfigLog;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Properties;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.security.auth.x500.X500Principal;
import sun.misc.BASE64Encoder;

public class ConsoleConfigTomcatManager
implements HostnameVerifier {
    public static final int STATUS_SUCCESS = 0;
    public static final int STATUS_NOT_FOUND = 1;
    public static final int STATUS_ALREADY_EXISTS = 1;
    public static final int STATUS_UNAVAILABLE = 2;
    public static final int STATUS_UNAUTHORIZED = 3;
    public static final int STATUS_ERROR = 4;
    public static final String STATE_ENABLED = "running";
    public static final String STATE_DISABLED = "stopped";
    private static final String COMMAND_DEPLOY = "deploy";
    private static final String COMMAND_UNDEPLOY = "undeploy";
    private static final String COMMAND_ENABLE = "start";
    private static final String COMMAND_DISABLE = "stop";
    private static final String COMMAND_RELOAD = "reload";
    private static final String COMMAND_LIST = "list";
    private static final String PARAM_CONFIG = "config";
    private static final String PARAM_PATH = "path";
    private static final String RESPONSE_OK = "OK";
    private static final String RESPONSE_FAIL = "FAIL";
    private static final String RESPONSE_ALREADY_EXISTS = "Application already exists";
    private static final String RESPONSE_NOT_FOUND = "No context exists";
    private static final String MANAGER_PATH = "/manager";
    private static final String LOCALHOST_NAME = "localhost";
    private static final String LOCALHOST_ADDR = "127.0.0.1";
    private static final String FS = File.separator;
    private Properties env = null;
    private String user = null;
    private String pswd = null;
    private String trustpswd = null;
    private String trustpath = null;
    private String host = null;
    private int port;
    private String sdata = null;
    private int status;
    private String message;
    private ArrayList aresp;

    public ConsoleConfigTomcatManager(Properties properties, String string, String string2, String string3, String string4) {
        this.env = properties;
        this.user = string;
        this.pswd = string2;
        this.trustpath = string3;
        this.trustpswd = string4;
        this.host = this.getAdminHost();
        this.port = this.getAdminPort();
        this.sdata = this.encodeAuthData(this.user, this.pswd);
    }

    public int deploy(String string) {
        String string2 = this.getContextXmlFile(string);
        if (string2 == null) {
            ConsoleConfigException consoleConfigException = new ConsoleConfigException("tomcat_err_10", string);
            this.message = consoleConfigException.getMessage();
            return 1;
        }
        return this.request(COMMAND_DEPLOY, string, PARAM_CONFIG, string2);
    }

    public int undeploy(String string) {
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        return this.request(COMMAND_UNDEPLOY, string, PARAM_PATH, string);
    }

    public int enable(String string) {
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        return this.request(COMMAND_ENABLE, string, PARAM_PATH, string);
    }

    public int disable(String string) {
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        return this.request(COMMAND_DISABLE, string, PARAM_PATH, string);
    }

    public int reload(String string) {
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        return this.request(COMMAND_RELOAD, string, PARAM_PATH, string);
    }

    public int list(ArrayList arrayList) {
        int n = this.request(COMMAND_LIST, "", null, null);
        if (n == 0 && this.aresp != null && this.aresp.size() > 1) {
            for (int i = 1; i < this.aresp.size(); ++i) {
                String string = this.getListEntry((String)this.aresp.get(i));
                if (string == null) continue;
                arrayList.add(string);
            }
        }
        return n;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean verify(String string, SSLSession sSLSession) {
        String string2 = null;
        String string3 = null;
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            string2 = inetAddress.getHostName();
            string3 = inetAddress.getHostAddress();
        }
        catch (Exception exception) {
            ConsoleConfigLog.trace("Error getting local host name: ", exception);
            string2 = LOCALHOST_NAME;
            string3 = LOCALHOST_ADDR;
        }
        boolean bl = this.checkHost(string, string2, string3);
        if (!bl) {
            ConsoleConfigLog.trace("SSL host name mismatch: " + string);
            return false;
        }
        bl = false;
        try {
            String[] stringArray;
            X509Certificate x509Certificate;
            X500Principal x500Principal;
            String[] stringArray2;
            String string4 = "(no server certificate)";
            Certificate[] certificateArray = sSLSession.getPeerCertificates();
            if (certificateArray.length > 0 && (stringArray2 = (string4 = (x500Principal = (x509Certificate = (X509Certificate)certificateArray[0]).getSubjectX500Principal()).getName()).split(",")).length > 0 && (stringArray = stringArray2[0].split("=")).length > 1) {
                String string5 = stringArray[0].trim();
                String string6 = stringArray[1].trim();
                int n = string6.indexOf(46);
                if (n > 0) {
                    string6 = string6.substring(0, n);
                }
                if (string5.equalsIgnoreCase("CN") && this.checkHost(string6, string2, string3)) {
                    bl = true;
                }
            }
            if (!bl) {
                ConsoleConfigLog.trace("SSL cert name mismatch: " + string4);
            }
        }
        catch (Exception exception) {
            ConsoleConfigLog.trace("Error reading SSL server cert: ", exception);
        }
        return bl;
    }

    private int request(String string, String string2, String string3, String string4) {
        String string5 = "/manager/" + string;
        if (string3 != null) {
            string5 = string5 + "?" + string3;
        }
        if (string4 != null) {
            string5 = string5 + "=" + string4;
        }
        this.status = 0;
        this.message = "";
        this.aresp = null;
        HttpURLConnection httpURLConnection = null;
        ConsoleConfigException consoleConfigException = null;
        try {
            String string6;
            SSLSocketFactory sSLSocketFactory = this.getClientSocketFactory(this.trustpath, this.trustpswd);
            URL uRL = new URL("https", this.host, this.port, string5);
            httpURLConnection = (HttpsURLConnection)uRL.openConnection();
            httpURLConnection.setRequestMethod("GET");
            httpURLConnection.setAllowUserInteraction(false);
            httpURLConnection.setDoInput(true);
            httpURLConnection.setDoOutput(false);
            ((HttpsURLConnection)httpURLConnection).setSSLSocketFactory(sSLSocketFactory);
            ((HttpsURLConnection)httpURLConnection).setHostnameVerifier(this);
            httpURLConnection.setRequestProperty("Accept-Charset", "ISO-8859-1,UTF-8");
            httpURLConnection.setRequestProperty("Accept", "text/plain");
            httpURLConnection.setRequestProperty("Accept-Language", "en");
            httpURLConnection.setRequestProperty("Accept-encoding", "gzip,deflate");
            httpURLConnection.setRequestProperty("Authorization", this.sdata);
            httpURLConnection.connect();
            InputStream inputStream = null;
            int n = httpURLConnection.getResponseCode();
            if (n == 200) {
                inputStream = httpURLConnection.getInputStream();
            }
            if (inputStream != null) {
                while ((string6 = this.readLine(inputStream)) != null) {
                    if (this.aresp == null) {
                        this.aresp = new ArrayList();
                    }
                    this.aresp.add(string6);
                }
                inputStream.close();
            }
            if (n == 200) {
                this.status = 0;
                consoleConfigException = new ConsoleConfigException("tomcat_err_00");
                if (this.aresp != null && this.aresp.size() > 0 && !(string6 = ((String)this.aresp.get(0)).trim()).startsWith(RESPONSE_OK)) {
                    if (string6.indexOf(RESPONSE_NOT_FOUND) > 0) {
                        this.status = 1;
                        consoleConfigException = new ConsoleConfigException("tomcat_err_11", string2);
                    } else if (string6.indexOf(RESPONSE_ALREADY_EXISTS) > 0) {
                        this.status = 1;
                        consoleConfigException = new ConsoleConfigException("tomcat_err_12", string2);
                    } else {
                        this.status = 4;
                        consoleConfigException = new ConsoleConfigException("tomcat_err_13", string6);
                    }
                }
            } else if (n == 503 || n == 404 || n == 501 || n == 400) {
                this.status = 2;
                consoleConfigException = new ConsoleConfigException("tomcat_err_14");
            } else if (n == 401) {
                this.status = 3;
                consoleConfigException = new ConsoleConfigException("tomcat_err_15");
            } else {
                this.status = 4;
                consoleConfigException = new ConsoleConfigException("tomcat_err_16", new Integer(n).toString(), httpURLConnection.getResponseMessage());
            }
        }
        catch (ConnectException connectException) {
            this.status = 2;
        }
        catch (Exception exception) {
            this.status = 4;
            consoleConfigException = new ConsoleConfigException("tomcat_err_17", exception.getLocalizedMessage());
        }
        if (httpURLConnection != null) {
            try {
                httpURLConnection.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (consoleConfigException != null) {
            this.message = consoleConfigException.getMessage();
        }
        return this.status;
    }

    private boolean checkHost(String string, String string2, String string3) {
        boolean bl = false;
        String string4 = string2;
        int n = string.indexOf(46);
        if (n > 0) {
            try {
                int n2 = Integer.parseInt(string.substring(0, n));
                string4 = string3;
            }
            catch (Exception exception) {
                string4 = string2;
            }
        } else {
            int n3 = string2.indexOf(46);
            if (n3 > 0) {
                string4 = string2.substring(0, n3);
            }
        }
        if (string != null && (string.equalsIgnoreCase(LOCALHOST_NAME) || string.equals(LOCALHOST_ADDR) || string.equalsIgnoreCase(string4))) {
            bl = true;
        }
        return bl;
    }

    private int getAdminPort() {
        int n = -1;
        try {
            String string = this.env.getProperty("console_httpsport");
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            n = -1;
        }
        return n;
    }

    private String getAdminHost() {
        String string = this.env.getProperty("console_unsecurehost");
        if (string == null) {
            string = LOCALHOST_ADDR;
        }
        return string;
    }

    private String getContextXmlFile(String string) {
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        String string2 = this.env.getProperty("console_dombase");
        if (!(string2 = string2.replace('\\', '/')).startsWith("/")) {
            string2 = "/" + string2;
        }
        String string3 = this.env.getProperty("console_instance");
        String string4 = "file:" + string2 + "/" + string3 + "/" + "conf" + "/" + "com_sun_web_console" + "/" + LOCALHOST_NAME + "/" + string + ".xml";
        return string4;
    }

    private String getListEntry(String string) {
        String[] stringArray;
        String string2;
        String string3 = string;
        if (string.startsWith("/")) {
            string3 = string.substring(1);
        }
        if ((string2 = (stringArray = string3.split(":"))[0]).length() == 0) {
            string2 = "ROOT";
        }
        if (stringArray.length > 1) {
            string2 = string2 + ":" + stringArray[1];
        }
        return string2;
    }

    private String encodeAuthData(String string, String string2) {
        String string3 = string + ":" + string2;
        byte[] byArray = new byte[]{};
        try {
            byArray = string3.getBytes("ISO-8859-1");
        }
        catch (Exception exception) {
            System.out.println("AUTH: byte conversion failed");
        }
        String string4 = "Basic " + new BASE64Encoder().encode(byArray);
        return string4;
    }

    private SSLSocketFactory getClientSocketFactory(String string, String string2) throws ConsoleConfigException {
        FileInputStream fileInputStream = null;
        SSLSocketFactory sSLSocketFactory = null;
        ConsoleConfigException consoleConfigException = null;
        try {
            KeyStore keyStore = KeyStore.getInstance("jks");
            fileInputStream = new FileInputStream(string);
            int n = string2.length();
            char[] cArray = new char[n];
            string2.getChars(0, n, cArray, 0);
            keyStore.load(fileInputStream, cArray);
            String string3 = TrustManagerFactory.getDefaultAlgorithm();
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(string3);
            trustManagerFactory.init(keyStore);
            TrustManager[] trustManagerArray = trustManagerFactory.getTrustManagers();
            SSLContext sSLContext = SSLContext.getInstance("TLS");
            sSLContext.init(null, trustManagerArray, null);
            sSLSocketFactory = sSLContext.getSocketFactory();
        }
        catch (Exception exception) {
            System.out.println("Error in SSL setup: " + exception.getMessage());
            consoleConfigException = new ConsoleConfigException("SSL setup error: " + exception.getMessage());
        }
        if (fileInputStream != null) {
            try {
                fileInputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (consoleConfigException != null) {
            throw consoleConfigException;
        }
        return sSLSocketFactory;
    }

    private String readLine(InputStream inputStream) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            int n;
            if ((n = inputStream.read()) < 0) {
                if (stringBuffer.length() != 0) break;
                return null;
            }
            char c = (char)n;
            if (c == '\r') continue;
            if (c == '\n') break;
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }
}

