/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.console.config.tomcat;

import com.sun.management.services.common.CCServiceLibrary;
import com.sun.web.console.config.ConsoleConfigConstants;
import com.sun.web.console.config.ConsoleConfigException;
import com.sun.web.console.config.ConsoleConfigPasswordManager;
import com.sun.web.console.config.ConsoleConfigUtil;
import com.sun.web.console.config.ConsoleConfigWebModule;
import com.sun.web.console.config.tomcat.ContextXmlParser;
import com.sun.web.util.TemplateCallback;
import com.sun.web.util.TemplateRewriter;
import java.io.File;
import java.net.ServerSocket;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;

public class ConsoleConfigTomcatUtil
implements TemplateCallback {
    public static final String ROOT_CONTEXT = "ROOT";
    private static final String FS = File.separator;
    private static final String XML_SUFFIX = ".xml";
    private static final String BKP_SUFFIX = ".bkp";
    private static final String SHUTDOWN_PORT = "SHUTDOWN_PORT";
    private static final String SHUTDOWN_COMMAND = "SHUTDOWN_COMMAND";
    private static final String KEYSTORE_PATH = "keystore_path";
    private static final String TRUSTSTORE_PATH = "truststore_path";
    private static final String KEYSTORE_PASSWORD = "keystore_password";
    private static final String LISTEN_ADDRESS = "listen_address";
    private static final String REPLACE_PATH = "REPLACE_PATH";
    private static final String REPLACE_DOCBASE = "REPLACE_DOCBASE";
    private static final String REPLACE_DEBUG = "REPLACE_DEBUG";
    private static final String REPLACE_NAME = "REPLACE_NAME";
    private static final String REPLACE_SYSTEM = "REPLACE_SYSTEM";
    private static final String REPLACE_TIMESTAMP = "REPLACE_TIMESTAMP";
    private static final String REPLACE_ADDRESS = "REPLACE_ADDRESS";
    private Properties env = null;
    private HashMap replace_map = null;
    private Object osync = new Object();
    private static final char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public ConsoleConfigTomcatUtil(Properties properties) {
        this.env = properties;
    }

    public void copyTemplate(String string, String string2) throws ConsoleConfigException {
        String string3 = this.env.getProperty("console_home") + FS + ConsoleConfigConstants.TOMCAT_TEMPLATE_SUBDIR + FS;
        String string4 = this.env.getProperty("console_dombase") + FS + this.env.getProperty("console_instance") + FS + "conf" + FS;
        String string5 = string3 + string;
        String string6 = string4 + string2;
        String string7 = string4 + "keystore.jks";
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(KEYSTORE_PATH, string7);
        hashMap.put(TRUSTSTORE_PATH, string7);
        this.copyFileWithSubstitution(string5, string6, hashMap, null);
    }

    public void configureServerXml(String string) throws ConsoleConfigException {
        String string2 = this.getDynamicPortNumber();
        String string3 = this.getShutdownCommand();
        String string4 = this.env.getProperty("console_dombase") + FS + this.env.getProperty("console_instance") + FS + "conf" + FS;
        String string5 = string4 + "console.xml";
        String string6 = string4 + "server.xml";
        String string7 = string4 + "server.bkp";
        String string8 = string4 + "keystore.jks";
        String string9 = this.getKeystorePassword();
        String string10 = "";
        String string11 = this.env.getProperty("container_address");
        if (string11 != null && string11.length() > 0 && !string11.equals("0.0.0.0")) {
            string10 = "address=\"" + string11 + "\"";
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(SHUTDOWN_PORT, string2);
        hashMap.put(SHUTDOWN_COMMAND, string3);
        hashMap.put(KEYSTORE_PASSWORD, string9);
        hashMap.put(LISTEN_ADDRESS, string10);
        this.copyFileWithSubstitution(string5, string6, hashMap, string7);
        CCServiceLibrary.makeFilePrivate((String)string6, (String)string, (boolean)false);
    }

    public void configureContextXml(ConsoleConfigWebModule consoleConfigWebModule) throws ConsoleConfigException {
        String string = consoleConfigWebModule.getContextPathName();
        String string2 = consoleConfigWebModule.getLocation();
        String string3 = consoleConfigWebModule.getAppName();
        String string4 = "false";
        long l = consoleConfigWebModule.getTimestamp();
        int n = consoleConfigWebModule.getDebugLevel();
        String string5 = string = this.fixContextPathName(string);
        string5 = string5.equals(ROOT_CONTEXT) ? "" : "/" + string;
        if (string3 == null || string3.trim().length() == 0) {
            string3 = "";
        }
        if (l == 0L) {
            l = System.currentTimeMillis();
        }
        if (consoleConfigWebModule.isSystem()) {
            string4 = "true";
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(REPLACE_PATH, string5);
        hashMap.put(REPLACE_DOCBASE, string2);
        hashMap.put(REPLACE_DEBUG, new Integer(n).toString());
        hashMap.put(REPLACE_NAME, string3);
        hashMap.put(REPLACE_SYSTEM, string4);
        hashMap.put(REPLACE_TIMESTAMP, new Long(l).toString());
        String string6 = this.getContextDir();
        String string7 = this.env.getProperty("console_home") + FS + ConsoleConfigConstants.TOMCAT_TEMPLATE_SUBDIR + FS + "context_xml.tpl";
        String string8 = string6 + FS + string + XML_SUFFIX;
        String string9 = string6 + FS + string + BKP_SUFFIX;
        this.copyFileWithSubstitution(string7, string8, hashMap, string9);
    }

    public void removeContextXml(String string) throws ConsoleConfigException {
        String string2 = this.fixContextPathName(string);
        String string3 = this.getContextDir();
        String string4 = string3 + FS + string + XML_SUFFIX;
        String string5 = string3 + FS + string + BKP_SUFFIX;
        this.removeFile(string5);
        this.removeFile(string4);
    }

    public boolean existContextXml(String string) throws ConsoleConfigException {
        String string2 = this.fixContextPathName(string);
        String string3 = this.getContextDir() + FS + string2 + XML_SUFFIX;
        boolean bl = false;
        File file = new File(string3);
        if (file.exists()) {
            bl = true;
        }
        return bl;
    }

    public ConsoleConfigWebModule readContextXml(String string) throws ConsoleConfigException {
        ConsoleConfigWebModule consoleConfigWebModule = null;
        String string2 = this.fixContextPathName(string);
        String string3 = this.getContextDir() + FS + string2 + XML_SUFFIX;
        File file = new File(string3);
        if (file.exists()) {
            ContextXmlParser contextXmlParser = new ContextXmlParser();
            consoleConfigWebModule = contextXmlParser.parse(string3);
        }
        return consoleConfigWebModule;
    }

    public ConsoleConfigWebModule[] listContextXml() throws ConsoleConfigException {
        Object object;
        ConsoleConfigWebModule[] consoleConfigWebModuleArray = null;
        String string = this.getContextDir();
        File file = new File(string);
        String[] stringArray = null;
        try {
            stringArray = file.list();
        }
        catch (Exception exception) {
            throw new ConsoleConfigException("tomcat_err_08", exception.getLocalizedMessage());
        }
        if (stringArray != null && stringArray.length > 0) {
            object = new ArrayList(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].endsWith(XML_SUFFIX)) continue;
                ((ArrayList)object).add(string + FS + stringArray[i]);
            }
            stringArray = new String[((ArrayList)object).size()];
            ((ArrayList)object).toArray(stringArray);
        }
        if (stringArray != null && stringArray.length > 0) {
            object = new ContextXmlParser();
            ArrayList<ConsoleConfigWebModule> arrayList = new ArrayList<ConsoleConfigWebModule>(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    arrayList.add(((ContextXmlParser)object).parse(stringArray[i]));
                    continue;
                }
                catch (ConsoleConfigException consoleConfigException) {
                    throw consoleConfigException;
                }
                catch (Exception exception) {
                    throw new ConsoleConfigException("tomcat_err_04", stringArray[i], exception.getLocalizedMessage());
                }
            }
            if (arrayList.size() > 0) {
                consoleConfigWebModuleArray = new ConsoleConfigWebModule[arrayList.size()];
                arrayList.toArray(consoleConfigWebModuleArray);
            }
        }
        return consoleConfigWebModuleArray;
    }

    public void removeWebappCache(String string) throws ConsoleConfigException {
        String string2 = this.fixContextPathName(string);
        String string3 = this.env.getProperty("console_dombase") + FS + this.env.getProperty("console_instance") + FS + "work" + FS + "com_sun_web_console" + FS + "localhost";
        File file = new File(string3 + FS + string2);
        if (file.exists()) {
            ConsoleConfigUtil.deleteFile(file);
        }
    }

    public String substitute(String string) {
        String string2 = null;
        if (string != null && (string2 = (String)this.replace_map.get(string)) == null) {
            string2 = this.env.getProperty(string);
        }
        return string2;
    }

    private String fixContextPathName(String string) {
        String string2 = string.trim();
        if (string2.startsWith("/")) {
            string2 = string.substring(1);
        }
        if (string2.length() == 0) {
            string2 = ROOT_CONTEXT;
        }
        return string2;
    }

    private String getContextDir() {
        String string = this.env.getProperty("console_dombase") + FS + this.env.getProperty("console_instance") + FS + "conf" + FS + "com_sun_web_console" + FS + "localhost";
        return string;
    }

    private void removeFile(String string) throws ConsoleConfigException {
        File file = new File(string);
        if (file.exists() && file.isFile()) {
            try {
                file.delete();
            }
            catch (Exception exception) {
                throw new ConsoleConfigException("tomcat_err_09", string, exception.getLocalizedMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFileWithSubstitution(String string, String string2, HashMap hashMap, String string3) throws ConsoleConfigException {
        try {
            Object object;
            File file = new File(string2);
            if (file.exists()) {
                if (string3 != null) {
                    object = new File(string3);
                    if (((File)object).exists()) {
                        ((File)object).delete();
                    }
                    file.renameTo((File)object);
                } else {
                    file.delete();
                }
            }
            object = new TemplateRewriter();
            Object object2 = this.osync;
            synchronized (object2) {
                this.replace_map = hashMap;
                object.copyTemplate(string, string2, (TemplateCallback)this);
            }
        }
        catch (Exception exception) {
            throw new ConsoleConfigException("tomcat_err_02", string, string2, exception.getLocalizedMessage());
        }
    }

    private String getDynamicPortNumber() {
        ServerSocket serverSocket = null;
        String string = null;
        try {
            serverSocket = new ServerSocket(0);
            int n = serverSocket.getLocalPort();
            if (n > 0) {
                string = new Integer(n).toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (serverSocket != null) {
            try {
                serverSocket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string;
    }

    private String getShutdownCommand() {
        SecureRandom secureRandom = new SecureRandom();
        byte[] byArray = new byte[8];
        secureRandom.nextBytes(byArray);
        return this.toHex(byArray);
    }

    private String getKeystorePassword() {
        String string = "";
        String string2 = this.env.getProperty("console_conf") + FS + this.env.getProperty("console_instance") + FS + ".pswd";
        ConsoleConfigPasswordManager consoleConfigPasswordManager = new ConsoleConfigPasswordManager(string2);
        try {
            consoleConfigPasswordManager.load();
            string = consoleConfigPasswordManager.getValue("keystore_pswd");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    private String toHex(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append(hex[byArray[i] >> 4 & 0xF]);
            stringBuffer.append(hex[byArray[i] & 0xF]);
        }
        return stringBuffer.toString();
    }
}

