/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.volmgr.client;

import com.sun.admin.cis.common.ActionString;
import com.sun.admin.volmgr.client.DeviceTable;
import com.sun.admin.volmgr.client.StripeGroupTableModel;
import com.sun.admin.volmgr.client.StripeRowGroup;
import com.sun.admin.volmgr.client.StripeRowHeaderManager;
import com.sun.admin.volmgr.client.ttk.GroupableMoveableTablePanel;
import com.sun.admin.volmgr.client.ttk.table.RowGroup;
import com.sun.admin.volmgr.client.ttk.table.SimpleRowGroup;
import com.sun.admin.volmgr.client.util.Util;
import com.sun.admin.volmgr.common.Association;
import com.sun.admin.volmgr.common.Device;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class ConcatStripeTablePanelManager {
    private GroupableMoveableTablePanel panel;
    private StripeGroupTableModel model;

    public ConcatStripeTablePanelManager(Device[] deviceArray) {
        if (deviceArray == null) {
            deviceArray = new Device[]{};
        }
        this.model = new StripeGroupTableModel(deviceArray);
        DeviceTable deviceTable = new DeviceTable(this.model);
        this.panel = new GroupableMoveableTablePanel(deviceTable, this.model, this.model);
        ImageIcon imageIcon = Util.loadImageIcon("down.gif");
        JButton jButton = this.panel.getMoveDownButton();
        jButton.setDisabledIcon(null);
        jButton.setIcon(imageIcon);
        imageIcon = Util.loadImageIcon("up.gif");
        jButton = this.panel.getMoveUpButton();
        jButton.setDisabledIcon(null);
        jButton.setIcon(imageIcon);
        final StripeRowHeaderManager stripeRowHeaderManager = new StripeRowHeaderManager(deviceTable, this.model);
        this.model.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                stripeRowHeaderManager.update();
            }
        });
        JScrollPane jScrollPane = this.panel.getTableScrollPane();
        jScrollPane.setRowHeaderView(stripeRowHeaderManager.getHeader());
        this.setLabels(Util.getActionString("browser_available"), Util.getActionString("volume_add_wiz_group_as_stripe"), Util.getActionString("volume_add_wiz_ungroup_from_stripe"), new ActionString("move_down_btn"), new ActionString("move_up_btn"));
    }

    public GroupableMoveableTablePanel getTablePanel() {
        return this.panel;
    }

    public void setLabels(ActionString actionString, ActionString actionString2, ActionString actionString3, ActionString actionString4, ActionString actionString5) {
        GroupableMoveableTablePanel groupableMoveableTablePanel = this.getTablePanel();
        JLabel jLabel = groupableMoveableTablePanel.getLabel();
        jLabel.setText(actionString.getString());
        jLabel.setDisplayedMnemonic(actionString.getMnemonic());
        groupableMoveableTablePanel.getGroupButton().setText(actionString2.getString());
        groupableMoveableTablePanel.getUngroupButton().setText(actionString3.getString());
        groupableMoveableTablePanel.getMoveDownButton().setText(actionString4.getString());
        groupableMoveableTablePanel.getMoveUpButton().setText(actionString5.getString());
    }

    public static Device getStripeFromSlice(Device device) {
        Device device2 = null;
        Association association = ConcatStripeTablePanelManager.getStripeAssociationFromSlice(device);
        if (association != null) {
            device2 = (Device)association.getProperty("dependent");
        }
        return device2;
    }

    public static Association getStripeAssociationFromSlice(Device device) {
        Vector vector = device.getAssociations();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            Device device2;
            Object object;
            Association association = (Association)vector.get(i);
            if (association.getProperty("antecedent") != device || !((object = association.getProperty("dependent")) instanceof Device) || !(device2 = (Device)object).getProperty("type").equals("Stripe")) continue;
            return association;
        }
        return null;
    }

    public synchronized void setItems(Device[] deviceArray) {
        this.model.removeAllRows();
        if (deviceArray != null) {
            this.model.addRows(deviceArray);
        }
        ArrayList<SimpleRowGroup> arrayList = new ArrayList<SimpleRowGroup>();
        Device device = null;
        SimpleRowGroup simpleRowGroup = null;
        for (int i = 0; i < deviceArray.length; ++i) {
            Device device2 = deviceArray[i];
            Device device3 = null;
            Association association = ConcatStripeTablePanelManager.getStripeAssociationFromSlice(device2);
            if (association != null) {
                device3 = (Device)association.getProperty("dependent");
            }
            if (device3 == device) {
                if (device3 == null) continue;
                simpleRowGroup.setLastRow(i);
                continue;
            }
            if (device3 != null) {
                long l;
                try {
                    l = (Long)device3.getProperty("interlace");
                }
                catch (Throwable throwable) {
                    l = 32L;
                }
                simpleRowGroup = new StripeRowGroup();
                simpleRowGroup.setFirstRow(i);
                simpleRowGroup.setLastRow(i);
                ((StripeRowGroup)simpleRowGroup).setInterlaceInBlocks(l);
                arrayList.add(simpleRowGroup);
            }
            device = device3;
        }
        StripeRowGroup[] stripeRowGroupArray = arrayList.toArray(new StripeRowGroup[arrayList.size()]);
        this.model.setStripeRowGroups(stripeRowGroupArray);
    }

    public synchronized Device[] getItems() {
        Serializable serializable;
        Cloneable cloneable;
        int n;
        Device[] deviceArray = ConcatStripeTablePanelManager.objectArrayToDeviceArray(this.model.getAllRows());
        RowGroup[] rowGroupArray = this.model.getAllRowGroups();
        for (n = 0; n < deviceArray.length; ++n) {
            cloneable = deviceArray[n];
            serializable = ConcatStripeTablePanelManager.getStripeAssociationFromSlice((Device)cloneable);
            if (serializable == null) continue;
            ((Device)cloneable).removeAssociation((Association)serializable);
        }
        for (n = 0; n < rowGroupArray.length; ++n) {
            try {
                cloneable = (StripeRowGroup)rowGroupArray[n];
                serializable = new Long(((StripeRowGroup)cloneable).getInterlaceInBlocks());
                Device device = new Device();
                device.setProperty("type", "Stripe");
                device.setProperty("interlace", serializable);
                for (int i = ((SimpleRowGroup)cloneable).getFirstRow(); i <= ((SimpleRowGroup)cloneable).getLastRow(); ++i) {
                    Device device2 = deviceArray[i];
                    Association association = new Association();
                    association.setProperty("antecedent", device2);
                    association.setProperty("dependent", device);
                    device.addAssociation(association);
                    device2.addAssociation(association);
                }
                continue;
            }
            catch (ClassCastException classCastException) {
                System.err.println("Group not a StripeRowGroup!");
                continue;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                System.err.println("StripeRowGroup referenced invalid row: " + arrayIndexOutOfBoundsException.getMessage());
            }
        }
        return deviceArray;
    }

    private static Device[] objectArrayToDeviceArray(Object[] objectArray) {
        Device[] deviceArray = new Device[objectArray.length];
        System.arraycopy(objectArray, 0, deviceArray, 0, objectArray.length);
        return deviceArray;
    }
}

