/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.volmgr.client;

import com.sun.admin.volmgr.client.ttk.RowLayout;
import com.sun.admin.volmgr.client.ttk.Spinner;
import com.sun.admin.volmgr.client.ttk.text.LongSpinnerModel;
import com.sun.admin.volmgr.client.ttk.text.SpinnerDataModel;
import com.sun.admin.volmgr.client.util.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class InterlacePanel
extends JPanel {
    public static final int BLOCKS = 0;
    public static final int KBYTES = 1;
    public static final int MBYTES = 2;
    private JTextField field = new JTextField(Long.toString(32L), 6);
    private JComboBox combo;

    public InterlacePanel() {
        JLabel jLabel = new JLabel();
        Util.initLabel(jLabel, "add_wiz_interlace_label", this.field);
        Spinner spinner = new Spinner(this.field, (SpinnerDataModel)new LongSpinnerModel(1L, Long.MAX_VALUE));
        this.combo = new JComboBox<String>(new String[]{Util.getResourceString("blocks"), Util.getResourceString("kilobytes"), Util.getResourceString("megabytes")});
        this.combo.setSelectedIndex(0);
        JPanel jPanel = new JPanel(new RowLayout(RowLayout.LEFT, 10));
        jPanel.add((Component)jLabel, RowLayout.VCENTER);
        jPanel.add((Component)spinner, RowLayout.VCENTER);
        jPanel.add((Component)this.combo, RowLayout.VCENTER);
        this.setLayout(new BorderLayout(15, 15));
        this.add((Component)jPanel, "Center");
    }

    public long getInterlaceInBlocks() {
        long l = 0L;
        l = Long.parseLong(this.field.getText());
        switch (this.combo.getSelectedIndex()) {
            case 1: {
                l <<= 1;
                break;
            }
            case 2: {
                l <<= 11;
            }
        }
        return l;
    }

    public void setInterlaceInBlocks(long l) {
        Util.DeviceSize deviceSize = Util.getSizeInGreatestUnits(l, 1001, 1003);
        this.field.setText(Long.toString(deviceSize.size));
        switch (deviceSize.units) {
            case 1002: {
                this.combo.setSelectedIndex(1);
                break;
            }
            case 1003: {
                this.combo.setSelectedIndex(2);
                break;
            }
            default: {
                this.combo.setSelectedIndex(0);
            }
        }
    }

    public boolean isValidInterlace() {
        long l;
        try {
            l = this.getInterlaceInBlocks();
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return l >= 16L && l <= 204800L;
    }
}

