/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.volmgr.client;

import com.sun.admin.cis.common.ListProperties;
import com.sun.admin.volmgr.client.ServiceWrapper;
import com.sun.admin.volmgr.client.util.Util;
import com.sun.admin.volmgr.common.Device;
import com.sun.admin.volmgr.common.util.CommandResult;
import com.sun.admin.volmgr.server.SVMServicesIF;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Vector;

public class ViperServiceWrapper
extends ServiceWrapper {
    private SVMServicesIF volMgrServer = null;

    public void init(Object object, Object object2) throws Exception {
        super.init(object, object2);
        this.volMgrServer = (SVMServicesIF)object;
    }

    public Vector getAvailableDisks() {
        try {
            return this.volMgrServer.getAvailableDisks();
        }
        catch (RemoteException remoteException) {
            System.err.println("Caught RemoteException: " + remoteException.getMessage());
            return new Vector();
        }
    }

    public Device[] getDevicesAvailableForAttach(String string, String string2) {
        Device[] deviceArray;
        try {
            deviceArray = this.volMgrServer.getDevicesAvailableForAttach(string, string2);
            Arrays.sort(deviceArray, Util.deviceNameComparator);
        }
        catch (Exception exception) {
            deviceArray = new Device[]{};
        }
        return deviceArray;
    }

    public Device[] getDevicesAvailableForUseAs(String string, String string2) {
        Device[] deviceArray;
        try {
            deviceArray = this.volMgrServer.getDevicesAvailableForUseAs(string, string2);
            Arrays.sort(deviceArray, Util.deviceNameComparator);
        }
        catch (Exception exception) {
            deviceArray = new Device[]{};
        }
        return deviceArray;
    }

    public Device[] getAvailableSlices(Device device) {
        Device[] deviceArray;
        try {
            deviceArray = this.volMgrServer.getAvailableSlices(device);
        }
        catch (Exception exception) {
            System.out.println("Caught exception: ");
            exception.printStackTrace();
            deviceArray = new Device[]{};
        }
        if (deviceArray == null) {
            System.out.println("Slices is null");
        }
        return deviceArray;
    }

    public SVMServicesIF getServices() {
        return this.volMgrServer;
    }

    public String getBasedir() {
        String string;
        try {
            string = this.volMgrServer.getBasedir();
        }
        catch (Exception exception) {
            string = new String("/");
        }
        return string;
    }

    public CommandResult[] exec(String[] stringArray) {
        try {
            return this.volMgrServer.exec(stringArray, true);
        }
        catch (RemoteException remoteException) {
            return new CommandResult[]{new CommandResult(new String[]{stringArray.length > 0 ? stringArray[0] : ""}, -1, new String[0], new String[]{remoteException.getMessage()})};
        }
    }

    public Vector getAllAntecedents(Device device) {
        Vector vector;
        try {
            vector = this.volMgrServer.getAllAntecedents(device);
        }
        catch (Exception exception) {
            vector = new Vector();
        }
        return vector;
    }

    public Vector getAllDependents(Device device) {
        Vector vector;
        try {
            vector = this.volMgrServer.getAllDependents(device);
        }
        catch (Exception exception) {
            vector = new Vector();
        }
        return vector;
    }

    public Vector getAntecedents(Device device, String string) {
        Vector vector;
        try {
            vector = this.volMgrServer.getAntecedents(device, string);
        }
        catch (Exception exception) {
            vector = new Vector();
        }
        return vector;
    }

    public Vector getDependents(Device device, String string) {
        Vector vector;
        try {
            vector = this.volMgrServer.getDependents(device, string);
        }
        catch (Exception exception) {
            vector = new Vector();
        }
        return vector;
    }

    public Vector getDevices(String string) {
        Vector vector;
        try {
            vector = this.volMgrServer.getDevices(string);
        }
        catch (Exception exception) {
            vector = new Vector();
        }
        return vector;
    }

    public Vector getDevices(String string, ListProperties listProperties) {
        Vector vector;
        try {
            vector = this.volMgrServer.getDevices(string, listProperties);
        }
        catch (Exception exception) {
            vector = new Vector();
        }
        return vector;
    }

    public int[] getUsedVolumeNumbers(String string) {
        int[] nArray;
        try {
            nArray = this.volMgrServer.getUsedVolumeNumbers(string);
        }
        catch (Exception exception) {
            System.out.println("Caught exception: ");
            exception.printStackTrace();
            nArray = new int[]{};
        }
        return nArray;
    }

    public int[] getUsedHspNumbers(String string) {
        int[] nArray;
        try {
            nArray = this.volMgrServer.getUsedHspNumbers(string);
        }
        catch (Exception exception) {
            System.out.println("Caught exception: ");
            exception.printStackTrace();
            nArray = new int[]{};
        }
        return nArray;
    }

    public void flushDeviceCache() {
        try {
            this.volMgrServer.updateState(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean canCreateSps(Device device, int n, long l) {
        boolean bl = false;
        try {
            bl = this.volMgrServer.canCreateSps(device, n, l);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return bl;
    }

    public long getFreeSpace(Device device) {
        long l = 0L;
        try {
            l = this.volMgrServer.getFreeSpace(device);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return l;
    }

    public int getNumberOfPossibleSps(Device device, long l) {
        int n = 0;
        try {
            n = this.volMgrServer.getNumberOfPossibleSps(device, l);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return n;
    }

    public long getPosssibleSpSize(Device device, int n) {
        long l = 0L;
        try {
            l = this.volMgrServer.getPosssibleSpSize(device, n);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return l;
    }
}

