/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.volmgr.client.disksets;

import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.ListProperties;
import com.sun.admin.cis.common.ProgressPanel;
import com.sun.admin.cis.common.WarningDialog;
import com.sun.admin.volmgr.client.Content;
import com.sun.admin.volmgr.client.VVolMgr;
import com.sun.admin.volmgr.client.disksets.ConfDiskSetPanel;
import com.sun.admin.volmgr.client.disksets.DiskSetFilterControl;
import com.sun.admin.volmgr.client.disksets.VMgrDiskSetsMenuBar;
import com.sun.admin.volmgr.client.disksets.VMgrDiskSetsTBar;
import com.sun.admin.volmgr.client.util.GUIUtil;
import com.sun.admin.volmgr.client.util.HelpCache;
import com.sun.admin.volmgr.client.util.Util;
import com.sun.admin.volmgr.common.Device;
import com.sun.management.viper.console.VConsoleEvent;
import com.sun.management.viper.console.VScopeNode;
import com.sun.management.viper.console.gui.VFilter;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.tree.MutableTreeNode;

public class DiskSetsContent
extends Content {
    private static String[][] columnHeaders = null;
    private VFilter filterControl;
    private boolean stopped = false;

    public DiskSetsContent() {
        this.sortPreferencesKey = this.getClass().getName() + ".sortPreferences";
        this.rootNode = new VScopeNode();
        this.rootNode.setColumnHeaders(this.getColumnHeaders());
        this.rootNode.setMenuBar((JMenuBar)VMgrDiskSetsMenuBar.getMenuBar(this));
        this.rootNode.setToolBar((JToolBar)VMgrDiskSetsTBar.getToolBar(this));
        try {
            this.listProperties = new ListProperties();
            this.listProperties.setFilters(new Vector());
        }
        catch (AdminException adminException) {
            Util.getApp().reportErrorException((Exception)((Object)adminException));
        }
    }

    public String[][] getColumnHeaders() {
        if (columnHeaders == null) {
            Object[][] objectArray = new Object[][]{{Util.getResourceString("setnumber"), new Integer(16)}, {Util.getResourceString("owner"), new Integer(16)}};
            columnHeaders = this.constructColumnHeaders(objectArray);
        }
        return columnHeaders;
    }

    public Hashtable getColumnValues(Device device) {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put(Util.getResourceString("setnumber"), device.getProperty("setnumber"));
        Device device2 = Util.getDiskSetOwner(device);
        String string = device2 == null ? Util.getResourceString("diskset_owner_none") : Util.getDeviceBaseName(device2);
        hashtable.put(Util.getResourceString("owner"), string);
        return hashtable;
    }

    public Device[] getDevices() {
        Vector vector = Util.getApp().getServiceWrapper().getDevices("Diskset", this.getListProperties());
        if (vector != null) {
            for (int i = vector.size() - 1; i >= 0; --i) {
                Device device = (Device)vector.get(i);
                String string = Util.getDeviceBaseName(device);
                if (string == null || !string.equals("") && !string.equals("*disks*")) continue;
                vector.remove(i);
            }
        }
        return vector.toArray(new Device[vector.size()]);
    }

    public void deleteSelected() {
        Vector vector;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Vector vector2 = this.getSelected();
        if (vector2.isEmpty()) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        int n = vector2.size();
        for (int i = 0; i < n; ++i) {
            Object object5;
            int n2;
            object4 = (VScopeNode)vector2.get(i);
            object3 = (Device)object4.getPayload();
            object2 = Util.getDeviceBaseName((Device)object3);
            object = Util.getApp().getServiceWrapper().getAntecedents((Device)object3, "DriveInDiskGroup");
            if (object != null) {
                n2 = ((Vector)object).size();
                for (int j = 0; j < n2; ++j) {
                    Device device = (Device)((Vector)object).get(j);
                    object5 = Util.getDeviceBaseName(device);
                    arrayList.add(Util.getBasedir() + "usr/sbin/metaset -s " + (String)object2 + " -d -f " + (String)object5);
                    arrayList2.add(Util.getResourceString("diskset_delete_disk_cmd", object2));
                }
            }
            if ((vector = Util.getApp().getServiceWrapper().getAntecedents((Device)object3, "HostInDiskGroup")) == null) continue;
            int n3 = vector.size();
            for (n2 = 0; n2 < n3; ++n2) {
                object5 = (Device)vector.get(n2);
                String string = Util.getDeviceBaseName((Device)object5);
                arrayList.add(Util.getBasedir() + "usr/sbin/metaset -s " + (String)object2 + " -d -h " + string);
                arrayList2.add(Util.getResourceString("diskset_delete_host_cmd", object2));
            }
        }
        final String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        final String[] stringArray2 = arrayList2.toArray(new String[arrayList2.size()]);
        object4 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Util.executeCommands(stringArray, stringArray2);
            }
        };
        object3 = Util.getResourceString("sure_delete_diskset");
        object2 = new ConfDiskSetPanel(stringArray, (String)object3);
        object = new String(Util.getResourceString("warning_delete_diskset"));
        vector = new WarningDialog(GUIUtil.getAppFrame(), (String)object, (JPanel)object2, (ActionListener)object4, Util.getResourceString("warning_delete"));
    }

    public String whatAmI() {
        return Util.getResourceString("disksets");
    }

    public void updateStatusBar() {
        String string = Util.getResourceString("DiskSetsListContents", new Integer(this.getDataCache().size()));
        Util.getApp().setStatusBar(string);
    }

    public boolean isFilteringSupported() {
        return true;
    }

    public synchronized VFilter getFilterControl() {
        if (this.isFilteringSupported() && this.filterControl == null) {
            this.filterControl = new DiskSetFilterControl(this);
        }
        return this.filterControl;
    }

    public void appendToResultsPane(Device[] deviceArray) {
        String string;
        if (deviceArray.length == 0) {
            return;
        }
        ProgressPanel progressPanel = new ProgressPanel(GUIUtil.getAppFrame(), 2, 30, true, true);
        progressPanel.setTitle(Util.getResourceString("device_refresh_progress_title"));
        progressPanel.setRange(0, deviceArray.length);
        progressPanel.setVisible(true);
        progressPanel.setStopListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DiskSetsContent.this.stopped = true;
            }
        });
        this.rootNode.setColumnHeaders(this.getColumnHeaders());
        for (int i = 0; i < deviceArray.length; ++i) {
            if (this.stopped) {
                this.stopped = false;
                break;
            }
            string = Util.getDeviceFullName(deviceArray[i]);
            String string2 = Util.getResourceString("diskset_refresh_loading_device", string);
            progressPanel.setText(string2);
            progressPanel.setValue(i + 1);
            VMgrDiskSetsMenuBar vMgrDiskSetsMenuBar = VMgrDiskSetsMenuBar.getMenuBar(this);
            VScopeNode vScopeNode = new VScopeNode(null, null, null, null, null, vMgrDiskSetsMenuBar.getPopupMenu(), Util.getSmallIcon(deviceArray[i]), Util.getLargeIcon(deviceArray[i]), string, string, null, -1, (Object)deviceArray[i]);
            vScopeNode.setToolTipText(Util.getResourceString("tooltip_content_type") + " " + Util.getResourceString("Diskset") + "  " + Util.getResourceString("tooltip_content_name") + " " + string);
            vScopeNode.setHTMLText(HelpCache.getHelpText(deviceArray[i]));
            vScopeNode.setColumnValues(this.getColumnValues(deviceArray[i]));
            this.rootNode.add((MutableTreeNode)vScopeNode);
            this.vDataCache.addElement(deviceArray[i]);
        }
        VVolMgr vVolMgr = Util.getApp();
        string = new VConsoleEvent((Object)vVolMgr, "vconsole.updatescope", (Object)this.getTreeNode());
        vVolMgr.fireConsoleAction((VConsoleEvent)string);
        progressPanel.dispose();
    }

    public void clear(boolean bl) {
        this.clearSelection();
        this.getDataCache().removeAllElements();
        System.gc();
        this.rootNode = new VScopeNode();
        this.rootNode.setColumnHeaders(this.getColumnHeaders());
        this.rootNode.setMenuBar((JMenuBar)VMgrDiskSetsMenuBar.getMenuBar(this));
        this.rootNode.setToolBar((JToolBar)VMgrDiskSetsTBar.getToolBar(this));
        this.getTreeNode().setInternalRoot(this.rootNode);
        if (bl) {
            VVolMgr vVolMgr = Util.getApp();
            VConsoleEvent vConsoleEvent = new VConsoleEvent((Object)vVolMgr, "vconsole.updatescope", (Object)this.treeNode);
            vVolMgr.fireConsoleAction(vConsoleEvent);
        }
        this.bRefresh = true;
    }

    public void distributeReplicas() {
        String string;
        Object object;
        Object object2;
        Vector vector = this.getSelected();
        if (vector.isEmpty()) {
            return;
        }
        int n = vector.size();
        final String[] stringArray = new String[n];
        final String[] stringArray2 = new String[n];
        int n2 = vector.size();
        for (int i = 0; i < n2; ++i) {
            object2 = (VScopeNode)vector.get(i);
            object = (Device)object2.getPayload();
            string = Util.getDeviceBaseName((Device)object);
            stringArray[i] = Util.getBasedir() + "usr/sbin/metaset -s " + string + " -b";
            stringArray2[i] = Util.getResourceString("diskset_dist_replicas_cmd", string);
        }
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Util.executeCommands(stringArray, stringArray2);
            }
        };
        String string2 = Util.getResourceString("sure_dist_diskset_replicas");
        object2 = new ConfDiskSetPanel(stringArray, string2);
        object = new String(Util.getResourceString("warning_dist_diskset_replicas"));
        string = new WarningDialog(GUIUtil.getAppFrame(), (String)object, (JPanel)object2, actionListener, Util.getResourceString("warning_distribute"));
    }

    public void releaseOwnership() {
        String string;
        Object object;
        Object object2;
        Vector vector = this.getSelected();
        if (vector.isEmpty()) {
            return;
        }
        int n = vector.size();
        final String[] stringArray = new String[n];
        final String[] stringArray2 = new String[n];
        int n2 = vector.size();
        for (int i = 0; i < n2; ++i) {
            object2 = (VScopeNode)vector.get(i);
            object = (Device)object2.getPayload();
            string = Util.getDeviceBaseName((Device)object);
            stringArray[i] = Util.getBasedir() + "usr/sbin/metaset -s " + string + " -r";
            stringArray2[i] = Util.getResourceString("diskset_dist_replicas_cmd", string);
        }
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Util.executeCommands(stringArray, stringArray2);
            }
        };
        String string2 = Util.getResourceString("sure_release_diskset");
        object2 = new ConfDiskSetPanel(stringArray, string2);
        object = new String(Util.getResourceString("warning_release_diskset"));
        string = new WarningDialog(GUIUtil.getAppFrame(), (String)object, (JPanel)object2, actionListener, Util.getResourceString("warning_release"));
    }

    public void takeOwnership() {
        String string;
        Object object;
        Object object2;
        Vector vector = this.getSelected();
        if (vector.isEmpty()) {
            return;
        }
        int n = vector.size();
        final String[] stringArray = new String[n];
        final String[] stringArray2 = new String[n];
        int n2 = vector.size();
        for (int i = 0; i < n2; ++i) {
            object2 = (VScopeNode)vector.get(i);
            object = (Device)object2.getPayload();
            string = Util.getDeviceBaseName((Device)object);
            stringArray[i] = Util.getBasedir() + "usr/sbin/metaset -s " + string + " -t";
            stringArray2[i] = Util.getResourceString("diskset_dist_replicas_cmd", string);
        }
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Util.executeCommands(stringArray, stringArray2);
            }
        };
        String string2 = Util.getResourceString("sure_take_diskset");
        object2 = new ConfDiskSetPanel(stringArray, string2);
        object = new String(Util.getResourceString("warning_take_diskset"));
        string = new WarningDialog(GUIUtil.getAppFrame(), (String)object, (JPanel)object2, actionListener, Util.getResourceString("warning_take"));
    }
}

