/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.volmgr.client.hsps;

import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.ListProperties;
import com.sun.admin.cis.common.ProgressPanel;
import com.sun.admin.cis.common.WarningDialog;
import com.sun.admin.volmgr.client.Content;
import com.sun.admin.volmgr.client.VVolMgr;
import com.sun.admin.volmgr.client.hsps.ConfHSPPanel;
import com.sun.admin.volmgr.client.hsps.HSPFilterControl;
import com.sun.admin.volmgr.client.hsps.VMgrHSPsMenuBar;
import com.sun.admin.volmgr.client.hsps.VMgrHSPsTBar;
import com.sun.admin.volmgr.client.util.GUIUtil;
import com.sun.admin.volmgr.client.util.HelpCache;
import com.sun.admin.volmgr.client.util.Util;
import com.sun.admin.volmgr.common.Device;
import com.sun.management.viper.console.VConsoleEvent;
import com.sun.management.viper.console.VScopeNode;
import com.sun.management.viper.console.gui.VFilter;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.tree.MutableTreeNode;

public class HSPsContent
extends Content {
    private static String[][] columnHeaders = null;
    private VFilter filterControl;
    private boolean stopped = false;

    public HSPsContent() {
        this.sortPreferencesKey = this.getClass().getName() + ".sortPreferences";
        this.rootNode = new VScopeNode();
        this.rootNode.setColumnHeaders(this.getColumnHeaders());
        this.rootNode.setMenuBar((JMenuBar)VMgrHSPsMenuBar.getMenuBar(this));
        this.rootNode.setToolBar((JToolBar)VMgrHSPsTBar.getToolBar(this));
        try {
            this.listProperties = new ListProperties();
            this.listProperties.setFilters(new Vector());
        }
        catch (AdminException adminException) {
            Util.getApp().reportErrorException((Exception)((Object)adminException));
        }
    }

    public String[][] getColumnHeaders() {
        Object[][] objectArray = new Object[][]{{Util.getResourceString("Diskset"), new Integer(16)}, {Util.getResourceString("sparecount"), new Integer(20016)}, {Util.getResourceString("hspusecount"), new Integer(20016)}};
        if (columnHeaders == null) {
            columnHeaders = this.constructColumnHeaders(objectArray);
        }
        return columnHeaders;
    }

    public Hashtable getColumnValues(Device device) {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        String string = Util.getDisplayableDiskSetName(device);
        hashtable.put(Util.getResourceString("Diskset"), string);
        Vector vector = Util.getApp().getServiceWrapper().getAntecedents(device, "ExtentRedundancyComponent");
        int n = vector != null && !vector.isEmpty() ? vector.size() : 0;
        hashtable.put(Util.getResourceString("sparecount"), new Integer(n));
        vector = Util.getApp().getServiceWrapper().getDependents(device, "ExtentRedundancyComponent");
        n = vector != null && !vector.isEmpty() ? vector.size() - 1 : 0;
        hashtable.put(Util.getResourceString("hspusecount"), new Integer(n));
        return hashtable;
    }

    public Device[] getDevices() {
        Vector vector = Util.getApp().getServiceWrapper().getDevices("Hsp", this.getListProperties());
        return vector.toArray(new Device[vector.size()]);
    }

    public void deleteSelected() {
        String string;
        Object object;
        Object object2;
        Vector vector = this.getSelected();
        if (vector.isEmpty()) {
            return;
        }
        int n = vector.size();
        final String[] stringArray = new String[n];
        final String[] stringArray2 = new String[n];
        int n2 = vector.size();
        for (int i = 0; i < n2; ++i) {
            object2 = (VScopeNode)vector.get(i);
            object = (Device)object2.getPayload();
            string = Util.getDeviceBaseName((Device)object);
            String string2 = Util.getDiskSetFlag((Device)object);
            stringArray[i] = Util.getBasedir() + "usr/sbin/metaclear" + string2 + ' ' + string;
            stringArray2[i] = Util.getResourceString("hsp_delete_cmd", string);
        }
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Util.executeCommands(stringArray, stringArray2);
            }
        };
        String string3 = Util.getResourceString("sure_delete_hsp");
        object2 = new ConfHSPPanel(stringArray, string3);
        object = new String(Util.getResourceString("warning_delete_hsp"));
        string = new WarningDialog(GUIUtil.getAppFrame(), (String)object, (JPanel)object2, actionListener, Util.getResourceString("warning_delete"));
    }

    public String whatAmI() {
        return Util.getResourceString("hsps");
    }

    public void updateStatusBar() {
        String string = Util.getResourceString("HSPsListContents", new Integer(this.getDataCache().size()));
        Util.getApp().setStatusBar(string);
    }

    public boolean isFilteringSupported() {
        return true;
    }

    public synchronized VFilter getFilterControl() {
        if (this.isFilteringSupported() && this.filterControl == null) {
            this.filterControl = new HSPFilterControl(this);
        }
        return this.filterControl;
    }

    public void appendToResultsPane(Device[] deviceArray) {
        String string;
        if (deviceArray.length == 0) {
            return;
        }
        ProgressPanel progressPanel = new ProgressPanel(GUIUtil.getAppFrame(), 2, 30, true, true);
        progressPanel.setTitle(Util.getResourceString("device_refresh_progress_title"));
        progressPanel.setRange(0, deviceArray.length);
        progressPanel.setVisible(true);
        progressPanel.setStopListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HSPsContent.this.stopped = true;
            }
        });
        this.rootNode.setColumnHeaders(this.getColumnHeaders());
        for (int i = 0; i < deviceArray.length; ++i) {
            if (this.stopped) {
                this.stopped = false;
                break;
            }
            string = Util.getDeviceFullName(deviceArray[i]);
            String string2 = Util.getResourceString("hsp_refresh_loading_device", string);
            progressPanel.setText(string2);
            progressPanel.setValue(i + 1);
            VMgrHSPsMenuBar vMgrHSPsMenuBar = VMgrHSPsMenuBar.getMenuBar(this);
            VScopeNode vScopeNode = new VScopeNode(null, null, null, null, null, vMgrHSPsMenuBar.getPopupMenu(), Util.getSmallIcon(deviceArray[i]), Util.getLargeIcon(deviceArray[i]), string, string, null, -1, (Object)deviceArray[i]);
            vScopeNode.setToolTipText(Util.getResourceString("tooltip_content_type") + " " + Util.getResourceString("HSP") + "  " + Util.getResourceString("tooltip_content_name") + " " + string);
            vScopeNode.setHTMLText(HelpCache.getHelpText(deviceArray[i]));
            vScopeNode.setColumnValues(this.getColumnValues(deviceArray[i]));
            this.rootNode.add((MutableTreeNode)vScopeNode);
            this.vDataCache.addElement(deviceArray[i]);
        }
        VVolMgr vVolMgr = Util.getApp();
        string = new VConsoleEvent((Object)vVolMgr, "vconsole.updatescope", (Object)this.getTreeNode());
        vVolMgr.fireConsoleAction((VConsoleEvent)string);
        progressPanel.dispose();
    }

    public void clear(boolean bl) {
        this.clearSelection();
        this.getDataCache().removeAllElements();
        System.gc();
        this.rootNode = new VScopeNode();
        this.rootNode.setColumnHeaders(this.getColumnHeaders());
        this.rootNode.setMenuBar((JMenuBar)VMgrHSPsMenuBar.getMenuBar(this));
        this.rootNode.setToolBar((JToolBar)VMgrHSPsTBar.getToolBar(this));
        this.getTreeNode().setInternalRoot(this.rootNode);
        VVolMgr vVolMgr = Util.getApp();
        if (bl) {
            VConsoleEvent vConsoleEvent = new VConsoleEvent((Object)vVolMgr, "vconsole.updatescope", (Object)this.treeNode);
            vVolMgr.fireConsoleAction(vConsoleEvent);
        }
        this.bRefresh = true;
    }
}

