/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.volmgr.client.hsps;

import com.sun.admin.cis.common.Constraints;
import com.sun.admin.volmgr.client.Content;
import com.sun.admin.volmgr.client.ContentEvent;
import com.sun.admin.volmgr.client.ContentListener;
import com.sun.admin.volmgr.client.VolActionsListener;
import com.sun.admin.volmgr.client.hsps.HSPsContent;
import com.sun.admin.volmgr.client.util.Util;
import com.sun.management.viper.console.VConsoleProperties;
import com.sun.management.viper.util.ResourceManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToolBar;

public class VMgrHSPsTBar
extends JToolBar
implements PropertyChangeListener {
    private JButton showCommandsBtn;
    private JButton addHSPBtn;
    private ContentListener contentListener;
    private VolActionsListener buttonClickListener;
    private ImageIcon showCommandsIcon;
    private ImageIcon addHSPIcon;
    private String showCommandsText;
    private String addHSPText;
    private Insets textMargin = new Insets(0, 2, 0, 2);
    private static VMgrHSPsTBar theToolBar = null;

    public static VMgrHSPsTBar getToolBar(HSPsContent hSPsContent) {
        if (theToolBar == null) {
            theToolBar = new VMgrHSPsTBar();
        }
        hSPsContent.addContentListener(theToolBar.getContentListener());
        return theToolBar;
    }

    public ContentListener getContentListener() {
        return this.contentListener;
    }

    private VMgrHSPsTBar() {
        this.buttonClickListener = new VolActionsListener();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.showCommandsText = Util.getResourceString("tbar_show_commands");
        this.addHSPText = Util.getResourceString("tbar_add_hsp");
        this.showCommandsIcon = Util.loadImageIcon("showcommands_24.gif");
        this.addHSPIcon = Util.loadImageIcon("hsp_24.gif");
        this.showCommandsBtn = new JButton(this.showCommandsIcon);
        this.setUpButton(this.showCommandsBtn, this.showCommandsText, "ShowCommands");
        Constraints.constrain((Container)this, (Component)this.showCommandsBtn, (int)0, (int)0, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)1.0, (int)0, (int)0, (int)0, (int)0);
        this.addHSPBtn = new JButton(this.addHSPIcon);
        this.setUpButton(this.addHSPBtn, this.addHSPText, "AddHSP");
        Constraints.constrain((Container)this, (Component)this.addHSPBtn, (int)1, (int)0, (int)1, (int)1, (int)0, (int)17, (double)10.0, (double)1.0, (int)0, (int)2, (int)0, (int)0);
        this.contentListener = new ContentListener(){

            public void itemPressed(ContentEvent contentEvent) {
                Content content = contentEvent.getSource();
                VMgrHSPsTBar.this.notifySelectionChange(content.getNumSelections());
            }
        };
    }

    private void setUpButton(JButton jButton, String string, String string2) {
        jButton.setToolTipText(string);
        jButton.setFocusPainted(false);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.setActionCommand(string2);
        jButton.addActionListener(this.buttonClickListener);
    }

    private void notifySelectionChange(int n) {
        VConsoleProperties vConsoleProperties = Util.getApp().getProperties();
        if (n == 1) {
            vConsoleProperties.setProperty("vconsole.propertiesenabled", "true");
        } else {
            vConsoleProperties.setProperty("vconsole.propertiesenabled", "false");
        }
        boolean bl = true;
        if (n == 0) {
            bl = false;
        }
        vConsoleProperties.setProperty("vconsole.deleteenabled", bl ? "true" : "false");
        vConsoleProperties.setProperty("vconsole.filterenabled", "true");
        if (!Util.getApp().getServiceWrapper().hasVolMgrWriteAuth()) {
            this.showCommandsBtn.setEnabled(false);
            this.addHSPBtn.setEnabled(false);
            vConsoleProperties.setProperty("vconsole.deleteenabled", "false");
        }
    }

    public void setProperties(VConsoleProperties vConsoleProperties) {
        if (vConsoleProperties != null) {
            this.setButtonDisplay(vConsoleProperties.getProperty("vconsole.buttondisplay"));
            vConsoleProperties.addPropertyChangeListener((PropertyChangeListener)this);
        }
    }

    public void setButtonDisplay(String string) {
        if (string.equals("vconsole.textonly")) {
            this.installString(this.showCommandsBtn, this.showCommandsText);
            this.installIcon(this.showCommandsBtn, null);
            this.installString(this.addHSPBtn, this.addHSPText);
            this.installIcon(this.addHSPBtn, null);
        } else if (string.equals("vconsole.icononly")) {
            this.installString(this.showCommandsBtn, null);
            this.installIcon(this.showCommandsBtn, this.showCommandsIcon);
            this.installString(this.addHSPBtn, null);
            this.installIcon(this.addHSPBtn, this.addHSPIcon);
        } else if (string.equals("vconsole.textandicon")) {
            this.installString(this.showCommandsBtn, this.showCommandsText);
            this.installIcon(this.showCommandsBtn, this.showCommandsIcon);
            this.installString(this.addHSPBtn, this.addHSPText);
            this.installIcon(this.addHSPBtn, this.addHSPIcon);
        }
    }

    private void installString(AbstractButton abstractButton, String string) {
        if (abstractButton != null) {
            abstractButton.setFont(ResourceManager.bodyFont);
            abstractButton.setText(string);
            if (string != null) {
                abstractButton.setMargin(this.textMargin);
            } else {
                abstractButton.setMargin(null);
            }
        }
    }

    private void installIcon(AbstractButton abstractButton, ImageIcon imageIcon) {
        if (abstractButton != null) {
            abstractButton.setIcon(imageIcon);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("vconsole.buttondisplay")) {
            this.setButtonDisplay(Util.getApp().getProperties().getProperty("vconsole.buttondisplay"));
        }
    }
}

