/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.volmgr.client.ttk.table;

import com.sun.admin.volmgr.client.ttk.table.RowAddable;
import com.sun.admin.volmgr.client.ttk.table.RowGettable;
import com.sun.admin.volmgr.client.ttk.table.RowMoveable;
import com.sun.admin.volmgr.client.ttk.table.RowRemovable;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public abstract class ManagedRowTableModel
extends AbstractTableModel
implements RowGettable,
RowAddable,
RowRemovable,
RowMoveable {
    protected Vector data = new Vector();
    protected String[] columNames;

    public ManagedRowTableModel(Object[] objectArray) {
        this.addRows(objectArray);
    }

    public ManagedRowTableModel(Object[] objectArray, String[] stringArray) {
        this(objectArray);
        this.columNames = stringArray;
    }

    public Class getColumnClass(int n) {
        try {
            return this.getValueAt(0, n).getClass();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public int getColumnCount() {
        if (this.columNames != null) {
            return this.columNames.length;
        }
        return 0;
    }

    public String getColumnName(int n) {
        try {
            return this.columNames[n];
        }
        catch (Exception exception) {
            return "";
        }
    }

    public int getRowCount() {
        return this.data.size();
    }

    public synchronized Object getRow(int n) {
        this.assertValidRow(n);
        return this.data.get(n);
    }

    public synchronized Object[] getRows(int n, int n2) {
        this.assertValidRange(n, n2);
        Object[] objectArray = new Object[n2 - n + 1];
        for (int i = n; i <= n2; ++i) {
            objectArray[i - n] = this.data.get(i);
        }
        return objectArray;
    }

    public synchronized Object[] getAllRows() {
        int n = this.data.size() - 1;
        if (n >= 0) {
            return this.getRows(0, n);
        }
        return new Object[0];
    }

    public synchronized void addRow(Object object) {
        this.addRow(this.data.size(), object);
    }

    public synchronized void addRow(int n, Object object) {
        this.addRows(n, new Object[]{object});
    }

    public synchronized void addRows(Object[] objectArray) {
        this.addRows(this.data.size(), objectArray);
    }

    public synchronized void addRows(int n, Object[] objectArray) {
        this.assertValidRow(n, this.data.size() + 1);
        for (int i = 0; i < objectArray.length; ++i) {
            this.data.add(n + i, objectArray[i]);
        }
        this.fireTableStructureChanged();
    }

    public synchronized void removeRow(int n) {
        this.removeRows(n, n);
    }

    public synchronized void removeAllRows() {
        int n = this.data.size();
        if (n > 0) {
            this.removeRows(0, n - 1);
        }
    }

    public synchronized void removeRows(int n, int n2) {
        this.assertValidRange(n, n2);
        for (int i = n2; i >= n; --i) {
            this.data.remove(i);
        }
        this.fireTableStructureChanged();
    }

    public synchronized boolean moveRowsDown(int n, int n2) {
        return this.moveRowsTo(n, n2, n2 + 2);
    }

    public synchronized boolean moveRowsUp(int n, int n2) {
        return this.moveRowsTo(n, n2, n - 1);
    }

    public synchronized boolean moveRowsTo(int n, int n2, int n3) {
        if (!this.canMoveRowsTo(n, n2, n3)) {
            throw new ArrayIndexOutOfBoundsException("Cannot move rows " + n + '-' + n2 + " beyond table boundary");
        }
        if (n <= n3 && n3 <= n2 + 1) {
            return false;
        }
        int n4 = n2 - n + 1;
        Object[] objectArray = new Object[n4];
        for (int i = n; i <= n2; ++i) {
            objectArray[i - n] = this.data.get(i);
        }
        this.removeRows(n, n2);
        if (n3 > n) {
            n3 -= n4;
        }
        this.addRows(n3, objectArray);
        this.fireTableStructureChanged();
        return true;
    }

    public synchronized boolean canMoveRowsUp(int n, int n2) {
        return this.canMoveRowsTo(n, n2, n - 1);
    }

    public synchronized boolean canMoveRowsDown(int n, int n2) {
        return this.canMoveRowsTo(n, n2, n2 + 2);
    }

    public synchronized boolean canMoveRowsTo(int n, int n2, int n3) {
        try {
            this.assertValidRange(n, n2);
            this.assertValidRow(n3, this.data.size() + 1);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return false;
        }
        return true;
    }

    private void assertValidRow(int n, int n2) {
        if (n < 0 || n >= n2) {
            throw new ArrayIndexOutOfBoundsException("Invalid row: " + n);
        }
    }

    private synchronized void assertValidRow(int n) {
        this.assertValidRow(n, this.data.size());
    }

    private void assertValidRange(int n, int n2) {
        if (n > n2) {
            throw new ArrayIndexOutOfBoundsException("Invalid row range: " + n + '-' + n2);
        }
        this.assertValidRow(n);
        this.assertValidRow(n2);
    }
}

