/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.volmgr.client.ttk.table;

import com.sun.admin.volmgr.client.ttk.table.RowGroup;
import com.sun.admin.volmgr.client.ttk.table.TableRowHeaderConstraints;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.util.Hashtable;
import javax.swing.JTable;

public class TableRowHeaderLayout
implements LayoutManager2 {
    protected static TableRowHeaderConstraints _CONSTRAINTS = new TableRowHeaderConstraints();
    private JTable table;
    private int spacing;
    private Hashtable hash = new Hashtable();

    public TableRowHeaderLayout(JTable jTable) {
        this.setTable(jTable);
    }

    public TableRowHeaderLayout(JTable jTable, int n) {
        this(jTable);
        this.setSpacing(n);
    }

    public void setTable(JTable jTable) {
        this.table = jTable;
    }

    public JTable getTable() {
        return this.table;
    }

    public void setSpacing(int n) {
        this.spacing = n;
    }

    public int getSpacing() {
        return this.spacing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLayoutComponent(Component component, Object object) {
        Object object2 = component.getTreeLock();
        synchronized (object2) {
            if (object == null) {
                object = _CONSTRAINTS;
            } else if (!(object instanceof TableRowHeaderConstraints)) {
                throw new IllegalArgumentException("Cannot add to layout: constraint must be a TableRowHeaderConstraints (or null)");
            }
            this.hash.put(component, ((TableRowHeaderConstraints)object).clone());
        }
    }

    public void addLayoutComponent(String string, Component component) {
        this.addLayoutComponent(component, _CONSTRAINTS);
    }

    public void removeLayoutComponent(Component component) {
        this.hash.remove(component);
    }

    public Dimension preferredLayoutSize(Container container) {
        int n = this.getTable().getPreferredSize().height;
        Dimension dimension = new Dimension(0, n);
        int n2 = container.getComponentCount();
        for (int i = 0; i < n2; ++i) {
            Component component = container.getComponent(i);
            if (!component.isVisible()) continue;
            Dimension dimension2 = component.getPreferredSize();
            if (dimension2.width <= dimension.width) continue;
            dimension.width = dimension2.width;
        }
        Insets insets = container.getInsets();
        dimension.width += insets.left + insets.right;
        return dimension;
    }

    public Dimension minimumLayoutSize(Container container) {
        int n = this.getTable().getMinimumSize().height;
        Dimension dimension = new Dimension(0, n);
        int n2 = container.getComponentCount();
        for (int i = 0; i < n2; ++i) {
            Component component = container.getComponent(i);
            if (!component.isVisible()) continue;
            Dimension dimension2 = component.getMinimumSize();
            if (dimension2.width <= dimension.width) continue;
            dimension.width = dimension2.width;
        }
        Insets insets = container.getInsets();
        dimension.width += insets.left + insets.right;
        return dimension;
    }

    public void layoutContainer(Container container) {
        Object object;
        Component component;
        int n;
        JTable jTable = this.getTable();
        int n2 = this.getSpacing();
        int n3 = n2 / 2;
        int n4 = n2 - n3;
        Insets insets = container.getInsets();
        Dimension dimension = container.getPreferredSize();
        Dimension dimension2 = container.getSize();
        int n5 = container.getComponentCount();
        int n6 = jTable.getRowCount();
        int[] nArray = new int[n6];
        for (n = 0; n < n5; ++n) {
            component = container.getComponent(n);
            if (!component.isVisible()) continue;
            try {
                object = this.getConstraints(component).getRowGroup();
                nArray[object.getFirstRow()] = 1;
                nArray[object.getLastRow()] = 1;
                continue;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                continue;
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        for (n = 0; n < n5; ++n) {
            int n7;
            int n8;
            int n9;
            int n10;
            int n11;
            int n12;
            RowGroup rowGroup;
            TableRowHeaderConstraints tableRowHeaderConstraints;
            component = container.getComponent(n);
            if (!component.isVisible()) continue;
            object = component.getPreferredSize();
            try {
                tableRowHeaderConstraints = this.getConstraints(component);
                rowGroup = tableRowHeaderConstraints.getRowGroup();
            }
            catch (NullPointerException nullPointerException) {
                continue;
            }
            TableRowHeaderConstraints.HOrient hOrient = tableRowHeaderConstraints.getHOrient();
            if (hOrient == TableRowHeaderConstraints.LEFT) {
                n12 = insets.left;
                n11 = ((Dimension)object).width;
            } else if (hOrient == TableRowHeaderConstraints.HFILL) {
                n12 = insets.left;
                n11 = dimension2.width - insets.left - insets.right;
            } else if (hOrient == TableRowHeaderConstraints.RIGHT) {
                n12 = dimension2.width - ((Dimension)object).width - insets.right;
                n11 = ((Dimension)object).width;
            } else {
                n12 = dimension2.width / 2 - ((Dimension)object).width / 2;
                n11 = ((Dimension)object).width;
            }
            int n13 = rowGroup.getFirstRow();
            int n14 = rowGroup.getLastRow();
            Rectangle rectangle = jTable.getCellRect(n13, 0, true);
            Rectangle rectangle2 = jTable.getCellRect(n14, 0, true);
            TableRowHeaderConstraints.VOrient vOrient = tableRowHeaderConstraints.getVOrient();
            if (vOrient == TableRowHeaderConstraints.TOP) {
                n10 = rectangle.y;
                n9 = rectangle2.y + rectangle2.height;
                n8 = rectangle.y + ((Dimension)object).height;
                n7 = n9 < n8 ? n9 : n8;
            } else if (vOrient == TableRowHeaderConstraints.VFILL) {
                n10 = rectangle.y;
                n7 = rectangle2.y + rectangle2.height;
            } else if (vOrient == TableRowHeaderConstraints.BOTTOM) {
                n9 = rectangle.y;
                n7 = rectangle2.y + rectangle2.height;
                n8 = n7 - ((Dimension)object).height;
                n10 = n9 > n8 ? n9 : n8;
            } else {
                n7 = rectangle2.y + rectangle2.height;
                n10 = rectangle.y;
                n9 = n7 - n10;
                if (n9 > ((Dimension)object).height) {
                    n7 = (n10 += (n9 - ((Dimension)object).height) / 2) + ((Dimension)object).height;
                }
            }
            if (n13 == 0) {
                n10 += insets.top;
            } else if (nArray[n13 - 1] != 0) {
                n10 += n3;
            }
            if (n14 == n6 - 1) {
                if (dimension2.height <= jTable.getSize().height) {
                    n7 -= insets.bottom;
                }
            } else if (nArray[n14 + 1] != 0) {
                n7 -= n4;
            }
            int n15 = n7 - n10;
            component.setBounds(n12, n10, n11, n15);
        }
    }

    public Dimension maximumLayoutSize(Container container) {
        Dimension dimension = this.getTable().getSize();
        return new Dimension(Integer.MAX_VALUE, dimension.height);
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    public void invalidateLayout(Container container) {
    }

    public void setConstraints(Component component, TableRowHeaderConstraints tableRowHeaderConstraints) {
        this.addLayoutComponent(component, tableRowHeaderConstraints);
    }

    public TableRowHeaderConstraints getConstraints(Component component) {
        return (TableRowHeaderConstraints)this.hash.get(component);
    }
}

