/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.volmgr.client.ttk.text;

import com.sun.admin.volmgr.client.ttk.text.SpinnerDataModel;
import java.text.ParseException;

public class LongSpinnerModel
implements SpinnerDataModel {
    private static final long _INCREMENT = 1L;
    private long min;
    private long max;
    private long increment;

    public LongSpinnerModel() {
        this(Long.MIN_VALUE, Long.MAX_VALUE);
    }

    public LongSpinnerModel(long l, long l2) {
        this(l, l2, 1L);
    }

    public LongSpinnerModel(long l, long l2, long l3) {
        this.setMin(l);
        this.setMax(l2);
        this.setIncrement(l3);
    }

    public void setMin(long l) {
        this.min = l;
    }

    public long getMin() {
        return this.min;
    }

    public void setMax(long l) {
        this.max = l;
    }

    public long getMax() {
        return this.max;
    }

    public void setIncrement(long l) {
        this.increment = l;
    }

    public long getIncrement() {
        return this.increment;
    }

    public String incrementValue(String string) throws ParseException {
        return this.incrementValueBy(string, true);
    }

    public String decrementValue(String string) throws ParseException {
        return this.incrementValueBy(string, false);
    }

    public boolean isValidBeginning(String string) {
        if (this.getMin() < 0L && string.trim().equals("-")) {
            return true;
        }
        try {
            Long.parseLong(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    protected String incrementValueBy(String string, boolean bl) throws ParseException {
        long l;
        long l2 = this.getIncrement();
        long l3 = this.getMin();
        long l4 = this.getMax();
        if (string.trim().length() == 0) {
            l = l3 <= 0L && l4 >= 0L ? 0L : l3;
        } else {
            try {
                l = Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParseException("Could not convert " + string + " to a long.", 0);
            }
            l += l2 * (long)(bl ? 1 : -1);
        }
        if (l < l3 || l > l4) {
            throw new ParseException("Incremented value " + l + " out of valid range (" + l3 + "-" + l4 + ")", 0);
        }
        return Long.toString(l);
    }
}

