/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.volmgr.client.volumes;

import com.sun.admin.cis.common.ActionString;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.JIntSpinBox;
import com.sun.admin.volmgr.client.Content;
import com.sun.admin.volmgr.client.ContentEvent;
import com.sun.admin.volmgr.client.ContentListener;
import com.sun.admin.volmgr.client.VolActionsListener;
import com.sun.admin.volmgr.client.ttk.RowLayout;
import com.sun.admin.volmgr.client.util.Util;
import com.sun.admin.volmgr.client.volumes.VolumesContent;
import com.sun.management.viper.console.VConsoleProperties;
import com.sun.management.viper.util.ResourceManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JToolBar;

public class VMgrVolumesTBar
extends JToolBar
implements PropertyChangeListener {
    private VolumesContent vContent;
    private JButton showCommandsBtn;
    private JButton addVolumeBtn;
    private ContentListener contentListener;
    private VolActionsListener buttonClickListener;
    private JRadioButton perfUnitsOpsBtn;
    private JRadioButton perfUnitsKbBtn;
    private JPanel perfUnitsButtonPanel;
    private JCheckBox updateSwitch;
    private JIntSpinBox updateRate;
    private JPanel updatePanel;
    private ImageIcon showCommandsIcon;
    private ImageIcon addVolumeIcon;
    private String showCommandsText;
    private String addVolumeText;
    private int timerDelay = 30;
    private Insets textMargin = new Insets(0, 2, 0, 2);
    private static VMgrVolumesTBar theToolBar = null;

    public static VMgrVolumesTBar getToolBar(VolumesContent volumesContent) {
        if (theToolBar == null) {
            theToolBar = new VMgrVolumesTBar(volumesContent);
        }
        volumesContent.addContentListener(theToolBar.getContentListener());
        return theToolBar;
    }

    public ContentListener getContentListener() {
        return this.contentListener;
    }

    private VMgrVolumesTBar(VolumesContent volumesContent) {
        this.vContent = volumesContent;
        this.buttonClickListener = new VolActionsListener();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.showCommandsText = Util.getResourceString("tbar_show_commands");
        this.addVolumeText = Util.getResourceString("tbar_add_volume");
        this.showCommandsIcon = Util.loadImageIcon("showcommands_24.gif");
        this.addVolumeIcon = Util.loadImageIcon("volume_24.gif");
        this.showCommandsBtn = new JButton(this.showCommandsIcon);
        this.setUpButton(this.showCommandsBtn, this.showCommandsText, "ShowCommands");
        Constraints.constrain((Container)this, (Component)this.showCommandsBtn, (int)0, (int)0, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)1.0, (int)0, (int)0, (int)0, (int)0);
        this.addVolumeBtn = new JButton(this.addVolumeIcon);
        this.setUpButton(this.addVolumeBtn, this.addVolumeText, "AddVolume");
        Constraints.constrain((Container)this, (Component)this.addVolumeBtn, (int)1, (int)0, (int)1, (int)1, (int)0, (int)17, (double)10.0, (double)1.0, (int)0, (int)2, (int)0, (int)0);
        this.perfUnitsOpsBtn = new JRadioButton("ops", true);
        ActionString actionString = Util.getActionString("perf_units_ops");
        this.perfUnitsOpsBtn.setText(actionString.getString());
        this.perfUnitsOpsBtn.setMnemonic(actionString.getMnemonic());
        this.perfUnitsOpsBtn.setFont(ResourceManager.bodyFont);
        this.perfUnitsOpsBtn.setActionCommand("ViewPerfOpsSec");
        this.perfUnitsOpsBtn.addActionListener(this.buttonClickListener);
        this.perfUnitsKbBtn = new JRadioButton("kb", false);
        actionString = Util.getActionString("perf_units_kb");
        this.perfUnitsKbBtn.setText(actionString.getString());
        this.perfUnitsKbBtn.setMnemonic(actionString.getMnemonic());
        this.perfUnitsKbBtn.setFont(ResourceManager.bodyFont);
        this.perfUnitsKbBtn.setActionCommand("ViewPerfKSec");
        this.perfUnitsKbBtn.addActionListener(this.buttonClickListener);
        this.perfUnitsButtonPanel = new JPanel();
        this.perfUnitsButtonPanel.setLayout(new RowLayout());
        this.perfUnitsButtonPanel.add(this.perfUnitsOpsBtn);
        this.perfUnitsButtonPanel.add(this.perfUnitsKbBtn);
        int n = 9;
        Constraints.constrain((Container)this, (Component)this.perfUnitsButtonPanel, (int)2, (int)0, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)1.0, (int)0, (int)n, (int)0, (int)0);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.perfUnitsOpsBtn);
        buttonGroup.add(this.perfUnitsKbBtn);
        this.updatePanel = new JPanel();
        this.updatePanel.setLayout(new GridBagLayout());
        actionString = Util.getActionString("update_switch_label");
        this.updateSwitch = new JCheckBox(actionString.getString(), false);
        Constraints.constrain((Container)this.updatePanel, (Component)this.updateSwitch, (int)-1, (int)0, (int)1, (int)1);
        this.updateSwitch.setMnemonic(actionString.getMnemonic());
        this.updateSwitch.setFont(ResourceManager.bodyFont);
        this.updateRate = new JIntSpinBox(5, 5, 99999);
        this.updateRate.setWrapping(false);
        this.updateRate.setIntValue(30);
        Constraints.constrain((Container)this.updatePanel, (Component)this.updateRate, (int)-1, (int)0, (int)1, (int)1);
        this.updateRate.getTextField().setEnabled(false);
        this.updateRate.getUpButton().setEnabled(false);
        this.updateRate.getDownButton().setEnabled(false);
        this.updateRate.getTextField().setFont(ResourceManager.bodyFont);
        this.updateRate.getTextField().setMinimumSize(this.updateRate.getTextField().getPreferredSize());
        actionString = Util.getActionString("update_rate_units");
        JLabel jLabel = new JLabel(actionString.getString());
        Constraints.constrain((Container)this.updatePanel, (Component)jLabel, (int)-1, (int)0, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)0, (int)5, (int)0, (int)0);
        jLabel.setFont(ResourceManager.bodyFont);
        jLabel.setForeground(ResourceManager.bodyColor);
        this.updateSwitch.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    VMgrVolumesTBar.this.vContent.setPerformanceViewPollingEnabled(true);
                    VMgrVolumesTBar.this.updateRate.getTextField().setEnabled(true);
                    int n = VMgrVolumesTBar.this.vContent.getPerfTimerDelay();
                    if (n < 99999) {
                        VMgrVolumesTBar.this.updateRate.getUpButton().setEnabled(true);
                    }
                    if (n > 1) {
                        VMgrVolumesTBar.this.updateRate.getDownButton().setEnabled(true);
                    }
                } else {
                    VMgrVolumesTBar.this.vContent.setPerformanceViewPollingEnabled(false);
                    VMgrVolumesTBar.this.updateRate.getTextField().setEnabled(false);
                    VMgrVolumesTBar.this.updateRate.getUpButton().setEnabled(false);
                    VMgrVolumesTBar.this.updateRate.getDownButton().setEnabled(false);
                }
            }
        });
        ActionListener actionListener = new ActionListener(){

            public synchronized void actionPerformed(ActionEvent actionEvent) {
                int n = VMgrVolumesTBar.this.updateRate.getIntValue();
                if (actionEvent.getSource() == VMgrVolumesTBar.this.updateRate.getUpButton()) {
                    VMgrVolumesTBar.this.timerDelay = n + 1;
                } else {
                    VMgrVolumesTBar.this.timerDelay = n - 1;
                }
                VMgrVolumesTBar.this.vContent.setPerfTimerDelay(VMgrVolumesTBar.this.timerDelay);
            }
        };
        this.updateRate.getUpButton().addActionListener(actionListener);
        this.updateRate.getDownButton().addActionListener(actionListener);
        Constraints.constrain((Container)this, (Component)this.updatePanel, (int)3, (int)0, (int)1, (int)1, (int)0, (int)17, (double)10.0, (double)1.0, (int)0, (int)n, (int)0, (int)0);
        this.contentListener = new ContentListener(){

            public void itemPressed(ContentEvent contentEvent) {
                Content content = contentEvent.getSource();
                VMgrVolumesTBar.this.notifySelectionChange(content.getNumSelections());
            }
        };
    }

    private void setUpButton(JButton jButton, String string, String string2) {
        jButton.setToolTipText(string);
        jButton.setFocusPainted(false);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.setActionCommand(string2);
        jButton.addActionListener(this.buttonClickListener);
    }

    private void notifySelectionChange(int n) {
        VConsoleProperties vConsoleProperties = Util.getApp().getProperties();
        if (n == 1) {
            vConsoleProperties.setProperty("vconsole.propertiesenabled", "true");
        } else {
            vConsoleProperties.setProperty("vconsole.propertiesenabled", "false");
        }
        boolean bl = true;
        if (n == 0) {
            bl = false;
        }
        vConsoleProperties.setProperty("vconsole.deleteenabled", bl ? "true" : "false");
        vConsoleProperties.setProperty("vconsole.filterenabled", "true");
        if (!Util.getApp().getServiceWrapper().hasVolMgrWriteAuth()) {
            this.showCommandsBtn.setEnabled(false);
            this.addVolumeBtn.setEnabled(false);
            vConsoleProperties.setProperty("vconsole.deleteenabled", "false");
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("vconsole.buttondisplay")) {
            this.setButtonDisplay(Util.getApp().getProperties().getProperty("vconsole.buttondisplay"));
        }
    }

    public void setUpdatePanelState(boolean bl, boolean bl2, boolean bl3, int n, int n2) {
        if (bl && bl2) {
            this.updatePanel.setVisible(true);
            this.perfUnitsButtonPanel.setVisible(true);
        } else {
            this.updatePanel.setVisible(false);
            this.perfUnitsButtonPanel.setVisible(false);
        }
        this.updateSwitch.setSelected(bl3);
        if (n == 0) {
            this.perfUnitsOpsBtn.setSelected(true);
        } else if (n == 0) {
            this.perfUnitsKbBtn.setSelected(true);
        }
        this.updateRate.setIntValue(n2);
        this.timerDelay = n2;
    }

    public void setProperties(VConsoleProperties vConsoleProperties) {
        if (vConsoleProperties != null) {
            this.setButtonDisplay(vConsoleProperties.getProperty("vconsole.buttondisplay"));
            vConsoleProperties.addPropertyChangeListener((PropertyChangeListener)this);
        }
    }

    private void setButtonDisplay(String string) {
        if (string.equals("vconsole.textonly")) {
            this.installString(this.showCommandsBtn, this.showCommandsText);
            this.installIcon(this.showCommandsBtn, null);
            this.installString(this.addVolumeBtn, this.addVolumeText);
            this.installIcon(this.addVolumeBtn, null);
        } else if (string.equals("vconsole.icononly")) {
            this.installString(this.showCommandsBtn, null);
            this.installIcon(this.showCommandsBtn, this.showCommandsIcon);
            this.installString(this.addVolumeBtn, null);
            this.installIcon(this.addVolumeBtn, this.addVolumeIcon);
        } else if (string.equals("vconsole.textandicon")) {
            this.installString(this.showCommandsBtn, this.showCommandsText);
            this.installIcon(this.showCommandsBtn, this.showCommandsIcon);
            this.installString(this.addVolumeBtn, this.addVolumeText);
            this.installIcon(this.addVolumeBtn, this.addVolumeIcon);
        }
    }

    private void installString(AbstractButton abstractButton, String string) {
        if (abstractButton != null) {
            abstractButton.setFont(ResourceManager.bodyFont);
            abstractButton.setText(string);
            if (string != null) {
                abstractButton.setMargin(this.textMargin);
            } else {
                abstractButton.setMargin(null);
            }
        }
    }

    private void installIcon(AbstractButton abstractButton, ImageIcon imageIcon) {
        if (abstractButton != null) {
            abstractButton.setIcon(imageIcon);
        }
    }
}

