/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.volmgr.client.wizards.cards;

import com.sun.admin.cis.common.ErrorDialog;
import com.sun.admin.volmgr.client.ttk.Spinner;
import com.sun.admin.volmgr.client.ttk.text.LongSpinnerModel;
import com.sun.admin.volmgr.client.ttk.text.SpinnerDataModel;
import com.sun.admin.volmgr.client.util.Util;
import com.sun.admin.volmgr.client.wizards.cards.MultiDeviceChooserCard;
import com.sun.admin.volmgr.client.wizards.command.DiskSetCommandFactory;
import com.sun.admin.volmgr.common.Device;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class DiskSetDisksCard
extends MultiDeviceChooserCard {
    private static String TITLERESOURCE = "diskset_add_wiz_disks_title";
    private static final String HELPFILE = "DiskSetDisksCard.html";
    private static String HEADER = "diskset_add_wiz_disks_header";
    private DiskSetCommandFactory factory;
    private JTextField lengthField;

    public DiskSetDisksCard(DiskSetCommandFactory diskSetCommandFactory) {
        super(TITLERESOURCE, HELPFILE, HEADER);
        this.factory = diskSetCommandFactory;
        this.initGUI();
    }

    protected Component getMainPanel() {
        Component component = super.getMainPanel();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(15, 15));
        jPanel.add(component, "Center");
        JLabel jLabel = new JLabel();
        Util.initLabel(jLabel, "diskset_add_wiz_length_label");
        this.lengthField = new JTextField();
        jLabel.setLabelFor(this.lengthField);
        LongSpinnerModel longSpinnerModel = new LongSpinnerModel(64L, 8192L);
        Spinner spinner = new Spinner(this.lengthField, (SpinnerDataModel)longSpinnerModel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(0, 15, 15));
        jPanel2.add(jLabel);
        jPanel2.add(spinner);
        jPanel.add((Component)jPanel2, "South");
        return jPanel;
    }

    protected Device[] getDevices() {
        return Util.getApp().getServiceWrapper().getDevicesAvailableForUseAs("Diskset", "");
    }

    protected boolean setDevices(Device[] deviceArray) {
        return true;
    }

    public void refresh() {
        this.lengthField.setText(Long.toString(this.factory.getReplicaLength()));
        super.refresh();
    }

    public boolean stop(boolean bl) {
        long l;
        String string = this.lengthField.getText().trim();
        try {
            l = Long.parseLong(string);
            if (l < 64L || l > 8192L) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException numberFormatException) {
            String string2 = Util.getResourceString("invalid_replica_length", string);
            new ErrorDialog(null, string2);
            return false;
        }
        this.factory.setDisks(this.getTableSelectorManager().getOutItems());
        this.factory.setReplicaLength(l);
        return true;
    }
}

