/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.volmgr.client.wizards.cards;

import com.sun.admin.cis.common.ErrorDialog;
import com.sun.admin.volmgr.client.InterlacePanel;
import com.sun.admin.volmgr.client.util.Util;
import com.sun.admin.volmgr.client.wizards.cards.SimpleVWizardCard;
import com.sun.admin.volmgr.client.wizards.command.VolumeCommandFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;

public class InterlaceCard
extends SimpleVWizardCard {
    private static String TITLE = "add_wiz_interlace_title";
    private static final String HELPFILE = "InterlaceCard.html";
    private static String HEADER = "add_wiz_interlace_header";
    private VolumeCommandFactory factory;
    private InterlacePanel panel;

    public InterlaceCard(VolumeCommandFactory volumeCommandFactory) {
        super(TITLE, HELPFILE, HEADER);
        this.factory = volumeCommandFactory;
        this.initGUI();
    }

    protected Component getMainPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(15, 15));
        jPanel.add(super.getMainPanel(), "North");
        this.panel = new InterlacePanel();
        jPanel.add((Component)this.panel, "Center");
        return jPanel;
    }

    public void refresh() {
        this.panel.setInterlaceInBlocks(this.factory.getInterlaceInBlocks());
    }

    public boolean stop(boolean bl) {
        if (bl) {
            if (!this.panel.isValidInterlace()) {
                Util.DeviceSize deviceSize = Util.getSizeInGreatestUnits(16L, 1001);
                Util.DeviceSize deviceSize2 = Util.getSizeInGreatestUnits(204800L, 1001);
                Object[] objectArray = new Object[]{Util.getUnitText(deviceSize.size, deviceSize.units), Util.getUnitText(deviceSize2.size, deviceSize2.units)};
                String string = Util.getResourceString("invalid_interlace_value", objectArray);
                new ErrorDialog(null, string);
                return false;
            }
            this.factory.setInterlaceInBlocks(this.panel.getInterlaceInBlocks());
        }
        return true;
    }
}

