/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.volmgr.client.wizards.cards;

import com.sun.admin.cis.common.ErrorDialog;
import com.sun.admin.cis.common.FlowArea;
import com.sun.admin.volmgr.client.VVolMgr;
import com.sun.admin.volmgr.client.ttk.I18nTextComponent;
import com.sun.admin.volmgr.client.ttk.Spinner;
import com.sun.admin.volmgr.client.ttk.text.LongSpinnerModel;
import com.sun.admin.volmgr.client.ttk.text.SpinnerDataModel;
import com.sun.admin.volmgr.client.util.GUIUtil;
import com.sun.admin.volmgr.client.util.Util;
import com.sun.admin.volmgr.client.wizards.cards.SimpleVWizardCard;
import com.sun.admin.volmgr.client.wizards.command.VolumeCommandFactory;
import com.sun.admin.volmgr.common.Device;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class SoftPartitionParamCard
extends SimpleVWizardCard {
    private static String TITLE = "SoftPartitionParamCard_title";
    private static final String HELPFILE = "SoftPartitionParamCard.html";
    private static String HEADER = "SoftPartitionParamCard_header";
    public static int AS_MANY_SP_AS_POSSIBLE = -1;
    public static long ALL_AVAILABLE_SPACE_FOR_SP = -1L;
    private VolumeCommandFactory factory;
    private JTextArea availableLabel;
    private JRadioButton[] buttons = new JRadioButton[3];
    private JTextField[] numberFields = new JTextField[3];
    private JTextField[] sizeFields = new JTextField[3];
    private JComboBox[] unitsCombos = new JComboBox[3];

    public SoftPartitionParamCard(VolumeCommandFactory volumeCommandFactory) {
        super(TITLE, HELPFILE, HEADER);
        this.factory = volumeCommandFactory;
        this.initGUI();
    }

    private int getNumberOfSoftPartitionsFromField(int n) {
        JTextField jTextField = this.numberFields[n];
        if (jTextField != null) {
            try {
                return Integer.parseInt(jTextField.getText());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return AS_MANY_SP_AS_POSSIBLE;
    }

    private long getPartitionSizeFromField(int n) {
        JTextField jTextField = this.sizeFields[n];
        if (jTextField != null) {
            try {
                return Long.parseLong(jTextField.getText());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return ALL_AVAILABLE_SPACE_FOR_SP;
    }

    private int getUnitsFromComboBox(int n) {
        JComboBox jComboBox = this.unitsCombos[n];
        if (jComboBox != null) {
            return jComboBox.getSelectedIndex();
        }
        return 1;
    }

    private Spinner createNumberSpinner() {
        return new Spinner(new JTextField(4), (SpinnerDataModel)new LongSpinnerModel(1L, Long.MAX_VALUE));
    }

    private Spinner createPartitionSizeSpinner() {
        return new Spinner(new JTextField(4), (SpinnerDataModel)new LongSpinnerModel(1L, Long.MAX_VALUE));
    }

    private JComboBox createUnitsCombo() {
        return new JComboBox<String>(new String[]{Util.getResourceString("blocks"), Util.getResourceString("kilobytes"), Util.getResourceString("megabytes"), Util.getResourceString("gigabytes"), Util.getResourceString("terabytes")});
    }

    private static JRadioButton createJRadioButton(Component[] componentArray) {
        final JRadioButton jRadioButton = new JRadioButton();
        FocusAdapter focusAdapter = new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                jRadioButton.setSelected(true);
            }
        };
        for (int i = 0; i < componentArray.length; ++i) {
            componentArray[i].addFocusListener(focusAdapter);
        }
        return jRadioButton;
    }

    private static int getDerivedNumberOfSoftPartitions(long l, Device device) {
        return VVolMgr.getLastInstance().getServiceWrapper().getNumberOfPossibleSps(device, l);
    }

    private static long getDerivedSizeOfSoftPartitions(int n, Device device) {
        return VVolMgr.getLastInstance().getServiceWrapper().getPosssibleSpSize(device, n);
    }

    private static boolean canCreateSoftPartitions(int n, long l, Device device) {
        return VVolMgr.getLastInstance().getServiceWrapper().canCreateSps(device, n, l);
    }

    protected Component getMainPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(15, 15));
        jPanel.add(super.getMainPanel(), "North");
        I18nTextComponent[] i18nTextComponentArray = new I18nTextComponent[3];
        Spinner spinner = this.createNumberSpinner();
        this.numberFields[0] = spinner.getTextField();
        Spinner spinner2 = this.createPartitionSizeSpinner();
        this.sizeFields[0] = spinner2.getTextField();
        this.unitsCombos[0] = this.createUnitsCombo();
        Component[] componentArray = (Component[])Util.getCombinedArray(new Component[][]{GUIUtil.getDescendentComponents(spinner), GUIUtil.getDescendentComponents(spinner2), {this.unitsCombos[0]}});
        this.buttons[0] = SoftPartitionParamCard.createJRadioButton(componentArray);
        this.buttons[0].setSelected(true);
        i18nTextComponentArray[0] = new I18nTextComponent(Util.getResourceString("SoftPartitionParamCard_option1"), new Component[]{spinner, spinner2, this.unitsCombos[0]});
        spinner2 = this.createPartitionSizeSpinner();
        this.sizeFields[1] = spinner2.getTextField();
        this.unitsCombos[1] = this.createUnitsCombo();
        componentArray = (Component[])Util.getCombinedArray(new Component[][]{GUIUtil.getDescendentComponents(spinner2), {this.unitsCombos[1]}});
        this.buttons[1] = SoftPartitionParamCard.createJRadioButton(componentArray);
        i18nTextComponentArray[1] = new I18nTextComponent(Util.getResourceString("SoftPartitionParamCard_option2"), new Component[]{spinner2, this.unitsCombos[1]});
        spinner = this.createNumberSpinner();
        this.numberFields[2] = spinner.getTextField();
        componentArray = GUIUtil.getDescendentComponents(spinner);
        this.buttons[2] = SoftPartitionParamCard.createJRadioButton(componentArray);
        i18nTextComponentArray[2] = new I18nTextComponent(Util.getResourceString("SoftPartitionParamCard_option3"), new Component[]{spinner});
        ButtonGroup buttonGroup = new ButtonGroup();
        this.availableLabel = new FlowArea("");
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets.bottom = 10;
        jPanel2.add((Component)this.availableLabel, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets.bottom = 0;
        for (int i = 0; i < this.buttons.length; ++i) {
            buttonGroup.add(this.buttons[i]);
            gridBagConstraints.gridwidth = 1;
            jPanel2.add((Component)this.buttons[i], gridBagConstraints);
            gridBagConstraints.gridwidth = 0;
            jPanel2.add((Component)i18nTextComponentArray[i], gridBagConstraints);
        }
        jPanel.add((Component)jPanel2, "West");
        return jPanel;
    }

    public void refresh() {
        int n;
        long l = Util.getDeviceAvailableSpace(this.factory.getComponents()[0]);
        String string = Util.getReadableSizeWithUnits(l * 512L);
        this.availableLabel.setText(Util.getResourceString("SoftPartitionParamCard_available", string));
        int n2 = this.factory.getNumberOfSoftPartitions();
        long l2 = this.factory.getSoftPartitionSizeInBlocks();
        this.buttons[0].setSelected(true);
        for (int i = 0; i < this.numberFields.length; ++i) {
            if (this.numberFields[i] == null) continue;
            this.numberFields[i].setText("" + n2);
        }
        Util.DeviceSize deviceSize = Util.getSizeInGreatestUnits(l2, 1001);
        switch (deviceSize.units) {
            case 1005: {
                n = 4;
                break;
            }
            case 1004: {
                n = 3;
                break;
            }
            case 1003: {
                n = 2;
                break;
            }
            case 1002: {
                n = 1;
                break;
            }
            default: {
                n = 0;
            }
        }
        for (int i = 0; i < this.sizeFields.length; ++i) {
            if (this.sizeFields[i] == null) continue;
            this.sizeFields[i].setText("" + deviceSize.size);
            this.unitsCombos[i].setSelectedIndex(n);
        }
    }

    public boolean stop(boolean bl) {
        if (bl) {
            boolean bl2;
            int n;
            for (n = this.buttons.length - 1; n > 0 && !this.buttons[n].isSelected(); --n) {
            }
            int n2 = this.getNumberOfSoftPartitionsFromField(n);
            long l = this.getPartitionSizeFromField(n);
            if (l != ALL_AVAILABLE_SPACE_FOR_SP) {
                switch (this.getUnitsFromComboBox(n)) {
                    case 4: {
                        l <<= 31;
                        break;
                    }
                    case 3: {
                        l <<= 21;
                        break;
                    }
                    case 2: {
                        l <<= 11;
                        break;
                    }
                    case 1: {
                        l <<= 1;
                    }
                }
            }
            Device device = this.factory.getComponents()[0];
            if (n2 == AS_MANY_SP_AS_POSSIBLE) {
                if (l == ALL_AVAILABLE_SPACE_FOR_SP) {
                    throw new IllegalArgumentException("Either number or size must be set values");
                }
                n2 = SoftPartitionParamCard.getDerivedNumberOfSoftPartitions(l, device);
                bl2 = n2 > 0;
            } else {
                bl2 = l == ALL_AVAILABLE_SPACE_FOR_SP ? (l = SoftPartitionParamCard.getDerivedSizeOfSoftPartitions(n2, device)) > 0L : SoftPartitionParamCard.canCreateSoftPartitions(n2, l, device);
            }
            if (!bl2) {
                Object[] objectArray = new Object[]{n2 > 0 ? n2 + " " : "", l > 0L ? Util.getReadableSizeWithUnits(l * 512L) + " " : ""};
                String string = Util.getResourceString("SoftPartitionParamCard_error", objectArray);
                new ErrorDialog(null, string);
                return false;
            }
            this.factory.setNumberOfSoftPartitions(n2);
            this.factory.setSoftPartitionSizeInBlocks(l);
        }
        return true;
    }
}

