/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.volmgr.client.wizards.command;

import com.sun.admin.volmgr.client.ConcatStripeTablePanelManager;
import com.sun.admin.volmgr.client.util.Util;
import com.sun.admin.volmgr.client.wizards.HasDeviceName;
import com.sun.admin.volmgr.client.wizards.HasDiskSet;
import com.sun.admin.volmgr.common.Device;
import java.util.ArrayList;

public class VolumeCommandFactory
implements HasDiskSet,
HasDeviceName {
    private String base = Util.getBasedir();
    private String diskset;
    private String disksetFlag;
    private String type;
    private Device[] components;
    private String hsp;
    private long interlace = 32L;
    private String oldName;
    private int readOption;
    private int writeOption;
    private int passNumber = 1;
    private Device primarySubmirror;
    private long bufferSize = 128L;
    private boolean regenParity;
    private String[] names;
    private int number = 1;
    private long sizeInBlocks = 1L;

    public String getBaseDir() {
        return this.base;
    }

    public synchronized void setDiskSetName(String string) {
        this.diskset = string;
        this.disksetFlag = string == null || string.equals("") ? "" : " -s " + string;
    }

    public synchronized String getDiskSetName() {
        return this.diskset;
    }

    public synchronized void setVolumeType(String string) {
        this.type = string;
    }

    public synchronized String getVolumeType() {
        return this.type;
    }

    public synchronized void setHSPName(String string) {
        int n;
        if (string != null && (n = string.indexOf(47)) != -1) {
            this.setDiskSetName(string.substring(0, n));
            string = string.substring(n + 1);
        }
        this.hsp = string;
    }

    public synchronized String getHSPName() {
        return this.hsp;
    }

    public synchronized void setDeviceName(String string) {
        String[] stringArray;
        if (string == null) {
            stringArray = new String[]{};
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = string;
        }
        this.setDeviceNames(stringArray);
    }

    public synchronized String getDeviceName() {
        String string = null;
        try {
            string = this.names[0];
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public synchronized void setComponents(Device[] deviceArray) {
        this.components = deviceArray;
    }

    public synchronized Device[] getComponents() {
        return this.components;
    }

    public synchronized void setInterlaceInBlocks(long l) {
        this.interlace = l;
    }

    public synchronized long getInterlaceInBlocks() {
        return this.interlace;
    }

    public synchronized void setOldDeviceName(String string) {
        int n;
        if (string != null && (n = string.indexOf(47)) != -1) {
            this.setDiskSetName(string.substring(0, n));
            string = string.substring(n + 1);
        }
        this.oldName = string;
    }

    public synchronized String getOldDeviceName() {
        return this.oldName;
    }

    public synchronized void setReadOption(int n) {
        this.readOption = n;
    }

    public synchronized int getReadOption() {
        return this.readOption;
    }

    public synchronized void setWriteOption(int n) {
        this.writeOption = n;
    }

    public synchronized int getWriteOption() {
        return this.writeOption;
    }

    public synchronized void setPassNumber(int n) {
        this.passNumber = n;
    }

    public synchronized int getPassNumber() {
        return this.passNumber;
    }

    public synchronized void setPrimarySubmirror(Device device) {
        this.primarySubmirror = device;
    }

    public synchronized Device getPrimarySubmirror() {
        return this.primarySubmirror;
    }

    public void setBufferSize(long l) {
        this.bufferSize = l;
    }

    public long getBufferSize() {
        return this.bufferSize;
    }

    public void setRegenerateParity(boolean bl) {
        this.regenParity = bl;
    }

    public boolean getRegenerateParity() {
        return this.regenParity;
    }

    public void setDeviceNames(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            int n = stringArray[i].indexOf(47);
            if (n == -1) continue;
            this.setDiskSetName(stringArray[i].substring(0, n));
            stringArray[i] = stringArray[i].substring(n + 1);
        }
        this.names = stringArray;
    }

    public String[] getDeviceNames() {
        return this.names;
    }

    public synchronized void setNumberOfSoftPartitions(int n) {
        this.number = n;
    }

    public synchronized int getNumberOfSoftPartitions() {
        return this.number;
    }

    public synchronized void setSoftPartitionSizeInBlocks(long l) {
        this.sizeInBlocks = l;
    }

    public synchronized long getSoftPartitionSizeInBlocks() {
        return this.sizeInBlocks;
    }

    public synchronized String getDiskSetFlag() {
        if (this.disksetFlag == null) {
            return "";
        }
        return this.disksetFlag;
    }

    protected static String getInterlaceFlag(long l) {
        if (l != 32L) {
            Util.DeviceSize deviceSize = Util.getSizeInGreatestUnits(l, 1001, 1003);
            switch (deviceSize.units) {
                case 1001: {
                    return " -i " + deviceSize.size + 'b';
                }
                case 1002: {
                    return " -i " + deviceSize.size + 'k';
                }
                case 1003: {
                    return " -i " + deviceSize.size + 'm';
                }
            }
        }
        return "";
    }

    protected synchronized String getInterlaceFlag() {
        return VolumeCommandFactory.getInterlaceFlag(this.getInterlaceInBlocks());
    }

    public synchronized String[] getAttachHSPCommands() {
        String string = this.getHSPName();
        String string2 = this.getDeviceName();
        if (string == null || string2 == null) {
            return new String[0];
        }
        String string3 = this.getBaseDir();
        String string4 = this.getDiskSetFlag();
        return new String[]{string3 + "usr/sbin/metaparam" + string4 + ' ' + "-h " + string + ' ' + string2};
    }

    public synchronized String[] getRenameVolumeCommands() {
        String string = this.getDeviceName();
        String string2 = this.getOldDeviceName();
        if (string == null || string2 == null) {
            return new String[0];
        }
        String string3 = this.getBaseDir();
        String string4 = this.getDiskSetFlag();
        return new String[]{string3 + "usr/sbin/metarename" + string4 + ' ' + string2 + ' ' + string};
    }

    private static Device[][] getStripeGroups(Device[] deviceArray) {
        ArrayList<Device[]> arrayList = new ArrayList<Device[]>();
        for (int i = 0; i < deviceArray.length; ++i) {
            Device[] deviceArray2;
            Device device = deviceArray[i];
            Device device2 = ConcatStripeTablePanelManager.getStripeFromSlice(device);
            if (device2 == null) {
                deviceArray2 = new Device[]{device};
            } else {
                Device device3;
                int n;
                for (n = i + 1; n < deviceArray.length && (device3 = ConcatStripeTablePanelManager.getStripeFromSlice(deviceArray[n])) == device2; ++n) {
                }
                deviceArray2 = new Device[n - i];
                System.arraycopy(deviceArray, i, deviceArray2, 0, deviceArray2.length);
                i = n - 1;
            }
            arrayList.add(deviceArray2);
        }
        return (Device[][])arrayList.toArray((T[])new Device[arrayList.size()][]);
    }

    public synchronized String[] getCreateConcatCommands() {
        int n;
        Object[] objectArray;
        Object object;
        String string = this.getDeviceName();
        Device[] deviceArray = this.getComponents();
        if (string == null || deviceArray == null) {
            return new String[0];
        }
        String string2 = this.getBaseDir();
        String string3 = this.getDiskSetFlag();
        String string4 = "";
        if (deviceArray.length == 1 && (object = deviceArray[0].getProperty("mountpoint")) != null && !object.equals("")) {
            string4 = " -f";
        }
        object = new StringBuffer();
        ((StringBuffer)object).append(string2);
        ((StringBuffer)object).append("usr/sbin/metainit");
        ((StringBuffer)object).append(string4);
        ((StringBuffer)object).append(string3);
        ((StringBuffer)object).append(' ');
        ((StringBuffer)object).append(string);
        Device[][] deviceArray2 = VolumeCommandFactory.getStripeGroups(deviceArray);
        ((StringBuffer)object).append(' ').append(deviceArray2.length);
        for (int i = 0; i < deviceArray2.length; ++i) {
            objectArray = deviceArray2[i];
            ((StringBuffer)object).append(' ').append(objectArray.length);
            for (n = 0; n < objectArray.length; ++n) {
                ((StringBuffer)object).append(' ').append(Util.getDeviceBaseName((Device)objectArray[n]));
            }
            if (objectArray.length <= 1) continue;
            Device device = ConcatStripeTablePanelManager.getStripeFromSlice((Device)objectArray[0]);
            long l = (Long)device.getProperty("interlace");
            String string5 = VolumeCommandFactory.getInterlaceFlag(l);
            ((StringBuffer)object).append(string5);
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(2);
        arrayList.add(((StringBuffer)object).toString());
        objectArray = this.getAttachHSPCommands();
        for (n = 0; n < objectArray.length; ++n) {
            arrayList.add(objectArray[n]);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public synchronized String[] getCreateStripeCommands() {
        String string = this.getDeviceName();
        Device[] deviceArray = this.getComponents();
        if (string == null || deviceArray == null) {
            return new String[0];
        }
        String string2 = this.getBaseDir();
        String string3 = this.getDiskSetFlag();
        String string4 = this.getInterlaceFlag();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string2);
        stringBuffer.append("usr/sbin/metainit");
        stringBuffer.append(string3);
        stringBuffer.append(' ');
        stringBuffer.append(string);
        stringBuffer.append(" 1 ");
        stringBuffer.append(deviceArray.length);
        for (int i = 0; i < deviceArray.length; ++i) {
            stringBuffer.append(' ');
            stringBuffer.append(Util.getDeviceBaseName(deviceArray[i]));
        }
        stringBuffer.append(string4);
        String[] stringArray = this.getAttachHSPCommands();
        return (String[])Util.getCombinedArray(new String[][]{{stringBuffer.toString()}, stringArray});
    }

    public synchronized String[] getMetattachSubmirrorCommands() {
        String string = this.getDeviceName();
        Device[] deviceArray = this.getComponents();
        if (string == null || deviceArray == null) {
            return new String[0];
        }
        String string2 = this.getBaseDir();
        String string3 = this.getDiskSetFlag();
        String[] stringArray = new String[deviceArray.length];
        String string4 = string2 + "usr/sbin/metattach" + string3 + ' ' + string + ' ';
        for (int i = 0; i < deviceArray.length; ++i) {
            stringArray[i] = string4 + Util.getDeviceBaseName(deviceArray[i]);
        }
        return stringArray;
    }

    public synchronized String[] getResyncMirrorCommands() {
        String string = this.getDeviceName();
        if (string == null) {
            return new String[0];
        }
        String string2 = this.getBaseDir();
        String string3 = this.getDiskSetFlag();
        long l = this.getBufferSize();
        return new String[]{string2 + "usr/sbin/metasync" + string3 + ' ' + l + ' ' + string};
    }

    public synchronized String[] getChangeMirrorParamsCommands() {
        String string;
        String string2;
        String string3 = this.getDeviceName();
        if (string3 == null) {
            return new String[0];
        }
        String string4 = this.getBaseDir();
        String string5 = this.getDiskSetFlag();
        int n = this.getReadOption();
        int n2 = this.getWriteOption();
        int n3 = this.getPassNumber();
        switch (n) {
            case 0: {
                string2 = " -r roundrobin";
                break;
            }
            case 1: {
                string2 = " -r geometric";
                break;
            }
            case 2: {
                string2 = " -r first";
                break;
            }
            default: {
                string2 = "";
            }
        }
        switch (n2) {
            case 0: {
                string = " -w parallel";
                break;
            }
            case 1: {
                string = " -w serial";
                break;
            }
            default: {
                string = "";
            }
        }
        String string6 = " -p " + n3;
        return new String[]{string4 + "usr/sbin/metaparam" + string5 + string2 + string + string6 + ' ' + string3};
    }

    public synchronized String[] getCreateMirrorCommands() {
        String string;
        String string2;
        String string3 = this.getDeviceName();
        Device[] deviceArray = this.getComponents();
        Device device = this.getPrimarySubmirror();
        if (string3 == null || device == null || deviceArray == null) {
            return new String[0];
        }
        String string4 = this.getBaseDir();
        String string5 = this.getDiskSetFlag();
        String string6 = "";
        Object object = device.getProperty("mountpoint");
        if (object != null && !object.equals("")) {
            string6 = " -f";
        }
        int n = this.getReadOption();
        int n2 = this.getWriteOption();
        int n3 = this.getPassNumber();
        switch (n) {
            default: {
                string2 = "";
                break;
            }
            case 1: {
                string2 = "-g ";
                break;
            }
            case 2: {
                string2 = "-r ";
            }
        }
        switch (n2) {
            default: {
                string = "";
                break;
            }
            case 1: {
                string = "-S ";
            }
        }
        String string7 = "";
        if (n3 != 1) {
            string7 = n3 + " ";
        }
        String string8 = Util.getDeviceBaseName(device);
        String string9 = string4 + "usr/sbin/metainit" + string6 + string5 + ' ' + string3 + ' ' + "-m " + string8 + ' ' + string2 + string + string7;
        String[] stringArray = this.getMetattachSubmirrorCommands();
        String[] stringArray2 = new String[stringArray.length + 1];
        stringArray2[0] = string9;
        System.arraycopy(stringArray, 0, stringArray2, 1, stringArray.length);
        return stringArray2;
    }

    public synchronized String[] getResyncRAIDCommands() {
        String string = this.getDeviceName();
        if (string == null) {
            return new String[0];
        }
        String string2 = this.getBaseDir();
        String string3 = this.getDiskSetFlag();
        boolean bl = this.getRegenerateParity();
        String string4 = bl ? "-p " : "";
        return new String[]{string2 + "usr/sbin/metasync" + string3 + ' ' + string4 + string};
    }

    public synchronized String[] getCreateRAIDCommands() {
        String string = this.getDeviceName();
        Device[] deviceArray = this.getComponents();
        if (string == null || deviceArray == null) {
            return new String[0];
        }
        String string2 = this.getBaseDir();
        String string3 = this.getDiskSetFlag();
        String string4 = this.getInterlaceFlag();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string2);
        stringBuffer.append("usr/sbin/metainit");
        stringBuffer.append(string3);
        stringBuffer.append(' ');
        stringBuffer.append(string);
        stringBuffer.append(" -r");
        for (int i = 0; i < deviceArray.length; ++i) {
            stringBuffer.append(' ');
            stringBuffer.append(Util.getDeviceBaseName(deviceArray[i]));
        }
        stringBuffer.append(string4);
        String[] stringArray = this.getAttachHSPCommands();
        return (String[])Util.getCombinedArray(new String[][]{{stringBuffer.toString()}, stringArray});
    }

    protected synchronized String getSoftPartitionSizeArgument() {
        long l = this.getSoftPartitionSizeInBlocks();
        Util.DeviceSize deviceSize = Util.getSizeInGreatestUnits(l, 1001, 1005);
        switch (deviceSize.units) {
            case 1005: {
                return " " + deviceSize.size + 't';
            }
            case 1004: {
                return " " + deviceSize.size + 'g';
            }
            case 1003: {
                return " " + deviceSize.size + 'm';
            }
            case 1002: {
                return " " + deviceSize.size + 'k';
            }
        }
        return " " + l + 'b';
    }

    public synchronized String[] getCreateSoftPartitionCommands() {
        String[] stringArray = this.getDeviceNames();
        Device[] deviceArray = this.getComponents();
        int n = this.getNumberOfSoftPartitions();
        long l = this.getSoftPartitionSizeInBlocks();
        if (stringArray == null || stringArray.length != n || deviceArray == null || deviceArray.length == 0 || n <= 0 || l <= 0L) {
            return new String[0];
        }
        Device device = deviceArray[0];
        String string = Util.getDeviceBaseName(device);
        Object object = device.getProperty("type");
        boolean bl = "Disk".equals(object);
        String string2 = this.getBaseDir();
        String string3 = this.getDiskSetFlag();
        String string4 = this.getSoftPartitionSizeArgument();
        String[] stringArray2 = new String[n];
        for (int i = 0; i < n; ++i) {
            if (i == 1 && bl) {
                string = string + "s0";
            }
            stringArray2[i] = string2 + "usr/sbin/metainit" + string3 + ' ' + stringArray[i] + " -p " + (i == 0 && bl ? "-e " : "") + string + string4;
        }
        return stringArray2;
    }

    public synchronized String getGrowSoftPartitionCommand() {
        String string = this.getDeviceName();
        long l = this.getSoftPartitionSizeInBlocks();
        if (string == null || l <= 0L) {
            return "";
        }
        String string2 = this.getBaseDir();
        String string3 = this.getDiskSetFlag();
        String string4 = this.getSoftPartitionSizeArgument();
        return string2 + "usr/sbin/metattach" + string3 + ' ' + string + string4;
    }

    private synchronized String[] getMetattachCommands(boolean bl) {
        String string = this.getDeviceName();
        Device[] deviceArray = this.getComponents();
        if (string == null || deviceArray == null) {
            return new String[0];
        }
        String string2 = this.getBaseDir();
        String string3 = this.getDiskSetFlag();
        String string4 = bl ? this.getInterlaceFlag() : "";
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string2);
        stringBuffer.append("usr/sbin/metattach");
        stringBuffer.append(string3);
        stringBuffer.append(string4);
        stringBuffer.append(' ');
        stringBuffer.append(string);
        for (int i = 0; i < deviceArray.length; ++i) {
            stringBuffer.append(' ');
            stringBuffer.append(Util.getDeviceBaseName(deviceArray[i]));
        }
        return new String[]{stringBuffer.toString()};
    }

    public String[] getMetattachStripeCommands() {
        return this.getMetattachCommands(true);
    }

    public String[] getMetattachRAIDCommands() {
        return this.getMetattachCommands(false);
    }

    public synchronized String[] getMetareplaceCommands() {
        String string = this.getDeviceName();
        Device[] deviceArray = this.getComponents();
        if (string == null || deviceArray == null || deviceArray.length != 2) {
            return new String[0];
        }
        String string2 = this.getBaseDir();
        String string3 = this.getDiskSetFlag();
        return new String[]{string2 + "usr/sbin/metareplace" + string3 + " -f " + string + ' ' + Util.getDeviceBaseName(deviceArray[0]) + ' ' + Util.getDeviceBaseName(deviceArray[1])};
    }

    public synchronized String[] getAttachComponentsToHSPCommands() {
        String string = this.getHSPName();
        Device[] deviceArray = this.getComponents();
        if (string == null || deviceArray == null) {
            return new String[0];
        }
        String string2 = this.getBaseDir();
        String string3 = this.getDiskSetFlag();
        String[] stringArray = new String[deviceArray.length];
        String string4 = string2 + "usr/sbin/metaparam" + string3 + ' ' + "-h " + string + ' ';
        for (int i = 0; i < deviceArray.length; ++i) {
            stringArray[i] = string4 + Util.getDeviceBaseName(deviceArray[i]);
        }
        return stringArray;
    }
}

