/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.volmgr.common;

import com.sun.admin.volmgr.common.Device;
import com.sun.admin.volmgr.common.DeviceFilter;
import com.sun.admin.volmgr.common.DeviceProperties;
import com.sun.admin.volmgr.server.SVMAPI;
import java.util.Enumeration;
import java.util.Vector;

public class ProblemDeviceFilter
extends DeviceFilter {
    public static final String MDDB_FLAGS_STRING = "RSFDMaWm  pc luo tB";
    public static final int HSS_UNUSED = 0;
    public static final int HSS_AVAILABLE = 1;
    public static final int HSS_RESERVED = 2;
    public static final int HSS_BROKEN = 3;
    public static final int RUS_INIT = 1;
    public static final int RUS_OKAY = 2;
    public static final int RUS_ERRED = 4;
    public static final int RUS_LAST_ERRED = 8;
    public static final int RUS_DOI = 16;
    public static final int RUS_REGEN = 32;
    public static final int RCS_INIT = 1;
    public static final int RCS_OKAY = 2;
    public static final int RCS_ERRED = 4;
    public static final int RCS_LAST_ERRED = 8;
    public static final int RCS_RESYNC = 16;
    public static final int RCS_INIT_ERRED = 32;
    public static final int RCS_REGEN = 64;
    public static final int MD_RI_INPROGRESS = 1;
    public static final int MD_GROW_INPROGRESS = 2;
    public static final int CS_OKAY = 1;
    public static final int CS_ERRED = 2;
    public static final int CS_RESYNC = 4;
    public static final int CS_LAST_ERRED = 8;
    public static final int LDL_ERROR = 1;
    public static final int LDL_HERROR = 2;
    public static final int TRANS_NEED_OPEN = 1;
    public static final int TRANS_OPENED = 2;
    public static final int TRANS_DETACHING = 4;
    public static final int TRANS_DETACHED = 8;
    public static final int TRANS_DETACH_SKIP = 16;
    public static final int TRANS_ATTACHING = 32;
    public static final int TRANS_ROLL_ON_WRITE = 64;
    public static final int TRANS_NEED_SCANROLL = 128;
    public static final int SMS_UNUSED = 0;
    public static final int SMS_RUNNING = 1;
    public static final int SMS_COMP_ERRED = 2;
    public static final int SMS_COMP_RESYNC = 4;
    public static final int SMS_ATTACHED = 8;
    public static final int SMS_ATTACHED_RESYNC = 16;
    public static final int SMS_OFFLINE = 32;
    public static final int SMS_OFFLINE_RESYNC = 64;
    public static final int SMS_ALL_ERRED = 128;
    public static final int SMS_INUSE = 65535;
    public static final int SMS_LIMPING = 6;
    public static final int SMS_IGNORE = 16384;
    public static final int SMS_ACTIVE = 87;
    public static final int MD_SM_RESYNC_TARGET = 1;
    public static final int MD_UN_RESYNC_ACTIVE = 65536;
    public static final int MD_UN_WAR = 131072;
    public static final int MD_UN_OFFLINE_SM = 262144;
    public static final int MD_UN_OPT_NOT_DONE = 524288;
    public static final int MD_UN_KEEP_DIRTY = 786432;
    public static final int MD_UN_RESYNC_CANCEL = 0x100000;
    public static final int MD_UN_REPLAYED = 0x200000;
    public static final int MD_UN_RENAMING = 0x400000;
    public static final int MD_UN_MOD_INPROGRESS = 0x490000;

    public ProblemDeviceFilter() {
    }

    public ProblemDeviceFilter(Device device, SVMAPI sVMAPI, boolean bl) {
        super(device, sVMAPI, bl);
    }

    public boolean matches() {
        if (!this.getSelected()) {
            return true;
        }
        Device device = this.getDevice();
        SVMAPI sVMAPI = this.getSvm();
        if (device == null || sVMAPI == null) {
            return false;
        }
        Integer n = (Integer)device.getProperty("state");
        int n2 = n;
        Object object = device.getProperty("type");
        if ("Metadb".equals(object)) {
            return this.isMetadbProblem(sVMAPI, device, n2);
        }
        if ("Trans".equals(object)) {
            return this.isTransProblem(sVMAPI, device, n2);
        }
        if ("Mirror".equals(object)) {
            String string = (String)device.getProperty("trans component type");
            if (string != null && string.equals("log")) {
                return this.isTransLogProblem(sVMAPI, device, n2);
            }
        } else if ("Concat".equals(object) || "Stripe".equals(object)) {
            String string = (String)device.getProperty("trans component type");
            if (this.isaSubmirror(sVMAPI, device)) {
                return this.isSubmirrorProblem(sVMAPI, device, n2);
            }
            if (string != null && string.equals("log")) {
                return this.isTransLogProblem(sVMAPI, device, n2);
            }
        } else if ("Raid".equals(object)) {
            String string = (String)device.getProperty("trans component type");
            if (string != null && string.equals("log")) {
                return this.isTransLogProblem(sVMAPI, device, n2);
            }
        } else {
            if ("Hsp".equals(object)) {
                return this.isSpareProblem(sVMAPI, device, n2);
            }
            if ("Slice".equals(object)) {
                String string = (String)device.getProperty("trans component type");
                if (this.isaRaidComponent(sVMAPI, device)) {
                    return this.isRaidCompProblem(sVMAPI, device, n2);
                }
                if (this.isaStripeComponent(sVMAPI, device)) {
                    return this.isStripeCompProblem(sVMAPI, device, n2);
                }
                if (string != null && string.equals("log")) {
                    return this.isTransLogProblem(sVMAPI, device, n2);
                }
            }
        }
        return false;
    }

    public boolean isStripeCompProblem(SVMAPI sVMAPI, Device device, int n) {
        switch (n) {
            case 1: {
                return false;
            }
            case 2: {
                return true;
            }
            case 8: {
                return true;
            }
            case 4: {
                return true;
            }
        }
        return true;
    }

    public boolean isRaidCompProblem(SVMAPI sVMAPI, Device device, int n) {
        switch (n) {
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
            case 4: 
            case 32: {
                return true;
            }
            case 8: {
                return true;
            }
            case 16: {
                return true;
            }
        }
        return true;
    }

    public boolean isSpareProblem(SVMAPI sVMAPI, Device device, int n) {
        Vector vector = null;
        try {
            vector = sVMAPI.getAntecedents(device, "ExtentRedundancyComponent");
        }
        catch (Exception exception) {
            return false;
        }
        if (vector != null && vector.size() > 0) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Device device2 = (Device)enumeration.nextElement();
                Integer n2 = (Integer)device2.getProperty("state");
                int n3 = n2;
                switch (n3) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public boolean isRaidProblem(SVMAPI sVMAPI, Device device, int n) {
        switch (n) {
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
            case 4: 
            case 8: {
                return true;
            }
            case 16: {
                return true;
            }
            case 32: {
                return true;
            }
        }
        return true;
    }

    public boolean isMetadbProblem(SVMAPI sVMAPI, Device device, int n) {
        String string = new String("");
        for (int i = 0; i < MDDB_FLAGS_STRING.length(); ++i) {
            if ((n & 1 << i) == 0) continue;
            string = string + MDDB_FLAGS_STRING.charAt(i);
        }
        if (string.indexOf("W") != -1) {
            return true;
        }
        if (string.indexOf("M") != -1) {
            return true;
        }
        if (string.indexOf("D") != -1) {
            return true;
        }
        if (string.indexOf("F") != -1) {
            return true;
        }
        if (string.indexOf("S") != -1) {
            return true;
        }
        return string.indexOf("R") != -1;
    }

    public boolean isTransProblem(SVMAPI sVMAPI, Device device, int n) {
        int n2 = 0;
        Integer n3 = (Integer)device.getProperty("flags");
        if (n3 != null) {
            n2 = n3;
        }
        if ((n2 & 8) > 0) {
            return true;
        }
        if ((n2 & 4) > 0) {
            return true;
        }
        if ((n2 & 0x20) > 0) {
            return true;
        }
        return this.isTransLogProblem(sVMAPI, device, n);
    }

    public boolean isTransLogProblem(SVMAPI sVMAPI, Device device, int n) {
        int n2 = 0;
        Integer n3 = (Integer)device.getProperty("flags");
        if (n3 != null) {
            n2 = n3;
        }
        if ((n2 & 1) > 0) {
            return true;
        }
        return (n2 & 2) > 0;
    }

    public boolean isSubmirrorProblem(SVMAPI sVMAPI, Device device, int n) {
        Object object;
        Vector vector;
        int n2 = 0;
        Integer n3 = (Integer)device.getProperty("flags");
        if (n3 != null) {
            n2 = n3;
        }
        DeviceProperties deviceProperties = null;
        try {
            vector = sVMAPI.getDependents(device, "BasedOn");
        }
        catch (Exception exception) {
            return true;
        }
        if (vector != null) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Device device2 = (Device)enumeration.nextElement();
                object = (String)device2.getProperty("type");
                if (!((String)object).equals("Mirror")) continue;
                deviceProperties = device2;
                break;
            }
        }
        if (deviceProperties == null) {
            return false;
        }
        boolean bl = (n2 & 1) > 0;
        int n4 = 0;
        object = (Integer)deviceProperties.getProperty("state");
        if (object != null) {
            n4 = (Integer)object;
        }
        if ((n & 1) > 0 && ((n4 & 0x80000) <= 0 || (n4 & 0x80000) > 0 && !bl)) {
            return false;
        }
        if ((n & 0x54) > 0 || (n4 & 0x80000) > 0) {
            if ((n4 & 0x10000) > 0) {
                return true;
            }
            return true;
        }
        return (n & 0x2A) > 0;
    }

    public boolean isaSubmirror(SVMAPI sVMAPI, Device device) {
        Vector vector;
        if (sVMAPI == null || device == null) {
            return false;
        }
        try {
            vector = sVMAPI.getDependents(device, "BasedOn");
        }
        catch (Exception exception) {
            return false;
        }
        if (vector != null && vector.size() > 0) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Device device2 = (Device)enumeration.nextElement();
                String string = (String)device2.getProperty("type");
                if (!string.equals("Mirror")) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isaRaidComponent(SVMAPI sVMAPI, Device device) {
        Vector vector;
        if (sVMAPI == null || device == null) {
            return false;
        }
        try {
            vector = sVMAPI.getDependents(device, "BasedOn");
        }
        catch (Exception exception) {
            return false;
        }
        if (vector != null && vector.size() > 0) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Device device2 = (Device)enumeration.nextElement();
                String string = (String)device2.getProperty("type");
                if (!string.equals("Raid")) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isaStripeComponent(SVMAPI sVMAPI, Device device) {
        Vector vector;
        if (sVMAPI == null || device == null) {
            return false;
        }
        try {
            vector = sVMAPI.getDependents(device, "BasedOn");
        }
        catch (Exception exception) {
            return false;
        }
        if (vector != null && vector.size() > 0) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Device device2 = (Device)enumeration.nextElement();
                String string = (String)device2.getProperty("type");
                if (!string.equals("Stripe")) continue;
                return true;
            }
        }
        return false;
    }
}

