/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deg.sunvts.ms;

import com.sun.deg.sunvts.agent.RemoteVTSKImpl;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import java.util.StringTokenizer;

class CommandTranslator {
    private static CommandTranslator commandTranslator = null;
    private static final String[] vtskErrors = new String[]{"communication between vtskjb & vtsk failed. vtsk is not responding.", "error", "format error", "usage"};

    private CommandTranslator() {
    }

    public static CommandTranslator getCommandTanslator() {
        if (commandTranslator == null) {
            commandTranslator = new CommandTranslator();
        }
        return commandTranslator;
    }

    String executeCommand(String encodedCommand) throws Exception {
        StringTokenizer tokenizer = new StringTokenizer(encodedCommand, " ");
        if (!tokenizer.hasMoreTokens()) {
            throw new Exception("Invalid command");
        }
        String command = tokenizer.nextToken();
        String param1 = null;
        String param2 = null;
        String param3 = null;
        if (tokenizer.hasMoreTokens()) {
            param1 = tokenizer.nextToken();
        }
        if (tokenizer.hasMoreTokens()) {
            param2 = tokenizer.nextToken();
        }
        if (tokenizer.hasMoreTokens()) {
            param3 = tokenizer.nextToken();
        }
        if (command.equals("get_log")) {
            return this.getLog(command, param1, param2);
        }
        if (command.equals("set_global_options") || command.equals("load_session") || command.equals("save_session") || command.equals("set_modesequencer_options")) {
            int optionIndex = encodedCommand.indexOf("[");
            String optionString = encodedCommand.substring(optionIndex);
            command = command + " " + optionString;
            return this.executeVTSKCommand(command);
        }
        if (command.equals("set_test_options")) {
            command = command + " " + param1;
            int optionIndex = encodedCommand.indexOf("[");
            String optionString = encodedCommand.substring(optionIndex);
            command = command + " " + optionString;
            return this.executeVTSKCommand(command);
        }
        if (command.equals("set_device_options")) {
            command = command + " " + param1;
            int optionIndex = encodedCommand.indexOf("[");
            String optionString = encodedCommand.substring(optionIndex);
            command = command + " " + optionString;
            return this.executeVTSKCommand(command);
        }
        if (param1 == null && param2 == null && param3 == null) {
            return this.executeVTSKCommand(command);
        }
        if (param1 != null && param2 == null && param3 == null) {
            command = command + " " + param1;
            return this.executeVTSKCommand(command);
        }
        if (param1 != null && param2 != null && param3 == null) {
            command = command + " " + param1 + " " + param2;
            return this.executeVTSKCommand(command);
        }
        throw new Exception("Invalid command '" + encodedCommand + "'");
    }

    private String executeVTSKCommand(String command) throws Exception {
        String cmdResult = "";
        try {
            RemoteVTSKImpl remoteVTSKImpl = RemoteVTSKImpl.getRemoteVTSKImpl();
            cmdResult = remoteVTSKImpl.executeVTSKCommand(command);
        }
        catch (Exception ex) {
            throw this.getUserFriendlyException(ex);
        }
        for (int count = 0; count < vtskErrors.length; ++count) {
            if (!cmdResult.toLowerCase().startsWith(vtskErrors[count])) continue;
            throw new Exception(cmdResult);
        }
        return cmdResult;
    }

    private Exception getUserFriendlyException(Exception ex) {
        StringBuffer errorMsg = new StringBuffer(80);
        errorMsg.append("Failed to connect to VTSK on ");
        if (ex instanceof MalformedURLException) {
            errorMsg.append(". This is not a valid host name.");
        } else if (ex instanceof NotBoundException || ex instanceof ConnectException || ex instanceof java.rmi.ConnectException) {
            errorMsg.append(". VTSK Java Bridge is not running on this port.");
        } else if (ex instanceof UnmarshalException) {
            errorMsg = new StringBuffer("Communication broken with VTSK on ");
            errorMsg.append(".");
        } else if (ex instanceof RemoteException) {
            Throwable cause = ex.getCause();
            errorMsg.append(". " + cause.getMessage());
        } else {
            return ex;
        }
        ex.printStackTrace();
        return new Exception(errorMsg.toString());
    }

    private String getLog(String command, String logName, String noOfLines) throws Exception {
        if (logName != null) {
            command = command + " " + logName;
        }
        if (noOfLines != null) {
            command = command + " " + noOfLines;
        }
        return this.executeVTSKCommand(command);
    }
}

