/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.services.authentication;

import com.sun.management.services.authentication.LoginCallback;
import com.sun.management.services.authentication.LoginData;
import com.sun.management.services.common.Debug;
import java.io.IOException;
import java.util.Locale;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.servlet.http.HttpSession;

public class CliCallbackHandler
implements CallbackHandler {
    private Locale locale = null;
    private HttpSession session = null;

    public CliCallbackHandler(HttpSession httpSession, Locale locale) {
        this.locale = locale;
        this.session = httpSession;
    }

    public void handle(Callback[] callbackArray) throws IOException, UnsupportedCallbackException {
        if (callbackArray != null) {
            for (int i = 0; i < callbackArray.length; ++i) {
                try {
                    LoginCallback loginCallback = (LoginCallback)callbackArray[i];
                    if (loginCallback != null) {
                        loginCallback.setLocale(this.locale);
                        LoginData loginData = this.getCachedData(this.session, loginCallback.getDataName());
                        if (!loginCallback.setData(loginData)) {
                            throw new IOException("user_data_not_available");
                        }
                    }
                }
                catch (Exception exception) {
                    Debug.trace1((String)"Error handling callback class: ", (Throwable)exception);
                    throw new UnsupportedCallbackException(callbackArray[i], "Unrecognized Callback");
                }
                Debug.trace3((String)("Done Handling Callback class: " + callbackArray[i].getClass().getName()));
            }
        }
    }

    private LoginData getCachedData(HttpSession httpSession, String string) {
        LoginData loginData = (LoginData)httpSession.getAttribute(string);
        return loginData;
    }
}

