/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.services.authentication;

import com.sun.management.services.authentication.LoginCallback;
import com.sun.management.services.authentication.LoginData;
import com.sun.management.services.common.Debug;
import java.io.IOException;
import java.util.Locale;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpSession;

public class ConsoleCallbackHandler
implements CallbackHandler {
    private HttpSession session = null;
    private Locale locale = null;
    private String thisVB = null;
    private String curVB = null;
    private static final long WAIT_TIMEOUT = 3600000L;
    private static final String JSF_PRESENTATION_MODULE = "/jsp/login/UserLogin.jsp";
    private static final String JATO_PRESENTATION_MODULE = "com.sun.web.console.login.LoginViewBean";
    private static final String LEGACY_DATA_CLASSNAME = "com.sun.management.services.authentication.UserDataObject";

    public ConsoleCallbackHandler(HttpSession httpSession, Locale locale) {
        this.session = httpSession;
        this.locale = locale;
    }

    public void handle(Callback[] callbackArray) throws IOException, UnsupportedCallbackException {
        if (callbackArray != null) {
            for (int i = 0; i < callbackArray.length; ++i) {
                block17: {
                    try {
                        Class<?> clazz;
                        LoginCallback loginCallback = (LoginCallback)callbackArray[i];
                        if (loginCallback == null) break block17;
                        loginCallback.setLocale(this.locale);
                        this.thisVB = loginCallback.getPresentationClassName();
                        if (this.thisVB.equals(JATO_PRESENTATION_MODULE)) {
                            this.thisVB = JSF_PRESENTATION_MODULE;
                        }
                        this.session.setAttribute("thisVB", (Object)this.thisVB);
                        String string = loginCallback.getDataName();
                        LoginData loginData = (LoginData)this.session.getAttribute("dataobject");
                        if (string == null || string.length() == 0) {
                            string = LEGACY_DATA_CLASSNAME;
                        }
                        boolean bl = false;
                        try {
                            clazz = Class.forName(string);
                            if (loginData == null) {
                                loginData = (LoginData)clazz.newInstance();
                            } else {
                                String string2 = loginData.getClass().getName();
                                if (!string.equals(string2)) {
                                    loginData = (LoginData)clazz.newInstance();
                                }
                            }
                            this.session.setAttribute("dataobject", (Object)loginData);
                            bl = loginCallback.setData(loginData);
                        }
                        catch (Exception exception) {
                            throw new LoginException("Error creating login data class: " + exception.getMessage());
                        }
                        if (bl) break block17;
                        if (this.curVB == null || !this.curVB.equals(this.thisVB)) {
                            this.waitUserData("forward_to:" + this.thisVB);
                            this.curVB = this.thisVB;
                        } else if (this.curVB.equals(this.thisVB)) {
                            this.waitUserData("auth_error");
                        }
                        loginData = (LoginData)this.session.getAttribute("dataobject");
                        if (loginData == null) {
                            try {
                                clazz = Class.forName(string);
                                loginData = (LoginData)clazz.newInstance();
                            }
                            catch (Exception exception) {
                                throw new LoginException("Error creating login data class: " + exception.getMessage());
                            }
                        }
                        loginCallback.setData(loginData);
                        this.session.setAttribute("dataobject", (Object)loginData);
                    }
                    catch (Exception exception) {
                        Debug.trace3((String)"Error handling callback class: ", (Throwable)exception);
                        throw new UnsupportedCallbackException(callbackArray[i], "Unrecognized Callback");
                    }
                }
                Debug.trace1((String)("Done Handling Callback class: " + callbackArray[i].getClass().getName()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitUserData(String string) {
        Thread thread;
        Thread thread2 = thread = Thread.currentThread();
        synchronized (thread2) {
            this.session.setAttribute("serverconv", (Object)string);
            Debug.trace1((String)("SENDING SERVER RESPONSE : " + string));
            thread.notifyAll();
        }
        Debug.trace1((String)"WAITTING FOR RESPONSE");
        thread2 = thread;
        synchronized (thread2) {
            String string2 = null;
            try {
                string2 = (String)this.session.getAttribute("clientconv");
                long l = System.currentTimeMillis();
                while (string2 == null) {
                    thread.wait(3600000L);
                    string2 = (String)this.session.getAttribute("clientconv");
                    if (3600000L >= System.currentTimeMillis() - l) continue;
                }
                this.session.removeAttribute("clientconv");
            }
            catch (Exception exception) {
                Debug.trace1((String)"waitUserData : ", (Throwable)exception);
                exception.printStackTrace();
            }
            Debug.trace1((String)("----------DONE WAITING FOR USER , RESPONSE IS : " + string2));
        }
    }

    private LoginData getCachedData(HttpSession httpSession, String string) {
        try {
            LoginData loginData = (LoginData)httpSession.getAttribute(string);
            return loginData;
        }
        catch (ClassCastException classCastException) {
            Debug.trace1((String)"cached data obj not of proper type", (Throwable)classCastException);
            return null;
        }
    }
}

