/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.services.authentication.sso;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOProvider;
import com.iplanet.sso.SSOToken;
import com.sun.management.services.authentication.sso.ConsoleSSOToken;
import com.sun.management.services.authentication.sso.ConsoleSSOTokenID;
import com.sun.management.services.common.Debug;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Random;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public final class ConsoleSSOProvider
implements SSOProvider {
    private static SecureRandom random;
    private HashMap tokenMap = new HashMap();
    private static final int RANDOM_KEYSIZE = 20;
    private static final char[] hex;

    public SSOToken createSSOToken(HttpServletRequest httpServletRequest) throws UnsupportedOperationException, SSOException {
        HttpSession httpSession = httpServletRequest.getSession();
        String string = (String)httpSession.getAttribute("tokenID");
        if (!this.isTokenIdStringValid(string)) {
            Subject subject = (Subject)httpSession.getAttribute("subject");
            if (subject != null) {
                ConsoleSSOTokenID consoleSSOTokenID = this.getNewToken();
                ConsoleSSOToken consoleSSOToken = new ConsoleSSOToken(subject, consoleSSOTokenID);
                this.putToken(consoleSSOToken);
                httpSession.setAttribute("tokenID", (Object)consoleSSOToken.getTokenID().toString());
                return consoleSSOToken;
            }
            throw new SSOException("subject_not_found");
        }
        return this.createSSOToken(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putToken(ConsoleSSOToken consoleSSOToken) {
        HashMap hashMap = this.tokenMap;
        synchronized (hashMap) {
            this.tokenMap.put(consoleSSOToken.getTokenID().toString(), consoleSSOToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeToken(String string) {
        HashMap hashMap = this.tokenMap;
        synchronized (hashMap) {
            this.tokenMap.remove(string);
        }
    }

    private boolean isTokenIdStringValid(String string) {
        if (string == null) {
            return false;
        }
        return this.tokenMap.get(string) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConsoleSSOToken getToken(String string) throws SSOException {
        HashMap hashMap = this.tokenMap;
        synchronized (hashMap) {
            ConsoleSSOToken consoleSSOToken = (ConsoleSSOToken)this.tokenMap.get(string);
            if (consoleSSOToken != null) {
                return consoleSSOToken;
            }
        }
        Debug.trace1((String)("bad_token_ID : " + string));
        throw new SSOException("bad_token_ID: " + string);
    }

    public SSOToken createSSOToken(String string) throws SSOException, UnsupportedOperationException {
        return this.getToken(string);
    }

    public void destroyToken(SSOToken sSOToken) throws SSOException {
        ConsoleSSOTokenID consoleSSOTokenID = (ConsoleSSOTokenID)sSOToken.getTokenID();
        try {
            ConsoleSSOToken consoleSSOToken = (ConsoleSSOToken)sSOToken;
            consoleSSOToken.dispose();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.removeToken(sSOToken.getTokenID().toString());
        Debug.trace1((String)("SSOToken destroyed, token ID : " + consoleSSOTokenID.toString()));
    }

    public boolean isValidToken(SSOToken sSOToken) {
        try {
            return sSOToken.getIdleTime() <= sSOToken.getMaxIdleTime();
        }
        catch (SSOException sSOException) {
            return false;
        }
    }

    public void validateToken(SSOToken sSOToken) throws SSOException {
        if (sSOToken.getIdleTime() > sSOToken.getMaxIdleTime()) {
            throw new SSOException("session_timed_out");
        }
    }

    private ConsoleSSOTokenID getNewToken() throws SSOException {
        if (random == null) {
            throw new SSOException("random_number_generation_problem");
        }
        byte[] byArray = new byte[10];
        random.nextBytes(byArray);
        String string = ConsoleSSOProvider.toHex(byArray);
        String string2 = "localhost";
        try {
            string2 = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        string = string + string2;
        string = string.trim();
        ConsoleSSOTokenID consoleSSOTokenID = new ConsoleSSOTokenID(string);
        Debug.trace3((String)("created new token ID : " + consoleSSOTokenID.toString()));
        return consoleSSOTokenID;
    }

    private static synchronized byte[] getSeed() {
        byte[] byArray = new byte[20];
        byte[] byArray2 = new byte[20];
        byte[] byArray3 = new byte[20];
        long l = System.currentTimeMillis();
        Random random = new Random(l);
        random.nextBytes(byArray);
        random.nextBytes(byArray2);
        l = System.currentTimeMillis();
        long l2 = 1L;
        long l3 = 0L;
        for (int i = 0; i < 20; ++i) {
            l3 = l & l2;
            byArray3[i] = l3 > 0L ? byArray[i] : byArray2[i];
            l2 <<= 1;
        }
        return byArray3;
    }

    private static synchronized String toHex(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append(hex[byArray[i] >> 4 & 0xF]);
            stringBuffer.append(hex[byArray[i] & 0xF]);
        }
        return stringBuffer.toString();
    }

    static {
        try {
            byte[] byArray = ConsoleSSOProvider.getSeed();
            random = new SecureRandom(byArray);
        }
        catch (Exception exception) {
            random = null;
        }
        hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    }
}

