/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.services.session;

import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.management.services.audit.ConsoleAuditEvent_Authorization;
import com.sun.management.services.audit.ConsoleAuditService;
import com.sun.management.services.audit.ConsoleAuditSession;
import com.sun.management.services.common.ConsoleConfiguration;
import com.sun.management.services.common.Debug;
import com.sun.management.services.logging.ConsoleLogService;
import com.sun.management.services.registration.AppFilter;
import com.sun.management.services.registration.MgmtAppRegistrationService;
import com.sun.management.services.registration.MgmtAppRegistrationServiceFactory;
import com.sun.management.services.registration.RegistrationInfo;
import com.sun.management.services.session.SessionTimeoutManager;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public abstract class CoreSessionManagerFilter
implements Filter {
    public static final String POPUP_PARAMETER_NAME = "com_sun_web_ui_popup";
    public static final String IGNORE_PATH_HTTPS = "ignore-paths-https";
    public static final String IGNORE_PATH_HTTP = "ignore-paths-http";
    public static final String WILD_CARD = "*";
    public static final String HTTP_PROTOCOL = "http";
    private FilterConfig filterConfig = null;
    protected int securePort;
    protected int unsecurePort;
    private HashSet ignoreSetHttps = null;
    private HashSet ignoreSetHttp = null;
    private String contextName = null;
    private static Logger debugLogger = null;
    protected static final MgmtAppRegistrationService mRegService = MgmtAppRegistrationServiceFactory.getRegistrationService();
    protected SessionTimeoutManager timeoutManager = SessionTimeoutManager.getInstance();

    public void init(FilterConfig filterConfig) throws ServletException {
        StringTokenizer stringTokenizer;
        String string;
        this.setFilterConfig(filterConfig);
        Debug.traceOpen();
        if (debugLogger == null) {
            debugLogger = ConsoleLogService.getDebugLogger();
        }
        try {
            string = System.getProperty("com.sun.web.console.secureport");
            this.securePort = new Integer(string);
        }
        catch (Exception exception) {
            Debug.trace1((String)"Secure port invalid, using default value.");
            this.securePort = 6789;
        }
        try {
            string = System.getProperty("com.sun.web.console.unsecureport");
            this.unsecurePort = new Integer(string);
        }
        catch (Exception exception) {
            Debug.trace1((String)"Non-secure port invalid, using default value.");
            this.unsecurePort = 6788;
        }
        string = filterConfig.getInitParameter(IGNORE_PATH_HTTPS);
        this.ignoreSetHttps = new HashSet();
        if (string != null && string.length() != 0) {
            stringTokenizer = new StringTokenizer(string, "\n");
            while (stringTokenizer.hasMoreTokens()) {
                this.ignoreSetHttps.add(stringTokenizer.nextToken().trim());
            }
        }
        string = filterConfig.getInitParameter(IGNORE_PATH_HTTP);
        this.ignoreSetHttp = new HashSet();
        if (string != null && string.length() != 0) {
            stringTokenizer = new StringTokenizer(string, "\n");
            while (stringTokenizer.hasMoreTokens()) {
                this.ignoreSetHttp.add(stringTokenizer.nextToken().trim());
            }
        }
        stringTokenizer = filterConfig.getServletContext();
        stringTokenizer.setAttribute("com.sun.web.console.resource_path", "/console");
        this.setUploadMaxSize((ServletContext)stringTokenizer, "com.sun.web.ui.v3.uploadfilter.maxfilesize", -1L);
        this.setUploadMaxSize((ServletContext)stringTokenizer, "com.sun.webui.v4.uploadfilter.maxfilesize", 0L);
    }

    public void destroy() {
        this.setFilterConfig(null);
        if (this.ignoreSetHttps != null) {
            this.ignoreSetHttps.clear();
            this.ignoreSetHttps = null;
        }
        if (this.ignoreSetHttp != null) {
            this.ignoreSetHttp.clear();
            this.ignoreSetHttp = null;
        }
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        this.setRequestEncoding(httpServletRequest, httpServletResponse);
        boolean bl = false;
        if (httpServletRequest.getScheme().equalsIgnoreCase(HTTP_PROTOCOL)) {
            bl = true;
        }
        try {
            String string = httpServletRequest.getRequestURI();
            Debug.trace2((String)("Request: " + httpServletRequest.getScheme() + "-" + httpServletRequest.getServerName() + "-" + httpServletRequest.getServerPort() + ": " + string));
            if (this.ignorePath(string, httpServletRequest, bl)) {
                filterChain.doFilter(servletRequest, servletResponse);
                return;
            }
            boolean bl2 = this.isLoggedIn(httpServletRequest);
            if (string.endsWith("/")) {
                String string2 = string.substring(0, string.length() - 1);
                if (string.equals("/")) {
                    string2 = "/console";
                }
                if (string2.indexOf("/", 1) == -1) {
                    if (string2.equals("/console")) {
                        string2 = bl2 ? "/console/faces/jsp/launch/Launch.jsp" : "/console/jsp/login/BeginLogin.jsp";
                    } else {
                        String string3 = this.getAppURL(string);
                        if (string3 != null) {
                            string2 = string3;
                        } else {
                            Debug.trace1((String)("Cannot remap URL: " + string2));
                        }
                    }
                }
                httpServletResponse.sendRedirect(httpServletResponse.encodeRedirectURL(string2));
                return;
            }
            if (this.isConsoleLoginApp(string) && bl2) {
                String[] stringArray = new String[]{"ConsoleLogin=true"};
                this.redirectSecure("/console/faces/jsp/launch/Launch.jsp", stringArray, httpServletRequest, httpServletResponse);
                return;
            }
            if (this.securePort != httpServletRequest.getServerPort()) {
                if (this.isConsoleApp(string)) {
                    this.redirectSecure("/console/jsp/login/BeginLogin.jsp", null, httpServletRequest, httpServletResponse);
                } else {
                    Debug.trace3((String)"Request on unsecure port not honored");
                    httpServletResponse.sendError(404, "Request on unsecure port");
                }
                return;
            }
            boolean bl3 = this.isAppRegistered(httpServletRequest);
            if (!bl2) {
                Enumeration enumeration = httpServletRequest.getParameterNames();
                while (enumeration.hasMoreElements()) {
                    String string4;
                    String string5 = (String)enumeration.nextElement();
                    if (!string5.endsWith(POPUP_PARAMETER_NAME) || !(string4 = httpServletRequest.getParameter(string5)).equals("true")) continue;
                    this.redirectAlert(httpServletRequest, httpServletResponse, string);
                    return;
                }
                this.redirectLogin(httpServletRequest, httpServletResponse, string);
                return;
            }
            if (!bl3) {
                this.appNotRegisteredDo(httpServletRequest, httpServletResponse, bl2);
                return;
            }
            this.handleRequest(httpServletRequest, httpServletResponse, filterChain);
        }
        catch (ServletException servletException) {
            Debug.trace1((String)("Unexpected servlet exception in session filter: " + servletException.getMessage()));
            Throwable throwable = servletException.getRootCause();
            if (throwable != null) {
                String string = throwable.getClass().getName();
                Debug.trace1((String)("---Root cause (" + string + "): " + throwable.getMessage()), (Throwable)throwable);
            }
        }
        catch (Exception exception) {
            Debug.trace1((String)"Unexpected exception in session filter", (Throwable)exception);
            throw new ServletException("Unexpected exception in session filter:" + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    protected void setFilterConfig(FilterConfig filterConfig) {
        this.filterConfig = filterConfig;
    }

    protected FilterConfig getFilterConfig() {
        return this.filterConfig;
    }

    protected boolean ignorePath(String string, HttpServletRequest httpServletRequest, boolean bl) {
        String string2 = httpServletRequest.getContextPath();
        if (!this.isAppRegistered(httpServletRequest)) {
            return false;
        }
        String string3 = null;
        if (string2 == null || string2.length() == 0) {
            return false;
        }
        if (string.startsWith(string2)) {
            string3 = string.substring(string2.length());
        }
        if (string3 == null && string.startsWith("//")) {
            string3 = string.substring(1, string2.length() + 1);
        }
        if (string3.indexOf("/images/") != -1) {
            return true;
        }
        if (string3.indexOf("/help/") != -1) {
            return true;
        }
        if (string3.indexOf("/html/") != -1 && (string3.endsWith(".html") || string3.endsWith(".shtml"))) {
            return true;
        }
        if (string3.indexOf("/js/") != -1 && string3.endsWith(".js")) {
            return true;
        }
        if (string3.indexOf("/cchelp/") != -1) {
            return true;
        }
        if (string3.indexOf("/cchelp2/") != -1) {
            return true;
        }
        if (string3.indexOf("/ccversion/") != -1) {
            return true;
        }
        if (string3.indexOf("/theme/") != -1) {
            return true;
        }
        Iterator iterator = null;
        iterator = bl ? this.ignoreSetHttp.iterator() : this.ignoreSetHttps.iterator();
        boolean bl2 = false;
        while (iterator.hasNext()) {
            String string4 = (String)iterator.next();
            if (string4.equals(WILD_CARD)) {
                return true;
            }
            if (string3.equals("/")) {
                return false;
            }
            bl2 = string4.endsWith(WILD_CARD) ? string4.regionMatches(true, 0, string3, 0, string4.length() - 1) : string4.equalsIgnoreCase(string3);
            if (!bl2) continue;
            return true;
        }
        return false;
    }

    protected void handleRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws IOException, ServletException {
        this.storeSSOTokenIDString(httpServletRequest, httpServletResponse);
        this.timeoutManager.updateTimeout(httpServletRequest.getSession());
        String string = httpServletRequest.getRequestURI();
        String string2 = null;
        if (this.isConsoleApp(string)) {
            this.redirectSecure("/console/faces/jsp/launch/Launch.jsp", null, httpServletRequest, httpServletResponse);
            return;
        }
        string2 = this.resolveAppURL(string);
        if (!this.isUserAuth(string2, httpServletRequest, httpServletResponse)) {
            this.redirectAuthFailure(httpServletRequest, httpServletResponse);
            return;
        }
        if (!string2.equals(string)) {
            try {
                httpServletResponse.sendRedirect(httpServletResponse.encodeRedirectURL(string2));
            }
            catch (Exception exception) {
                Debug.trace1((String)("CoreSessionManagerFilter.sendRedirect exception: " + exception.getLocalizedMessage()));
            }
        } else {
            filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        }
    }

    protected String resolveAppURL(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        if (stringTokenizer.countTokens() != 1) {
            return string;
        }
        String string2 = stringTokenizer.nextToken();
        string2 = "/" + string2 + "/";
        return this.getAppURL(string2);
    }

    protected String getAppURL(String string) {
        MgmtAppRegistrationService mgmtAppRegistrationService = MgmtAppRegistrationServiceFactory.getRegistrationService();
        return mgmtAppRegistrationService.getAppURL(string);
    }

    private void redirectAlert(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) {
        this.redirectSecure("/console/faces/jsp/login/Timeout.jsp", null, httpServletRequest, httpServletResponse);
    }

    private void redirectLogin(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) {
        ArrayList<String> arrayList = new ArrayList<String>(5);
        if (this.isTimeout(httpServletRequest)) {
            this.removeCookie(httpServletResponse);
            arrayList.add("ConsoleTimeout=true");
        } else {
            String string2;
            if (!this.isConsoleApp(string)) {
                string2 = this.resolveAppURL(string);
                if (string2 == null) {
                    this.appNotRegisteredDo(httpServletRequest, httpServletResponse, false);
                    return;
                }
                arrayList.add("redirect_url=\"" + string2 + "\"");
            }
            if ((string2 = httpServletRequest.getQueryString()) != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string2, "&");
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken();
                    if (string3.startsWith("jato.page")) continue;
                    arrayList.add(string3);
                }
            }
        }
        this.redirectSecure("/console/jsp/login/BeginLogin.jsp", arrayList.toArray(new String[0]), httpServletRequest, httpServletResponse);
    }

    private void redirectAuthFailure(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String[] stringArray = new String[]{"user_not_auth=true"};
        this.redirectSecure("/console/faces/jsp/launch/Launch.jsp", stringArray, httpServletRequest, httpServletResponse);
    }

    private void appNotRegisteredDo(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, boolean bl) {
        String[] stringArray = new String[]{"app_not_avail=true"};
        String string = bl ? "/console/faces/jsp/launch/Launch.jsp" : "/console/jsp/login/BeginLogin.jsp";
        this.redirectSecure(string, stringArray, httpServletRequest, httpServletResponse);
    }

    private void redirectSecure(String string, String[] stringArray, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        StringBuffer stringBuffer = new StringBuffer(string.length() + 256);
        if (this.securePort != httpServletRequest.getServerPort()) {
            stringBuffer.append("https://" + httpServletRequest.getServerName() + ":" + this.securePort);
        }
        stringBuffer.append(string);
        if (stringArray != null && stringArray.length > 0) {
            stringBuffer.append("?");
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append(stringArray[i]);
                if (i == stringArray.length - 1) continue;
                stringBuffer.append("&");
            }
        }
        try {
            httpServletResponse.sendRedirect(httpServletResponse.encodeRedirectURL(stringBuffer.toString()));
        }
        catch (Exception exception) {
            Debug.trace1((String)"Secure redirection exception", (Throwable)exception);
        }
    }

    private boolean isLoggedIn(HttpServletRequest httpServletRequest) {
        return this.getSSOTokenIDString(httpServletRequest) != null && !this.isTimeout(httpServletRequest);
    }

    private String getSSOTokenIDString(HttpServletRequest httpServletRequest) {
        Cookie cookie = this.getCookie(httpServletRequest);
        if (cookie != null) {
            return cookie.getValue();
        }
        return null;
    }

    private Cookie getCookie(HttpServletRequest httpServletRequest) {
        Cookie[] cookieArray = httpServletRequest.getCookies();
        if (cookieArray == null) {
            return null;
        }
        for (int i = 0; i < cookieArray.length; ++i) {
            Cookie cookie = cookieArray[i];
            if (!cookie.getName().equals("tokenID")) continue;
            return cookie;
        }
        return null;
    }

    private boolean isTimeout(HttpServletRequest httpServletRequest) {
        String string = this.getSSOTokenIDString(httpServletRequest);
        if (string != null) {
            return this.timeoutManager.isTimeout(string);
        }
        return false;
    }

    private void storeSSOTokenIDString(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String string = this.getSSOTokenIDString(httpServletRequest);
        if (string == null) {
            throw new IllegalArgumentException("The cookie has no Token_ID");
        }
        HttpSession httpSession = httpServletRequest.getSession();
        String string2 = (String)httpSession.getAttribute("tokenID");
        Cookie cookie = new Cookie("tokenID", string);
        cookie.setPath("/");
        httpServletResponse.addCookie(cookie);
        if (string.equals(string2)) {
            return;
        }
        httpSession.setAttribute("tokenID", (Object)string);
    }

    private boolean isAppRegistered(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getRequestURI();
        if (this.isConsoleApp(string)) {
            return true;
        }
        String string2 = this.resolveAppURL(string);
        if (string2 == null) {
            return false;
        }
        int n = string2.indexOf("/", 1);
        if (n != -1) {
            String string3 = string2.substring(0, n);
            if (string3 != null && this.isConsoleApp(string3)) {
                return true;
            }
            return this.getAppURL(string3 + "/") != null;
        }
        return false;
    }

    private boolean isConsoleApp(String string) {
        return string.equals("/") || string.equals("/com_sun_web_ui") || string.equals("/console") || string.equals("/console/login/Login");
    }

    private boolean isConsoleLoginApp(String string) {
        return string.equals("/console/jsp/login/BeginLogin.jsp") || string.equals("/console/faces/jsp/login/UserLogin.jsp") || string.equals("/console/faces/jsp/login/RoleLogin.jsp");
    }

    protected final boolean isUserAuth(String string, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        if (stringTokenizer.countTokens() < 1) {
            return true;
        }
        String string2 = stringTokenizer.nextToken();
        String string3 = MgmtAppRegistrationServiceFactory.getPluginName((String)string2);
        RegistrationInfo registrationInfo = MgmtAppRegistrationServiceFactory.getRegistrationInfo((String)string3);
        try {
            AppFilter appFilter = new AppFilter();
            if (appFilter.checkUserPermission(httpServletRequest, registrationInfo)) {
                return true;
            }
        }
        catch (Exception exception) {
            Debug.trace1((String)("CoreSessionManagerFilter.isUserAuth() exception: " + exception.getLocalizedMessage()));
        }
        return false;
    }

    private void removeCookie(HttpServletResponse httpServletResponse) {
        Cookie cookie = new Cookie("tokenID", "");
        cookie.setPath("/");
        cookie.setMaxAge(0);
        httpServletResponse.addCookie(cookie);
    }

    private void writeFailedAuditEvent(String string, HttpServletRequest httpServletRequest) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        String string2 = stringTokenizer.nextToken();
        try {
            ConsoleAuditEvent_Authorization consoleAuditEvent_Authorization;
            SSOTokenManager sSOTokenManager = SSOTokenManager.getInstance();
            SSOToken sSOToken = sSOTokenManager.createSSOToken(httpServletRequest);
            ConsoleAuditSession consoleAuditSession = ConsoleAuditService.getAuditSession((SSOToken)sSOToken);
            if (consoleAuditSession != null && consoleAuditSession.isAuditOn() && (consoleAuditEvent_Authorization = (ConsoleAuditEvent_Authorization)consoleAuditSession.getAuditEvent("com.sun.management.services.audit.ConsoleAuditEvent_Authorization")) != null) {
                AppFilter appFilter = new AppFilter();
                Permission permission = null;
                String string3 = null;
                if (appFilter != null && (permission = appFilter.getPermission()) != null && (string3 = permission.getName()) == null) {
                    string3 = permission.getClass().getName();
                }
                consoleAuditEvent_Authorization.setPermissionName(string3);
                consoleAuditEvent_Authorization.setObjectName(string2);
                consoleAuditEvent_Authorization.putEvent(-1);
            }
        }
        catch (Exception exception) {
            Debug.trace1((String)("Session filter: authz audit event failure" + exception.getMessage()));
        }
    }

    private void setUploadMaxSize(ServletContext servletContext, String string, long l) {
        long l2 = l;
        String string2 = ConsoleConfiguration.getProperty(string);
        if (string2 != null && string2.length() > 0) {
            int n = string2.length() - 1;
            char c = string2.charAt(n);
            int n2 = 1;
            if (c == 'k' || c == 'K') {
                string2 = string2.substring(0, n);
                n2 = 1024;
            }
            if (c == 'm' || c == 'M') {
                string2 = string2.substring(0, n);
                n2 = 0x100000;
            }
            try {
                l2 = Long.parseLong(string2);
                if (l2 > 0L) {
                    l2 *= (long)n2;
                }
            }
            catch (Exception exception) {
                Debug.trace1((String)("Invalid upload filter value: " + string2));
                l2 = l;
            }
        }
        if (l2 != 0L) {
            servletContext.setAttribute(string, (Object)new Long(l2));
            Debug.trace3((String)("Upload filter value " + string + " set to " + l2));
        }
    }

    protected void setRequestEncoding(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        try {
            httpServletRequest.setCharacterEncoding("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }
}

