/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.common;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.sun.web.ui.common.CCDebug;
import com.sun.web.ui.common.CCI18NFileIO;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.servlet.Servlet;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.jsp.PageContext;

public class CCI18N {
    public static final String TAGS_BUNDLE_ID = "com.sun.web.ui";
    public static final String TAGS_BUNDLE = "com.sun.web.ui.resources.Resources";
    public static final String BUNDLE_REQUEST_KEY_PREFIX = "com.sun.web.ui.common.CCI18N.Bundle:";
    public static final String BASE_REQUEST_KEY_PREFIX = "com.sun.web.ui.common.CCI18N.Base:";
    public static final String ISO_ENCODING = "ISO-8859-1";
    public static final String UTF8_ENCODING = "UTF-8";
    protected ResourceBundle bundle = null;
    protected String bundleID = null;
    protected ServletRequest request = null;
    public static final String LOCALE_SESSION_KEY_PREFIX = "com.sun.web.ui.common.CCI18N.Locale:";

    public CCI18N(ServletRequest servletRequest, String string) {
        if (servletRequest == null) {
            throw new IllegalArgumentException("request cannot be null.");
        }
        this.request = servletRequest;
        this.bundleID = string;
    }

    public CCI18N(ServletRequest servletRequest, ServletResponse servletResponse, String string, String string2, Locale locale) {
        this(servletRequest, servletResponse, string, string2, locale, null);
    }

    public CCI18N(ServletRequest servletRequest, ServletResponse servletResponse, String string, String string2, Locale locale, ClassLoader classLoader) {
        this(servletRequest, string2);
        if (string2 != null) {
            CCI18N.setResourceBundle(servletRequest, servletResponse, string, string2, locale, classLoader);
        } else {
            CCI18N.initContentType(servletRequest, servletResponse);
            this.setResourceBundle(CCI18N.findResourceBundle(servletRequest, string, locale != null ? locale : CCI18N.getTagsLocale(servletRequest), classLoader));
        }
    }

    public String getBaseName(ServletRequest servletRequest, String string) {
        if (servletRequest == null) {
            throw new IllegalArgumentException("request cannot be null.");
        }
        if (string == null) {
            throw new IllegalArgumentException("bundleID cannot be null.");
        }
        return (String)servletRequest.getAttribute(BASE_REQUEST_KEY_PREFIX + string);
    }

    public String getMessage(String string) {
        if (string == null) {
            return null;
        }
        ResourceBundle resourceBundle = this.getResourceBundle();
        try {
            if (resourceBundle == null) {
                resourceBundle = CCI18N.getResourceBundle(this.request, this.bundleID);
            }
            string = resourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return string;
    }

    public String getMessage(String string, Object[] objectArray) {
        if (string == null) {
            return null;
        }
        if (objectArray == null) {
            return this.getMessage(string);
        }
        String string2 = this.getMessage(string);
        MessageFormat messageFormat = new MessageFormat(string2);
        Object[] objectArray2 = new Object[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray2[i] = this.getMessage(objectArray[i].toString());
        }
        try {
            string = messageFormat.format(objectArray2);
        }
        catch (NullPointerException nullPointerException) {
            CCDebug.trace3("Unmatched message args in pattern: " + string2);
        }
        return string;
    }

    public Locale getLocale() {
        return this.bundle != null ? this.bundle.getLocale() : null;
    }

    public ResourceBundle getResourceBundle() {
        return this.bundle;
    }

    public static ResourceBundle getResourceBundle(ServletRequest servletRequest, String string) {
        if (servletRequest == null) {
            throw new IllegalArgumentException("pageContext cannot be null.");
        }
        if (string == null) {
            throw new IllegalArgumentException("bundleID cannot be null.");
        }
        return (ResourceBundle)servletRequest.getAttribute(BUNDLE_REQUEST_KEY_PREFIX + string);
    }

    public void setResourceBundle(ResourceBundle resourceBundle) {
        this.bundle = resourceBundle;
    }

    public static void setResourceBundle(ServletRequest servletRequest, ResourceBundle resourceBundle, String string) {
        if (servletRequest == null) {
            throw new IllegalArgumentException("request cannot be null.");
        }
        if (string == null) {
            throw new IllegalArgumentException("bundleID cannot be null.");
        }
        servletRequest.setAttribute(BUNDLE_REQUEST_KEY_PREFIX + string, (Object)resourceBundle);
    }

    public static boolean setResourceBundle(ServletRequest servletRequest, ServletResponse servletResponse, String string, String string2, Locale locale) {
        return CCI18N.setResourceBundle(servletRequest, servletResponse, string, string2, locale, null);
    }

    public static boolean setResourceBundle(ServletRequest servletRequest, ServletResponse servletResponse, String string, String string2, Locale locale, ClassLoader classLoader) {
        CCI18N.initContentType(servletRequest, servletResponse);
        ResourceBundle resourceBundle = CCI18N.findResourceBundle(servletRequest, string, locale != null ? locale : CCI18N.getTagsLocale(servletRequest), classLoader);
        if (resourceBundle == null) {
            CCDebug.trace3("The resource bundle could not be found.");
            return false;
        }
        CCI18N.setResourceBundle(servletRequest, resourceBundle, string2);
        CCI18N.setBaseName(servletRequest, string, string2);
        return true;
    }

    private static ResourceBundle findResourceBundle(ServletRequest servletRequest, String string, Locale locale, ClassLoader classLoader) {
        Locale locale2;
        if (servletRequest == null) {
            throw new IllegalArgumentException("request cannot be null.");
        }
        ResourceBundle resourceBundle = null;
        ArrayList<Object> arrayList = new ArrayList<Locale>();
        if (locale != null) {
            arrayList.add(locale);
        } else {
            arrayList = Collections.list(servletRequest.getLocales());
        }
        for (int i = 0; i < arrayList.size() && (!(locale2 = (Locale)arrayList.get(i)).getLanguage().equals(Locale.ENGLISH.getLanguage()) || !locale2.getCountry().equals(Locale.US.getCountry()) && locale2.getCountry().length() != 0); ++i) {
            resourceBundle = CCI18N.loadResourceBundle(servletRequest, string, locale2, classLoader);
            if (resourceBundle == null) continue;
            if (resourceBundle.getLocale() == null || resourceBundle.getLocale().getLanguage().length() > 0) break;
            CCDebug.trace3("Locale not available: " + locale2);
        }
        if (resourceBundle == null || resourceBundle.getLocale() == null || resourceBundle.getLocale().getLanguage().length() == 0) {
            resourceBundle = CCI18N.loadResourceBundle(servletRequest, string, new Locale(""), classLoader);
        }
        return resourceBundle;
    }

    private static ResourceBundle loadResourceBundle(ServletRequest servletRequest, String string, Locale locale, ClassLoader classLoader) {
        if (string == null) {
            throw new IllegalArgumentException("baseName cannot be null.");
        }
        ResourceBundle resourceBundle = null;
        try {
            ClassLoader classLoader2;
            ClassLoader classLoader3 = classLoader2 = classLoader != null ? classLoader : CCI18N.getClassLoader();
            resourceBundle = classLoader2 != null ? ResourceBundle.getBundle(string, locale, classLoader2) : ResourceBundle.getBundle(string, locale);
        }
        catch (MissingResourceException missingResourceException) {
            try {
                resourceBundle = ResourceBundle.getBundle(string);
            }
            catch (MissingResourceException missingResourceException2) {
                // empty catch block
            }
        }
        return resourceBundle;
    }

    private static ClassLoader getClassLoader() {
        Servlet servlet = RequestManager.getHandlingServlet();
        return servlet != null ? servlet.getClass().getClassLoader() : null;
    }

    private static void setBaseName(ServletRequest servletRequest, String string, String string2) {
        servletRequest.setAttribute(BASE_REQUEST_KEY_PREFIX + string2, (Object)string);
    }

    public static void initContentType(ServletRequest servletRequest, ServletResponse servletResponse) {
        CCI18N.setContentType(servletResponse, CCI18N.getTagsLocale(servletRequest));
    }

    public static void setTagsLocale(ServletRequest servletRequest, Locale locale) {
        ResourceBundle resourceBundle = CCI18N.findResourceBundle(servletRequest, TAGS_BUNDLE, locale, null);
        CCI18N.setResourceBundle(servletRequest, resourceBundle, TAGS_BUNDLE_ID);
    }

    public static Locale getTagsLocale(ServletRequest servletRequest) {
        Locale locale;
        ResourceBundle resourceBundle = CCI18N.getResourceBundle(servletRequest, TAGS_BUNDLE_ID);
        if (resourceBundle == null) {
            resourceBundle = CCI18N.findResourceBundle(servletRequest, TAGS_BUNDLE, null, null);
            CCI18N.setResourceBundle(servletRequest, resourceBundle, TAGS_BUNDLE_ID);
        }
        Locale locale2 = locale = resourceBundle != null ? resourceBundle.getLocale() : null;
        if (locale == null || locale.getLanguage().length() == 0) {
            locale = Locale.ENGLISH;
        }
        return locale;
    }

    private static void setContentType(ServletResponse servletResponse, Locale locale) {
        if (servletResponse == null) {
            throw new IllegalArgumentException("response cannot be null.");
        }
        if (!servletResponse.getLocale().equals(locale)) {
            servletResponse.setLocale(locale);
        }
        servletResponse.setContentType("text/html; charset=UTF-8");
    }

    public CCI18N(PageContext pageContext, String string) {
        this(pageContext.getRequest(), string);
    }

    public CCI18N(PageContext pageContext, String string, String string2, Locale locale) {
        this(pageContext.getRequest(), pageContext.getResponse(), string, string2, locale);
    }

    public CCI18N(PageContext pageContext, String string, String string2, Locale locale, String string3, String string4) {
        this(pageContext.getRequest(), pageContext.getResponse(), string, string2, locale, string3, string4);
    }

    public CCI18N(RequestContext requestContext, String string) {
        this((ServletRequest)requestContext.getRequest(), (ServletResponse)requestContext.getResponse(), string, null, null);
    }

    public CCI18N(RequestContext requestContext, String string, String string2, String string3) {
        this((ServletRequest)requestContext.getRequest(), (ServletResponse)requestContext.getResponse(), string, null, null, string2, string3);
    }

    public CCI18N(ServletRequest servletRequest, ServletResponse servletResponse, String string, String string2, Locale locale, String string3, String string4) {
        this(servletRequest, string2);
        CCI18NFileIO cCI18NFileIO = new CCI18NFileIO(servletRequest, servletResponse, string, string2, locale, string3, string4);
        this.setResourceBundle(cCI18NFileIO.getResourceBundle());
    }

    public static Locale getLocale(PageContext pageContext, String string) {
        if (pageContext == null) {
            throw new IllegalArgumentException("pageContext cannot be null.");
        }
        if (string == null) {
            throw new IllegalArgumentException("baseName cannot be null.");
        }
        return (Locale)pageContext.getRequest().getAttribute(LOCALE_SESSION_KEY_PREFIX + string);
    }

    public static void setLocale(PageContext pageContext, String string, Locale locale) {
        if (pageContext == null) {
            throw new IllegalArgumentException("pageContext cannot be null.");
        }
        if (string == null) {
            throw new IllegalArgumentException("baseName cannot be null.");
        }
        pageContext.getRequest().setAttribute(LOCALE_SESSION_KEY_PREFIX + string, (Object)locale);
    }

    public String getBaseName(PageContext pageContext, String string) {
        return this.getBaseName(pageContext.getRequest(), string);
    }

    public static ResourceBundle getResourceBundle(PageContext pageContext, String string) {
        if (pageContext == null) {
            throw new IllegalArgumentException("pageContext cannot be null.");
        }
        return CCI18N.getResourceBundle(pageContext.getRequest(), string);
    }

    public static void setResourceBundle(PageContext pageContext, ResourceBundle resourceBundle, String string) {
        if (pageContext == null) {
            throw new IllegalArgumentException("pageContext cannot be null.");
        }
        CCI18N.setResourceBundle(pageContext.getRequest(), resourceBundle, string);
    }

    public static boolean setResourceBundle(PageContext pageContext, String string, String string2, Locale locale) {
        return CCI18N.setResourceBundle(pageContext, string, string2, locale, null, null);
    }

    public static boolean setResourceBundle(PageContext pageContext, String string, String string2, Locale locale, String string3, String string4) {
        if (pageContext == null) {
            throw new IllegalArgumentException("pageContext cannot be null.");
        }
        return CCI18N.setResourceBundle(pageContext.getRequest(), pageContext.getResponse(), string, string2, locale, string3, string4);
    }

    public static boolean setResourceBundle(ServletRequest servletRequest, ServletResponse servletResponse, String string, String string2, Locale locale, String string3, String string4) {
        return CCI18NFileIO.setResourceBundle(servletRequest, servletResponse, string, string2, locale, string3, string4);
    }

    public static void setContentType(Locale locale, PageContext pageContext, RequestContext requestContext) {
        try {
            ServletResponse servletResponse = pageContext != null ? pageContext.getResponse() : requestContext.getResponse();
            CCI18N.setContentType(servletResponse, locale);
        }
        catch (NullPointerException nullPointerException) {
            CCDebug.trace3("Cannot obtain ServletResponse object" + nullPointerException.getMessage());
        }
    }

    public static String getUTF8String(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string;
        try {
            byte[] byArray = string2.getBytes(ISO_ENCODING);
            string2 = new String(byArray, UTF8_ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string2 = string;
        }
        return string2;
    }
}

