/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.model;

import com.sun.web.ui.common.CCImage;
import com.sun.web.ui.model.CCTopologyBadgeSet;
import java.awt.Color;
import java.awt.Image;
import javax.servlet.ServletContext;

public final class CCDefaultBadgeSet
extends CCTopologyBadgeSet {
    public static final int SMALL = 0;
    public static final int MEDIUM = 5;
    private int scaleOffset;

    public CCDefaultBadgeSet(ServletContext servletContext) {
        this(servletContext, 0);
    }

    public CCDefaultBadgeSet(ServletContext servletContext, int n) {
        super(servletContext);
        this.setImageScale(n);
        this.addBadge(4, CCImage.ALARM_MINOR_SMALL, Color.blue);
        this.addBadge(3, CCImage.ALARM_MAJOR_SMALL, new Color(153, 153, 0));
        this.addBadge(2, CCImage.ALARM_CRITICAL_SMALL, Color.red);
        this.addBadge(1, CCImage.ALARM_DOWN_SMALL, Color.black);
        this.addBadge(5, null, null);
        this.addBadge(9, CCImage.ALARM_MINOR_MEDIUM, Color.blue);
        this.addBadge(8, CCImage.ALARM_MAJOR_MEDIUM, new Color(153, 153, 0));
        this.addBadge(7, CCImage.ALARM_CRITICAL_MEDIUM, Color.red);
        this.addBadge(6, CCImage.ALARM_DOWN_MEDIUM, Color.black);
        this.addBadge(10, null, null);
    }

    public int getImageScale() {
        return this.scaleOffset;
    }

    public void setImageScale(int n) {
        if (n != 0 && n != 5) {
            throw new IllegalArgumentException("imageScale must be SMALL or MEDIUM");
        }
        this.scaleOffset = n;
    }

    public int getCombinedBadge(int n, int n2) {
        return n == 0 ? n2 : (n2 == 0 ? n : Math.min(n, n2));
    }

    public Image getImage(int n) {
        return super.getImage(n + this.scaleOffset);
    }
}

