/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.model;

import com.sun.web.ui.common.CCDebug;
import com.sun.web.ui.common.CCSystem;
import com.sun.web.ui.model.CCDefaultEntityResolver;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

abstract class CCDocumentBuilder {
    CCDocumentBuilder() {
    }

    public static Document createDocument(InputStream inputStream) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setIgnoringElementContentWhitespace(true);
        documentBuilderFactory.setValidating(true);
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            EntityResolver entityResolver = CCSystem.getEntityResolver();
            if (entityResolver == null) {
                entityResolver = new CCDefaultEntityResolver();
            }
            documentBuilder.setEntityResolver(entityResolver);
            documentBuilder.setErrorHandler(new DefaultHandler(){

                public void error(SAXParseException sAXParseException) {
                    throw new IllegalArgumentException(sAXParseException.getMessage());
                }

                public void fatalError(SAXParseException sAXParseException) {
                    throw new IllegalArgumentException(sAXParseException.getMessage());
                }

                public void warning(SAXParseException sAXParseException) {
                    CCDebug.trace3(sAXParseException.getMessage());
                }
            });
            return documentBuilder.parse(inputStream);
        }
        catch (Exception exception) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
            illegalArgumentException.initCause(exception);
            throw illegalArgumentException;
        }
    }

    public static Document createDocument(String string) {
        if (string == null) {
            throw new IllegalArgumentException("XML string empty!");
        }
        return CCDocumentBuilder.createDocument(new ByteArrayInputStream(string.getBytes()));
    }

    public static String getXMLString(InputStream inputStream) {
        try {
            int n = inputStream.available();
            String string = "";
            do {
                byte[] byArray;
                if ((n = inputStream.read(byArray = new byte[n])) <= 0) continue;
                string = string + new String(byArray, 0, n);
            } while (n > 0);
            inputStream.close();
            return string;
        }
        catch (IOException iOException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
            illegalArgumentException.initCause(iOException);
            throw illegalArgumentException;
        }
    }
}

