/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.model;

import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.sun.web.ui.common.CCDebug;
import com.sun.web.ui.model.CCManageChildrenModel;
import com.sun.web.ui.model.CCPageTitleModelInterface;
import com.sun.web.ui.view.html.CCButton;
import com.sun.web.ui.view.html.CCDropDownMenu;
import com.sun.web.ui.view.html.CCStaticTextField;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import javax.servlet.ServletContext;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CCPageTitleModel
extends CCManageChildrenModel
implements CCPageTitleModelInterface {
    private static final long serialVersionUID = -6180314027414608987L;
    private String pageTitleText = null;
    private String alertIconType = null;
    private String pageTitleHelpMessage = null;
    private Boolean showPageTitleSeparator = null;
    private Boolean showPageButtonsTop = null;
    private Boolean showPageButtonsBottom = null;
    private Boolean showPageBottomSpacer = null;
    private HashMap childMap = new HashMap();

    public CCPageTitleModel() {
        CCDebug.initTrace();
    }

    public CCPageTitleModel(String string) {
        this();
        this.setDocument(string);
    }

    public CCPageTitleModel(ServletContext servletContext, String string) {
        this();
        String string2 = this.getXMLFileAsString(servletContext.getResourceAsStream(string));
        this.setDocument(string2);
    }

    public CCPageTitleModel(InputStream inputStream) {
        this();
        this.setDocument(inputStream);
    }

    public void setDocument(InputStream inputStream) {
        super.setDocument(inputStream);
        this.createChildMaps();
    }

    protected void createDocument(InputStream inputStream) throws IllegalArgumentException {
        if (inputStream == null) {
            throw new IllegalArgumentException("Invalid parameter: The InputStream is null in CCPageTitleModel.");
        }
        super.createDocument(inputStream);
    }

    private void createChildMaps() {
        Document document = this.getDocument();
        if (document == null) {
            return;
        }
        this.parseNodeList(document.getElementsByTagName("pagebuttons"), this.childMap);
        this.parseNodeList(document.getElementsByTagName("pageactions"), this.childMap);
        this.parseNodeList(document.getElementsByTagName("pageviews"), this.childMap);
    }

    private void parseNodeList(NodeList nodeList, HashMap hashMap) {
        if (nodeList == null) {
            CCDebug.trace1("NodeList parameter is null in CCPageTitleModel.parseNodeList().");
            return;
        }
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            if (node.hasChildNodes()) {
                this.parseNodeList(node.getChildNodes(), hashMap);
            }
            if (!node.hasAttributes()) continue;
            NamedNodeMap namedNodeMap = node.getAttributes();
            Node node2 = namedNodeMap.getNamedItem("name");
            Node node3 = namedNodeMap.getNamedItem("tagclass");
            if (node2 == null) continue;
            String string = node.getNodeName();
            String string2 = node2.getNodeValue();
            if (!string.equals("cc")) continue;
            hashMap.put(string2, node3.getNodeValue());
        }
    }

    protected void setChildMapValue(String string, String string2, HashMap hashMap) {
        if (string == null) {
            CCDebug.trace1("name parameter is null.");
            return;
        }
        if (string2 == null) {
            CCDebug.trace1("tagclass parameter is null.");
            return;
        }
        if (string2.equals("com.sun.web.ui.taglib.html.CCButtonTag")) {
            hashMap.put(string, CCButton.class);
        } else if (string2.equals("com.sun.web.ui.taglib.html.CCDropDownMenuTag")) {
            hashMap.put(string, CCDropDownMenu.class);
        } else if (string2.equals("com.sun.web.ui.taglib.html.CCStaticTextFieldTag")) {
            hashMap.put(string, CCStaticTextField.class);
        } else {
            CCDebug.trace1("Unknown tag class: " + string2);
        }
    }

    public void registerChildren(ContainerViewBase containerViewBase) {
        Iterator iterator = this.childMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            try {
                super.registerChildren(containerViewBase, string, (String)this.childMap.get(string));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                CCDebug.trace1("Cannot register tag class: " + string);
            }
        }
    }

    public View createChild(View view, String string) {
        String string2 = (String)this.childMap.get(string);
        return super.createChild(view, this, string, string2);
    }

    public boolean isChildSupported(String string) {
        boolean bl = this.childMap.containsKey(string);
        if (bl) {
            return true;
        }
        return super.isChildSupported(string);
    }

    public String getPageTitleText() {
        return this.pageTitleText;
    }

    public void setPageTitleText(String string) {
        this.pageTitleText = string;
    }

    public String getAlertIconType() {
        return this.alertIconType;
    }

    public void setAlertIconType(String string) {
        this.alertIconType = string;
    }

    public String getPageTitleHelpMessage() {
        return this.pageTitleHelpMessage;
    }

    public void setPageTitleHelpMessage(String string) {
        this.pageTitleHelpMessage = string;
    }

    public Boolean getShowPageTitleSeparator() {
        return this.showPageTitleSeparator;
    }

    public void setShowPageTitleSeparator(boolean bl) {
        this.showPageTitleSeparator = new Boolean(bl);
    }

    public Boolean getShowPageButtonsTop() {
        return this.showPageButtonsTop;
    }

    public void setShowPageButtonsTop(boolean bl) {
        this.showPageButtonsTop = new Boolean(bl);
    }

    public Boolean getShowPageButtonsBottom() {
        return this.showPageButtonsBottom;
    }

    public void setShowPageButtonsBottom(boolean bl) {
        this.showPageButtonsBottom = new Boolean(bl);
    }

    public Boolean getShowPageBottomSpacer() {
        return this.showPageBottomSpacer;
    }

    public void setShowPageBottomSpacer(boolean bl) {
        this.showPageBottomSpacer = new Boolean(bl);
    }
}

