/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.servlet.datetime;

import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.web.ui.model.CCDateTimeModel;
import com.sun.web.ui.model.CCDateTimeModelInterface;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.servlet.common.TagsViewBeanBase;
import com.sun.web.ui.servlet.datetime.DateTimeServlet;
import com.sun.web.ui.view.datetime.CCDateTime;
import com.sun.web.ui.view.html.CCHiddenField;
import com.sun.web.ui.view.masthead.CCSecondaryMasthead;
import com.sun.web.ui.view.pagetitle.CCPageTitle;
import java.io.IOException;
import java.io.Serializable;
import java.util.Calendar;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;

public class DateTimeWindowViewBean
extends TagsViewBeanBase {
    public static final String PAGE_NAME = "DateTimeWindow";
    public static final String DEFAULT_DISPLAY_URL = "/com_sun_web_ui/jsp/datetime/DateTimeWindow.jsp";
    public static final String CHILD_MASTHEAD = "Masthead";
    public static final String CHILD_DATETIME = "DateTime";
    public static final String CHILD_PAGE_TITLE = "PageTitle";
    public static final String CHILD_HIDDEN_TEXT_NAME = "TextName";
    public static final String CHILD_HIDDEN_DTWIN_NAME = "DTWinName";
    public static final String CHILD_HIDDEN_INPUT_VALID = "InputValid";
    public static final String CHILD_HIDDEN_FORM_NAME = "ParentFormName";
    private CCPageTitleModel pageTitleModel = null;
    private CCDateTimeModelInterface dateTimeModel = null;
    private WindowAttributes winAttrs = null;

    public DateTimeWindowViewBean() {
        super(PAGE_NAME);
        this.setDefaultDisplayURL(DEFAULT_DISPLAY_URL);
        this.initModuleUrl();
        this.initPageTitleModel();
        this.registerChildren();
    }

    private void initModuleUrl() {
        String string = "jato:" + DateTimeServlet.PACKAGE_NAME + ".*:moduleURL";
        RequestManager.getRequestContext().getServletContext().setAttribute(string, (Object)"../datetime");
    }

    private void initPageTitleModel() {
        this.pageTitleModel = new CCPageTitleModel(RequestManager.getRequestContext().getServletContext(), "/com_sun_web_ui/jsp/datetime/pagetitle.xml");
        this.pageTitleModel.setValue("OkButton", "datetime.ok");
        this.pageTitleModel.setValue("CancelButton", "datetime.cancel");
    }

    protected void registerChildren() {
        this.registerChild(CHILD_MASTHEAD, CCSecondaryMasthead.class);
        this.registerChild(CHILD_PAGE_TITLE, CCPageTitle.class);
        this.registerChild(CHILD_HIDDEN_TEXT_NAME, CCHiddenField.class);
        this.registerChild(CHILD_HIDDEN_FORM_NAME, CCHiddenField.class);
        this.registerChild(CHILD_HIDDEN_DTWIN_NAME, CCHiddenField.class);
        this.registerChild(CHILD_HIDDEN_INPUT_VALID, CCHiddenField.class);
        this.registerChild(CHILD_DATETIME, CCDateTime.class);
        this.pageTitleModel.registerChildren((ContainerViewBase)this);
    }

    protected View createChild(String string) {
        if (string.equals(CHILD_MASTHEAD)) {
            CCSecondaryMasthead cCSecondaryMasthead = new CCSecondaryMasthead((ContainerView)this, string);
            return cCSecondaryMasthead;
        }
        if (string.equals(CHILD_DATETIME)) {
            CCDateTime cCDateTime = new CCDateTime((ContainerView)this, this.getDateTimeModel(), string);
            return cCDateTime;
        }
        if (string.equals(CHILD_PAGE_TITLE)) {
            CCPageTitle cCPageTitle = new CCPageTitle((ContainerView)this, this.pageTitleModel, string);
            return cCPageTitle;
        }
        if (string.equals(CHILD_HIDDEN_TEXT_NAME) || string.equals(CHILD_HIDDEN_FORM_NAME) || string.equals(CHILD_HIDDEN_DTWIN_NAME) || string.equals(CHILD_HIDDEN_INPUT_VALID)) {
            CCHiddenField cCHiddenField = new CCHiddenField((ContainerView)this, string, null);
            return cCHiddenField;
        }
        if (this.pageTitleModel.isChildSupported(string)) {
            return this.pageTitleModel.createChild((View)this, string);
        }
        throw new IllegalArgumentException("Invalid child name [" + string + "]");
    }

    public void beginDisplay(DisplayEvent displayEvent) throws ModelControlException {
        super.beginDisplay(displayEvent);
        HttpServletRequest httpServletRequest = this.getRequestContext().getRequest();
        CCDateTime cCDateTime = (CCDateTime)this.getChild(CHILD_DATETIME);
        CCDateTimeModelInterface cCDateTimeModelInterface = cCDateTime.getModel();
        WindowAttributes windowAttributes = (WindowAttributes)this.getPageSessionAttribute("winAttrs");
        if (windowAttributes == null) {
            windowAttributes = new WindowAttributes();
            windowAttributes.src = httpServletRequest.getParameter("src");
            windowAttributes.alt = httpServletRequest.getParameter("alt");
            windowAttributes.width = httpServletRequest.getParameter("width");
            windowAttributes.height = httpServletRequest.getParameter("height");
            windowAttributes.dateTextName = httpServletRequest.getParameter("dateTextName");
            windowAttributes.parentFormName = httpServletRequest.getParameter("formName");
            windowAttributes.dateTimeWindowName = httpServletRequest.getParameter("dateTimeWindowName");
            windowAttributes.showPreviewButton = httpServletRequest.getParameter("showPreview");
            windowAttributes.modelType = new Integer(cCDateTimeModelInterface.getType());
            windowAttributes.repeatIntervals = cCDateTimeModelInterface.getRepeatIntervals();
            this.setPageSessionAttribute("winAttrs", windowAttributes);
        }
        CCSecondaryMasthead cCSecondaryMasthead = (CCSecondaryMasthead)this.getChild(CHILD_MASTHEAD);
        cCSecondaryMasthead.setSrc(windowAttributes.src);
        cCSecondaryMasthead.setHeight(windowAttributes.height);
        cCSecondaryMasthead.setWidth(windowAttributes.width);
        cCSecondaryMasthead.setAlt(windowAttributes.alt);
        this.setDisplayFieldValue(CHILD_HIDDEN_TEXT_NAME, windowAttributes.dateTextName);
        this.setDisplayFieldValue(CHILD_HIDDEN_FORM_NAME, windowAttributes.parentFormName);
        this.setDisplayFieldValue(CHILD_HIDDEN_DTWIN_NAME, windowAttributes.dateTimeWindowName);
        cCDateTimeModelInterface.setType(windowAttributes.modelType);
        cCDateTimeModelInterface.setRepeatIntervals(windowAttributes.repeatIntervals);
        if (windowAttributes.showPreviewButton != null && windowAttributes.showPreviewButton.equals("true")) {
            ((CCDateTime)this.getChild(CHILD_DATETIME)).setShowPreviewButton(true);
        }
        this.initDateTimeModel(httpServletRequest, cCDateTime, cCDateTimeModelInterface);
    }

    private void initDateTimeModel(HttpServletRequest httpServletRequest, CCDateTime cCDateTime, CCDateTimeModelInterface cCDateTimeModelInterface) {
        String string = httpServletRequest.getParameter("startDate");
        if (string != null && !string.equals("")) {
            string = cCDateTime.validateDateString(string);
            try {
                Calendar calendar = cCDateTime.getCalendar();
                calendar.setTime(cCDateTime.getDateFormat().parse(string));
                cCDateTimeModelInterface.setStartDateTime(calendar.getTime());
                String string2 = httpServletRequest.getParameter("startHour");
                String string3 = httpServletRequest.getParameter("startMinute");
                calendar.set(11, new Integer(string2));
                calendar.set(12, new Integer(string3));
                cCDateTimeModelInterface.setStartDateTime(calendar.getTime());
                string2 = httpServletRequest.getParameter("endHour");
                string3 = httpServletRequest.getParameter("endMinute");
                calendar.set(11, new Integer(string2));
                calendar.set(12, new Integer(string3));
                cCDateTimeModelInterface.setEndTime(calendar.getTime());
                String string4 = httpServletRequest.getParameter("repeatInterval");
                int n = 0;
                String[] stringArray = cCDateTimeModelInterface.getRepeatIntervals();
                string4 = string4.substring("interval".length());
                n = new Integer(string4);
                cCDateTimeModelInterface.setSelectedRepeatIntervalName(stringArray[n]);
                String string5 = httpServletRequest.getParameter("repeatPeriod");
                cCDateTimeModelInterface.setRepeatLimitPeriod(new Integer(string5));
                String string6 = httpServletRequest.getParameter("repeatUnit");
                string6 = string6.substring("limitUnit".length());
                cCDateTimeModelInterface.setRepeatLimitUnit(new Integer(string6));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void handleOkButtonRequest(RequestInvocationEvent requestInvocationEvent) throws ServletException, IOException {
        WindowAttributes windowAttributes = (WindowAttributes)this.getPageSessionAttribute("winAttrs");
        CCDateTime cCDateTime = (CCDateTime)this.getChild(CHILD_DATETIME);
        CCDateTimeModelInterface cCDateTimeModelInterface = cCDateTime.getModel();
        cCDateTimeModelInterface.setType(windowAttributes.modelType);
        cCDateTimeModelInterface.setRepeatIntervals(windowAttributes.repeatIntervals);
        if (cCDateTime.validateDataInput()) {
            this.setDisplayFieldValue(CHILD_HIDDEN_INPUT_VALID, "true");
        }
        this.forwardTo(this.getRequestContext());
    }

    public CCDateTimeModelInterface getDateTimeModel() {
        if (this.dateTimeModel == null) {
            this.dateTimeModel = new CCDateTimeModel();
        }
        return this.dateTimeModel;
    }

    public void setDateTimeModel(CCDateTimeModelInterface cCDateTimeModelInterface) {
        this.dateTimeModel = cCDateTimeModelInterface;
    }

    static class WindowAttributes
    implements Serializable {
        public String alt;
        public String src;
        public String width;
        public String height;
        public String dateTextName;
        public String parentFormName;
        public String dateTimeWindowName;
        public Integer modelType;
        public String[] repeatIntervals;
        public String showPreviewButton;

        WindowAttributes() {
        }
    }
}

