/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.servlet.topology;

import com.sun.web.ui.common.CCDebug;
import com.sun.web.ui.servlet.topology.CCTopologyRenderer;
import com.sun.web.ui.servlet.topology.CCTopologyServlet;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import javax.imageio.ImageIO;

class CCTopologyImageData {
    private static final int TYPE = 0;
    private static final int BYTES = 1;
    private final CCTopologyRenderer renderer;
    private final Rectangle clipRegion;
    private final String imageFormat;
    private final Object[] imageData;

    public CCTopologyImageData(CCTopologyRenderer cCTopologyRenderer, Rectangle rectangle, String string) {
        if (cCTopologyRenderer == null) {
            throw new IllegalArgumentException("renderer == null");
        }
        if (!CCTopologyServlet.isValidImageFormat(string)) {
            throw new IllegalArgumentException("Unsupported format: " + string);
        }
        this.renderer = cCTopologyRenderer;
        this.clipRegion = rectangle;
        this.imageFormat = string;
        this.imageData = new Object[2];
    }

    private CCTopologyImageData(Object[] objectArray) {
        this.renderer = null;
        this.clipRegion = null;
        this.imageFormat = null;
        this.imageData = objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CCTopologyImageData createFromPrimitives(Object object) {
        Object object2;
        Object[] objectArray = null;
        try {
            objectArray = (Object[])object;
            object2 = (String)objectArray[0];
            object2 = (byte[])objectArray[1];
        }
        catch (Exception exception) {
            return null;
        }
        object2 = new CCTopologyImageData(objectArray);
        if (((CCTopologyImageData)object2).isEncoded()) {
            return object2;
        }
        Object object3 = object2;
        synchronized (object3) {
            long l = 100L;
            while (l < 160000L) {
                Object object4 = object;
                synchronized (object4) {
                    if (((CCTopologyImageData)object2).isEncoded()) {
                        return object2;
                    }
                }
                try {
                    object2.wait(l);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                l = (long)((double)l * 1.3);
            }
        }
        return null;
    }

    public Object asPrimitives() {
        return this.imageData;
    }

    public String getImageType() {
        return (String)this.imageData[0];
    }

    private void setImageType(String string) {
        this.imageData[0] = string;
    }

    public byte[] getImageBytes() {
        return (byte[])this.imageData[1];
    }

    private void setImageBytes(byte[] byArray) {
        this.imageData[1] = byArray;
    }

    public boolean isEncoded() {
        return this.getImageBytes() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void encodeImage() {
        Object object;
        BufferedImage bufferedImage = null;
        Object object2 = object = this.asPrimitives();
        synchronized (object2) {
            this.setImageType("image/" + this.imageFormat);
            byte[] byArray = new byte[]{};
            try {
                bufferedImage = this.renderer.getImage(this.clipRegion);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)bufferedImage, this.imageFormat, byteArrayOutputStream);
                byArray = byteArrayOutputStream.toByteArray();
            }
            catch (Exception exception) {
                CCDebug.trace1("Image creation/encoding failed", exception);
            }
            this.setImageBytes(byArray);
        }
        if (bufferedImage != null) {
            bufferedImage.flush();
        }
    }
}

