/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.servlet.topology;

import com.iplanet.jato.util.HtmlUtil;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.sun.web.ui.common.CCI18N;
import com.sun.web.ui.model.CCDefaultActionSet;
import com.sun.web.ui.model.CCTopologyModelInterface;
import com.sun.web.ui.servlet.common.TagsServletBase;
import com.sun.web.ui.servlet.topology.CCDefaultTopologyRenderer;
import com.sun.web.ui.servlet.topology.CCSessionImageCache;
import com.sun.web.ui.servlet.topology.CCTopologyImageData;
import com.sun.web.ui.servlet.topology.CCTopologyRenderer;
import com.sun.web.ui.taglib.common.CCTagBase;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.Arrays;
import javax.imageio.ImageIO;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.PageContext;

public final class CCTopologyServlet
extends TagsServletBase {
    private static final String MENU_PREFIX = "window.CCMenu";
    private static final String IMAGE_ID_PARAM = "image";
    private static final int DEFAULT_MAX_IMAGE_SIZE = 1000000;
    private static final String DEFAULT_IMAGE_FORMAT = "png";
    public static final String ID_PARAM = "cctopologyid";
    public static final String ACTION_PARAM = "cctopologyaction";
    public static final String TURNER_OPEN_ACTION = "cctrno";
    public static final String TURNER_CLOSE_ACTION = "cctrnc";
    public static final String GROUP_NODE_BADGE_CLICKED = "ccGnodb";
    public static final String GROUP_EDGE_CLICKED = "ccGedg";
    public static final String GROUP_EDGE_BADGE_CLICKED = "ccGedgb";
    public static final String GROUP_EDGE_ID_SEPARATOR = "^cc^";
    static final int GROUP_EDGE_DEFAULT = -2147483647;
    static final int GROUP_EDGE_BADGE_DEFAULT = -2147483646;
    static final int GROUP_NODE_BADGE_DEFAULT = -2147483645;
    public static final String TURNER_OPEN_TOOLTIP = "topology.turner.open";
    public static final String TURNER_CLOSE_TOOLTIP = "topology.turner.close";
    public static final String GROUP_EDGE_TOOLTIP = "topology.group.edge";
    public static final String GROUP_NODE_BADGE_TOOLTIP = "topology.group.node.badge";
    public static final String GROUP_EDGE_BADGE_TOOLTIP = "topology.group.edge.badge";
    public static final String IMG_ALT_ATTR_TEXT = "topology.img.alt.att.text";

    public static String getTopologyImageTags(PageContext pageContext, String string, String string2, CCI18N cCI18N, CCTopologyModelInterface cCTopologyModelInterface, boolean bl, boolean bl2, String string3) {
        if (cCTopologyModelInterface == null) {
            throw new IllegalArgumentException("model == null");
        }
        if (pageContext == null) {
            throw new IllegalArgumentException("pageContext == null");
        }
        CCI18N cCI18N2 = new CCI18N(pageContext.getRequest(), pageContext.getResponse(), "com.sun.web.ui.resources.Resources", "com.sun.web.ui", null);
        return CCTopologyServlet.getTopologyImageTags(pageContext.getSession(), string, string2, new CCDefaultTopologyRenderer(cCTopologyModelInterface, cCI18N2, cCI18N, null), cCI18N, cCI18N2, 1000000, DEFAULT_IMAGE_FORMAT, bl, bl2, string3);
    }

    public static String getTopologyImageTags(HttpSession httpSession, String string, String string2, CCTopologyRenderer cCTopologyRenderer, CCI18N cCI18N, CCI18N cCI18N2, int n, String string3, boolean bl, boolean bl2, String string4) {
        CCTopologyModelInterface.Edge[] edgeArray;
        if (httpSession == null) {
            throw new IllegalArgumentException("session == null");
        }
        if (cCTopologyRenderer == null) {
            throw new IllegalArgumentException("renderer == null");
        }
        n = n == 0 ? 1000000 : Math.max(n, 10000);
        if (!CCTopologyServlet.isValidImageFormat(string3)) {
            string3 = DEFAULT_IMAGE_FORMAT;
        }
        int n2 = 1;
        int n3 = 1;
        Rectangle rectangle = new Rectangle(cCTopologyRenderer.getImageSize());
        int n4 = rectangle.width * rectangle.height / n + 1;
        if (n4 > 1) {
            double d = Math.sqrt((double)n4 * rectangle.getWidth() / rectangle.getHeight());
            n2 = (int)Math.ceil(d);
            n3 = (int)Math.ceil((double)n4 / d);
        }
        int n5 = rectangle.width / n2 + 1;
        int n6 = rectangle.height / n3 + 1;
        String[][] stringArray = new String[n3][n2];
        Rectangle[][] rectangleArray = new Rectangle[n3][n2];
        CCSessionImageCache cCSessionImageCache = CCSessionImageCache.getInstance(httpSession);
        NonSyncStringBuffer nonSyncStringBuffer = new NonSyncStringBuffer();
        nonSyncStringBuffer.append("\n<input type=\"hidden\" name=\"cctopologyid\"/>");
        nonSyncStringBuffer.append("<input type=\"hidden\" name=\"cctopologyaction\"/>\n");
        nonSyncStringBuffer.append("\n<table cellpadding=\"0\" cellspacing=\"0\"");
        nonSyncStringBuffer.append(" border=\"0\">\n");
        String string5 = CCTopologyServlet.localize(cCI18N, cCI18N2, IMG_ALT_ATTR_TEXT);
        for (int i = 0; i < n3; ++i) {
            nonSyncStringBuffer.append("  <tr>\n");
            for (int j = 0; j < n2; ++j) {
                rectangleArray[i][j] = rectangle.intersection(new Rectangle(j * n5, i * n6, n5, n6));
                stringArray[i][j] = cCSessionImageCache.cacheImage(cCTopologyRenderer, rectangleArray[i][j], string3);
                nonSyncStringBuffer.append("    <td><img src=\"").append(string).append('?').append(IMAGE_ID_PARAM).append('=').append(stringArray[i][j]).append("\" width=\"").append(rectangleArray[i][j].width).append("\" height=\"").append(rectangleArray[i][j].height).append("\" usemap=\"#").append(stringArray[i][j]).append("\" border=\"0\"").append(" alt=\"" + string5 + "\">").append("</img></td>\n");
            }
            nonSyncStringBuffer.append("</tr>\n");
        }
        nonSyncStringBuffer.append("</table>\n");
        nonSyncStringBuffer.append("<script type=\"text/javascript\" ");
        nonSyncStringBuffer.append("language=\"JavaScript1.2\">\n<!--\n");
        nonSyncStringBuffer.append("function onLoad() {\n");
        CCTopologyModelInterface cCTopologyModelInterface = cCTopologyRenderer.getModel();
        CCTopologyModelInterface.ActionSet actionSet = cCTopologyModelInterface.getActionSet();
        int[] nArray = actionSet == null ? new int[]{} : actionSet.getValidIds();
        String string6 = null;
        for (int i = 0; i < nArray.length; ++i) {
            String string7;
            edgeArray = actionSet.getMenu(nArray[i]);
            if (edgeArray == null) continue;
            string6 = string7 = MENU_PREFIX + nArray[i];
            nonSyncStringBuffer.append(string7).append(" = new Menu();\n");
            nonSyncStringBuffer.append(string7).append(".addMenuItem(\"&#8212;&nbsp;").append(cCI18N.getMessage(edgeArray.getTitle())).append("&nbsp;&#8212;\");\n");
            String[] stringArray2 = edgeArray.getItems();
            for (int j = 0; j < stringArray2.length; ++j) {
                String string8 = stringArray2[j];
                if (string8.equals("CCContextualMenuModelInterface.SEPARATOR")) {
                    nonSyncStringBuffer.append(string7).append(".addMenuSeparator();\n");
                    continue;
                }
                String string9 = cCI18N.getMessage(string8);
                if (!edgeArray.isItemEnabled(string8)) {
                    string9 = "<font color=#999>" + string9 + "</font>";
                }
                nonSyncStringBuffer.append(string7).append(".addMenuItem(\"").append(string9).append("\",\"hideMenu(").append(string7).append(")");
                if (edgeArray.isItemEnabled(string8)) {
                    nonSyncStringBuffer.append(";closeTopoMenu(document.").append(string2).append(",'").append(stringArray2[j]).append("')");
                }
                nonSyncStringBuffer.append("\");\n");
            }
            nonSyncStringBuffer.append(string7).append(".disableDrag = true;\n\n");
        }
        if (string6 != null) {
            nonSyncStringBuffer.append(string6).append(".writeMenus();\n");
        }
        nonSyncStringBuffer.append("}\n//-->\n</script>\n");
        CCTopologyModelInterface.Node[] nodeArray = cCTopologyRenderer.getDisplayedNodes();
        edgeArray = cCTopologyRenderer.getDisplayedEdges();
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n2; ++j) {
                int n7;
                Rectangle rectangle2 = rectangleArray[i][j];
                nonSyncStringBuffer.append("<map name=\"");
                nonSyncStringBuffer.append(stringArray[i][j]);
                nonSyncStringBuffer.append("\" id=\"topologyMap\">");
                for (n7 = 0; n7 < nodeArray.length; ++n7) {
                    CCTopologyServlet.appendAreaTags(nonSyncStringBuffer, string2, cCTopologyRenderer, cCI18N, cCI18N2, nodeArray[n7], rectangle2, bl, bl2, string4);
                }
                for (n7 = 0; n7 < edgeArray.length; ++n7) {
                    CCTopologyServlet.appendAreaTags(nonSyncStringBuffer, string2, cCTopologyRenderer, cCI18N, cCI18N2, edgeArray[n7], rectangle2, bl, bl2, string4);
                }
                nonSyncStringBuffer.append("\n</map>\n");
            }
        }
        nonSyncStringBuffer.append("<script type=\"text/javascript\" ");
        nonSyncStringBuffer.append("language=\"JavaScript1.2\">\n<!--\n");
        nonSyncStringBuffer.append("if (document.all || document.getElementById) {\n");
        nonSyncStringBuffer.append("    onLoad(); \n} var ccScroll = ").append("new ccScrollCookie(\"ccScroll\");").append(" ccScroll.restore();ccScroll.reset();\n//-->\n</script>\n");
        return nonSyncStringBuffer.toString();
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        CCSessionImageCache cCSessionImageCache = CCSessionImageCache.getInstance(httpServletRequest.getSession());
        CCTopologyImageData cCTopologyImageData = cCSessionImageCache.takeImageData(httpServletRequest.getParameter(IMAGE_ID_PARAM));
        if (cCTopologyImageData != null) {
            httpServletResponse.setContentType(cCTopologyImageData.getImageType());
            servletOutputStream.write(cCTopologyImageData.getImageBytes());
        }
        servletOutputStream.flush();
    }

    static boolean isValidImageFormat(String string) {
        return string != null && Arrays.asList(ImageIO.getWriterFormatNames()).contains(string);
    }

    private static void appendAreaTags(NonSyncStringBuffer nonSyncStringBuffer, String string, CCTopologyRenderer cCTopologyRenderer, CCI18N cCI18N, CCI18N cCI18N2, CCTopologyModelInterface.Node node, Rectangle rectangle, boolean bl, boolean bl2, String string2) {
        Object object;
        boolean bl3;
        CCTopologyModelInterface.ActionSet actionSet = cCTopologyRenderer.getModel().getActionSet();
        String string3 = node.getLabel();
        String string4 = null;
        String string5 = null;
        int n = 0;
        int n2 = 0;
        int n3 = node.getAction();
        if (actionSet instanceof CCDefaultActionSet && n3 == Integer.MIN_VALUE) {
            string4 = "ccnod";
        } else if (actionSet != null && n3 != 0) {
            string4 = actionSet.getAction(n3);
            if (actionSet.getMenu(n3) != null) {
                n = n3;
            }
        }
        int n4 = node.getBadgeAction();
        String string6 = null;
        if (actionSet instanceof CCDefaultActionSet && n4 == Integer.MIN_VALUE) {
            string5 = "ccnodb";
        } else if (n4 == -2147483645) {
            string5 = GROUP_NODE_BADGE_CLICKED;
            string6 = CCTopologyServlet.localize(cCI18N, cCI18N2, GROUP_NODE_BADGE_TOOLTIP);
        } else if (actionSet != null && n4 != 0) {
            string5 = actionSet.getAction(n4);
            if (actionSet.getMenu(n4) != null) {
                n2 = n4;
            }
        }
        String string7 = node.getTooltip();
        if (string7 != null) {
            string7 = HtmlUtil.escape((String)string7);
        }
        if (string7 != null) {
            string7 = string3 + ", " + string7;
        }
        boolean bl4 = (bl3 = node.isInFilter()) && (string7 != null || string4 != null);
        boolean bl5 = false;
        if (node instanceof CCTopologyModelInterface.GroupNode) {
            bl5 = ((CCTopologyModelInterface.GroupNode)node).isExpanded();
            String string8 = CCTopologyServlet.localize(cCI18N, cCI18N2, bl5 ? TURNER_CLOSE_TOOLTIP : TURNER_OPEN_TOOLTIP);
            if (string8 != null) {
                string8 = string3 + ", " + string8;
            }
            object = bl5 ? TURNER_CLOSE_ACTION : TURNER_OPEN_ACTION;
            CCTopologyServlet.appendAreaTags(nonSyncStringBuffer, string, cCTopologyRenderer.getTurnerArea(node, rectangle), string8, node.getId(), (String)object, 0, bl, bl2, string2);
        }
        int n5 = node.getBadge();
        if (!bl5 && n5 != 0) {
            object = node.getBadgeTooltip();
            if (string6 != null) {
                object = object != null ? (String)object + ", " + string6 : string6;
            }
            if (object != null) {
                object = HtmlUtil.escape((String)object);
            }
            if (object != null) {
                object = string3 + ", " + (String)object;
            }
            if (bl3 && (object != null || string5 != null)) {
                CCTopologyServlet.appendAreaTags(nonSyncStringBuffer, string, cCTopologyRenderer.getBadgeArea(node, rectangle), (String)object, node.getId(), string5, n2, bl, bl2, string2);
            }
        }
        if (bl4) {
            object = cCTopologyRenderer.getLabelArea(node, rectangle);
            Rectangle rectangle2 = cCTopologyRenderer.getIconArea(node, rectangle);
            if (bl5 || rectangle2 == null) {
                CCTopologyServlet.appendAreaTags(nonSyncStringBuffer, string, (Rectangle)object, string7, node.getId(), string4, n, bl, bl2, string2);
            } else if (object == null) {
                CCTopologyServlet.appendAreaTags(nonSyncStringBuffer, string, rectangle2, string7, node.getId(), string4, n, bl, bl2, string2);
            } else {
                CCTopologyServlet.appendAreaTags(nonSyncStringBuffer, string, CCTopologyServlet.mergeAreas((Rectangle)object, rectangle2), string7, node.getId(), string4, n, bl, bl2, string2);
            }
        }
    }

    private static Polygon mergeAreas(Rectangle rectangle, Rectangle rectangle2) {
        Polygon polygon = new Polygon();
        if (rectangle.x + rectangle.width < rectangle2.x) {
            int n = rectangle.x - 2;
            int n2 = rectangle.y;
            polygon.addPoint(n, n2);
            n = rectangle2.x - 2;
            polygon.addPoint(n, n2);
            n2 = rectangle2.y - 2;
            polygon.addPoint(n, n2);
            n = rectangle2.x + rectangle2.width;
            polygon.addPoint(n, n2);
            n2 = rectangle2.y + rectangle2.height;
            polygon.addPoint(n, n2);
            n = rectangle2.x - 2;
            polygon.addPoint(n, n2);
            n2 = rectangle.y + rectangle.height;
            polygon.addPoint(n, n2);
            n = rectangle.x - 2;
            polygon.addPoint(n, n2);
        } else if (rectangle.y < rectangle2.y) {
            int n = rectangle.x - 2;
            int n3 = rectangle.y;
            polygon.addPoint(n, n3);
            polygon.addPoint(n, n3 += rectangle.height);
            n = rectangle2.x - 2;
            polygon.addPoint(n, n3);
            n3 = rectangle2.y + rectangle2.height;
            polygon.addPoint(n, n3);
            n = rectangle2.x + rectangle2.width;
            polygon.addPoint(n, n3);
            n3 = rectangle.y + rectangle.height;
            polygon.addPoint(n, n3);
            n = rectangle.x + rectangle.width;
            polygon.addPoint(n, n3);
            n3 = rectangle.y;
            polygon.addPoint(n, n3);
        } else {
            int n = rectangle.x - 2;
            int n4 = rectangle.y;
            polygon.addPoint(n, n4);
            polygon.addPoint(n, n4 += rectangle.height);
            n = rectangle.x + rectangle.width;
            polygon.addPoint(n, n4);
            n4 = rectangle.y;
            polygon.addPoint(n, n4);
            n = rectangle2.x + rectangle2.width;
            polygon.addPoint(n, n4);
            n4 = rectangle2.y - 2;
            polygon.addPoint(n, n4);
            n = rectangle2.x - 2;
            polygon.addPoint(n, n4);
            n4 = rectangle.y;
            polygon.addPoint(n, n4);
        }
        return polygon;
    }

    private static void appendAreaTags(NonSyncStringBuffer nonSyncStringBuffer, String string, CCTopologyRenderer cCTopologyRenderer, CCI18N cCI18N, CCI18N cCI18N2, CCTopologyModelInterface.Edge edge, Rectangle rectangle, boolean bl, boolean bl2, String string2) {
        String string3;
        if (!edge.isInFilter()) {
            return;
        }
        CCTopologyModelInterface.ActionSet actionSet = cCTopologyRenderer.getModel().getActionSet();
        String string4 = null;
        String string5 = null;
        int n = 0;
        int n2 = 0;
        int n3 = edge.getAction();
        if (actionSet instanceof CCDefaultActionSet && n3 == Integer.MIN_VALUE) {
            string4 = "ccedg";
        } else if (n3 == -2147483647) {
            string4 = GROUP_EDGE_CLICKED;
        } else if (actionSet != null && n3 != 0) {
            string4 = actionSet.getAction(n3);
            if (actionSet.getMenu(n3) != null) {
                n = n3;
            }
        }
        int n4 = edge.getBadgeAction();
        String string6 = null;
        if (actionSet instanceof CCDefaultActionSet && n4 == Integer.MIN_VALUE) {
            string5 = "ccedgb";
        } else if (n4 == -2147483646) {
            string5 = GROUP_EDGE_BADGE_CLICKED;
            string6 = CCTopologyServlet.localize(cCI18N, cCI18N2, GROUP_EDGE_BADGE_TOOLTIP);
        } else if (actionSet != null && n4 != 0) {
            string5 = actionSet.getAction(n4);
            if (actionSet.getMenu(n4) != null) {
                n2 = n4;
            }
        }
        String string7 = edge.getId();
        if (string7.indexOf(GROUP_EDGE_ID_SEPARATOR) != -1) {
            string7 = string7 + GROUP_EDGE_ID_SEPARATOR + edge.getBadge();
        }
        if ((string3 = edge.getTooltip()) != null) {
            string3 = HtmlUtil.escape((String)string3);
        }
        boolean bl3 = string3 != null || string4 != null;
        int n5 = edge.getBadge();
        if (n5 != 0) {
            String string8 = edge.getBadgeTooltip();
            if (string6 != null) {
                string8 = string8 != null ? string8 + ", " + string6 : string6;
            }
            if (string8 != null) {
                string8 = HtmlUtil.escape((String)string8);
            }
            if (string8 != null || string5 != null) {
                CCTopologyServlet.appendAreaTags(nonSyncStringBuffer, string, cCTopologyRenderer.getBadgeArea(edge, rectangle), string8, string7, string5, n2, bl, bl2, string2);
            }
        }
        if (bl3) {
            CCTopologyServlet.appendAreaTags(nonSyncStringBuffer, string, cCTopologyRenderer.getEdgeArea(edge, rectangle), string3, string7, string4, n, bl, bl2, string2);
        }
    }

    public static String localize(CCI18N cCI18N, CCI18N cCI18N2, String string) {
        if (string == null) {
            return null;
        }
        String string2 = string;
        if (cCI18N != null) {
            string2 = cCI18N.getMessage(string);
        }
        if (cCI18N2 != null && string.equals(string2)) {
            string2 = cCI18N2.getMessage(string);
        }
        return string2;
    }

    private static void appendAreaTags(NonSyncStringBuffer nonSyncStringBuffer, String string, Rectangle[] rectangleArray, String string2, String string3, String string4, int n, boolean bl, boolean bl2, String string5) {
        if (rectangleArray != null) {
            for (int i = 0; i < rectangleArray.length; ++i) {
                CCTopologyServlet.appendAreaTags(nonSyncStringBuffer, string, rectangleArray[i], string2, string3, string4, n, bl, bl2, string5);
            }
        }
    }

    private static void appendAreaTags(NonSyncStringBuffer nonSyncStringBuffer, String string, Rectangle rectangle, String string2, String string3, String string4, int n, boolean bl, boolean bl2, String string5) {
        if (rectangle != null) {
            NonSyncStringBuffer nonSyncStringBuffer2 = new NonSyncStringBuffer();
            nonSyncStringBuffer2.append((int)rectangle.getMinX()).append(',').append((int)rectangle.getMinY()).append(',').append((int)rectangle.getMaxX()).append(',').append((int)rectangle.getMaxY());
            CCTopologyServlet.appendAreaTags(nonSyncStringBuffer, string, "rect", nonSyncStringBuffer2.toString(), string2, string3, string4, n, bl, bl2, string5);
        }
    }

    private static void appendAreaTags(NonSyncStringBuffer nonSyncStringBuffer, String string, Polygon polygon, String string2, String string3, String string4, int n, boolean bl, boolean bl2, String string5) {
        if (polygon != null) {
            NonSyncStringBuffer nonSyncStringBuffer2 = new NonSyncStringBuffer();
            for (int i = 0; i < polygon.npoints; ++i) {
                if (i > 0) {
                    nonSyncStringBuffer2.append(',');
                }
                nonSyncStringBuffer2.append(polygon.xpoints[i]).append(',').append(polygon.ypoints[i]);
            }
            CCTopologyServlet.appendAreaTags(nonSyncStringBuffer, string, "poly", nonSyncStringBuffer2.toString(), string2, string3, string4, n, bl, bl2, string5);
        }
    }

    private static void appendAreaTags(NonSyncStringBuffer nonSyncStringBuffer, String string, String string2, String string3, String string4, String string5, String string6, int n, boolean bl, boolean bl2, String string7) {
        nonSyncStringBuffer.append("\n  <area shape=\"").append(string2).append("\" coords=\"").append(string3).append('\"');
        if (string7 != null) {
            nonSyncStringBuffer.append(" tabindex=\"").append(string7).append('\"');
        }
        if (string6 != null || n != 0) {
            NonSyncStringBuffer nonSyncStringBuffer2 = new NonSyncStringBuffer();
            if (n != 0) {
                nonSyncStringBuffer2.append("\"javascript: openTopoMenu(document.").append(string).append(",'").append(string5).append("',").append(MENU_PREFIX).append(n).append(")\"");
            } else {
                nonSyncStringBuffer2.append("\"javascript: topoClick(document.").append(string).append(",'").append(string5).append("','").append(string6).append("')\"");
            }
            nonSyncStringBuffer.append(" href=").append(nonSyncStringBuffer2.toString());
            nonSyncStringBuffer2.setLength(0);
            nonSyncStringBuffer2.append("\"javascript: return topoKeyPress(event,document.").append(string).append(",'").append(string5).append("','").append(string6).append("')\"");
            nonSyncStringBuffer.append(" onKeyPress=").append(nonSyncStringBuffer2.toString());
        }
        if (string4 == null) {
            string4 = "";
        }
        nonSyncStringBuffer.append(" alt=\"").append(string4).append("\" title=\"").append(string4).append('\"');
        nonSyncStringBuffer.append(" onmouseover=\"window.status='").append(CCTagBase.escapeJsQuotes(string4)).append("'; return true;\"").append(" onmouseout=\"window.status='';\"");
        nonSyncStringBuffer.append(" />");
    }
}

