/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.taglib.tabs;

import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.util.HtmlUtil;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.JspDisplayEvent;
import com.sun.web.ui.common.CCBodyContentImpl;
import com.sun.web.ui.common.CCDebug;
import com.sun.web.ui.common.CCImage;
import com.sun.web.ui.common.CCJspWriterImpl;
import com.sun.web.ui.model.CCNavNodeInterface;
import com.sun.web.ui.model.CCTabsModelInterface;
import com.sun.web.ui.taglib.common.CCTagBase;
import com.sun.web.ui.taglib.html.CCHrefTag;
import com.sun.web.ui.taglib.skip.CCSkipTag;
import com.sun.web.ui.view.html.CCHref;
import com.sun.web.ui.view.tabs.CCTabs;
import java.io.IOException;
import java.util.Iterator;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.Tag;

public class CCTabsTag
extends CCTagBase {
    protected static final String ATTRIB_TARGET = "target";
    protected static final String ATTRIB_TYPE = "type";
    protected static final String ATTRIB_SUBMITFORMDATA = "submitFormData";
    public static final String TYPE_DEFAULT = "default";
    public static final String TYPE_MINI = "mini";
    private int PADDING_MIN_LEN = 6;
    private static final String WHITESPACE = "[ \t\n\f\r]";
    private CCTabsModelInterface model = null;
    private CCTabs tabsView = null;
    private NonSyncStringBuffer buffer = null;
    private NonSyncStringBuffer skipTagAltText = null;
    private boolean bIsMiniTab = false;

    public void reset() {
        super.reset();
        this.model = null;
        this.tabsView = null;
        this.buffer = null;
        this.bIsMiniTab = false;
    }

    protected String getHTMLStringInternal(Tag tag, PageContext pageContext, View view) throws JspException {
        if (tag == null) {
            throw new IllegalArgumentException("parent cannot be null");
        }
        if (pageContext == null) {
            throw new IllegalArgumentException("pageContext cannot be null");
        }
        if (view == null) {
            throw new IllegalArgumentException("view cannot be null");
        }
        super.getHTMLStringInternal(tag, pageContext, view);
        this.checkChildType(view, CCTabs.class);
        this.tabsView = (CCTabs)view;
        this.model = this.tabsView.getCCTabsModel();
        if (this.model == null) {
            CCDebug.trace1("Model is null.");
            return null;
        }
        this.setParent(tag);
        this.setPageContext(pageContext);
        if (this.getType().equals(TYPE_MINI)) {
            this.bIsMiniTab = true;
        }
        try {
            this.tabsView.beginDisplay((DisplayEvent)new JspDisplayEvent((Tag)this, pageContext));
        }
        catch (ModelControlException modelControlException) {
            throw new JspException(modelControlException.getMessage());
        }
        return this.getTabComponentHTML();
    }

    private String getTabComponentHTML() throws JspException {
        if (this.isNav4()) {
            return null;
        }
        if (this.bIsMiniTab) {
            return this.getTabsHTMLString();
        }
        CCSkipTag cCSkipTag = new CCSkipTag();
        cCSkipTag.setBundleID(this.getBundleID());
        cCSkipTag.setColor(CCImage.COLOR_MEDIUM_GREY1);
        cCSkipTag.setTabIndex(this.getTabIndex());
        try {
            CCBodyContentImpl cCBodyContentImpl = new CCBodyContentImpl(new CCJspWriterImpl(null, 100, false));
            cCBodyContentImpl.print(this.getTabsHTMLString());
            cCSkipTag.setBodyContent(cCBodyContentImpl);
        }
        catch (IOException iOException) {
            CCDebug.trace1(iOException.getMessage());
        }
        cCSkipTag.setAlt(HtmlUtil.escape((String)this.skipTagAltText.toString()));
        return cCSkipTag.getHTMLString(this.getParent(), this.pageContext, null);
    }

    private String getTabsHTMLString() throws JspException {
        if (this.model.getNodes().size() < 1) {
            CCDebug.trace1("No tabs defined.");
            return null;
        }
        this.skipTagAltText = new NonSyncStringBuffer(128);
        this.skipTagAltText.append(this.getTagMessage("tab.skipTagAltText"));
        this.buffer = new NonSyncStringBuffer(8192);
        CCNavNodeInterface cCNavNodeInterface = null;
        CCNavNodeInterface cCNavNodeInterface2 = null;
        CCNavNodeInterface cCNavNodeInterface3 = null;
        int n = this.model.getMaxDepth() + 1;
        cCNavNodeInterface = this.appendFirstLevelTabs();
        this.appendSkipTagAltText(cCNavNodeInterface);
        if (this.bIsMiniTab || n <= 1) {
            return this.buffer.toString();
        }
        if (n <= 2) {
            cCNavNodeInterface3 = this.appendSecondLevelTabs(cCNavNodeInterface);
        } else {
            cCNavNodeInterface2 = this.appendSecondLevelTabs(cCNavNodeInterface);
            this.appendSkipTagAltText(cCNavNodeInterface2);
            cCNavNodeInterface3 = this.appendLastLevelTabs(cCNavNodeInterface2);
        }
        this.appendSkipTagAltText(cCNavNodeInterface3);
        return this.buffer.toString();
    }

    private CCNavNodeInterface appendFirstLevelTabs() throws JspException {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        CCNavNodeInterface cCNavNodeInterface = this.getSelectedTab();
        if (!this.bIsMiniTab) {
            string5 = "Tab1Div";
            string4 = "Tab1Lnk";
            string3 = "Tab1TblSelTd";
            string2 = "Tab1SelTxtNew";
            int n = this.getTabDepth(cCNavNodeInterface);
            string = n == 3 ? "Tab1Tbl3New" : (n == 2 ? "Tab1Tbl2New" : "Tab1TblNew");
        } else {
            string5 = "MniTabDiv";
            string4 = "MniTabLnk";
            string3 = "MniTabTblSelTd";
            string2 = "MniTabSelTxt";
            string = "MniTabTbl";
        }
        this.appendOpeningDivAndTable(string5, string);
        CCNavNodeInterface cCNavNodeInterface2 = null;
        Iterator iterator = this.model.getNodes().iterator();
        while (iterator.hasNext()) {
            cCNavNodeInterface2 = (CCNavNodeInterface)iterator.next();
            if (!cCNavNodeInterface2.equals(cCNavNodeInterface)) {
                this.appendUnselectedTab(cCNavNodeInterface2, string4, false);
                continue;
            }
            this.appendSelectedTab(cCNavNodeInterface2, string3, string2);
        }
        this.appendClosingDivAndTable();
        return cCNavNodeInterface;
    }

    private CCNavNodeInterface appendSecondLevelTabs(CCNavNodeInterface cCNavNodeInterface) throws JspException {
        if (cCNavNodeInterface.getNumChildren() < 1) {
            return null;
        }
        CCNavNodeInterface cCNavNodeInterface2 = this.getSelectedSubTab(cCNavNodeInterface);
        int n = cCNavNodeInterface2.getNumChildren() > 0 ? 3 : 2;
        String string = n == 3 ? "Tab2Tbl3New" : "Tab2TblNew";
        this.appendLevel2Level3Tabs(2, cCNavNodeInterface, cCNavNodeInterface2, "Tab2Div", string, "Tab2Lnk", "Tab2TblSelTd", "Tab2SelTxt");
        return cCNavNodeInterface2;
    }

    private CCNavNodeInterface appendLastLevelTabs(CCNavNodeInterface cCNavNodeInterface) throws JspException {
        if (cCNavNodeInterface == null || cCNavNodeInterface.getNumChildren() < 1) {
            return null;
        }
        CCNavNodeInterface cCNavNodeInterface2 = this.getSelectedSubTab(cCNavNodeInterface);
        this.appendLevel2Level3Tabs(3, cCNavNodeInterface, cCNavNodeInterface2, "Tab3Div", "Tab3TblNew", "Tab3Lnk", "Tab3TblSelTd", "Tab3SelTxt");
        return cCNavNodeInterface2;
    }

    private void appendLevel2Level3Tabs(int n, CCNavNodeInterface cCNavNodeInterface, CCNavNodeInterface cCNavNodeInterface2, String string, String string2, String string3, String string4, String string5) throws JspException {
        this.appendOpeningDivAndTable(string, string2);
        CCNavNodeInterface cCNavNodeInterface3 = null;
        boolean bl = false;
        Iterator iterator = cCNavNodeInterface.getChildren().iterator();
        while (iterator.hasNext()) {
            cCNavNodeInterface3 = (CCNavNodeInterface)iterator.next();
            if (!cCNavNodeInterface3.equals(cCNavNodeInterface2)) {
                this.appendUnselectedTab(cCNavNodeInterface3, string3, bl);
                if (n == 2) continue;
                bl = true;
                continue;
            }
            this.appendSelectedTab(cCNavNodeInterface3, string4, string5);
            bl = false;
        }
        this.appendClosingDivAndTable();
    }

    private void appendOpeningDivAndTable(String string, String string2) {
        this.buffer.append("<div class=\"").append(string).append("\">\n").append("<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\"").append(" class=\"").append(string2).append("\" title=\"\">\n<tr>\n");
    }

    private void appendClosingDivAndTable() {
        this.buffer.append("</tr>\n</table>\n</div>\n");
    }

    private void appendUnselectedTab(CCNavNodeInterface cCNavNodeInterface, String string, boolean bl) throws JspException {
        String string2 = this.getMessage(cCNavNodeInterface.getLabel());
        if (string2.length() <= this.PADDING_MIN_LEN) {
            string = string + " " + "TabPad";
        }
        if (bl) {
            this.appendDivider(CCImage.TAB_DIVIDER, "20", "5");
        }
        this.buffer.append("<td>").append(this.getHrefHTMLString(cCNavNodeInterface, string)).append("</td>\n");
    }

    private void appendSelectedTab(CCNavNodeInterface cCNavNodeInterface, String string, String string2) {
        String string3 = this.getMessage(cCNavNodeInterface.getLabel());
        if (string3.length() <= this.PADDING_MIN_LEN) {
            string2 = string2 + " " + "TabPad";
        }
        this.buffer.append("<td class=\"").append(string).append("\"><div class=\"").append(string2).append("\" title=\"");
        this.appendCurrTabMessage(cCNavNodeInterface);
        this.buffer.append("\">").append(HtmlUtil.escape((String)string3)).append("</div></td>\n");
    }

    private String getHrefHTMLString(CCNavNodeInterface cCNavNodeInterface, String string) throws JspException {
        Object object;
        String string2;
        View view = this.tabsView.getChild("TabHref");
        this.checkChildType(view, CCHref.class);
        CCHref cCHref = (CCHref)view;
        CCHrefTag cCHrefTag = new CCHrefTag();
        cCHref.setValue(new Integer(cCNavNodeInterface.getId()));
        cCHrefTag.setName("TabHref");
        cCHrefTag.setStyleClass(string);
        cCHrefTag.setBundleID(this.getBundleID());
        cCHrefTag.setTabIndex(this.getTabIndex());
        if (cCNavNodeInterface.getTooltip() != null) {
            cCHrefTag.setTitle(cCNavNodeInterface.getTooltip());
        }
        if (cCNavNodeInterface.getStatus() != null) {
            this.setHrefStatus(cCHrefTag, HtmlUtil.escapeQuotes((String)this.getMessage(cCNavNodeInterface.getStatus())));
        }
        String string3 = string2 = cCNavNodeInterface.getTarget() != null ? cCNavNodeInterface.getTarget() : this.getTarget();
        if (string2 != null) {
            cCHrefTag.setTarget(string2);
            cCHref.addExtraValue("reload", "true");
            this.setOnClickJavascript(cCNavNodeInterface.getOnClick(), cCHrefTag);
        } else {
            if (cCNavNodeInterface.getOnClick() != null) {
                cCHrefTag.setOnClick(cCNavNodeInterface.getOnClick());
            }
            cCHrefTag.setSubmitFormData(this.getSubmitFormData());
        }
        String string4 = HtmlUtil.escape((String)this.getMessage(cCNavNodeInterface.getLabel()));
        try {
            object = new CCBodyContentImpl(new CCJspWriterImpl(null, 100, false));
            ((CCBodyContentImpl)((Object)object)).print(string4);
            cCHrefTag.setBodyContent((BodyContent)object);
        }
        catch (IOException iOException) {
            CCDebug.trace1(iOException.getMessage());
        }
        object = "";
        if (this.fireBeginDisplayEvent((ContainerView)this.tabsView, cCHrefTag)) {
            object = cCHrefTag.getHTMLString(this.getParent(), this.pageContext, (View)cCHref);
        }
        return this.fireEndDisplayEvent((ContainerView)this.tabsView, cCHrefTag, (String)object);
    }

    private void setOnClickJavascript(String string, CCHrefTag cCHrefTag) throws JspException {
        String string2 = this.getFormName();
        if (string2 == null) {
            return;
        }
        NonSyncStringBuffer nonSyncStringBuffer = new NonSyncStringBuffer();
        if (string != null) {
            nonSyncStringBuffer.append(string).append(";");
        }
        nonSyncStringBuffer.append("javascript:var f=document.").append(string2).append(";if (f != null) {f.action=this.href").append(";f.submit();return true}");
        cCHrefTag.setOnClick(nonSyncStringBuffer.toString());
    }

    private void setHrefStatus(CCHrefTag cCHrefTag, String string) throws JspException {
        if (cCHrefTag == null) {
            CCDebug.trace1("CCHrefTag parameter is null.");
            return;
        }
        if (string == null) {
            CCDebug.trace1("status parameter is null.");
            return;
        }
        NonSyncStringBuffer nonSyncStringBuffer = new NonSyncStringBuffer(8192);
        nonSyncStringBuffer.append("window.status='").append(CCTabsTag.escapeJsQuotes(string)).append("'; return true");
        cCHrefTag.setOnMouseOver(nonSyncStringBuffer.toString());
        cCHrefTag.setOnFocus(nonSyncStringBuffer.toString());
        cCHrefTag.setOnMouseOut("window.status=''; return true");
        cCHrefTag.setOnBlur("window.status=''; return true");
    }

    private CCNavNodeInterface getSelectedTab() {
        CCNavNodeInterface cCNavNodeInterface = this.model.getSelectedNode();
        if (cCNavNodeInterface != null) {
            if (cCNavNodeInterface.getParent() == null) {
                return cCNavNodeInterface;
            }
            CCNavNodeInterface[] cCNavNodeInterfaceArray = cCNavNodeInterface.getPath();
            if (cCNavNodeInterfaceArray.length > 0) {
                return cCNavNodeInterfaceArray[0];
            }
        }
        cCNavNodeInterface = (CCNavNodeInterface)this.model.getNodes().get(0);
        this.model.setSelectedNode(cCNavNodeInterface);
        return cCNavNodeInterface;
    }

    private CCNavNodeInterface getSelectedSubTab(CCNavNodeInterface cCNavNodeInterface) {
        if (cCNavNodeInterface == null || cCNavNodeInterface.getNumChildren() < 1) {
            return null;
        }
        CCNavNodeInterface cCNavNodeInterface2 = this.model.getSelectedNode();
        if (cCNavNodeInterface2 != null) {
            if (cCNavNodeInterface2.equals(cCNavNodeInterface)) {
                cCNavNodeInterface2 = (CCNavNodeInterface)cCNavNodeInterface.getChildren().get(0);
                this.model.setSelectedNode(cCNavNodeInterface2);
                return cCNavNodeInterface2;
            }
            CCNavNodeInterface[] cCNavNodeInterfaceArray = cCNavNodeInterface2.getPath();
            int n = cCNavNodeInterface.getLevel();
            return n + 1 >= cCNavNodeInterfaceArray.length ? cCNavNodeInterface2 : cCNavNodeInterfaceArray[n + 1];
        }
        cCNavNodeInterface2 = (CCNavNodeInterface)cCNavNodeInterface.getChildren().get(0);
        this.model.setSelectedNode(cCNavNodeInterface2);
        return cCNavNodeInterface2;
    }

    private void appendCurrTabMessage(CCNavNodeInterface cCNavNodeInterface) {
        this.buffer.append(HtmlUtil.escape((String)(this.getTagMessage("tab.currTab") + " " + this.getMessage(cCNavNodeInterface.getLabel()))));
    }

    private void appendSkipTagAltText(CCNavNodeInterface cCNavNodeInterface) {
        if (cCNavNodeInterface != null) {
            this.skipTagAltText.append(": ").append(this.getMessage(cCNavNodeInterface.getLabel()));
        }
    }

    private void appendDivider(String string, String string2, String string3) {
        this.buffer.append("<td>").append(CCTabsTag.getImageHTMLString(string, string2, string3)).append("</td>\n");
    }

    private void appendLevel1Gutter(int n, String string) throws JspException {
        this.buffer.append("<td class=\"").append(string).append("\">").append(CCTabsTag.getImageHTMLString(CCImage.DOT, 1, n)).append("</td>\n");
    }

    private int getTabDepth(CCNavNodeInterface cCNavNodeInterface) {
        int n = cCNavNodeInterface.getNumChildren();
        if (n < 1) {
            return 1;
        }
        return cCNavNodeInterface.getNumDescendants() > n ? 3 : 2;
    }

    private void appendColSpanAttribute(int n) {
        if (n > 1) {
            this.buffer.append(" colspan=\"").append(n + "\"");
        }
    }

    private void appendTabSpacer(int n) throws JspException {
        this.buffer.append("<td>").append(CCTabsTag.getImageHTMLString(CCImage.DOT, 1, n)).append("</td>\n");
    }

    public String getTarget() {
        return (String)this.getValue(ATTRIB_TARGET);
    }

    public void setTarget(String string) {
        this.setValue(ATTRIB_TARGET, string);
    }

    public String getType() {
        String string = (String)this.getValue(ATTRIB_TYPE);
        if (string != null && string.equalsIgnoreCase(TYPE_MINI)) {
            return TYPE_MINI;
        }
        return TYPE_DEFAULT;
    }

    public void setType(String string) {
        if (string != null && (string.equalsIgnoreCase(TYPE_MINI) || string.equalsIgnoreCase(TYPE_DEFAULT))) {
            this.setValue(ATTRIB_TYPE, string);
        }
    }

    public String getSubmitFormData() {
        return this.getValue(ATTRIB_SUBMITFORMDATA) != null ? (String)this.getValue(ATTRIB_SUBMITFORMDATA) : "false";
    }

    public void setSubmitFormData(String string) {
        if (string != null && !string.toLowerCase().equals("true") && !string.toLowerCase().equals("false")) {
            CCDebug.trace1("Invalid parameter: " + string);
            return;
        }
        this.setValue(ATTRIB_SUBMITFORMDATA, string);
    }
}

