/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.view.datetime;

import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.util.HtmlUtil;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.iplanet.jato.view.html.OptionList;
import com.iplanet.jato.view.html.TextField;
import com.sun.web.ui.common.CCDebug;
import com.sun.web.ui.common.CCImage;
import com.sun.web.ui.common.CCStateData;
import com.sun.web.ui.model.CCDateTimeModelInterface;
import com.sun.web.ui.view.alert.CCAlertInline;
import com.sun.web.ui.view.datetime.CCDateTimeBase;
import com.sun.web.ui.view.html.CCButton;
import com.sun.web.ui.view.html.CCDropDownMenu;
import com.sun.web.ui.view.html.CCHref;
import java.io.IOException;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;

public class CCDateTime
extends CCDateTimeBase
implements CCStateData {
    public static final String DEFAULT_HREF = "defaultHref";
    public static final String DECREASE_BUTTON = "decrease";
    public static final String INCREASE_BUTTON = "increase";
    public static final String MONTH_COMBO = "monthMenu";
    public static final String YEAR_COMBO = "yearMenu";
    public static final String START_DATE_TEXT = "startDate";
    public static final String REPEAT_INTERVAL_COMBO = "repeatIntervalMenu";
    public static final String START_HOUR_COMBO = "startHour";
    public static final String START_MINUTE_COMBO = "startMinute";
    public static final String END_HOUR_COMBO = "endHour";
    public static final String END_MINUTE_COMBO = "endMinute";
    public static final String REPEAT_LIMITUNIT_COMBO = "repeatLimitUnit";
    public static final String REPEAT_LIMITPERIOD_TEXT = "repeatLimitPeriod";
    public static final String REPEAT_INTERVAL_HREF = "repeatIntervalHref";
    public static final String CHILD_PREVIEW_BUTTON = "previewButton";
    public static final String CHILD_ALERT = "Alert";
    public static final String CHILD_DATE_HREF = "DateHREF";
    public static final String MONTH_PREFIX = "month";
    public static final String INPUT_ERROR_DATE = "datetime.dateError";
    public static final String INPUT_ERROR_TIME = "datetime.timeError";
    public static final String INPUT_ERROR_LIMIT = "datetime.limitError";
    private final String STATE_DATA = this.getQualifiedName() + ".stateData";
    private final String INTERVAL_CHANGE = this.getQualifiedName() + ".intervalChanged";
    private final String PREVIEW_CLICKED = this.getQualifiedName() + ".previewClicked";
    private final int DEFAULT_REPEAT_INTERVAL_INDEX = 0;
    private final String START_DATE = "startDateKey";
    private final String END_DATE = "endDateKey";
    private final String REPEAT_INTERVAL = "repeatIntervalKey";
    private final String REPEAT_LIMITUNIT = "repeatLimitUnitKey";
    private final String REPEAT_LIMITPERIOD = "repeatLimitPeriodKey";
    private String[] monthLabels;
    private int currentYear;
    private int startYear = -1;
    private int endYear = -1;
    private int yearsInCalendar = 10;
    private final int MONTHS_ONE_YEAR = 12;
    private final int MINUTE_INCREASING = 5;
    private final int MINUTES_ONE_HOUR = 60;
    private final int HOURS_ONE_DAY = 24;
    private final int DAYS_ONE_WEEK = 7;
    private final int MS_ONE_MINUTE = 60000;

    public CCDateTime(ContainerView containerView, CCDateTimeModelInterface cCDateTimeModelInterface, String string) {
        super(containerView, cCDateTimeModelInterface, string);
        String[] stringArray = this.dateFormat.getDateFormatSymbols().getMonths();
        if (stringArray[12].trim().length() == 0) {
            this.monthLabels = new String[12];
            for (int i = 0; i < 12; ++i) {
                this.monthLabels[i] = stringArray[i];
            }
        } else {
            this.monthLabels = stringArray;
        }
        Calendar calendar = this.getCalendar();
        this.currentYear = calendar.get(1);
        if (cCDateTimeModelInterface.getStartDateTime() != null) {
            calendar.setTime(cCDateTimeModelInterface.getStartDateTime());
        }
        this.startYear = cCDateTimeModelInterface.getStartYear() != -1 ? cCDateTimeModelInterface.getStartYear() : calendar.get(1);
        if (cCDateTimeModelInterface.getEndYear() != -1) {
            this.endYear = cCDateTimeModelInterface.getEndYear();
        }
        if (this.endYear == -1) {
            if (this.startYear < this.currentYear) {
                this.yearsInCalendar = this.currentYear - this.startYear + 10;
            }
        } else if (this.startYear < this.endYear) {
            this.yearsInCalendar = this.endYear - this.startYear + 1;
        }
        this.registerChildren();
    }

    protected void registerChildren() {
        this.registerChild(DECREASE_BUTTON, CCButton.class);
        this.registerChild(INCREASE_BUTTON, CCButton.class);
        this.registerChild(MONTH_COMBO, CCDropDownMenu.class);
        this.registerChild(YEAR_COMBO, CCDropDownMenu.class);
        this.registerChild(START_DATE_TEXT, TextField.class);
        this.registerChild(START_HOUR_COMBO, CCDropDownMenu.class);
        this.registerChild(START_MINUTE_COMBO, CCDropDownMenu.class);
        this.registerChild(END_HOUR_COMBO, CCDropDownMenu.class);
        this.registerChild(END_MINUTE_COMBO, CCDropDownMenu.class);
        this.registerChild(REPEAT_INTERVAL_COMBO, CCDropDownMenu.class);
        this.registerChild(REPEAT_LIMITUNIT_COMBO, CCDropDownMenu.class);
        this.registerChild(REPEAT_LIMITPERIOD_TEXT, TextField.class);
        this.registerChild(DEFAULT_HREF, CCHref.class);
        this.registerChild(REPEAT_INTERVAL_HREF, CCHref.class);
        this.registerChild(CHILD_ALERT, CCAlertInline.class);
        this.registerChild(CHILD_PREVIEW_BUTTON, CCButton.class);
        this.registerChild(CHILD_DATE_HREF, CCHref.class);
    }

    protected View createChild(String string) {
        if (string.equals(DECREASE_BUTTON)) {
            CCButton cCButton = new CCButton((ContainerView)this, string, null);
            cCButton.setType("icon");
            cCButton.setSrc(CCImage.DATETIME_BACKWARD);
            cCButton.setAlt("datetime.backward");
            return cCButton;
        }
        if (string.equals(INCREASE_BUTTON)) {
            CCButton cCButton = new CCButton((ContainerView)this, string, null);
            cCButton.setType("icon");
            cCButton.setSrc(CCImage.DATETIME_FORWARD);
            cCButton.setAlt("datetime.forward");
            return cCButton;
        }
        if (string.equals(MONTH_COMBO)) {
            CCDropDownMenu cCDropDownMenu = new CCDropDownMenu((ContainerView)this, string, null);
            String[] stringArray = new String[this.monthLabels.length];
            for (int i = 0; i < this.monthLabels.length; ++i) {
                stringArray[i] = MONTH_PREFIX + i;
            }
            OptionList optionList = new OptionList(this.monthLabels, stringArray);
            cCDropDownMenu.setOptions(optionList);
            return cCDropDownMenu;
        }
        if (string.equals(YEAR_COMBO)) {
            String[] stringArray = new String[this.yearsInCalendar];
            for (int i = 0; i < this.yearsInCalendar; ++i) {
                stringArray[i] = Integer.toString(this.startYear + i);
            }
            CCDropDownMenu cCDropDownMenu = new CCDropDownMenu((ContainerView)this, string, null);
            OptionList optionList = new OptionList(stringArray, stringArray);
            cCDropDownMenu.setOptions(optionList);
            return cCDropDownMenu;
        }
        if (string.equals(START_HOUR_COMBO) || string.equals(END_HOUR_COMBO)) {
            String[] stringArray = new String[25];
            stringArray[0] = "  ";
            for (int i = 0; i < 24; ++i) {
                stringArray[i + 1] = i < 10 ? "0" + i : Integer.toString(i);
            }
            CCDropDownMenu cCDropDownMenu = new CCDropDownMenu((ContainerView)this, string, null);
            cCDropDownMenu.setOptions(new OptionList(stringArray, stringArray));
            return cCDropDownMenu;
        }
        if (string.equals(START_MINUTE_COMBO) || string.equals(END_MINUTE_COMBO)) {
            int n = 12;
            String[] stringArray = new String[n + 1];
            stringArray[0] = "  ";
            for (int i = 0; i < n; ++i) {
                int n2 = i * 5;
                stringArray[i + 1] = n2 < 10 ? "0" + n2 : Integer.toString(n2);
            }
            CCDropDownMenu cCDropDownMenu = new CCDropDownMenu((ContainerView)this, string, null);
            cCDropDownMenu.setOptions(new OptionList(stringArray, stringArray));
            return cCDropDownMenu;
        }
        if (string.equals(REPEAT_INTERVAL_COMBO)) {
            CCDropDownMenu cCDropDownMenu = new CCDropDownMenu((ContainerView)this, string, null);
            return cCDropDownMenu;
        }
        if (string.equals(START_DATE_TEXT)) {
            TextField textField = new TextField((ContainerView)this, string, null);
            return textField;
        }
        if (string.equals(REPEAT_LIMITUNIT_COMBO)) {
            CCDropDownMenu cCDropDownMenu = new CCDropDownMenu((ContainerView)this, string, null);
            return cCDropDownMenu;
        }
        if (string.equals(REPEAT_LIMITPERIOD_TEXT)) {
            TextField textField = new TextField((ContainerView)this, string, null);
            return textField;
        }
        if (string.equals(DEFAULT_HREF) || string.equals(REPEAT_INTERVAL_HREF) || string.equals(CHILD_DATE_HREF)) {
            CCHref cCHref = new CCHref((ContainerView)this, string, null);
            return cCHref;
        }
        if (string.equals(CHILD_ALERT)) {
            return new CCAlertInline((ContainerView)this, string, null);
        }
        if (string.equals(CHILD_PREVIEW_BUTTON)) {
            CCButton cCButton = new CCButton((ContainerView)this, string, "datetime.preview");
            cCButton.setType("secondaryMini");
            return cCButton;
        }
        throw new IllegalArgumentException("Invalid child name [" + string + "]");
    }

    public void beginDisplay(DisplayEvent displayEvent) throws ModelControlException {
        Object object;
        int n;
        super.beginDisplay(displayEvent);
        Boolean bl = (Boolean)this.getParentViewBean().getPageSessionAttribute(this.INTERVAL_CHANGE);
        this.restoreStateData();
        if (bl != null && bl.booleanValue()) {
            this.getParentViewBean().setPageSessionAttribute(this.INTERVAL_CHANGE, null);
            return;
        }
        bl = (Boolean)this.getParentViewBean().getPageSessionAttribute(this.PREVIEW_CLICKED);
        if (bl != null && bl.booleanValue()) {
            this.getParentViewBean().setPageSessionAttribute(this.PREVIEW_CLICKED, null);
            if (!this.validateDataInput()) {
                return;
            }
        }
        HashMap hashMap = (HashMap)this.getStateData();
        Calendar calendar = this.getCalendar();
        Date date = this.model.getStartDateTime();
        if (date != null) {
            calendar.setTime(date);
        }
        try {
            n = hashMap.get(MONTH_COMBO) != null ? Integer.parseInt((String)hashMap.get(MONTH_COMBO)) : calendar.get(2);
            this.setDisplayFieldValue(MONTH_COMBO, MONTH_PREFIX + n);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            int n2 = n = hashMap.get(YEAR_COMBO) != null ? Integer.parseInt((String)hashMap.get(YEAR_COMBO)) : calendar.get(1);
            if (n >= this.startYear && n < this.startYear + this.yearsInCalendar) {
                this.setDisplayFieldValue(YEAR_COMBO, Integer.toString(n));
            } else {
                this.setDisplayFieldValue(YEAR_COMBO, Integer.toString(this.endYear));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        String string = "  ";
        String string2 = "  ";
        String string3 = "";
        if (date != null) {
            int n3;
            try {
                n3 = hashMap.get(START_HOUR_COMBO) != null ? Integer.parseInt((String)hashMap.get(START_HOUR_COMBO)) : calendar.get(11);
                string = n3 < 10 ? "0" + n3 : Integer.toString(n3);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                int n4 = n3 = hashMap.get(START_MINUTE_COMBO) != null ? Integer.parseInt((String)hashMap.get(START_MINUTE_COMBO)) : calendar.get(12);
                if (n3 % 5 != 0) {
                    n3 = n3 - n3 % 5 + 5;
                }
                if (n3 == 60) {
                    n3 = 0;
                }
                string2 = n3 < 10 ? "0" + n3 : Integer.toString(n3);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            string3 = hashMap.get(START_DATE_TEXT) != null ? (String)hashMap.get(START_DATE_TEXT) : this.dateFormat.format(calendar.getTime());
        }
        this.setDisplayFieldValue(START_HOUR_COMBO, string);
        this.setDisplayFieldValue(START_MINUTE_COMBO, string2);
        this.setDisplayFieldValue(START_DATE_TEXT, string3);
        String string4 = "  ";
        String string5 = "  ";
        Date date2 = this.model.getEndTime();
        if (date2 != null) {
            calendar.setTime(date2);
        }
        if (hashMap.get(END_HOUR_COMBO) != null) {
            int n5;
            try {
                n5 = hashMap.get(END_HOUR_COMBO) != null ? Integer.parseInt((String)hashMap.get(END_HOUR_COMBO)) : calendar.get(11);
                string4 = n5 < 10 ? "0" + n5 : Integer.toString(n5);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                int n6 = n5 = hashMap.get(END_MINUTE_COMBO) != null ? Integer.parseInt((String)hashMap.get(END_MINUTE_COMBO)) : calendar.get(12);
                if (n5 % 5 != 0) {
                    n5 = n5 - n5 % 5 + 5;
                }
                if (n5 == 60) {
                    n5 = 0;
                }
                string5 = n5 < 10 ? "0" + n5 : Integer.toString(n5);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.setDisplayFieldValue(END_HOUR_COMBO, string4);
        this.setDisplayFieldValue(END_MINUTE_COMBO, string5);
        String string6 = null;
        if (hashMap.get(REPEAT_INTERVAL_COMBO) != null) {
            string6 = (String)hashMap.get(REPEAT_INTERVAL_COMBO);
            this.updateRepeatInterval();
        } else {
            string6 = this.model.getSelectedRepeatIntervalName();
            if (string6 != null) {
                object = this.model.getRepeatIntervals();
                for (int i = 0; i < ((String[])object).length; ++i) {
                    if (!string6.equals(object[i])) continue;
                    string6 = "interval" + i;
                    break;
                }
            } else {
                string6 = "interval0";
            }
        }
        this.setDisplayFieldValue(REPEAT_INTERVAL_COMBO, string6);
        try {
            object = hashMap.get(REPEAT_LIMITUNIT_COMBO) != null ? (String)hashMap.get(REPEAT_LIMITUNIT_COMBO) : "limitUnit" + Integer.toString(this.model.getRepeatLimitUnit());
            this.setDisplayFieldValue(REPEAT_LIMITUNIT_COMBO, object);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        object = hashMap.get(REPEAT_LIMITPERIOD_TEXT) != null ? (String)hashMap.get(REPEAT_LIMITPERIOD_TEXT) : Integer.toString(this.model.getRepeatLimitPeriod());
        try {
            Object object2 = Integer.parseInt((String)object) != -1 ? object : "";
            this.setDisplayFieldValue(REPEAT_LIMITPERIOD_TEXT, object2);
        }
        catch (NumberFormatException numberFormatException) {
            this.setDisplayFieldValue(REPEAT_LIMITPERIOD_TEXT, object);
        }
    }

    public Map getStateData() {
        HashMap hashMap;
        ViewBean viewBean = this.getParentViewBean();
        HashMap hashMap2 = hashMap = viewBean.getPageSessionAttribute(this.STATE_DATA) != null ? (HashMap)viewBean.getPageSessionAttribute(this.STATE_DATA) : new HashMap();
        if (this.getDisplayFieldValue(MONTH_COMBO) != null) {
            hashMap.put(MONTH_COMBO, this.getDisplayFieldValue(MONTH_COMBO));
        }
        if (this.getDisplayFieldValue(YEAR_COMBO) != null) {
            hashMap.put(YEAR_COMBO, this.getDisplayFieldValue(YEAR_COMBO));
        }
        if (this.getDisplayFieldValue(START_DATE_TEXT) != null) {
            hashMap.put(START_DATE_TEXT, this.getDisplayFieldValue(START_DATE_TEXT));
        }
        if (this.getDisplayFieldValue(START_HOUR_COMBO) != null) {
            hashMap.put(START_HOUR_COMBO, this.getDisplayFieldValue(START_HOUR_COMBO));
        }
        if (this.getDisplayFieldValue(START_MINUTE_COMBO) != null) {
            hashMap.put(START_MINUTE_COMBO, this.getDisplayFieldValue(START_MINUTE_COMBO));
        }
        if (this.getDisplayFieldValue(END_HOUR_COMBO) != null) {
            hashMap.put(END_HOUR_COMBO, this.getDisplayFieldValue(END_HOUR_COMBO));
        }
        if (this.getDisplayFieldValue(END_MINUTE_COMBO) != null) {
            hashMap.put(END_MINUTE_COMBO, this.getDisplayFieldValue(END_MINUTE_COMBO));
        }
        if (this.getDisplayFieldValue(REPEAT_INTERVAL_COMBO) != null) {
            hashMap.put(REPEAT_INTERVAL_COMBO, this.getDisplayFieldValue(REPEAT_INTERVAL_COMBO));
        }
        if (this.getDisplayFieldValue(REPEAT_LIMITUNIT_COMBO) != null) {
            hashMap.put(REPEAT_LIMITUNIT_COMBO, this.getDisplayFieldValue(REPEAT_LIMITUNIT_COMBO));
        }
        if (this.getDisplayFieldValue(REPEAT_LIMITPERIOD_TEXT) != null) {
            hashMap.put(REPEAT_LIMITPERIOD_TEXT, this.getDisplayFieldValue(REPEAT_LIMITPERIOD_TEXT));
        }
        if (hashMap.get("startDateKey") == null) {
            hashMap.put("startDateKey", this.model.getStartDateTime());
        }
        if (hashMap.get("endDateKey") == null) {
            hashMap.put("endDateKey", this.model.getEndTime());
        }
        if (hashMap.get("repeatIntervalKey") == null) {
            hashMap.put("repeatIntervalKey", this.model.getSelectedRepeatIntervalName());
        }
        if (hashMap.get("repeatLimitUnitKey") == null) {
            hashMap.put("repeatLimitUnitKey", new Integer(this.model.getRepeatLimitUnit()));
        }
        if (hashMap.get("repeatLimitPeriodKey") == null) {
            hashMap.put("repeatLimitPeriodKey", new Integer(this.model.getRepeatLimitPeriod()));
        }
        return hashMap;
    }

    public void setStateData() {
        this.restoreStateData();
    }

    public void setStateData(Map map) {
        this.resetStateData();
        if (map == null) {
            CCDebug.trace1("State data map is null");
            return;
        }
        this.setDisplayFieldValue(MONTH_COMBO, map.get(MONTH_COMBO));
        this.setDisplayFieldValue(YEAR_COMBO, map.get(YEAR_COMBO));
        this.setDisplayFieldValue(START_DATE_TEXT, map.get(START_DATE_TEXT));
        this.setDisplayFieldValue(START_HOUR_COMBO, map.get(START_HOUR_COMBO));
        this.setDisplayFieldValue(START_MINUTE_COMBO, map.get(START_MINUTE_COMBO));
        this.setDisplayFieldValue(END_HOUR_COMBO, map.get(END_HOUR_COMBO));
        this.setDisplayFieldValue(END_MINUTE_COMBO, map.get(END_MINUTE_COMBO));
        this.setDisplayFieldValue(REPEAT_INTERVAL_COMBO, map.get(REPEAT_INTERVAL_COMBO));
        this.setDisplayFieldValue(REPEAT_LIMITUNIT_COMBO, map.get(REPEAT_LIMITUNIT_COMBO));
        this.setDisplayFieldValue(REPEAT_LIMITPERIOD_TEXT, map.get(REPEAT_LIMITPERIOD_TEXT));
        this.model.setStartDateTime((Date)map.get("startDateKey"));
        this.model.setEndTime((Date)map.get("endDateKey"));
        String string = (String)map.get("repeatIntervalKey");
        this.model.setSelectedRepeatIntervalName(string.substring("interval".length()));
        String string2 = (String)map.get("repeatLimitUnitKey");
        string2 = string2.substring("limitUnit".length());
        try {
            this.model.setRepeatLimitUnit(Integer.parseInt(string2));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        String string3 = (String)map.get("repeatLimitPeriodKey");
        try {
            this.model.setRepeatLimitPeriod(Integer.parseInt(string3));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void reset() {
        this.resetStateData();
    }

    public void resetStateData() {
        this.setDisplayFieldValue(MONTH_COMBO, null);
        this.setDisplayFieldValue(YEAR_COMBO, null);
        this.setDisplayFieldValue(START_DATE_TEXT, null);
        this.setDisplayFieldValue(START_HOUR_COMBO, null);
        this.setDisplayFieldValue(START_MINUTE_COMBO, null);
        this.setDisplayFieldValue(END_HOUR_COMBO, null);
        this.setDisplayFieldValue(END_MINUTE_COMBO, null);
        this.setDisplayFieldValue(REPEAT_INTERVAL_COMBO, null);
        this.setDisplayFieldValue(REPEAT_LIMITUNIT_COMBO, null);
        this.setDisplayFieldValue(REPEAT_LIMITPERIOD_TEXT, null);
        this.getParentViewBean().setPageSessionAttribute(this.STATE_DATA, null);
    }

    public void restoreStateData() {
        HashMap hashMap = (HashMap)this.getStateData();
        if (hashMap.get("startDateKey") != null) {
            this.model.setStartDateTime((Date)hashMap.get("startDateKey"));
        }
        if (hashMap.get("endDateKey") != null) {
            this.model.setEndTime((Date)hashMap.get("endDateKey"));
        }
        if (hashMap.get("repeatIntervalKey") != null) {
            this.model.setSelectedRepeatIntervalName((String)hashMap.get("repeatIntervalKey"));
        }
        if (hashMap.get("repeatLimitUnitKey") != null) {
            this.model.setRepeatLimitUnit((Integer)hashMap.get("repeatLimitUnitKey"));
        }
        if (hashMap.get("repeatLimitPeriodKey") != null) {
            this.model.setRepeatLimitPeriod((Integer)hashMap.get("repeatLimitPeriodKey"));
        }
        this.getParentViewBean().setPageSessionAttribute(this.STATE_DATA, (Serializable)hashMap);
    }

    public void handleDateHREFRequest(RequestInvocationEvent requestInvocationEvent) throws ServletException, IOException, ParseException {
        CCHref cCHref = (CCHref)this.getChild(CHILD_DATE_HREF);
        String string = (String)cCHref.getValue();
        this.setDisplayFieldValue(START_DATE_TEXT, string);
        HashMap hashMap = (HashMap)this.getStateData();
        hashMap.put("startDateKey", this.dateFormat.parse(string));
        this.getParentViewBean().setPageSessionAttribute(this.STATE_DATA, (Serializable)hashMap);
        this.getParentViewBean().forwardTo(this.getRequestContext());
    }

    public void handleDecreaseRequest(RequestInvocationEvent requestInvocationEvent) throws ServletException, IOException {
        CCDropDownMenu cCDropDownMenu = (CCDropDownMenu)this.getChild(MONTH_COMBO);
        CCDropDownMenu cCDropDownMenu2 = (CCDropDownMenu)this.getChild(YEAR_COMBO);
        String string = (String)cCDropDownMenu.getValue();
        int n = new Integer(string = string.substring(MONTH_PREFIX.length()));
        if (n == 0) {
            int n2 = new Integer(cCDropDownMenu2.getValue().toString());
            if (n2 != this.startYear) {
                cCDropDownMenu2.setValue(Integer.toString(n2 - 1));
                n = this.monthLabels.length;
            } else {
                n = 1;
            }
        }
        cCDropDownMenu.setValue(MONTH_PREFIX + (n - 1));
        ViewBean viewBean = this.getParentViewBean();
        viewBean.forwardTo(this.getRequestContext());
    }

    public void handleIncreaseRequest(RequestInvocationEvent requestInvocationEvent) throws ServletException, IOException {
        CCDropDownMenu cCDropDownMenu = (CCDropDownMenu)this.getChild(MONTH_COMBO);
        CCDropDownMenu cCDropDownMenu2 = (CCDropDownMenu)this.getChild(YEAR_COMBO);
        String string = (String)cCDropDownMenu.getValue();
        int n = new Integer(string = string.substring(MONTH_PREFIX.length()));
        if (n == this.monthLabels.length - 1) {
            int n2 = new Integer(cCDropDownMenu2.getValue().toString());
            if (n2 != this.startYear + this.yearsInCalendar - 1) {
                cCDropDownMenu2.setValue(Integer.toString(n2 + 1));
                n = -1;
            } else {
                n = this.monthLabels.length - 2;
            }
        }
        cCDropDownMenu.setValue(MONTH_PREFIX + (n + 1));
        ViewBean viewBean = this.getParentViewBean();
        viewBean.forwardTo(this.getRequestContext());
    }

    public void handleDefaultHrefRequest(RequestInvocationEvent requestInvocationEvent) throws ServletException, IOException {
        Object object;
        if (this.getDisplayFieldValue(REPEAT_INTERVAL_COMBO) != null) {
            object = (HashMap)this.getStateData();
            this.getParentViewBean().setPageSessionAttribute(this.STATE_DATA, (Serializable)object);
        }
        object = this.getParentViewBean();
        object.forwardTo(this.getRequestContext());
    }

    public void handleRepeatIntervalHrefRequest(RequestInvocationEvent requestInvocationEvent) throws ServletException, IOException {
        ViewBean viewBean = this.getParentViewBean();
        viewBean.setPageSessionAttribute(this.INTERVAL_CHANGE, (Serializable)new Boolean(true));
        viewBean.forwardTo(this.getRequestContext());
    }

    public void handlePreviewButtonRequest(RequestInvocationEvent requestInvocationEvent) throws ServletException, IOException {
        ViewBean viewBean = this.getParentViewBean();
        viewBean.setPageSessionAttribute(this.PREVIEW_CLICKED, (Serializable)new Boolean(true));
        viewBean.forwardTo(this.getRequestContext());
    }

    private String updateRepeatInterval() {
        String string = (String)this.getDisplayFieldValue(REPEAT_INTERVAL_COMBO);
        if (string != null) {
            String[] stringArray = this.model.getRepeatIntervals();
            String string2 = HtmlUtil.escape((String)(string = string.substring("interval".length())));
            int n = new Integer(string2);
            if (n < 0 || n >= this.model.getRepeatIntervals().length) {
                n = 0;
            }
            this.model.setSelectedRepeatIntervalName(stringArray[n]);
            int n2 = this.model.getRepeatIntervalUnit(stringArray[n]);
            int n3 = -1;
            int n4 = this.model.getType();
            if (n4 == 0 || n4 == 3) {
                String string3;
                if (n2 != 5) {
                    string3 = (String)this.getDisplayFieldValue(REPEAT_LIMITPERIOD_TEXT);
                    if (string3 == null) {
                        string3 = "";
                    }
                    if (string3.trim().length() != 0) {
                        try {
                            n3 = new Integer(string3);
                            if (n3 <= 0) {
                                return INPUT_ERROR_LIMIT;
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            return INPUT_ERROR_LIMIT;
                        }
                    }
                }
                if ((string3 = (String)this.getDisplayFieldValue(REPEAT_LIMITUNIT_COMBO)) != null) {
                    string3 = string3.substring("limitUnit".length());
                    this.model.setRepeatLimitUnit(new Integer(string3));
                }
            }
            this.model.setRepeatLimitPeriod(n3);
        }
        return null;
    }

    public boolean validateDataInput() {
        Object object;
        Object object2;
        Object object3;
        String[] stringArray = this.model.getRepeatIntervals();
        TextField textField = (TextField)this.getChild(START_DATE_TEXT);
        String string = textField.getValue() != null ? (String)textField.getValue() : "";
        Calendar calendar = this.getCalendar();
        int n = 0;
        if ((string = this.validateDateString(string)) == null) {
            this.displayAlertError(INPUT_ERROR_DATE);
            return false;
        }
        this.setDisplayFieldValue(START_DATE_TEXT, string);
        try {
            calendar.setTime(this.dateFormat.parse(string));
        }
        catch (ParseException parseException) {
            this.displayAlertError(INPUT_ERROR_DATE);
            return false;
        }
        if (this.model.getType() == 2) {
            this.model.setStartDateTime(calendar.getTime());
            return true;
        }
        CCDropDownMenu cCDropDownMenu = (CCDropDownMenu)this.getChild(START_HOUR_COMBO);
        CCDropDownMenu cCDropDownMenu2 = (CCDropDownMenu)this.getChild(START_MINUTE_COMBO);
        String string2 = (String)cCDropDownMenu.getValue();
        String string3 = (String)cCDropDownMenu2.getValue();
        if (string2 == null || string3 == null || string2.equals("  ") || string3.equals("  ")) {
            this.displayAlertError(INPUT_ERROR_TIME);
            return false;
        }
        int n2 = new Integer(string2);
        int n3 = new Integer(string3);
        calendar.set(11, n2);
        calendar.set(12, n3);
        this.model.setStartDateTime(calendar.getTime());
        String string4 = this.updateRepeatInterval();
        if (this.model.getType() == 0 || this.model.getType() == 3) {
            int n4;
            object3 = (CCDropDownMenu)this.getChild(END_HOUR_COMBO);
            object2 = (CCDropDownMenu)this.getChild(END_MINUTE_COMBO);
            string2 = (String)object3.getValue();
            string3 = (String)object2.getValue();
            if (string2 != null && string3 != null && !string2.equals("  ") && !string3.equals("  ")) {
                int n5 = new Integer(string2);
                n4 = new Integer(string3);
                if (n2 > n5 || n2 == n5 && n3 > n4) {
                    this.displayAlertError("datetime.startLTEndError");
                    return false;
                }
                calendar.set(11, n5);
                calendar.set(12, n4);
                this.model.setEndTime(calendar.getTime());
            } else if (string2 != null && string3 != null && string2.equals("  ") && string3.equals("  ")) {
                this.model.setEndTime(null);
            } else {
                this.displayAlertError("datetime.endTimeError");
                return false;
            }
            if (string4 != null) {
                this.displayAlertError(string4);
                return false;
            }
            object = this.model.getRepeatIntervals();
            n4 = this.model.getRepeatIntervalUnit(object[n]);
            if (n4 == 3) {
                for (int i = 0; i < this.model.getRepeatLimitPeriod(); ++i) {
                    Calendar calendar2 = (Calendar)calendar.clone();
                    calendar2.add(2, i);
                    if (calendar.get(5) <= calendar2.get(5)) continue;
                    this.displayAlertWarning("datetime.dateWarning");
                    break;
                }
            }
        }
        object3 = (HashMap)this.getStateData();
        ((HashMap)object3).put("startDateKey", null);
        ((HashMap)object3).put("endDateKey", null);
        ((HashMap)object3).put("repeatIntervalKey", null);
        ((HashMap)object3).put("repeatLimitUnitKey", null);
        ((HashMap)object3).put("repeatLimitPeriodKey", null);
        object2 = String.valueOf(calendar.get(2));
        object = String.valueOf(calendar.get(1));
        ((HashMap)object3).put(MONTH_COMBO, String.valueOf(object2));
        ((HashMap)object3).put(YEAR_COMBO, String.valueOf(object));
        this.setDisplayFieldValue(MONTH_COMBO, MONTH_PREFIX + (String)object2);
        this.setDisplayFieldValue(YEAR_COMBO, String.valueOf(object));
        this.getParentViewBean().setPageSessionAttribute(this.STATE_DATA, (Serializable)object3);
        return true;
    }

    public boolean isOneDayScheduled(Date date) {
        Date date2 = this.model.getStartDateTime();
        if (date2 == null) {
            return false;
        }
        Calendar calendar = this.getCalendar();
        calendar.setTime(date2);
        int n = calendar.get(2);
        int n2 = calendar.get(5);
        int n3 = calendar.get(1);
        calendar.setTime(date);
        if (n == calendar.get(2) && n2 == calendar.get(5) && n3 == calendar.get(1)) {
            return true;
        }
        int n4 = this.model.getType();
        if (n4 == 2 || n4 == 4) {
            return false;
        }
        if (date.before(date2)) {
            return false;
        }
        calendar.setTime(date2);
        int n5 = this.model.getRepeatLimitUnit();
        int n6 = this.model.getRepeatLimitPeriod();
        if (n5 != -1 && n6 != -1) {
            if (n5 == 0) {
                calendar.add(11, n6 - 1);
                calendar.set(12, 59);
            } else if (n5 == 1) {
                calendar.add(5, n6 - 1);
                calendar.set(11, 23);
                calendar.set(12, 59);
            } else if (n5 == 2) {
                n6 = n6 * 7 - 1;
                calendar.add(5, n6);
                calendar.set(11, 23);
                calendar.set(12, 59);
            } else if (n5 == 3) {
                int n7 = calendar.get(5);
                calendar.add(2, n6);
                if (n7 == calendar.get(5)) {
                    calendar.add(5, -1);
                }
                calendar.set(11, 23);
                calendar.set(12, 59);
            }
            if (calendar.getTime().before(date)) {
                return false;
            }
        }
        calendar.setTime(date2);
        String string = this.model.getSelectedRepeatIntervalName();
        if (string == null) {
            string = this.model.getRepeatIntervals()[0];
        }
        int n8 = this.model.getRepeatIntervalUnit(string);
        int n9 = this.model.getRepeatIntervalAccount(string);
        if (n8 == 1 || n8 == 0 || n8 == 2) {
            long l = 0L;
            if (n8 == 0) {
                if (n9 <= 24) {
                    return true;
                }
                l = n9 * 60 * 60000;
            } else if (n8 == 1) {
                l = n9 * 24 * 60 * 60000;
            } else if (n8 == 2) {
                Calendar calendar2 = this.getCalendar();
                calendar2.setTime(date);
                return calendar.get(7) == calendar2.get(7);
            }
            Calendar calendar3 = this.getCalendar();
            calendar3.set(1, 1970);
            calendar3.set(2, 0);
            calendar3.set(5, 1);
            calendar3.set(11, 0);
            calendar3.set(12, 0);
            calendar3.set(13, 0);
            calendar3.set(14, 0);
            long l2 = calendar3.getTime().getTime();
            long l3 = date2.getTime() - l2;
            long l4 = date.getTime() - l2;
            long l5 = 86400000L;
            do {
                if (l4 / l5 != (l3 += l) / l5) continue;
                return true;
            } while (l3 <= l4);
            return false;
        }
        if (n8 == 4) {
            calendar.setTime(date);
            int n10 = calendar.get(7);
            int n11 = 0;
            if (n10 == 1) {
                n11 = n9 & 0x40;
            } else if (n10 == 2) {
                n11 = n9 & 1;
            } else if (n10 == 3) {
                n11 = n9 & 2;
            } else if (n10 == 4) {
                n11 = n9 & 4;
            } else if (n10 == 5) {
                n11 = n9 & 8;
            } else if (n10 == 6) {
                n11 = n9 & 0x10;
            } else if (n10 == 7) {
                n11 = n9 & 0x20;
            }
            return n11 != 0;
        }
        if (n8 == 3) {
            calendar.setTime(date);
            n2 = calendar.get(5);
            calendar.setTime(date2);
            int n12 = calendar.get(5);
            return n2 == n12;
        }
        return n8 != 5;
    }

    private void displayAlertError(String string) {
        CCAlertInline cCAlertInline = (CCAlertInline)this.getChild(CHILD_ALERT);
        cCAlertInline.setValue("error");
        cCAlertInline.setDetail(string);
        cCAlertInline.setSummary("datetime.errorSummary");
    }

    private void displayAlertWarning(String string) {
        CCAlertInline cCAlertInline = (CCAlertInline)this.getChild(CHILD_ALERT);
        cCAlertInline.setValue("warning");
        cCAlertInline.setDetail(string);
        cCAlertInline.setSummary("datetime.warningSummary");
    }
}

