/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.packaging;

import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.solarisprovider.packaging.DirFilter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMDateTime;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt16;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.provider.InstanceProvider;

public class Solaris_Package
implements InstanceProvider {
    private CIMOMHandle cimomhandle = null;
    private ProviderUtility provUtil = null;
    public static final String PROVIDER_NAME = "Solaris_Package";
    public static final String PKGINFO_DIR = "/var/sadm/pkg";
    public static final String PKGINFO_FILE = "pkginfo";
    public static final String PATH_SEP = "/";

    public void initialize(CIMOMHandle cimomhandle) throws CIMException {
        this.cimomhandle = cimomhandle;
        this.provUtil = new ProviderUtility(cimomhandle, PROVIDER_NAME);
    }

    public void cleanup() throws CIMException {
    }

    public CIMObjectPath createInstance(CIMObjectPath op, CIMInstance ci) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public void deleteInstance(CIMObjectPath cp) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public void setInstance(CIMObjectPath op, CIMInstance ci) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public synchronized CIMInstance getInstance(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, CIMClass cc) throws CIMException {
        String pkgName = "";
        CIMInstance ci = null;
        try {
            Enumeration enum1 = op.getKeys().elements();
            while (enum1.hasMoreElements()) {
                CIMProperty cp = (CIMProperty)enum1.nextElement();
                if (!cp.getName().equalsIgnoreCase("name")) continue;
                pkgName = (String)cp.getValue().getValue();
            }
            ci = cc.newInstance();
            if (!this.validatePkgExists(pkgName)) {
                return ci;
            }
            ci.setProperty("Name", new CIMValue((Object)pkgName));
            ci.setProperty("TargetOperatingSystem", new CIMValue((Object)new UnsignedInt16(29)));
            ci.setProperty("Status", new CIMValue((Object)this.GetPkgStatus(pkgName)));
            ci.setProperty("Architecture", new CIMValue((Object)this.GetPkgArchitecture(pkgName)));
            ci.setProperty("Description", new CIMValue((Object)this.GetPkgDescription(pkgName)));
            ci.setProperty("Caption", new CIMValue((Object)this.GetPkgDescription(pkgName)));
            ci.setProperty("Manufacturer", new CIMValue((Object)this.GetPkgVendor(pkgName)));
            ci.setProperty("Category", new CIMValue((Object)this.GetPkgCategory(pkgName)));
            ci.setProperty("Basedir", new CIMValue((Object)this.GetPkgBasedir(pkgName)));
            Vector pkgInfo = this.getPkgInfo(pkgName);
            ci.setProperty("SupportInfo", new CIMValue((Object)this.getPkgInfoValue(pkgInfo, "HOTLINE", pkgName)));
            ci.setProperty("OtherTargetOS", new CIMValue((Object)"none"));
            ci.setProperty("IdentificationCode", new CIMValue((Object)this.getPkgInfoValue(pkgInfo, "PSTAMP", pkgName)));
            Calendar cal = this.convertDate(this.getPkgInfoValue(pkgInfo, "INSTDATE", pkgName));
            CIMDateTime CIMDate = new CIMDateTime(cal);
            ci.setProperty("InstallDate", new CIMValue((Object)CIMDate));
            String version = this.GetPkgVersion(pkgName);
            ci.setProperty("Version", new CIMValue((Object)this.getVersion(version, pkgName)));
            ci.setProperty("BuildNumber", new CIMValue((Object)this.getBuildNumber(version, pkgName)));
        }
        catch (Exception e) {
            this.provUtil.writeLog(2, "LM_10400", "LM_104001", null, null, null, null);
        }
        if (localOnly) {
            ci = ci.localElements();
        }
        return ci.filterProperties(propertyList, includeQualifiers, includeClassOrigin);
    }

    public synchronized CIMObjectPath[] enumerateInstanceNames(CIMObjectPath op, CIMClass cc) throws CIMException {
        Vector<CIMObjectPath> packageInstances = new Vector<CIMObjectPath>();
        try {
            File packageDir = new File(PKGINFO_DIR);
            DirFilter filter = new DirFilter();
            String[] directories = packageDir.list(filter);
            for (int x = 0; x < directories.length; ++x) {
                CIMObjectPath cop = new CIMObjectPath(op.getObjectName(), op.getNameSpace());
                cop.addKey("Name", new CIMValue((Object)directories[x]));
                cop.addKey("Version", new CIMValue((Object)this.getVersion(this.getVersion(this.GetPkgVersion(directories[x]), directories[x]), directories[x])));
                cop.addKey("TargetOperatingSystem", new CIMValue((Object)new UnsignedInt16(29)));
                packageInstances.addElement(cop);
            }
        }
        catch (Exception e) {
            this.provUtil.writeLog(2, "LM_10450", "LM_10451", PROVIDER_NAME, PKGINFO_DIR, null, null);
        }
        CIMObjectPath[] copArray = new CIMObjectPath[packageInstances.size()];
        packageInstances.toArray(copArray);
        return copArray;
    }

    public synchronized CIMInstance[] enumerateInstances(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, CIMClass cc) throws CIMException {
        Vector<CIMInstance> packageInstances = new Vector<CIMInstance>();
        try {
            File packageDir = new File(PKGINFO_DIR);
            DirFilter filter = new DirFilter();
            String[] directories = packageDir.list(filter);
            for (int x = 0; x < directories.length; ++x) {
                String pkgName = directories[x];
                CIMInstance ci = cc.newInstance();
                ci.setProperty("Name", new CIMValue((Object)pkgName));
                ci.setProperty("TargetOperatingSystem", new CIMValue((Object)new UnsignedInt16(29)));
                ci.setProperty("Status", new CIMValue((Object)this.GetPkgStatus(pkgName)));
                ci.setProperty("Architecture", new CIMValue((Object)this.GetPkgArchitecture(pkgName)));
                ci.setProperty("Description", new CIMValue((Object)this.GetPkgDescription(pkgName)));
                ci.setProperty("Caption", new CIMValue((Object)this.GetPkgDescription(pkgName)));
                ci.setProperty("Manufacturer", new CIMValue((Object)this.GetPkgVendor(pkgName)));
                ci.setProperty("Category", new CIMValue((Object)this.GetPkgCategory(pkgName)));
                ci.setProperty("Basedir", new CIMValue((Object)this.GetPkgBasedir(pkgName)));
                Vector pkgInfo = this.getPkgInfo(pkgName);
                ci.setProperty("SupportInfo", new CIMValue((Object)this.getPkgInfoValue(pkgInfo, "HOTLINE", pkgName)));
                ci.setProperty("OtherTargetOS", new CIMValue((Object)"none"));
                ci.setProperty("IdentificationCode", new CIMValue((Object)this.getPkgInfoValue(pkgInfo, "PSTAMP", pkgName)));
                Date date = new Date(this.getPkgInfoValue(pkgInfo, "INSTDATE", pkgName));
                CIMDateTime CIMDate = new CIMDateTime(date);
                ci.setProperty("InstallDate", new CIMValue((Object)CIMDate));
                String version = this.GetPkgVersion(pkgName);
                ci.setProperty("Version", new CIMValue((Object)this.getVersion(version, pkgName)));
                ci.setProperty("BuildNumber", new CIMValue((Object)this.getBuildNumber(version, pkgName)));
                if (localOnly) {
                    ci = ci.localElements();
                }
                packageInstances.addElement(ci.filterProperties(propertyList, includeQualifiers, includeClassOrigin));
            }
        }
        catch (Exception e) {
            this.provUtil.writeLog(2, "LM_10450", "LM_10451", PROVIDER_NAME, PKGINFO_DIR, null, null);
        }
        CIMInstance[] ciArray = new CIMInstance[packageInstances.size()];
        packageInstances.toArray(ciArray);
        return ciArray;
    }

    public synchronized Vector getPkgInfo(String pkgName) {
        File pkgInfoFile = new File("/var/sadm/pkg/" + pkgName + PATH_SEP + PKGINFO_FILE);
        Vector<String> pkgInfo = new Vector<String>();
        try {
            if (pkgInfoFile.exists() && pkgInfoFile.isFile() && pkgInfoFile.canRead()) {
                BufferedReader in = new BufferedReader(new FileReader(pkgInfoFile));
                String line = in.readLine();
                int index = 0;
                while (line != null) {
                    index = line.indexOf("=");
                    if (index != -1) {
                        String attrib = line.substring(0, index);
                        String value = line.substring(index + 1, line.length());
                        attrib = attrib.trim();
                        value = value.trim();
                        pkgInfo.addElement(attrib);
                        pkgInfo.addElement(value);
                    }
                    line = in.readLine();
                }
                in.close();
                return pkgInfo;
            }
            this.provUtil.writeLog(2, "LM_10452", "LM_10453", PROVIDER_NAME, "/var/sadm/pkg/" + pkgName, null, null);
            return null;
        }
        catch (Exception e) {
            this.provUtil.writeLog(2, e);
            return null;
        }
    }

    public String getPkgInfoValue(Vector pkgInfo, String attrib, String pkgName) {
        try {
            int index = pkgInfo.indexOf(attrib);
            if (index != -1) {
                return (String)pkgInfo.elementAt(index + 1);
            }
            this.provUtil.writeLog(1, "LM_10454", "LM_10455", PROVIDER_NAME, attrib, pkgName, null);
            return "";
        }
        catch (Exception e) {
            this.provUtil.writeLog(1, e);
            return "";
        }
    }

    private String getVersion(String version, String pkgName) {
        if (version != null && version.length() > 0) {
            int index = version.indexOf(",");
            if (index != -1) {
                return version.substring(0, index);
            }
            return version;
        }
        this.provUtil.writeLog(1, "LM_10456", "LM_10457", PROVIDER_NAME, pkgName, null, null);
        return "";
    }

    private String getBuildNumber(String version, String pkgName) {
        if (version != null && version.length() > 0) {
            int index = version.indexOf(",");
            if (index != -1) {
                return version.substring(index + 1, version.length());
            }
            this.provUtil.writeLog(1, "LM_10458", "LM_10459", PROVIDER_NAME, pkgName, null, null);
            return "";
        }
        this.provUtil.writeLog(1, "LM_10458", "LM_10459", PROVIDER_NAME, pkgName, null, null);
        return "";
    }

    private Calendar convertDate(String newDate) {
        Calendar cal = Calendar.getInstance();
        cal.set(2000, 1, 1, 0, 0);
        StringTokenizer st = new StringTokenizer(newDate, " ");
        String[] date = new String[]{"Jan", "01", "2000", "00", "00"};
        int count = 0;
        try {
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (count < 2) {
                    date[count] = token;
                    ++count;
                    continue;
                }
                StringTokenizer stc = new StringTokenizer(token, ":");
                while (stc.hasMoreTokens()) {
                    date[count] = stc.nextToken();
                    ++count;
                }
            }
            if (count == 5) {
                cal.set(Integer.parseInt(date[2]), this.convertMonth(date[0]), Integer.parseInt(date[1]), Integer.parseInt(date[3]), Integer.parseInt(date[4]));
            }
        }
        catch (Exception e) {
            this.provUtil.writeLog(1, e);
        }
        return cal;
    }

    private int convertMonth(String month) {
        if ((month = month.trim()).equalsIgnoreCase("Jan")) {
            return 0;
        }
        if (month.equalsIgnoreCase("Feb")) {
            return 1;
        }
        if (month.equalsIgnoreCase("Mar")) {
            return 2;
        }
        if (month.equalsIgnoreCase("Apr")) {
            return 3;
        }
        if (month.equalsIgnoreCase("May")) {
            return 4;
        }
        if (month.equalsIgnoreCase("Jun")) {
            return 5;
        }
        if (month.equalsIgnoreCase("Jul")) {
            return 6;
        }
        if (month.equalsIgnoreCase("Aug")) {
            return 7;
        }
        if (month.equalsIgnoreCase("Sep")) {
            return 8;
        }
        if (month.equalsIgnoreCase("Oct")) {
            return 9;
        }
        if (month.equalsIgnoreCase("Nov")) {
            return 10;
        }
        if (month.equalsIgnoreCase("Dec")) {
            return 11;
        }
        return 1;
    }

    private boolean validatePkgExists(String pkgName) {
        boolean pkgExists = false;
        if (pkgName == null || pkgName.length() == 0) {
            return pkgExists;
        }
        try {
            File packageDir = new File(PKGINFO_DIR);
            DirFilter filter = new DirFilter();
            String[] directories = packageDir.list(filter);
            for (int x = 0; x < directories.length; ++x) {
                if (!pkgName.equals(directories[x])) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return pkgExists;
    }

    public synchronized String getPkgStatus(String pkgName) {
        return this.GetPkgStatus(pkgName);
    }

    synchronized native String GetPkgDescription(String var1);

    synchronized native String GetPkgArchitecture(String var1);

    synchronized native String GetPkgVersion(String var1);

    synchronized native String GetPkgVendor(String var1);

    synchronized native String GetPkgBasedir(String var1);

    synchronized native String GetPkgCategory(String var1);

    synchronized native String GetPkgStatus(String var1);

    public CIMInstance[] execQuery(CIMObjectPath op, String query, String ql, CIMClass cc) throws CIMException {
        return null;
    }

    static {
        System.loadLibrary("solprov");
    }
}

