/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.printer;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;

public class PrtBuff {
    public static final String PRT_FILE = "/usr/sadm/mof/prt.out";
    public static final String JOB_FILETMP = "/usr/sadm/mof/tmp.out";
    public static final String JOB_FILE = "/usr/sadm/mof/job.out";
    public static final String PRT_LIST = "lpstat -v";
    public static final String JOB_LIST = "lpstat -o";

    public synchronized void createPrtFile() {
        File f = new File(PRT_FILE);
        if (f.exists()) {
            f.delete();
        }
        try {
            int c;
            Process p1 = Runtime.getRuntime().exec(PRT_LIST);
            InputStream in = p1.getInputStream();
            FileWriter prt = new FileWriter(PRT_FILE, false);
            while ((c = in.read()) != -1) {
                prt.write((char)c);
            }
            prt.flush();
            prt.close();
            in.close();
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    public synchronized void createJobFile() {
        String buff = null;
        File job = new File(JOB_FILE);
        File job_tmp = new File(JOB_FILETMP);
        if (job.exists()) {
            job.delete();
        }
        if (job_tmp.exists()) {
            job_tmp.delete();
        }
        try {
            int c;
            Process p2 = Runtime.getRuntime().exec(JOB_LIST);
            BufferedInputStream in = (BufferedInputStream)p2.getInputStream();
            BufferedWriter tmpFile = new BufferedWriter(new FileWriter(JOB_FILETMP, false));
            while ((c = in.read()) != -1) {
                tmpFile.write((char)c);
            }
            tmpFile.flush();
            tmpFile.close();
            in.close();
        }
        catch (IOException e) {
            System.err.println(e);
        }
        try {
            int num = 0;
            BufferedReader tmpIn = new BufferedReader(new FileReader(JOB_FILETMP));
            BufferedWriter jobFile = new BufferedWriter(new FileWriter(JOB_FILE, false));
            while ((buff = tmpIn.readLine()) != null) {
                if (buff.indexOf("!", 0) <= 0) continue;
                ++num;
                jobFile.write(buff);
                jobFile.write("\n");
                jobFile.flush();
            }
            tmpIn.close();
            jobFile.flush();
            jobFile.close();
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    public synchronized int getNumPrinters() {
        int num = 0;
        String buff = null;
        try {
            BufferedReader in = new BufferedReader(new FileReader(PRT_FILE));
            while ((buff = in.readLine()) != null) {
                ++num;
            }
            in.close();
        }
        catch (IOException e) {
            System.err.println(e);
        }
        return num;
    }

    public synchronized int getNumJobs() {
        int num = 0;
        String buff = null;
        try {
            BufferedReader in = new BufferedReader(new FileReader(JOB_FILE));
            while ((buff = in.readLine()) != null) {
                if (buff.indexOf("!", 0) <= 0) continue;
                ++num;
            }
            in.close();
        }
        catch (IOException e) {
            System.err.println(e);
        }
        return num;
    }

    public synchronized String getJob(String arg, int lines) {
        String buff = null;
        String jobid = null;
        String job = JOB_FILE;
        try {
            BufferedReader in = new BufferedReader(new FileReader(job));
            for (int i = 0; i < lines; ++i) {
                in.readLine();
            }
            buff = in.readLine();
            in.close();
        }
        catch (IOException e) {
            System.err.println(e);
        }
        StringBuffer contents = new StringBuffer(buff);
        int idx1 = buff.indexOf(32, 0);
        contents.delete(0, idx1);
        jobid = buff.substring(0, idx1);
        if (arg.equals("ID")) {
            return jobid;
        }
        return "No Jobs";
    }

    public synchronized String getPrinter(int lines) {
        String token = null;
        try {
            String buff = null;
            int num = 0;
            String printer_file = PRT_FILE;
            BufferedReader in = new BufferedReader(new FileReader(printer_file));
            for (int i = 0; i < lines; ++i) {
                buff = in.readLine();
            }
            buff = in.readLine();
            in.close();
            String buff2 = null;
            buff2 = buff.replace(':', ' ');
            StringTokenizer prt = new StringTokenizer(buff2, " ");
            while (prt.hasMoreTokens()) {
                if (num > 1) {
                    token = prt.nextToken();
                    break;
                }
                prt.nextToken();
                ++num;
            }
        }
        catch (IOException e) {
            System.err.println(e);
        }
        return token.trim();
    }

    public synchronized boolean delPrinter(String prt) {
        try {
            String DEL_CMD = "lpadmin -x " + prt;
            Process p = null;
            int processExitValue = -1;
            Runtime rt = Runtime.getRuntime();
            if (rt == null) {
                return false;
            }
            p = rt.exec(DEL_CMD);
            try {
                p.waitFor();
            }
            catch (Exception e) {
                System.err.println(e);
            }
            processExitValue = p.exitValue();
            return processExitValue == 0;
        }
        catch (IOException e) {
            System.err.println(e);
            return false;
        }
    }

    public synchronized boolean addQ(String Q, String pserver, String desc, boolean default_prn) {
        try {
            String CREATE_CMD = "/usr/sbin/lpadmin -p " + Q + " -s " + pserver + "!" + Q;
            String SET_DEFAULT_PRT = "lpadmin -p _default -s " + pserver + "!" + Q;
            String CREATE_DESC = "/usr/sbin/lpadmin -p " + Q + " -s " + pserver + "!" + Q + " -D '" + desc + "'\n";
            Process p = null;
            int processExitValue = -1;
            Runtime rt = Runtime.getRuntime();
            if (rt == null) {
                return false;
            }
            p = desc != null ? rt.exec(CREATE_DESC) : rt.exec(CREATE_CMD);
            try {
                p.waitFor();
            }
            catch (Exception e) {
                System.err.println(e);
            }
            processExitValue = p.exitValue();
            if (processExitValue == 0) {
                if (default_prn) {
                    p = rt.exec(SET_DEFAULT_PRT);
                    try {
                        p.waitFor();
                    }
                    catch (Exception e) {
                        System.err.println(e);
                    }
                    processExitValue = p.exitValue();
                    if (processExitValue != 0) {
                        return false;
                    }
                }
                return true;
            }
            return false;
        }
        catch (IOException e) {
            System.err.println(e);
            return false;
        }
    }

    public synchronized String getPrintServer(String prtName) {
        String buff = null;
        String TMPFILE = "/tmp/tmp.out";
        String CMD = "/usr/bin/lpstat -v " + prtName;
        try {
            int c;
            Process p2 = Runtime.getRuntime().exec(CMD);
            BufferedInputStream in = (BufferedInputStream)p2.getInputStream();
            BufferedWriter tmpFile = new BufferedWriter(new FileWriter(TMPFILE, false));
            while ((c = in.read()) != -1) {
                tmpFile.write((char)c);
            }
            tmpFile.flush();
            tmpFile.close();
            in.close();
        }
        catch (IOException e) {
            System.err.println(e);
        }
        try {
            boolean num = false;
            BufferedReader tmpIn = new BufferedReader(new FileReader(TMPFILE));
            int idx = 0;
            String server = null;
            while ((buff = tmpIn.readLine()) != null) {
                if (buff.indexOf(58, 0) <= 0) continue;
                idx = buff.indexOf(58, 0);
                if (buff.indexOf(40, 0) > 0) {
                    server = buff.substring(idx + 2, buff.indexOf(40, 0));
                    continue;
                }
                server = buff.substring(idx + 2, buff.length());
            }
            tmpIn.close();
            File f = new File(TMPFILE);
            if (f.exists()) {
                f.delete();
            }
            return server.trim();
        }
        catch (IOException e) {
            System.err.println(e);
            return null;
        }
    }

    public synchronized boolean getDefaultPrt(String prtName) {
        String buff = null;
        String TMPFILE = "/tmp/tmp.out";
        String CMD = "/usr/bin/lpstat -v _default | grep " + prtName;
        try {
            int c;
            Process p2 = Runtime.getRuntime().exec(CMD);
            BufferedInputStream in = (BufferedInputStream)p2.getInputStream();
            BufferedWriter tmpFile = new BufferedWriter(new FileWriter(TMPFILE, false));
            while ((c = in.read()) != -1) {
                tmpFile.write((char)c);
            }
            tmpFile.flush();
            tmpFile.close();
            in.close();
        }
        catch (IOException e) {
            System.err.println(e);
        }
        try {
            boolean num = false;
            BufferedReader tmpIn = new BufferedReader(new FileReader(TMPFILE));
            boolean idx = false;
            Object server = null;
            buff = tmpIn.readLine();
            if (buff != null) {
                if (buff.indexOf(prtName, 0) > 0) {
                    tmpIn.close();
                    File f = new File(TMPFILE);
                    if (f.exists()) {
                        f.delete();
                    }
                    return true;
                }
                tmpIn.close();
                File f = new File(TMPFILE);
                if (f.exists()) {
                    f.delete();
                }
                return false;
            }
        }
        catch (IOException e) {
            System.err.println(e);
        }
        return false;
    }

    public static void debug(String x) {
        try {
            FileWriter fp = new FileWriter("/tmp/debug2", true);
            fp.write("\nDEBUG: = " + x);
            fp.flush();
            fp.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

