/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.scheduledjob;

import com.sun.wbem.utility.common.QuickVector;

public class CronLogEntries {
    private static int COMMAND_COLUMN = 0;
    private static int PROCESS_ID_COLUMN = 1;
    private static int START_TIME_COLUMN = 2;
    private static int END_TIME_COLUMN = 3;
    private static int RETURN_CODE_COLUMN = 4;
    private static int NUMBER_OF_COLUMNS = 5;
    private QuickVector entries = null;
    private int numberOfEntries = 0;

    public CronLogEntries() {
        this(1);
    }

    public CronLogEntries(int numberOfEntries) {
        String[] entry = null;
        this.entries = new QuickVector(numberOfEntries);
        this.entries.setSize(numberOfEntries);
        for (int i = 0; i < numberOfEntries; ++i) {
            entry = new String[NUMBER_OF_COLUMNS];
            for (int j = 0; j < NUMBER_OF_COLUMNS; ++j) {
                entry[j] = "";
            }
            this.entries.quickSetElementAt((Object)entry, i);
        }
        this.numberOfEntries = numberOfEntries;
    }

    public void setEntry(int entryNumber, String command, String processId, String startTime, String endTime, String returnCode) {
        String[] entry = null;
        try {
            entry = (String[])this.entries.quickElementAt(entryNumber - 1);
            entry[CronLogEntries.COMMAND_COLUMN] = command;
            entry[CronLogEntries.PROCESS_ID_COLUMN] = processId;
            entry[CronLogEntries.START_TIME_COLUMN] = startTime;
            entry[CronLogEntries.END_TIME_COLUMN] = endTime;
            entry[CronLogEntries.RETURN_CODE_COLUMN] = returnCode;
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
    }

    public void addEntries(int numberOfEntriesToAdd) {
        String[] entry = null;
        this.entries.setSize(this.numberOfEntries + numberOfEntriesToAdd);
        for (int i = this.numberOfEntries; i < this.numberOfEntries + numberOfEntriesToAdd; ++i) {
            entry = new String[NUMBER_OF_COLUMNS];
            for (int j = 0; j < NUMBER_OF_COLUMNS; ++j) {
                entry[j] = "";
            }
            this.entries.quickSetElementAt((Object)entry, i);
        }
        this.numberOfEntries += numberOfEntriesToAdd;
    }

    public void deleteEntry(int entryToDelete) {
        this.entries.removeElementAt(entryToDelete - 1);
        --this.numberOfEntries;
    }

    public int getNumberOfEntries() {
        return this.numberOfEntries;
    }

    public String getCommand(int entryNumber) {
        String[] entry = null;
        try {
            entry = (String[])this.entries.quickElementAt(entryNumber - 1);
            return entry[COMMAND_COLUMN];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    public void setCommand(int entryNumber, String command) {
        String[] entry = null;
        try {
            entry = (String[])this.entries.quickElementAt(entryNumber - 1);
            entry[CronLogEntries.COMMAND_COLUMN] = command;
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
    }

    public String getProcessId(int entryNumber) {
        String[] entry = null;
        try {
            entry = (String[])this.entries.quickElementAt(entryNumber - 1);
            return entry[PROCESS_ID_COLUMN];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    public void setProcessId(int entryNumber, String processId) {
        String[] entry = null;
        try {
            entry = (String[])this.entries.quickElementAt(entryNumber - 1);
            entry[CronLogEntries.PROCESS_ID_COLUMN] = processId;
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
    }

    public String getStartTime(int entryNumber) {
        String[] entry = null;
        try {
            entry = (String[])this.entries.quickElementAt(entryNumber - 1);
            return entry[START_TIME_COLUMN];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    public void setStartTime(int entryNumber, String startTime) {
        String[] entry = null;
        try {
            entry = (String[])this.entries.quickElementAt(entryNumber - 1);
            entry[CronLogEntries.START_TIME_COLUMN] = startTime;
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
    }

    public String getEndTime(int entryNumber) {
        String[] entry = null;
        try {
            entry = (String[])this.entries.quickElementAt(entryNumber - 1);
            return entry[END_TIME_COLUMN];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    public void setEndTime(int entryNumber, String endTime) {
        String[] entry = null;
        try {
            entry = (String[])this.entries.quickElementAt(entryNumber - 1);
            entry[CronLogEntries.END_TIME_COLUMN] = endTime;
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
    }

    public String getReturnCode(int entryNumber) {
        String[] entry = null;
        try {
            entry = (String[])this.entries.quickElementAt(entryNumber - 1);
            return entry[RETURN_CODE_COLUMN];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    public void setReturnCode(int entryNumber, String returnCode) {
        String[] entry = null;
        try {
            entry = (String[])this.entries.quickElementAt(entryNumber - 1);
            entry[CronLogEntries.RETURN_CODE_COLUMN] = returnCode;
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
    }
}

