/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.tz;

import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.solarisprovider.osserver.DBTableException;
import com.sun.wbem.solarisprovider.tz.TzTable;
import com.sun.wbem.utility.directorytable.DirectoryTableException;
import com.sun.wbem.utility.log.LogUtil;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.TimeZone;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.provider.Authorizable;
import javax.wbem.provider.InstanceProvider;

public class Solaris_SystemTimeZone
implements InstanceProvider,
Authorizable {
    protected static final String SOLARIS_TIMEZONE_WRITE_RIGHT = "solaris.compsys.write";
    private static final String HOST_ID = "HostId";
    private CIMOMHandle cimomhandle = null;
    private LogUtil logUtil = null;
    private ProviderUtility prov_util = null;
    private String PROVIDER_NAME = "SystemTimeZone";
    String[] msg = new String[]{this.PROVIDER_NAME};
    TimeZone tz = TimeZone.getDefault();
    private static String tzkey = "TZ";
    private static String CLASS_NAME = "Solaris_ComputerSystem";

    public void initialize(CIMOMHandle cimomhandle) throws CIMException {
        this.cimomhandle = cimomhandle;
        this.logUtil = LogUtil.getInstance((CIMOMHandle)cimomhandle);
        this.prov_util = new ProviderUtility(cimomhandle, this.PROVIDER_NAME);
        try {
            if (this.tz.getID().equalsIgnoreCase("Custom")) {
                TzTable myTable = new TzTable();
                String CURR_TZ = myTable.getTimezoneValue(tzkey);
                TimeZone deftz = TimeZone.getTimeZone(CURR_TZ);
                TimeZone.setDefault(deftz);
                this.tz = TimeZone.getDefault();
            }
        }
        catch (DirectoryTableException directoryTableException) {
            // empty catch block
        }
    }

    public void cleanup() throws CIMException {
    }

    public CIMObjectPath createInstance(CIMObjectPath op, CIMInstance ci) throws CIMException {
        this.logUtil.writeLog(this.PROVIDER_NAME, "LM_8600", "LM_8601", this.msg, "FAILURE", false, 0, 2);
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public void deleteInstance(CIMObjectPath cp) throws CIMException {
        this.logUtil.writeLog(this.PROVIDER_NAME, "LM_8602", "LM_8603", this.msg, "FAILURE", false, 0, 2);
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public void setInstance(CIMObjectPath op, CIMInstance ci) throws CIMException {
        CIMProperty cp;
        try {
            this.prov_util.checkRights(SOLARIS_TIMEZONE_WRITE_RIGHT, op);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CIMException("authorization failed");
        }
        this.checkCron(op);
        this.checkProcess(op);
        String tzvalue = null;
        CIMObjectPath tzvalue_op = null;
        String tzkey = "TZ";
        Enumeration e = op.getKeys().elements();
        while (e.hasMoreElements()) {
            cp = (CIMProperty)e.nextElement();
            if (cp == null || !cp.getName().equalsIgnoreCase("Setting")) continue;
            tzvalue_op = (CIMObjectPath)cp.getValue().getValue();
            break;
        }
        if (tzvalue_op == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        e = tzvalue_op.getKeys().elements();
        while (e.hasMoreElements()) {
            cp = (CIMProperty)e.nextElement();
            if (cp == null || !cp.getName().equalsIgnoreCase("StandardName")) continue;
            tzvalue = (String)cp.getValue().getValue();
        }
        if (tzvalue == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        boolean err = false;
        try {
            TzTable myTable = new TzTable();
            myTable.setTimezoneValue(tzkey, tzvalue);
            this.tz = TimeZone.getTimeZone(tzvalue);
            TimeZone.setDefault(this.tz);
        }
        catch (DirectoryTableException ex) {
            err = true;
        }
        catch (DBTableException ex) {
            err = true;
        }
        catch (Exception ex) {
            throw new CIMException("CIM_ERR_FAILED", (Object)"setInstance of TimeZone Failed");
        }
        if (err) {
            this.logUtil.writeLog(this.PROVIDER_NAME, "LM_8610", "LM_8611", this.msg, "FAILURE", false, 0, 2);
        }
    }

    public CIMInstance getInstance(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propList, CIMClass cc) throws CIMException {
        try {
            CIMInstance ci = cc.newInstance();
            CIMObjectPath element = new CIMObjectPath("Solaris_ComputerSystem");
            CIMObjectPath setting = new CIMObjectPath("Solaris_TimeZone");
            CIMObjectPath element_cop = new CIMObjectPath(element.getObjectName(), element.getNameSpace());
            CIMObjectPath setting_cop = new CIMObjectPath(setting.getObjectName(), setting.getNameSpace());
            element_cop.addKey("CreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
            element_cop.addKey("Name", new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
            try {
                setting_cop.addKey("StandardName", new CIMValue((Object)this.tz.getID()));
            }
            catch (Exception e) {
                throw new CIMException("CIM_ERR_FAILED", (Object)e);
            }
            try {
                setting_cop.addKey("CreationClassName", new CIMValue((Object)"Solaris_TimeZone"));
            }
            catch (Exception e) {
                throw new CIMException("CIM_ERR_FAILED", (Object)e);
            }
            ci.setProperty("Element", new CIMValue((Object)element_cop));
            ci.setProperty("Setting", new CIMValue((Object)setting_cop));
            if (localOnly) {
                ci = ci.localElements();
            }
            return ci.filterProperties(propList, includeQualifiers, includeClassOrigin);
        }
        catch (Exception e) {
            this.logUtil.writeLog(this.PROVIDER_NAME, "LM_8606", "LM_8607", this.msg, "FAILURE", false, 0, 2);
            throw new CIMException("CIM_ERR_FAILED", (Object)"getInstance of SystemTimeZone Failed");
        }
    }

    public CIMInstance[] enumerateInstances(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propList, CIMClass cc) throws CIMException {
        Vector<CIMInstance> timezone = new Vector<CIMInstance>();
        try {
            CIMInstance ci = cc.newInstance();
            CIMObjectPath element = new CIMObjectPath("Solaris_ComputerSystem");
            CIMObjectPath setting = new CIMObjectPath("Solaris_TimeZone");
            CIMObjectPath element_cop = new CIMObjectPath(element.getObjectName(), element.getNameSpace());
            CIMObjectPath setting_cop = new CIMObjectPath(setting.getObjectName(), setting.getNameSpace());
            element_cop.addKey("CreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
            element_cop.addKey("Name", new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
            setting_cop.addKey("StandardName", new CIMValue((Object)this.tz.getID()));
            setting_cop.addKey("CreationClassName", new CIMValue((Object)"Solaris_TimeZone"));
            ci.setProperty("Element", new CIMValue((Object)element_cop));
            ci.setProperty("Setting", new CIMValue((Object)setting_cop));
            timezone.addElement(ci.filterProperties(propList, includeQualifiers, includeClassOrigin));
            CIMInstance[] ciArray = new CIMInstance[timezone.size()];
            timezone.toArray(ciArray);
            return ciArray;
        }
        catch (Exception e) {
            this.logUtil.writeLog(this.PROVIDER_NAME, "LM_8606", "LM_8607", this.msg, "FAILURE", false, 0, 2);
            throw new CIMException("CIM_ERR_FAILED", (Object)"enumInstance of SystemTimeZone Failed");
        }
    }

    public CIMObjectPath[] enumerateInstanceNames(CIMObjectPath op, CIMClass cc) throws CIMException {
        Vector<CIMObjectPath> timezone = new Vector<CIMObjectPath>();
        CIMInstance ci = cc.newInstance();
        try {
            CIMObjectPath cop = new CIMObjectPath(op.getObjectName(), op.getNameSpace());
            CIMObjectPath element = new CIMObjectPath("Solaris_ComputerSystem");
            CIMObjectPath setting = new CIMObjectPath("Solaris_TimeZone");
            CIMObjectPath element_cop = new CIMObjectPath(element.getObjectName(), element.getNameSpace());
            CIMObjectPath setting_cop = new CIMObjectPath(setting.getObjectName(), setting.getNameSpace());
            element_cop.addKey("CreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
            element_cop.addKey("Name", new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
            setting_cop.addKey("StandardName", new CIMValue((Object)this.tz.getID()));
            setting_cop.addKey("CreationClassName", new CIMValue((Object)"Solaris_TimeZone"));
            cop.addKey("Element", new CIMValue((Object)element_cop));
            cop.addKey("Setting", new CIMValue((Object)setting_cop));
            timezone.addElement(cop);
            CIMObjectPath[] copArray = new CIMObjectPath[timezone.size()];
            timezone.toArray(copArray);
            return copArray;
        }
        catch (Exception e) {
            this.logUtil.writeLog(this.PROVIDER_NAME, "LM_8606", "LM_8607", this.msg, "FAILURE", false, 0, 2);
            throw new CIMException("CIM_ERR_FAILED", (Object)"enumInstance of SystemTimeZone Failed");
        }
    }

    public CIMInstance[] execQuery(CIMObjectPath op, String query, String ql, CIMClass cc) throws CIMException {
        return null;
    }

    private void checkCron(CIMObjectPath op) throws CIMException {
        String select = "SELECT * ";
        String from = "FROM Solaris_ScheduledJob_Cron ";
        String where = "WHERE Command = '/usr/bin/rdate' ";
        String or = "OR Command = '/usr/sbin/rdate'";
        String query = select + from + where + or;
        CIMObjectPath className = new CIMObjectPath("Solaris_ScheduledJob_Cron");
        className.setNameSpace(op.getNameSpace());
        Enumeration processes = this.cimomhandle.execQuery(className, query, "WQL");
        while (processes.hasMoreElements()) {
            CIMInstance processName = (CIMInstance)processes.nextElement();
            if (processName == null) continue;
            this.logUtil.writeLog(this.PROVIDER_NAME, "LM_8612", "LM_8614", this.msg, "FAILURE", false, 0, 2);
            throw new CIMException("CIM_ERR_NOT_SUPPORTED");
        }
    }

    private void checkProcess(CIMObjectPath op) throws CIMException {
        String query = "SELECT * FROM Solaris_Process WHERE ExecutingCommand = '/usr/lib/inet/xntpd'";
        CIMObjectPath className = new CIMObjectPath("Solaris_Process");
        className.setNameSpace(op.getNameSpace());
        Enumeration processes = this.cimomhandle.execQuery(className, query, "WQL");
        while (processes.hasMoreElements()) {
            CIMInstance processName = (CIMInstance)processes.nextElement();
            if (processName == null) continue;
            this.logUtil.writeLog(this.PROVIDER_NAME, "LM_8612", "LM_8613", this.msg, "FAILURE", false, 0, 2);
            throw new CIMException("CIM_ERR_NOT_SUPPORTED");
        }
    }
}

