/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.tz;

import com.sun.wbem.solarisprovider.osserver.DBTableException;
import com.sun.wbem.solarisprovider.tz.TzObject;
import com.sun.wbem.utility.directorytable.DirectoryRow;
import com.sun.wbem.utility.directorytable.DirectoryTable;
import com.sun.wbem.utility.directorytable.DirectoryTableDoesNotExistException;
import com.sun.wbem.utility.directorytable.DirectoryTableException;
import com.sun.wbem.utility.directorytable.DirectoryTableFactory;
import com.sun.wbem.utility.directorytable.SearchTemplate;
import com.sun.wbem.utility.directorytable.TableDefinitions;
import java.util.Vector;

public class TzTable {
    private String table = new String("/etc/TIMEZONE");
    private String keyCol = "key";
    private String valCol = "value";
    private int keyColNum = 0;
    private int valColNum = 0;

    public void TzTable() {
    }

    private DirectoryTable openTimezoneTable() throws DirectoryTableException {
        DirectoryTable timezoneTable = null;
        timezoneTable = DirectoryTableFactory.getDirectoryTableInstance((String)"File", (String)"", (String)"");
        TableDefinitions tableDefs = timezoneTable.getTableDefinitionsInstance();
        tableDefs.loadTableDefinitions("pkginfo");
        tableDefs.setMappedTableName(this.table);
        this.keyColNum = tableDefs.getColumnNumber(this.keyCol);
        this.valColNum = tableDefs.getColumnNumber(this.valCol);
        try {
            timezoneTable.open(tableDefs);
            return timezoneTable;
        }
        catch (DirectoryTableDoesNotExistException ex) {
            timezoneTable.create(tableDefs);
            return timezoneTable;
        }
        catch (DirectoryTableException ex) {
            throw ex;
        }
    }

    public void addTimezoneEntry(TzObject timezoneObject) throws DBTableException, DirectoryTableException {
        DirectoryTable timezoneTable = null;
        DirectoryRow timezoneEntry = null;
        String sKey = timezoneObject.getKey();
        String sTz = timezoneObject.getValue();
        if (sKey == null || sKey.trim().length() == 0 || sTz == null || sTz.trim().length() == 0) {
            throw new DBTableException("EXM_ADD_INV", this.table);
        }
        try {
            timezoneTable = this.openTimezoneTable();
            timezoneEntry = this.checkTimezoneEntry(timezoneTable, timezoneObject);
            if (timezoneEntry != null) {
                TzObject tzObj = this.makeTimezoneObject(timezoneEntry);
                timezoneTable.close();
                if (tzObj.equals(timezoneObject)) {
                    return;
                }
                throw new DBTableException("EXM_ADD_EXIST", this.table);
            }
            timezoneEntry = this.makeRow(timezoneTable, timezoneObject);
            if (timezoneEntry != null) {
                timezoneTable.addRow(timezoneEntry);
            }
        }
        catch (DirectoryTableException ex) {
            if (timezoneTable != null) {
                timezoneTable.close();
            }
            throw ex;
        }
        timezoneTable.close();
    }

    public void deleteTimezoneEntry(TzObject timezoneObject) throws DBTableException, DirectoryTableException {
        DirectoryTable timezoneTable = null;
        DirectoryRow timezoneEntry = null;
        String sKey = timezoneObject.getKey();
        String sTz = timezoneObject.getValue();
        if (sKey == null || sKey.trim().length() == 0) {
            throw new DBTableException("EXM_DEL_INV", this.table);
        }
        try {
            timezoneTable = this.openTimezoneTable();
            timezoneEntry = this.checkTimezoneEntry(timezoneTable, timezoneObject);
            if (timezoneEntry == null) {
                timezoneTable.close();
                return;
            }
            timezoneTable.deleteRow(timezoneEntry);
        }
        catch (DirectoryTableException ex) {
            if (timezoneTable != null) {
                timezoneTable.close();
            }
            throw ex;
        }
        timezoneTable.close();
    }

    public void modifyTimezoneEntry(TzObject oldTZObject, TzObject newTZObject) throws DBTableException, DirectoryTableException {
        this.deleteTimezoneEntry(oldTZObject);
        this.addTimezoneEntry(newTZObject);
    }

    public String getTimezoneValue(String key) throws DirectoryTableException {
        String tzkey = key;
        String tzval = null;
        DirectoryTable timezoneTable = null;
        DirectoryRow searchRow = null;
        DirectoryRow resultRow = null;
        try {
            timezoneTable = this.openTimezoneTable();
            searchRow = timezoneTable.getRowInstance();
            searchRow.putColumn(this.keyColNum, tzkey);
            resultRow = timezoneTable.getFirstRow((SearchTemplate)searchRow);
            if (resultRow != null) {
                tzval = resultRow.getColumn(this.valColNum);
            }
        }
        catch (DirectoryTableException ex) {
            if (timezoneTable != null) {
                timezoneTable.close();
            }
            throw ex;
        }
        timezoneTable.close();
        return tzval;
    }

    public void setTimezoneValue(String key, String value) throws DirectoryTableException, DBTableException {
        String oldtzval = null;
        TzObject oldtzObj = null;
        oldtzval = this.getTimezoneValue(key);
        oldtzObj = this.makeTimezoneObject(key, oldtzval);
        TzObject newtzObj = null;
        newtzObj = this.makeTimezoneObject(key, value);
        this.modifyTimezoneEntry(oldtzObj, newtzObj);
    }

    public Vector list() throws DirectoryTableException {
        Vector<TzObject> vTimezone = new Vector<TzObject>();
        DirectoryTable timezoneTable = null;
        DirectoryRow timezoneEntry = null;
        try {
            timezoneTable = this.openTimezoneTable();
            timezoneEntry = timezoneTable.getFirstRow();
            while (timezoneEntry != null) {
                vTimezone.addElement(this.makeTimezoneObject(timezoneEntry));
                timezoneEntry = timezoneTable.getNextRow();
            }
        }
        catch (DirectoryTableException ex) {
            if (timezoneTable != null) {
                timezoneTable.close();
            }
            throw ex;
        }
        timezoneTable.close();
        return vTimezone;
    }

    public TzObject getTimezoneEntry(TzObject timezoneObject) throws DirectoryTableException {
        DirectoryTable timezoneTable = null;
        DirectoryRow timezoneEntry = null;
        TzObject tzObj = null;
        try {
            timezoneTable = this.openTimezoneTable();
            timezoneEntry = this.checkTimezoneEntry(timezoneTable, timezoneObject);
            if (timezoneEntry != null) {
                tzObj = this.makeTimezoneObject(timezoneEntry);
            }
        }
        catch (DirectoryTableException ex) {
            if (timezoneTable != null) {
                timezoneTable.close();
            }
            throw ex;
        }
        timezoneTable.close();
        return tzObj;
    }

    public TzObject getTimezoneEntry(String key) throws DirectoryTableException {
        TzObject tzObj = new TzObject(key, null);
        return this.getTimezoneEntry(tzObj);
    }

    private DirectoryRow checkTimezoneEntry(DirectoryTable timezoneTable, TzObject timezoneObject) throws DirectoryTableException {
        DirectoryRow timezoneEntry = null;
        String sKey = timezoneObject.getKey();
        if (sKey == null || sKey.trim().length() == 0) {
            return null;
        }
        timezoneEntry = timezoneTable.getRowInstance();
        timezoneEntry.putColumn(this.keyColNum, sKey);
        timezoneEntry = timezoneTable.getFirstRow((SearchTemplate)timezoneEntry);
        return timezoneEntry;
    }

    private TzObject makeTimezoneObject(DirectoryRow timezoneEntry) throws DirectoryTableException {
        String tzkey = timezoneEntry.getColumn(this.keyColNum);
        String tzvalue = timezoneEntry.getColumn(this.valColNum);
        TzObject timezoneObject = new TzObject(tzkey, tzvalue);
        return timezoneObject;
    }

    private TzObject makeTimezoneObject(String key, String value) throws DirectoryTableException {
        String tzkey = key;
        String tzvalue = value;
        TzObject timezoneObject = new TzObject(tzkey, tzvalue);
        return timezoneObject;
    }

    private DirectoryRow makeRow(DirectoryTable timezoneTable, TzObject timezoneObject) throws DirectoryTableException {
        String sValue;
        DirectoryRow timezoneEntry = timezoneTable.getRowInstance();
        String sKey = timezoneObject.getKey();
        if (sKey != null && sKey.trim().length() != 0) {
            timezoneEntry.putColumn(this.keyColNum, sKey);
        }
        if ((sValue = timezoneObject.getValue()) != null && sValue.trim().length() != 0) {
            timezoneEntry.putColumn(this.valColNum, sValue);
        }
        return timezoneEntry;
    }
}

