/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.usermgr.users;

import com.sun.wbem.solarisprovider.usermgr.common.AdminCommonTools;
import com.sun.wbem.solarisprovider.usermgr.common.SolAccountAttr;
import com.sun.wbem.solarisprovider.usermgr.common.SolPasswordAttr;
import com.sun.wbem.solarisprovider.usermgr.groups.SolGroupAttr;
import com.sun.wbem.solarisprovider.usermgr.users.SolHomedirAttr;
import com.sun.wbem.solarisprovider.usermgr.users.SolServicesAttr;
import java.io.Serializable;

public class UserObj
implements Serializable,
Cloneable {
    public static final int MAX_DESCRIPTION_INTEGER_VALUE = 256;
    public static final int MAX_UID_USER_INTEGER_VALUE = Integer.MAX_VALUE;
    public static final int MIN_UID_USER_INTEGER_VALUE = 100;
    public static final int MIN_UID_SYSTEM_INTEGER_VALUE = 0;
    public static final int UID_NONE = 60001;
    public static final int UID_NOBODY = 60002;
    public static final int UID_FORMER_MAX = 65534;
    public static final String DEFAULT_PRIMARY_GROUP_NAME = "staff";
    private String strName = "";
    private String strFullName = "";
    private String strID = "";
    private String strDescription = "";
    private String strType = "";
    private String strTemplateName = "";
    private SolPasswordAttr solPasswd;
    private SolGroupAttr solGroup;
    private SolHomedirAttr solHomedir;
    private SolServicesAttr solServices;
    private SolAccountAttr solAccount;

    public UserObj() {
    }

    public UserObj(String strNewName) {
        this.strName = strNewName;
    }

    public Object clone() {
        try {
            UserObj newObj = (UserObj)super.clone();
            if (this.solPasswd != null) {
                newObj.solPasswd = (SolPasswordAttr)this.solPasswd.clone();
            }
            if (this.solAccount != null) {
                newObj.solAccount = (SolAccountAttr)this.solAccount.clone();
            }
            if (this.solGroup != null) {
                newObj.solGroup = (SolGroupAttr)this.solGroup.clone();
            }
            if (this.solHomedir != null) {
                newObj.solHomedir = (SolHomedirAttr)this.solHomedir.clone();
            }
            if (this.solServices != null) {
                newObj.solServices = (SolServicesAttr)this.solServices.clone();
            }
            return newObj;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public boolean requireModify() {
        if (this.solPasswd.requireModify()) {
            return true;
        }
        if (this.solHomedir.requireModify()) {
            return true;
        }
        return this.solServices.requireModify();
    }

    public boolean equals(UserObj inObj) {
        if (!this.strName.equals(inObj.getUserName())) {
            return false;
        }
        if (!this.strTemplateName.equals(inObj.getTemplateName())) {
            return false;
        }
        if (!this.strID.equals(inObj.getUserID())) {
            return false;
        }
        if (!this.strDescription.equals(inObj.getUserDescription())) {
            return false;
        }
        if (!this.strType.equals(inObj.getUserType())) {
            return false;
        }
        SolPasswordAttr inPassAttr = inObj.getSolPasswordAttr();
        if (this.solPasswd != null) {
            if (inPassAttr == null) {
                return false;
            }
            if (!this.solPasswd.equals(inPassAttr)) {
                return false;
            }
        } else if (inPassAttr != null) {
            return false;
        }
        SolAccountAttr inAccAttr = inObj.getSolAccountAttr();
        if (this.solAccount != null) {
            if (inAccAttr == null) {
                return false;
            }
            if (!this.solAccount.equals(inAccAttr)) {
                return false;
            }
        } else if (inAccAttr != null) {
            return false;
        }
        SolGroupAttr grpAttr = inObj.getSolGroupAttr();
        if (this.solGroup != null) {
            if (grpAttr == null) {
                return false;
            }
            if (!this.solGroup.equals(grpAttr)) {
                return false;
            }
        } else if (grpAttr != null) {
            return false;
        }
        SolHomedirAttr hdirAttr = inObj.getSolHomedirAttr();
        if (this.solHomedir != null) {
            if (hdirAttr == null) {
                return false;
            }
            if (!this.solHomedir.equals(hdirAttr)) {
                return false;
            }
        } else if (hdirAttr != null) {
            return false;
        }
        SolServicesAttr srvAttr = inObj.getSolServicesAttr();
        if (this.solServices != null) {
            if (srvAttr == null) {
                return false;
            }
            if (!this.solServices.equals(srvAttr)) {
                return false;
            }
        } else if (srvAttr != null) {
            return false;
        }
        return true;
    }

    public String getUserName() {
        return this.strName;
    }

    public void setUserName(String strNewName) {
        this.strName = strNewName;
    }

    public String getTemplateName() {
        return this.strTemplateName;
    }

    public void setTemplateName(String strNewName) {
        this.strTemplateName = strNewName;
    }

    public String getUserFullName() {
        return this.strFullName;
    }

    public void setUserFullName(String strNewFullName) {
        this.strFullName = strNewFullName;
    }

    public String getUserID() {
        return this.strID;
    }

    public void setUserID(String strNewID) {
        this.strID = strNewID;
    }

    public String getUserDescription() {
        return this.strDescription;
    }

    public void setUserDescription(String strNewDesc) {
        this.strDescription = strNewDesc;
    }

    public String getUserType() {
        return this.strType;
    }

    public void setUserType(String strOSType) {
        this.strType = strOSType;
    }

    public void setSolPasswordAttr(SolPasswordAttr solPasswd) {
        this.solPasswd = solPasswd;
    }

    public SolPasswordAttr getSolPasswordAttr() {
        return this.solPasswd;
    }

    public void setSolGroupAttr(SolGroupAttr input) {
        this.solGroup = input;
    }

    public SolGroupAttr getSolGroupAttr() {
        return this.solGroup;
    }

    public void setSolHomedirAttr(SolHomedirAttr solHomedir) {
        this.solHomedir = solHomedir;
    }

    public SolHomedirAttr getSolHomedirAttr() {
        return this.solHomedir;
    }

    public void setSolServicesAttr(SolServicesAttr solServices) {
        this.solServices = solServices;
    }

    public SolServicesAttr getSolServicesAttr() {
        return this.solServices;
    }

    public void setSolAccountAttr(SolAccountAttr input) {
        this.solAccount = input;
    }

    public SolAccountAttr getSolAccountAttr() {
        return this.solAccount;
    }

    public void debugPrint() {
        AdminCommonTools.CMN_Trace3("--------------------------------------------");
        AdminCommonTools.CMN_Trace3("User Object is as follows:");
        AdminCommonTools.CMN_Trace3("User name is " + this.strName);
        AdminCommonTools.CMN_Trace3("User ID is " + this.strID);
        AdminCommonTools.CMN_Trace3("User Description is " + this.strDescription);
        AdminCommonTools.CMN_Trace3("User type is " + this.strType);
        AdminCommonTools.CMN_Trace3("User Template is " + this.strTemplateName);
        if (this.solServices != null) {
            // empty if block
        }
        if (this.solHomedir != null) {
            // empty if block
        }
        if (this.solGroup != null) {
            this.solGroup.debugPrint();
        }
        if (this.solPasswd != null) {
            this.solPasswd.debugPrint();
        }
        if (this.solAccount != null) {
            this.solAccount.debugPrint();
        }
        AdminCommonTools.CMN_Trace3("End of User Object");
        AdminCommonTools.CMN_Trace3("--------------------------------------------");
    }
}

