/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.component;

import com.sun.web.ui.component.UploadBase;
import com.sun.web.ui.model.UploadedFile;
import com.sun.web.ui.util.ComponentUtilities;
import com.sun.web.ui.util.ThemeUtilities;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.commons.fileupload.FileItem;

public class Upload
extends UploadBase
implements Serializable {
    public static final String INPUT_ID = "_com.sun.web.ui.upload";
    public static final String INPUT_PARAM_ID = "_com.sun.web.ui.uploadParam";
    public static final String SCRIPT_ID = "_script";
    public static final String SCRIPT_FACET = "script";
    public static final String TEXT_ID = "_text";
    public static final String LENGTH_EXCEEDED = "length_exceeded";
    public static final String FILE_SIZE_KEY = "file_size_key";
    public static final String UPLOAD_NO_DATA_KEY = "upload_nodata_key";
    public static final String UPLOAD_ERROR_KEY = "upload_error_key";
    private static final boolean DEBUG = false;

    protected void log(String s) {
        System.out.println(this.getClass().getName() + "::" + s);
    }

    public Object getConvertedValue(FacesContext context, Object value) {
        String name;
        UploadedFileImpl uf = new UploadedFileImpl(value, context);
        if (this.isRequired() && uf.getSize() == 0L && ((name = uf.getOriginalName()) == null || name.trim().length() == 0)) {
            this.setValue("");
            return "";
        }
        return uf;
    }

    public String getValueAsString(FacesContext context) {
        return null;
    }

    public String getReadOnlyValueString(FacesContext context) {
        String valueString = null;
        Object value = this.getValue();
        if (value != null & value instanceof UploadedFile) {
            try {
                valueString = ((UploadedFile)value).getOriginalName();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (valueString == null) {
            valueString = ThemeUtilities.getTheme(context).getMessage("FileUpload.noFile");
        }
        return valueString;
    }

    public String getType() {
        return "file";
    }

    public Object getText() {
        return null;
    }

    public void setText(Object text) {
    }

    public int getColumns() {
        int columns = super.getColumns();
        if (columns < 1) {
            columns = 40;
        }
        return columns;
    }

    public String getPrimaryElementID(FacesContext context) {
        String clntId = this.getClientId(context);
        UIComponent facet = this.getFacet("label");
        if (facet != null) {
            return clntId.concat(INPUT_ID);
        }
        facet = ComponentUtilities.getPrivateFacet((UIComponent)this, "label", false);
        if (facet == null) {
            return this.getClientId(context);
        }
        return this.getClientId(context).concat(INPUT_ID);
    }

    class UploadedFileImpl
    implements UploadedFile {
        transient FileItem fileItemObject = null;

        UploadedFileImpl(Object attribute, FacesContext context) {
            try {
                this.fileItemObject = (FileItem)context.getExternalContext().getRequestMap().get(attribute);
            }
            catch (Exception e) {
                String message = "File not uploaded. Is the upload filter installed ?";
                throw new FacesException(message, (Throwable)e);
            }
        }

        public void write(File file) throws Exception {
            if (this.fileItemObject != null) {
                this.fileItemObject.write(file);
            }
        }

        public long getSize() {
            if (this.fileItemObject != null) {
                return this.fileItemObject.getSize();
            }
            return 0L;
        }

        public String getOriginalName() {
            if (this.fileItemObject != null) {
                return this.fileItemObject.getName();
            }
            return null;
        }

        public InputStream getInputStream() throws IOException {
            if (this.fileItemObject != null) {
                return this.fileItemObject.getInputStream();
            }
            return null;
        }

        public String getContentType() {
            if (this.fileItemObject != null) {
                return this.fileItemObject.getContentType();
            }
            return null;
        }

        public byte[] getBytes() {
            if (this.fileItemObject != null) {
                return this.fileItemObject.get();
            }
            return null;
        }

        public String getAsString() {
            if (this.fileItemObject != null) {
                return this.fileItemObject.getString();
            }
            return null;
        }

        public void dispose() {
            if (this.fileItemObject != null) {
                this.fileItemObject.delete();
            }
        }
    }
}

