/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.component.util.event;

import com.sun.web.ui.component.util.event.Handler;
import com.sun.web.ui.component.util.event.HandlerContext;
import com.sun.web.ui.component.util.event.IODescriptor;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HandlerDefinition
implements Serializable {
    public static final Class[] EVENT_ARGS = new Class[]{HandlerContext.class};
    private String _id = null;
    private String _description = null;
    private String _methodClass = null;
    private String _methodName = null;
    private transient Method _method = null;
    private Map _inputDefs = new HashMap(5);
    private Map _outputDefs = new HashMap(5);
    private List _childHandlers = new ArrayList(5);
    private transient Boolean _static = null;
    private static final long serialVersionUID = -6289339732628143599L;

    public HandlerDefinition(String id) {
        this._id = id;
    }

    public String getId() {
        return this._id;
    }

    public String getDescription() {
        return this._description;
    }

    public void setDescription(String desc) {
        this._description = desc;
    }

    public void setHandlerMethod(String cls, String methodName) {
        if (cls == null || methodName == null) {
            throw new IllegalArgumentException("Class name and method name must be non-null!");
        }
        this._methodClass = cls;
        this._methodName = methodName;
    }

    public void setHandlerMethod(Method method) {
        if (method != null) {
            this._methodName = method.getName();
            this._methodClass = method.getDeclaringClass().getName();
        } else {
            this._methodName = null;
            this._methodClass = null;
        }
        this._method = method;
    }

    public boolean isStatic() {
        if (this._static == null) {
            this._static = Modifier.isStatic(this.getHandlerMethod().getModifiers());
        }
        return this._static;
    }

    public Method getHandlerMethod() {
        if (this._method != null) {
            return this._method;
        }
        if (this._methodClass != null && this._methodName != null) {
            Class<?> clzz = null;
            try {
                clzz = Class.forName(this._methodClass);
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException("'" + this._methodClass + "' not found!", ex);
            }
            Method method = null;
            try {
                method = clzz.getMethod(this._methodName, EVENT_ARGS);
            }
            catch (NoSuchMethodException ex) {
                throw new RuntimeException("Method '" + this._methodName + "' not found!", ex);
            }
            this._method = method;
        }
        return this._method;
    }

    public void addInputDef(IODescriptor desc) {
        this._inputDefs.put(desc.getName(), desc);
    }

    public void setInputDefs(Map inputDefs) {
        if (inputDefs == null) {
            throw new IllegalArgumentException("inputDefs cannot be null!");
        }
        this._inputDefs = inputDefs;
    }

    public Map getInputDefs() {
        return this._inputDefs;
    }

    public IODescriptor getInputDef(String name) {
        return (IODescriptor)this._inputDefs.get(name);
    }

    public void addOutputDef(IODescriptor desc) {
        this._outputDefs.put(desc.getName(), desc);
    }

    public void setOutputDefs(Map outputDefs) {
        if (outputDefs == null) {
            throw new IllegalArgumentException("outputDefs cannot be null!");
        }
        this._outputDefs = outputDefs;
    }

    public Map getOutputDefs() {
        return this._outputDefs;
    }

    public IODescriptor getOutputDef(String name) {
        return (IODescriptor)this._outputDefs.get(name);
    }

    public void addChildHandler(Handler desc) {
        this._childHandlers.add(desc);
    }

    public void setChildHandlers(List childHandlers) {
        if (childHandlers == null) {
            throw new IllegalArgumentException("childHandlers cannot be null!");
        }
        this._childHandlers = childHandlers;
    }

    public List getChildHandlers() {
        return this._childHandlers;
    }
}

