/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.renderer;

import com.sun.web.ui.component.Icon;
import com.sun.web.ui.component.ImageComponent;
import com.sun.web.ui.renderer.AbstractRenderer;
import com.sun.web.ui.theme.Theme;
import com.sun.web.ui.util.ClientSniffer;
import com.sun.web.ui.util.LogUtil;
import com.sun.web.ui.util.RenderingUtilities;
import com.sun.web.ui.util.ThemeUtilities;
import java.beans.Beans;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class ImageRenderer
extends AbstractRenderer {
    private static final String[] integerAttributes = new String[]{"border", "hspace", "vspace"};
    private static final String[] stringAttributes = new String[]{"align", "onClick", "onDblClick", "onMouseDown", "onMouseMove", "onMouseOut", "onMouseOver"};

    protected void renderStart(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        ImageComponent image = (ImageComponent)component;
        writer.startElement("img", (UIComponent)image);
    }

    protected void renderAttributes(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        String longDesc;
        ImageComponent image = (ImageComponent)component;
        String clientId = image.getClientId(context);
        if (clientId != null) {
            writer.writeAttribute("id", (Object)clientId, null);
        }
        String url = image.getUrl();
        String icon = image.getIcon();
        String alt = image.getAlt();
        int height = image.getHeight();
        int width = image.getWidth();
        if (image instanceof Icon || icon != null && url == null) {
            String iconAlt;
            Icon themeIcon = ThemeUtilities.getTheme(context).getIcon(icon);
            url = themeIcon.getUrl();
            int dim = themeIcon.getHeight();
            if (height < 0 && dim >= 0) {
                height = dim;
            }
            dim = themeIcon.getWidth();
            if (width < 0 && dim >= 0) {
                width = dim;
            }
            if ((iconAlt = themeIcon.getAlt()) != null) {
                alt = iconAlt;
            }
        } else if (url == null) {
            if (!Beans.isDesignTime() && LogUtil.warningEnabled(ImageRenderer.class)) {
                LogUtil.warning(ImageRenderer.class, "  URL  was not specified and generally should be");
            }
        } else {
            url = context.getApplication().getViewHandler().getResourceURL(context, url);
        }
        url = url != null && url.trim().length() != 0 ? context.getExternalContext().encodeResourceURL(url) : "";
        StringBuffer styleAdditions = null;
        String style = image.getStyle();
        if (this.isPngAndIE(context, url)) {
            styleAdditions = new StringBuffer(200);
            styleAdditions.append("width:");
            if (width > 0) {
                styleAdditions.append(width);
                styleAdditions.append("px;");
            } else {
                styleAdditions.append("100px;");
            }
            styleAdditions.append("height:");
            if (height > 0) {
                styleAdditions.append(height);
                styleAdditions.append("px;");
            } else {
                styleAdditions.append("100px;");
            }
            styleAdditions.append("filter:progid:DXImageTransform.Microsoft.");
            styleAdditions.append("AlphaImageLoader(src='");
            styleAdditions.append(url);
            styleAdditions.append("', sizingMethod='scale')");
            Theme theme = ThemeUtilities.getTheme(context);
            url = theme.getIcon("DOT").getUrl();
            if (style == null) {
                style = styleAdditions.toString();
            } else {
                if (!style.endsWith(";")) {
                    style = style + ";";
                }
                style = style + styleAdditions;
            }
        }
        RenderingUtilities.renderStyleClass(context, writer, (UIComponent)image, null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        RenderingUtilities.renderURLAttribute(context, writer, (UIComponent)image, "src", url, "url");
        if (alt != null) {
            writer.writeAttribute("alt", (Object)alt, null);
        } else {
            writer.writeAttribute("alt", (Object)"", null);
        }
        String toolTip = image.getToolTip();
        if (toolTip != null) {
            writer.writeAttribute("title", (Object)toolTip, null);
        }
        if ((longDesc = image.getLongDesc()) != null) {
            writer.writeAttribute("longdesc", (Object)longDesc, null);
        }
        if (height >= 0) {
            writer.writeAttribute("height", (Object)Integer.toString(height), null);
        }
        if (width >= 0) {
            writer.writeAttribute("width", (Object)Integer.toString(width), null);
        }
        this.addIntegerAttributes(context, component, writer, integerAttributes);
        ImageRenderer.addStringAttributes(context, component, writer, stringAttributes);
    }

    protected void renderEnd(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        ImageComponent image = (ImageComponent)component;
        writer.endElement("img");
    }

    private boolean isPngAndIE(FacesContext context, String url) {
        ClientSniffer cs = ClientSniffer.getInstance(context);
        if (cs.isIe6up() || !cs.isIe5up()) {
            return false;
        }
        if (url.indexOf("sessionid") != -1) {
            return url.substring(0, url.indexOf(59)).endsWith(".png");
        }
        return url.endsWith(".png");
    }
}

