/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.html;

import com.sun.webui.jsf.component.EditableList;
import com.sun.webui.jsf.renderkit.html.ListRendererBase;
import com.sun.webui.jsf.util.JSONUtilities;
import com.sun.webui.jsf.util.JavaScriptUtilities;
import com.sun.webui.jsf.util.RenderingUtilities;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import java.io.IOException;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.json.JSONException;
import org.json.JSONObject;

public class EditableListRenderer
extends ListRendererBase {
    private static final boolean DEBUG = false;

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (!(component instanceof EditableList)) {
            String message = "Component " + component.toString() + " has been associated with an EditableListRenderer. " + " This renderer can only be used by components " + " that extend com.sun.webui.jsf.component.Selector.";
            throw new FacesException(message);
        }
        this.renderListComponent((EditableList)component, context, this.getStyles(component, context));
    }

    public void decode(FacesContext context, UIComponent component) {
        EditableList list = (EditableList)component;
        if (list.isReadOnly()) {
            return;
        }
        String id = list.getClientId(context);
        Map params = context.getExternalContext().getRequestParameterValuesMap();
        String listID = component.getClientId(context).concat("_list");
        String[] selections = null;
        Object parameters = params.get(listID);
        selections = parameters == null ? new String[]{} : (parameters instanceof String[] ? (String[])parameters : new String[]{parameters.toString()});
        list.setValuesToRemove(selections);
        String valueID = id.concat("_list_value");
        super.decode(context, component, valueID);
    }

    void renderListComponent(EditableList component, FacesContext context, String[] styles) throws IOException {
        if (component.isReadOnly()) {
            UIComponent label = component.getListLabelComponent();
            super.renderReadOnlyList(component, label, context, styles[8]);
            return;
        }
        UIComponent headerComponent = component.getFacet("header");
        UIComponent footerComponent = component.getFacet("footer");
        boolean gotHeaderOrFooter = headerComponent != null || footerComponent != null;
        ResponseWriter writer = context.getResponseWriter();
        super.renderOpenEncloser(component, context, "div", styles[8]);
        if (gotHeaderOrFooter) {
            writer.startElement("table", (UIComponent)component);
            writer.writeText((Object)"\n", null);
            if (headerComponent != null) {
                this.addComponentSingleRow(component, headerComponent, context);
            }
            writer.startElement("tr", (UIComponent)component);
            writer.writeText((Object)"\n", null);
            writer.startElement("td", (UIComponent)component);
            writer.writeText((Object)"\n", null);
        }
        writer.startElement("table", (UIComponent)component);
        writer.writeAttribute("class", (Object)styles[9], null);
        writer.writeText((Object)"\n", null);
        boolean listOnTop = component.isListOnTop();
        if (listOnTop) {
            this.addListRow(component, context, styles);
            this.addFieldRow(component, context, styles);
        } else {
            this.addFieldRow(component, context, styles);
            this.addListRow(component, context, styles);
        }
        writer.endElement("table");
        writer.writeText((Object)"\n", null);
        if (gotHeaderOrFooter) {
            writer.endElement("td");
            writer.writeText((Object)"\n", null);
            writer.endElement("tr");
            writer.writeText((Object)"\n", null);
            if (footerComponent != null) {
                this.addComponentSingleRow(component, footerComponent, context);
            }
            writer.endElement("table");
            writer.writeText((Object)"\n", null);
        }
        writer.endElement("div");
        this.renderJavaScript((UIComponent)component, context, writer);
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    private void addComponentSingleRow(EditableList list, UIComponent component, FacesContext context) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("tr", (UIComponent)list);
        writer.writeText((Object)"\n", null);
        writer.startElement("td", (UIComponent)list);
        RenderingUtilities.renderComponent(component, context);
        writer.writeText((Object)"\n", null);
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
        writer.endElement("tr");
        writer.writeText((Object)"\n", null);
    }

    private void addListRow(EditableList component, FacesContext context, String[] styles) throws IOException {
        UIComponent listLabelComponent = component.getListLabelComponent();
        UIComponent removeButtonComponent = component.getRemoveButtonComponent();
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("tr", (UIComponent)component);
        writer.writeText((Object)"\n", null);
        writer.startElement("td", (UIComponent)component);
        writer.writeAttribute("class", (Object)styles[13], null);
        writer.writeAttribute("valign", (Object)"top", null);
        writer.writeText((Object)"\n", null);
        RenderingUtilities.renderComponent(listLabelComponent, context);
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
        writer.startElement("td", (UIComponent)component);
        writer.writeAttribute("class", (Object)styles[14], null);
        writer.writeAttribute("valign", (Object)"top", null);
        writer.writeText((Object)"\n", null);
        super.renderHiddenValue((UIComponent)component, context, writer, styles[8]);
        writer.writeText((Object)"\n", null);
        String id = component.getClientId(context).concat("_list");
        super.renderList(component, id, context, styles);
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
        writer.startElement("td", (UIComponent)component);
        writer.writeAttribute("class", (Object)styles[15], null);
        writer.writeAttribute("valign", (Object)"top", null);
        writer.writeText((Object)"\n", null);
        RenderingUtilities.renderComponent(removeButtonComponent, context);
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
        writer.endElement("tr");
        writer.writeText((Object)"\n", null);
    }

    private void addFieldRow(EditableList component, FacesContext context, String[] styles) throws IOException {
        UIComponent textfieldLabelComponent = component.getFieldLabelComponent();
        UIComponent textfieldComponent = component.getFieldComponent();
        UIComponent addButtonComponent = component.getAddButtonComponent();
        UIComponent searchButtonComponent = component.getFacet("search");
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("tr", (UIComponent)component);
        writer.writeText((Object)"\n", null);
        writer.startElement("td", (UIComponent)component);
        writer.writeAttribute("class", (Object)styles[10], null);
        writer.writeText((Object)"\n", null);
        RenderingUtilities.renderComponent(textfieldLabelComponent, context);
        writer.writeText((Object)"\n", null);
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
        writer.startElement("td", (UIComponent)component);
        writer.writeAttribute("class", (Object)styles[11], null);
        writer.writeAttribute("valign", (Object)"top", null);
        writer.writeText((Object)"\n", null);
        RenderingUtilities.renderComponent(textfieldComponent, context);
        writer.writeText((Object)"\n", null);
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
        writer.startElement("td", (UIComponent)component);
        writer.writeAttribute("class", (Object)styles[12], null);
        writer.writeAttribute("valign", (Object)"top", null);
        writer.writeText((Object)"\n", null);
        RenderingUtilities.renderComponent(addButtonComponent, context);
        writer.writeText((Object)"\n", null);
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
        if (searchButtonComponent != null) {
            writer.startElement("td", (UIComponent)component);
            writer.writeAttribute("class", (Object)styles[12], null);
            writer.writeAttribute("valign", (Object)"top", null);
            writer.writeText((Object)"\n", null);
            RenderingUtilities.renderComponent(searchButtonComponent, context);
            writer.writeText((Object)"\n", null);
            writer.endElement("td");
            writer.writeText((Object)"\n", null);
        }
        writer.endElement("tr");
        writer.writeText((Object)"\n", null);
    }

    private void renderJavaScript(UIComponent component, FacesContext context, ResponseWriter writer) throws IOException {
        try {
            StringBuffer buff = new StringBuffer(256);
            JSONObject json = new JSONObject();
            json.put("id", (Object)component.getClientId(context));
            buff.append(JavaScriptUtilities.getModule("editableList")).append("\n").append(JavaScriptUtilities.getModuleName("editableList.init")).append("(").append(JSONUtilities.getString(json)).append(");");
            JavaScriptUtilities.renderJavaScript(component, writer, buff.toString(), true);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private String[] getStyles(UIComponent component, FacesContext context) {
        Theme theme = ThemeUtilities.getTheme(context);
        StringBuffer onchangeBuffer = new StringBuffer(128);
        onchangeBuffer.append(((EditableList)component).getOnChange());
        onchangeBuffer.append(JavaScriptUtilities.getModuleName("listbox.changed"));
        onchangeBuffer.append("('");
        onchangeBuffer.append(component.getClientId(context));
        onchangeBuffer.append("'); return false;");
        String[] styles = new String[]{onchangeBuffer.toString(), theme.getStyleClass("LIST"), theme.getStyleClass("LIST_DISABLED"), theme.getStyleClass("LIST_OPTION"), theme.getStyleClass("LIST_OPTION_DISABLED"), theme.getStyleClass("LIST_OPTION_SELECTED"), theme.getStyleClass("LIST_OPTION_GROUP"), theme.getStyleClass("LIST_OPTION_SEPARATOR"), theme.getStyleClass("HIDDEN"), theme.getStyleClass("EDITABLELIST_TABLE"), theme.getStyleClass("EDITABLELIST_FIELD_LABEL"), theme.getStyleClass("EDITABLELIST_FIELD"), theme.getStyleClass("EDITABLELIST_ADD_BUTTON"), theme.getStyleClass("EDITABLELIST_LIST_LABEL"), theme.getStyleClass("EDITABLELIST_LIST"), theme.getStyleClass("EDITABLELIST_REMOVE_BUTTON"), null};
        return styles;
    }
}

