/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.html;

import com.sun.webui.jsf.component.Icon;
import com.sun.webui.jsf.component.Wizard;
import com.sun.webui.jsf.component.WizardStep;
import com.sun.webui.jsf.model.WizardStepListItem;
import com.sun.webui.jsf.renderkit.html.AbstractRenderer;
import com.sun.webui.jsf.util.JSONUtilities;
import com.sun.webui.jsf.util.JavaScriptUtilities;
import com.sun.webui.jsf.util.RenderingUtilities;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Iterator;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.json.JSONException;
import org.json.JSONObject;

public class WizardRenderer
extends AbstractRenderer {
    private static final String ANCHOR = "a";
    private static final String DIV = "div";
    private static final String IMG = "img";
    private static final String INPUT = "input";
    private static final String PARA = "p";
    private static final String SCRIPT = "script";
    private static final String SPAN = "span";
    private static final String TABLE = "table";
    private static final String TD = "td";
    private static final String TR = "tr";
    private static final String ALIGN = "align";
    private static final String ALT = "alt";
    private static final String BORDER = "border";
    private static final String CELLPADDING = "cellpadding";
    private static final String CELLSPACING = "cellspacing";
    private static final String CLASS = "class";
    private static final String STYLE_CLASS = "styleClass";
    private static final String DISABLED = "disabled";
    private static final String HEIGHT = "height";
    private static final String HREF = "href";
    private static final String HSPACE = "hspace";
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String NOWRAP = "nowrap";
    private static final String ONBLUR = "onblur";
    private static final String ONCLICK = "onclick";
    private static final String ONFOCUS = "onfocus";
    private static final String ONMOUSEOVER = "onmouseover";
    private static final String ONMOUSEOUT = "onmouseout";
    private static final String SRC = "src";
    private static final String STYLE = "style";
    private static final String TITLE = "title";
    private static final String TYPE = "type";
    private static final String VALIGN = "valign";
    private static final String VALUE = "valign";
    private static final String WIDTH = "width";
    private static final String _1_PERCENT = "1%";
    private static final String _90_PERCENT = "90%";
    private static final String _99_PERCENT = "99%";
    private static final String _100_PERCENT = "100%";
    private static final String BOTTOM = "bottom";
    private static final String LEFT = "left";
    private static final String RIGHT = "right";
    private static final String SUBMIT = "submit";
    private static final String TOP = "top";
    private static final String TEXT_JAVASCRIPT = "text/javascript";
    private static final String NBSP = "&nbsp;";
    private static final String STEPS_PANE_SUFFIX = "_stepspane";
    private static final String SPACE = " ";
    private static final String EMPTY_STRING = "";
    private static final String USCORE = "_";
    private static final String WIZARD_JSOBJECT_CLASS = "Wizard";
    private static final String SQUOTE = "'";
    private static final String CLOSEPOPUPJS = "{0}.closePopup();";
    private static final String TOOLTIP = "toolTip";
    private static final String SHOWCONTROLS = "showControls";
    private static final String SHOWSTEPSPANE = "showStepsPane";
    private static final String SHOWSTEPHELP = "showStepHelp";
    private static final String SHOWTITLE = "showTitle";
    private static final String ONPOPUPDISMISS = "onPopupDismiss";
    private static final String WIZARD_SKIP_LINK_ALT = "Wizard.skipLinkAlt";
    private static final String MSG_COMPONENT_NOT_WIZARD = "WizardLayoutRenderer only renders Wizard components.";

    public boolean getRendersChildren() {
        return true;
    }

    protected String getWizardCloseJavaScript(FacesContext context, UIComponent component) throws IOException {
        String onPopupDismiss = (String)component.getAttributes().get(ONPOPUPDISMISS);
        if (onPopupDismiss == null || onPopupDismiss.length() == 0) {
            Object[] args = new Object[]{JavaScriptUtilities.getModuleName("wizard")};
            onPopupDismiss = MessageFormat.format(CLOSEPOPUPJS, args);
        }
        return onPopupDismiss;
    }

    protected void renderStart(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        if (!(component instanceof Wizard)) {
            throw new IllegalArgumentException(this.getMessage(MSG_COMPONENT_NOT_WIZARD));
        }
        Theme theme = ThemeUtilities.getTheme(context);
        this.renderWizardBegin(context, component, theme, writer);
    }

    public void encodeChildren(FacesContext context, UIComponent component) {
    }

    protected void renderEnd(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        Theme theme = ThemeUtilities.getTheme(context);
        if (!((Wizard)component).isComplete()) {
            this.renderWizard(context, component, theme, writer);
        }
        this.renderWizardEnd(context, component, theme, writer);
    }

    protected void renderWizardBegin(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer) throws IOException {
        String wizId = component.getClientId(context);
        writer.startElement(DIV, component);
        writer.writeAttribute(ID, (Object)wizId, ID);
        String style = (String)component.getAttributes().get(STYLE);
        if (style != null) {
            writer.writeAttribute(STYLE, (Object)style, STYLE);
        }
        String styles = RenderingUtilities.getStyleClasses(context, component, theme.getStyleClass("WIZARD"));
        writer.writeAttribute(CLASS, (Object)styles, null);
        String toolTip = (String)component.getAttributes().get(TOOLTIP);
        if (toolTip == null) {
            toolTip = theme.getMessage(WIZARD_SKIP_LINK_ALT);
        }
        this.renderSkipLink(context, component, theme, writer, component.getClientId(context), toolTip);
    }

    protected void renderWizard(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer) throws IOException {
        this.renderTitle(context, component, theme, writer);
        this.renderStepsBar(context, component, theme, writer);
        this.renderStepsPane(context, component, theme, writer);
        this.renderTask(context, component, theme, writer);
        this.renderControlBar(context, component, theme, writer);
    }

    protected void renderWizardEnd(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer) throws IOException {
        writer.endElement(DIV);
        try {
            StringBuffer buff = new StringBuffer(256);
            JSONObject json = new JSONObject();
            json.put(ID, (Object)component.getClientId(context));
            json.put("facesViewState", (Object)"javax.faces.ViewState");
            buff.append(JavaScriptUtilities.getModule("wizard")).append("\n").append(JavaScriptUtilities.getModuleName("wizard.init")).append("(").append(JSONUtilities.getString(json)).append(");");
            if (((Wizard)component).isComplete()) {
                buff.append(this.getWizardCloseJavaScript(context, component));
            }
            JavaScriptUtilities.renderJavaScript(component, writer, buff.toString(), true);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    protected void renderTitle(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer) throws IOException {
        if (!this.show(component, SHOWTITLE)) {
            return;
        }
        this.renderTitleBegin(context, component, theme, writer);
        this.renderTitleText(context, component, writer);
        this.renderTitleEnd(context, component, theme, writer);
    }

    protected void renderTitleBegin(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer) throws IOException {
        writer.startElement(DIV, component);
        writer.writeAttribute(CLASS, (Object)theme.getStyleClass("WIZARD_TITLE_BAR"), null);
    }

    protected void renderTitleText(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        Wizard wizard = (Wizard)component;
        UIComponent title = wizard.getTitleComponent();
        if (title != null) {
            RenderingUtilities.renderComponent(title, context);
        }
    }

    protected void renderTitleEnd(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer) throws IOException {
        writer.endElement(DIV);
    }

    protected void renderStepsBar(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer) throws IOException {
        Wizard wizard = (Wizard)component;
        UIComponent stepsBar = wizard.getStepsBarComponent();
        if (stepsBar != null) {
            RenderingUtilities.renderComponent(stepsBar, context);
            return;
        }
        if (wizard.hasStepHelp() && this.show(component, SHOWSTEPHELP)) {
            this.renderTabsBar(context, component, theme, writer);
        } else {
            this.renderEmptyBar(component, theme, writer);
        }
    }

    protected void renderStepsPane(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer) throws IOException {
        if (!this.show(component, SHOWSTEPSPANE)) {
            return;
        }
        Wizard wizard = (Wizard)component;
        UIComponent stepsPane = wizard.getStepsPaneComponent();
        if (stepsPane != null) {
            RenderingUtilities.renderComponent(stepsPane, context);
            return;
        }
        if (wizard.isStepsTabActive()) {
            this.renderStepListBegin(context, component, theme, writer);
            if (!wizard.hasStepHelp()) {
                this.renderStepsPaneTitle(context, component, theme, writer);
            }
            this.renderStepList(context, component, theme, writer);
            this.renderStepListEnd(context, component, theme, writer);
        } else {
            this.renderStepHelp(context, component, theme, writer);
        }
    }

    protected void renderStepListBegin(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer) throws IOException {
        Wizard wizard = (Wizard)component;
        String paneId = component.getClientId(context).concat(STEPS_PANE_SUFFIX);
        writer.startElement(DIV, component);
        writer.writeAttribute(ID, (Object)paneId, null);
        writer.writeAttribute(CLASS, (Object)theme.getStyleClass("WIZARD_STEP"), null);
    }

    protected void renderTabsBar(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer) throws IOException {
        Wizard wizard = (Wizard)component;
        UIComponent tabs = wizard.getTabsComponent();
        if (tabs == null) {
            return;
        }
        writer.startElement(DIV, component);
        writer.writeAttribute(CLASS, (Object)theme.getStyleClass("WIZARD_STEP_TAB"), null);
        RenderingUtilities.renderComponent(tabs, context);
        writer.endElement(DIV);
    }

    protected void renderEmptyBar(UIComponent component, Theme theme, ResponseWriter writer) throws IOException {
        writer.startElement(DIV, component);
        writer.writeAttribute(CLASS, (Object)theme.getStyleClass("WIZARD_BAR"), null);
        writer.endElement(DIV);
    }

    protected void renderStepsPaneTitle(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer) throws IOException {
        Wizard wizard = (Wizard)component;
        UIComponent stepsPaneTitle = wizard.getStepsPaneTitleComponent();
        if (stepsPaneTitle == null) {
            return;
        }
        writer.startElement(DIV, component);
        writer.writeAttribute(CLASS, (Object)theme.getStyleClass("WIZARD_STEP_TITLE"), null);
        RenderingUtilities.renderComponent(stepsPaneTitle, context);
        writer.endElement(DIV);
    }

    protected void renderStepList(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer) throws IOException {
        Wizard wizard = (Wizard)component;
        UIComponent stepList = wizard.getStepListComponent();
        if (stepList != null) {
            RenderingUtilities.renderComponent(stepList, context);
            return;
        }
        writer.startElement(TABLE, component);
        writer.writeAttribute(BORDER, (Object)Integer.toString(0), null);
        writer.writeAttribute(CELLSPACING, (Object)Integer.toString(0), null);
        writer.writeAttribute(CELLPADDING, (Object)Integer.toString(0), null);
        writer.writeAttribute(CLASS, (Object)theme.getStyleClass("WIZARD_STEP_TABLE"), null);
        Iterator stepListIterator = wizard.getStepListIterator();
        while (stepListIterator.hasNext()) {
            WizardStepListItem stepItem = (WizardStepListItem)stepListIterator.next();
            if (stepItem.isSubstep()) {
                this.renderSubstep(context, component, theme, writer, stepItem);
                continue;
            }
            if (stepItem.isCurrentStep()) {
                this.renderCurrentStep(context, component, theme, writer, stepItem);
                continue;
            }
            if (stepItem.isBranch()) {
                this.renderBranchStep(context, component, theme, writer, stepItem);
                continue;
            }
            this.renderStep(context, component, theme, writer, stepItem);
        }
        writer.endElement(TABLE);
    }

    protected void renderCurrentStepIndicator(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer) throws IOException {
        Wizard wizard = (Wizard)component;
        UIComponent stepIndicator = wizard.getStepIndicatorComponent();
        if (stepIndicator != null) {
            RenderingUtilities.renderComponent(stepIndicator, context);
        }
    }

    protected void renderSubstep(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer, WizardStepListItem step) throws IOException {
        boolean isCurrentStep = step.isCurrentStep();
        String stepTextStyle = isCurrentStep ? theme.getStyleClass("WIZARD_STEP_CURRENT_TEXT") : theme.getStyleClass("WIZARD_STEP_LINK");
        writer.startElement(TR, component);
        if (isCurrentStep) {
            writer.startElement(TD, component);
            writer.writeAttribute("valign", (Object)TOP, null);
            writer.writeAttribute(ALIGN, (Object)RIGHT, null);
            writer.writeAttribute(NOWRAP, (Object)NOWRAP, null);
            writer.startElement(DIV, component);
            writer.writeAttribute(CLASS, (Object)theme.getStyleClass("WIZARD_STEP_ARROW_DIV"), null);
            this.renderCurrentStepIndicator(context, component, theme, writer);
            writer.endElement(DIV);
            writer.endElement(TD);
        } else {
            writer.startElement(TD, component);
            writer.writeAttribute("valign", (Object)TOP, null);
            writer.endElement(TD);
        }
        writer.startElement(TD, component);
        writer.writeAttribute("valign", (Object)TOP, null);
        writer.startElement(TABLE, component);
        writer.writeAttribute(BORDER, (Object)Integer.toString(0), null);
        writer.writeAttribute(CELLSPACING, (Object)Integer.toString(0), null);
        writer.writeAttribute(CELLPADDING, (Object)Integer.toString(0), null);
        writer.startElement(TR, component);
        writer.startElement(TD, component);
        writer.writeAttribute("valign", (Object)TOP, null);
        writer.startElement(DIV, component);
        writer.writeAttribute(CLASS, (Object)theme.getStyleClass("WIZARD_STEP_TEXT_DIV"), null);
        this.renderStepNumber(context, component, theme, writer, step, stepTextStyle);
        writer.endElement(DIV);
        writer.endElement(TD);
        writer.startElement(TD, component);
        writer.writeAttribute("valign", (Object)TOP, null);
        writer.startElement(DIV, component);
        writer.writeAttribute(CLASS, (Object)theme.getStyleClass("WIZARD_STEP_TEXT_DIV"), null);
        this.renderStepSummary(context, component, theme, writer, step, stepTextStyle);
        writer.endElement(DIV);
        writer.endElement(TD);
        writer.endElement(TR);
        writer.endElement(TABLE);
        writer.endElement(TD);
        writer.endElement(TR);
    }

    protected void renderBranchStep(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer, WizardStepListItem step) throws IOException {
        writer.startElement(TR, component);
        writer.startElement(TD, component);
        writer.writeAttribute("valign", (Object)TOP, null);
        writer.writeAttribute(NOWRAP, (Object)NOWRAP, null);
        writer.write(NBSP);
        writer.endElement(TD);
        writer.startElement(TD, component);
        writer.writeAttribute("valign", (Object)TOP, null);
        writer.startElement(DIV, component);
        writer.writeAttribute(CLASS, (Object)theme.getStyleClass("WIZARD_STEP_TEXT_DIV"), null);
        this.renderStepPlaceholderText(context, component, theme, writer, step);
        writer.endElement(DIV);
        writer.endElement(TD);
        writer.endElement(TR);
    }

    protected void renderCurrentStep(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer, WizardStepListItem step) throws IOException {
        writer.startElement(TR, component);
        writer.startElement(TD, component);
        writer.writeAttribute("valign", (Object)TOP, null);
        writer.writeAttribute(NOWRAP, (Object)NOWRAP, null);
        writer.startElement(DIV, component);
        writer.writeAttribute(CLASS, (Object)theme.getStyleClass("WIZARD_STEP_ARROW_DIV"), null);
        this.renderCurrentStepIndicator(context, component, theme, writer);
        this.renderStepNumber(context, component, theme, writer, step, theme.getStyleClass("WIZARD_STEP_CURRENT_TEXT"));
        writer.endElement(DIV);
        writer.endElement(TD);
        writer.startElement(TD, component);
        writer.writeAttribute("valign", (Object)TOP, null);
        writer.startElement(DIV, component);
        writer.writeAttribute(CLASS, (Object)theme.getStyleClass("WIZARD_STEP_TEXT_DIV"), null);
        this.renderStepSummary(context, component, theme, writer, step, theme.getStyleClass("WIZARD_STEP_CURRENT_TEXT"));
        writer.endElement(DIV);
        writer.endElement(TD);
        writer.endElement(TR);
    }

    protected void renderStepNumber(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer, WizardStepListItem step, String styleClass) throws IOException {
        UIComponent number = ((Wizard)component).getStepNumberComponent(step.getStep(), step.getStepNumberString());
        if (number == null) {
            return;
        }
        number.getAttributes().put(STYLE_CLASS, styleClass);
        RenderingUtilities.renderComponent(number, context);
    }

    protected void renderStepSummary(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer, WizardStepListItem step, String styleClass) throws IOException {
        UIComponent text = ((Wizard)component).getStepSummaryComponent(step.getStep());
        if (text == null) {
            return;
        }
        text.getAttributes().put(STYLE_CLASS, styleClass);
        RenderingUtilities.renderComponent(text, context);
    }

    protected void renderStepPlaceholderText(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer, WizardStepListItem step) throws IOException {
        UIComponent text = ((Wizard)component).getStepPlaceholderTextComponent(step.getStep());
        if (text == null) {
            return;
        }
        text.getAttributes().put(STYLE_CLASS, theme.getStyleClass("WIZARD_STEP_TEXT"));
        RenderingUtilities.renderComponent(text, context);
    }

    protected void renderStep(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer, WizardStepListItem step) throws IOException {
        writer.startElement(TR, component);
        writer.startElement(TD, component);
        writer.writeAttribute("valign", (Object)TOP, null);
        writer.startElement(DIV, component);
        writer.writeAttribute(CLASS, (Object)theme.getStyleClass("WIZARD_STEP_NUMBER_DIV"), null);
        this.renderStepNumber(context, component, theme, writer, step, theme.getStyleClass("WIZARD_STEP_LINK"));
        writer.endElement(DIV);
        writer.endElement(TD);
        writer.startElement(TD, component);
        writer.writeAttribute("valign", (Object)TOP, null);
        writer.startElement(DIV, component);
        writer.writeAttribute(CLASS, (Object)theme.getStyleClass("WIZARD_STEP_TEXT_DIV"), null);
        this.renderStepSummary(context, component, theme, writer, step, theme.getStyleClass("WIZARD_STEP_LINK"));
        writer.endElement(DIV);
        writer.endElement(TD);
        writer.endElement(TR);
    }

    protected void renderStepHelp(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer) throws IOException {
        UIComponent stepHelp = ((Wizard)component).getStepHelpComponent();
        if (stepHelp != null) {
            RenderingUtilities.renderComponent(stepHelp, context);
        }
        WizardStep step = ((Wizard)component).getCurrentStep();
        this.renderStepHelpBegin(context, component, theme, writer, step);
        this.renderStepHelpText(context, component, theme, writer, step);
        this.renderStepHelpEnd(context, component, theme, writer, step);
    }

    protected void renderStepHelpBegin(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer, WizardStep step) throws IOException {
        writer.startElement(DIV, component);
        writer.writeAttribute(CLASS, (Object)theme.getStyleClass("WIZARD_HELP_DIV"), null);
        writer.startElement(PARA, component);
        writer.writeAttribute(CLASS, (Object)theme.getStyleClass("WIZARD_HELP_TEXT"), null);
    }

    protected void renderStepHelpText(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer, WizardStep step) throws IOException {
        UIComponent stepHelp = ((Wizard)component).getStepHelpTextComponent();
        if (stepHelp != null) {
            RenderingUtilities.renderComponent(stepHelp, context);
        }
    }

    protected void renderStepHelpEnd(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer, WizardStep step) throws IOException {
        writer.endElement(PARA);
        writer.endElement(DIV);
    }

    protected void renderStepListEnd(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer) throws IOException {
        writer.endElement(DIV);
    }

    protected void renderTask(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer) throws IOException {
        UIComponent task = ((Wizard)component).getTaskComponent();
        if (task != null) {
            RenderingUtilities.renderComponent(task, context);
            return;
        }
        WizardStep step = ((Wizard)component).getCurrentStep();
        if (step == null) {
            return;
        }
        this.renderTaskBegin(context, component, theme, writer);
        this.renderTaskHeader(context, component, theme, writer, step);
        this.renderStepTask(context, component, theme, writer, step);
        this.renderTaskEnd(context, component, theme, writer);
    }

    protected void renderTaskBegin(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer) throws IOException {
        String idandclass = theme.getStyleClass("WIZARD_BODY");
        writer.startElement(DIV, component);
        writer.writeAttribute(ID, (Object)component.getClientId(context).concat(USCORE).concat(idandclass), null);
        writer.writeAttribute(CLASS, (Object)idandclass, null);
        this.renderSkipAnchor(context, component, theme, writer, component.getClientId(context));
    }

    protected void renderTaskEnd(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer) throws IOException {
        writer.endElement(DIV);
    }

    protected void renderTaskHeader(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer, WizardStep step) throws IOException {
        UIComponent taskHeader = ((Wizard)component).getTaskHeaderComponent();
        if (taskHeader != null) {
            RenderingUtilities.renderComponent(taskHeader, context);
            return;
        }
        this.renderStepTitle(context, component, theme, writer, step);
        this.renderStepDetail(context, component, theme, writer, step);
    }

    protected void renderStepTitleLabelText(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer, WizardStep step) throws IOException {
        UIComponent titleLabel = ((Wizard)component).getStepTitleLabelTextComponent();
        if (titleLabel != null) {
            titleLabel.getAttributes().put(STYLE_CLASS, theme.getStyleClass("WIZARD_SUB_TITLE_TEXT"));
            RenderingUtilities.renderComponent(titleLabel, context);
        }
    }

    protected void renderStepTitle(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer, WizardStep step) throws IOException {
        UIComponent stepTitle = ((Wizard)component).getStepTitleComponent();
        if (stepTitle != null) {
            RenderingUtilities.renderComponent(stepTitle, context);
            return;
        }
        this.renderStepTitleBegin(context, component, theme, writer, step);
        this.renderStepTitleLabelText(context, component, theme, writer, step);
        this.renderStepTitleText(context, component, theme, writer, step);
        this.renderStepTitleEnd(context, component, theme, writer, step);
    }

    protected void renderStepTitleBegin(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer, WizardStep step) throws IOException {
        writer.startElement(DIV, component);
        writer.writeAttribute(CLASS, (Object)theme.getStyleClass("WIZARD_SUB_TITLE_DIV"), null);
    }

    protected void renderStepTitleText(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer, WizardStep step) throws IOException {
        UIComponent stepTitle = ((Wizard)component).getStepTitleTextComponent();
        if (stepTitle != null) {
            stepTitle.getAttributes().put(STYLE_CLASS, theme.getStyleClass("WIZARD_SUB_TITLE_TEXT"));
            RenderingUtilities.renderComponent(stepTitle, context);
        }
    }

    protected void renderStepTitleEnd(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer, WizardStep step) throws IOException {
        writer.endElement(DIV);
    }

    protected void renderStepDetail(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer, WizardStep step) throws IOException {
        UIComponent stepDetail = ((Wizard)component).getStepDetailComponent();
        if (stepDetail != null) {
            RenderingUtilities.renderComponent(stepDetail, context);
            return;
        }
        this.renderStepDetailBegin(context, component, theme, writer, step);
        this.renderStepDetailText(context, component, theme, writer, step);
        this.renderStepDetailEnd(context, component, theme, writer, step);
    }

    protected void renderStepDetailBegin(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer, WizardStep step) throws IOException {
        writer.startElement(DIV, component);
        writer.writeAttribute(CLASS, (Object)theme.getStyleClass("WIZARD_CONTENT_HELP_TEXT"), null);
    }

    protected void renderStepDetailText(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer, WizardStep step) throws IOException {
        UIComponent stepDetail = ((Wizard)component).getStepDetailTextComponent();
        if (stepDetail != null) {
            RenderingUtilities.renderComponent(stepDetail, context);
        }
    }

    protected void renderStepDetailEnd(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer, WizardStep step) throws IOException {
        writer.endElement(DIV);
    }

    protected void renderStepTaskBegin(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer, WizardStep step) throws IOException {
        writer.startElement(DIV, component);
        writer.writeAttribute(CLASS, (Object)theme.getStyleClass("WIZARD_TASK"), null);
    }

    protected void renderStepTask(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer, WizardStep step) throws IOException {
        UIComponent task = ((Wizard)component).getTaskStepComponent();
        if (task != null) {
            RenderingUtilities.renderComponent(task, context);
            return;
        }
        this.renderStepTaskBegin(context, component, theme, writer, step);
        this.renderStepTaskComponents(context, component, theme, writer, step);
        this.renderStepTaskEnd(context, component, theme, writer, step);
    }

    protected void renderStepTaskEnd(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer, WizardStep step) throws IOException {
        writer.endElement(DIV);
    }

    protected void renderControlBar(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer) throws IOException {
        if (!this.show(component, SHOWCONTROLS)) {
            return;
        }
        UIComponent controlBar = ((Wizard)component).getControlBarComponent();
        if (controlBar != null) {
            RenderingUtilities.renderComponent(controlBar, context);
            return;
        }
        this.renderControlBarBegin(context, component, theme, writer);
        this.renderControlBarSpacer(context, component, theme, writer);
        writer.startElement(DIV, component);
        writer.writeAttribute(CLASS, (Object)theme.getStyleClass("WIZARD_BUTTON_BOTTOM"), null);
        this.renderLeftControlBar(context, component, theme, writer);
        this.renderRightControlBar(context, component, theme, writer);
        writer.endElement(DIV);
        this.renderControlBarEnd(context, component, theme, writer);
    }

    protected void renderControlBarBegin(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer) throws IOException {
        writer.startElement(DIV, component);
        writer.writeAttribute(CLASS, (Object)theme.getStyleClass("WIZARD_BOTTOM"), null);
    }

    protected void renderControlBarEnd(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer) throws IOException {
        writer.endElement(DIV);
    }

    protected void renderControlBarSpacer(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer) throws IOException {
        writer.startElement(DIV, component);
        writer.writeAttribute(CLASS, (Object)theme.getStyleClass("WIZARD_BOTTOM_SPACER"), null);
        writer.endElement(DIV);
    }

    protected void renderLeftControlBar(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer) throws IOException {
        Wizard wizard = (Wizard)component;
        UIComponent leftControlBar = wizard.getLeftControlBarComponent();
        if (leftControlBar != null) {
            RenderingUtilities.renderComponent(leftControlBar, context);
            return;
        }
        this.renderLeftControlBarBegin(context, component, theme, writer);
        if (wizard.hasPrevious()) {
            this.renderPreviousControl(context, component, theme, writer);
        }
        if (wizard.hasNext()) {
            this.renderNextControl(context, component, theme, writer);
        } else if (wizard.hasFinish()) {
            this.renderFinishControl(context, component, theme, writer);
        }
        this.renderLeftControlBarEnd(context, component, theme, writer);
    }

    protected void renderLeftControlBarBegin(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer) throws IOException {
        writer.startElement(DIV, component);
        writer.writeAttribute(CLASS, (Object)theme.getStyleClass("WIZARD_LEFT"), null);
    }

    protected void renderPreviousControl(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer) throws IOException {
        Wizard wizard = (Wizard)component;
        UIComponent control = wizard.getPreviousComponent();
        if (control == null) {
            return;
        }
        this.renderControl(context, theme, control);
    }

    protected void renderNextControl(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer) throws IOException {
        Wizard wizard = (Wizard)component;
        UIComponent nextControl = wizard.getNextComponent();
        if (nextControl == null) {
            return;
        }
        this.renderControl(context, theme, nextControl);
    }

    protected void renderFinishControl(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer) throws IOException {
        Wizard wizard = (Wizard)component;
        UIComponent control = wizard.getFinishComponent();
        if (control == null) {
            return;
        }
        this.renderControl(context, theme, control);
    }

    protected void renderLeftControlBarEnd(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer) throws IOException {
        writer.endElement(DIV);
    }

    protected void renderRightControlBar(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer) throws IOException {
        Wizard wizard = (Wizard)component;
        UIComponent rightControlBar = wizard.getRightControlBarComponent();
        if (rightControlBar != null) {
            RenderingUtilities.renderComponent(rightControlBar, context);
            return;
        }
        this.renderRightControlBarBegin(context, component, theme, writer);
        if (wizard.hasCancel()) {
            this.renderCancelControl(context, component, theme, writer);
        } else if (wizard.hasClose()) {
            this.renderCloseControl(context, component, theme, writer);
        }
        this.renderRightControlBarEnd(context, component, theme, writer);
    }

    protected void renderRightControlBarBegin(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer) throws IOException {
        writer.startElement(DIV, component);
        writer.writeAttribute(CLASS, (Object)theme.getStyleClass("WIZARD_RIGHT"), null);
    }

    protected void renderCancelControl(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer) throws IOException {
        Wizard wizard = (Wizard)component;
        UIComponent control = wizard.getCancelComponent();
        if (control == null) {
            return;
        }
        this.renderControl(context, theme, control);
    }

    protected void renderCloseControl(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer) throws IOException {
        Wizard wizard = (Wizard)component;
        UIComponent control = wizard.getCloseComponent();
        if (control == null) {
            return;
        }
        this.renderControl(context, theme, control);
    }

    protected void renderRightControlBarEnd(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer) throws IOException {
        writer.endElement(DIV);
    }

    private void renderSkipLink(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer, String link, String alt) throws IOException {
        writer.startElement(DIV, component);
        writer.writeAttribute(CLASS, (Object)theme.getStyleClass("SKIP_WHITE"), null);
        writer.startElement(ANCHOR, component);
        writer.writeAttribute(HREF, (Object)("#" + link), null);
        this.renderRule(context, component, theme, writer, 1, 1, alt);
        writer.endElement(ANCHOR);
        writer.endElement(DIV);
    }

    private void renderSkipAnchor(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer, String anchor) throws IOException {
        writer.startElement(DIV, component);
        writer.writeAttribute(CLASS, (Object)theme.getStyleClass("SKIP_WHITE"), null);
        writer.startElement(ANCHOR, component);
        writer.writeAttribute(NAME, (Object)anchor, null);
        writer.writeAttribute(ID, (Object)anchor, null);
        writer.endElement(ANCHOR);
        writer.endElement(DIV);
    }

    private void renderRule(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer, int width, int height, String alt) throws IOException {
        Icon icon = ThemeUtilities.getIcon(theme, "DOT");
        if (alt != null) {
            icon.setAlt(alt);
        }
        icon.setHeight(height);
        icon.setWidth(width);
        RenderingUtilities.renderComponent((UIComponent)icon, context);
    }

    private boolean show(UIComponent component, String feature) {
        return true;
    }

    protected void renderStepTaskComponents(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer, WizardStep step) throws IOException {
        RenderingUtilities.renderComponent((UIComponent)step, context);
    }

    private String mergeStyle(String styles, String newStyle) {
        if (newStyle == null) {
            return styles;
        }
        if (styles == null) {
            return newStyle;
        }
        StringBuffer sb = new StringBuffer(styles);
        String[] splitStyles = styles.split(SPACE);
        for (int i = 0; i < splitStyles.length; ++i) {
            if (!splitStyles[i].equals(newStyle)) continue;
            return sb.toString();
        }
        sb.append(SPACE).append(newStyle);
        return sb.toString();
    }

    private void renderControl(FacesContext context, Theme theme, UIComponent control) throws IOException {
        RenderingUtilities.renderComponent(control, context);
    }

    public void decode(FacesContext context, UIComponent component) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
    }

    private String getMessage(String key) {
        return key;
    }

    protected void renderStepNumber(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer, WizardStepListItem step) throws IOException {
        UIComponent number = ((Wizard)component).getStepNumberComponent(step.getStep(), step.getStepNumberString());
        if (number == null) {
            return;
        }
        RenderingUtilities.renderComponent(number, context);
    }

    protected void renderStepSummary(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer, WizardStepListItem step) throws IOException {
        UIComponent text = ((Wizard)component).getStepSummaryComponent(step.getStep());
        if (text == null) {
            return;
        }
        RenderingUtilities.renderComponent(text, context);
    }
}

